/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder.scanpack;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jpos.DlgMessage;
import jpos.DlgReason;
import jpos.FrSales;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosMenuController;
import jpos.PosUtils;
import jpos.SP;
import jpos.Security;
import jpos.StoreParams;
import jpos.StringField;
import jpos.StringUtils;
import jpos.StyleLine;
import jpos.SystemSettings;
import jpos.TotalsTable;
import jpos.custorder.DeliveryInfo;
import jpos.custorder.scanpack.ScanPackResult;
import jpos.custorder.scanpack.ScanPackTable;
import jpos.custorder.scanpack.ScanPackTableModel;
import jpos.custorder.scanpack.ScanPackTotalsTableModel;
import jpos.searchfields.ProductClrSizeSearch;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;

public class DlgScanPack
extends PosDialog {
    private static final String PICKUP_TITLE = SP.getRS("Scan_Pack_Pickup_Title");
    private static final String DELIVERY_TITLE = SP.getRS("Scan_Pack_Delivery_Title");
    private static final String SPLIT_TITLE = SP.getRS("Scan_Pack_Split_Title");
    private static final ImageIcon PICKUP_ICON = new ImageIcon(SP.sParams.imagepath + "order_type_pickup_small.png");
    private static final ImageIcon DELIVERY_ICON = new ImageIcon(SP.sParams.imagepath + "order_type_delivery_small.png");
    private static final ImageIcon SPLIT_ICON = new ImageIcon(SP.sParams.imagepath + "order_type_split_small.png");
    public static final String YES_NOTES_MANDATORY = "Yes";
    public static final int REASSIGN_REASONS = 462;
    private StringBuffer searchText = new StringBuffer();
    private LabelSubHeading headingLabel;
    private ProductClrSizeSearch search;
    private ScanPackTable scanPackTable;
    private TotalsTable totalsTable;
    private ScanPackTotalsTableModel scanPackTotalsTableModel;
    private DialogButton enableManualPackingButton = new DialogButton(""){

        @Override
        public int getButtonWidth() {
            return 180;
        }
    };
    private DialogButton packAllButton = new DialogButton("");
    private DialogButton pickupAllButton = new DialogButton("");
    private DialogButton okButton = new DialogButton("");
    private LabelNormal custRefLabel = new LabelNormal();
    private StringField custRefField = new StringField(30);
    private List<StyleLine> styleLines;
    private DeliveryInfo.DeliveryOptions deliveryOption;
    private boolean newOrder;
    private boolean hideReference;
    private boolean result = false;
    private boolean manualPackSecurityGranted = false;

    public DlgScanPack(PosFrame frame, List<StyleLine> styleLines, DeliveryInfo.DeliveryOptions deliveryOption, boolean newOrder, boolean hideReference) {
        super(frame, SP.getRS("Scan_Pack_Title"), true);
        this.styleLines = styleLines;
        this.deliveryOption = deliveryOption;
        this.newOrder = newOrder;
        this.hideReference = hideReference;
        this.setAcceptOnEnter(false);
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.manualPackSecurityGranted = Security.hasSecurity(this.frParent, 11173L, this.frParent.getUser().getMemidx(), 2, false);
        this.headingLabel = new LabelSubHeading(DlgScanPack.getOptionTitle(this.deliveryOption));
        this.headingLabel.setIcon(DlgScanPack.getOptionIcon(this.deliveryOption));
        this.headingLabel.setIconTextGap(10);
        this.search = new ProductClrSizeSearch(this, TouchTextField.FontSize.LARGE){

            @Override
            public boolean processSku(long skuidx, String barcode) {
                DlgScanPack.this.packSku(skuidx);
                return true;
            }
        };
        this.search.getBarcodeSearchField().addFocusListener(new FocusAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void focusGained(FocusEvent e) {
                StringBuffer stringBuffer = DlgScanPack.this.searchText;
                synchronized (stringBuffer) {
                    if (DlgScanPack.this.searchText.length() > 0) {
                        DlgScanPack.this.search.getBarcodeSearchField().setText(DlgScanPack.this.searchText.toString());
                        DlgScanPack.this.searchText.setLength(0);
                    }
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyTyped(KeyEvent e) {
                StringBuffer stringBuffer = DlgScanPack.this.searchText;
                synchronized (stringBuffer) {
                    if (!DlgScanPack.this.search.getBarcodeSearchField().hasFocus() && !DlgScanPack.this.custRefField.hasFocus() && Character.isLetterOrDigit(e.getKeyChar())) {
                        DlgScanPack.this.search.getBarcodeSearchField().requestFocusInWindow();
                        DlgScanPack.this.searchText.append(e.getKeyChar());
                    }
                }
            }
        });
        this.custRefLabel.setText(SP.getRS("Reference_"));
        this.custRefField.setText("");
        this.custRefField.setFieldWidth(140);
        if (this.hideReference || !this.newOrder || this.deliveryOption == DeliveryInfo.DeliveryOptions.SPLIT) {
            this.custRefLabel.setVisible(false);
            this.custRefField.setVisible(false);
        }
        ScanPackTableModel scanPackTableModel = new ScanPackTableModel(this.deliveryOption){

            @Override
            public boolean allowManualPacking() {
                boolean allowed = DlgScanPack.this.isManualPackingAllowed();
                if (!allowed) {
                    DlgMessage.showMessage(DlgScanPack.this, SP.getRS("Scan_Barcode_To_Pack_Message"), SP.getRS("Scan_Barcode_To_Pack_Title"), 0);
                }
                return allowed;
            }
        };
        this.scanPackTable = new ScanPackTable((Window)this, scanPackTableModel);
        this.scanPackTotalsTableModel = new ScanPackTotalsTableModel(scanPackTableModel);
        this.totalsTable = new TotalsTable(this, this.scanPackTable, this.scanPackTotalsTableModel);
        this.scanPackTable.populate(this.styleLines);
        this.scanPackTable.getScrollPane().setPreferredSize(new Dimension(600, 402));
        this.enableManualPackingButton.setText(StoreParams.res.getString("F4_Enable_Manual_Packing"));
        this.enableManualPackingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgScanPack.this.enableManualPackingButton.setEnabled(false);
                DlgScanPack.this.requestManualPackSecurity();
                DlgScanPack.this.enableManualPackingButton.setEnabled(true);
            }
        });
        this.manageManualPacking();
        this.packAllButton.setText(StoreParams.res.getString("F5_Pack_All"));
        this.packAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgScanPack.this.packAllButton.setEnabled(false);
                DlgScanPack.this.packRemaining();
                DlgScanPack.this.packAllButton.setEnabled(true);
            }
        });
        if (this.deliveryOption == DeliveryInfo.DeliveryOptions.SPLIT) {
            this.packAllButton.setVisible(false);
        }
        this.pickupAllButton.setText(StoreParams.res.getString("F6_Pick_Up_All"));
        this.pickupAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgScanPack.this.pickupAllButton.setEnabled(false);
                DlgScanPack.this.pickupRemaining();
                DlgScanPack.this.pickupAllButton.setEnabled(true);
            }
        });
        if (this.deliveryOption == DeliveryInfo.DeliveryOptions.DELIVERY || this.deliveryOption == DeliveryInfo.DeliveryOptions.SPLIT) {
            this.pickupAllButton.setVisible(false);
        }
        this.okButton.setText(StoreParams.res.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgScanPack.this.okDialog();
            }
        });
        JPanel panelMain = new JPanel(new GridBagLayout());
        JPanel panelHeader = new JPanel(new GridBagLayout());
        JPanel panelBody = new JPanel(new GridBagLayout());
        JPanel panelFooter = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)panelMain, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelHeader, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelBody, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelFooter, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelHeader.add((Component)this.headingLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(7, 10, 0, 10), 0, 0));
        panelHeader.add((Component)this.search.getSearchPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(7, 10, 0, 10), 0, 0));
        panelHeader.add((Component)new JLabel(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(7, 10, 0, 10), 0, 0));
        panelHeader.add((Component)this.custRefLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(7, 10, 0, 5), 0, 0));
        panelHeader.add((Component)this.custRefField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(7, 5, 0, 10), 0, 0));
        panelHeader.add((Component)this.enableManualPackingButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(7, 5, 0, 10), 0, 0));
        panelBody.add((Component)this.scanPackTable.getScrollPane(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 10, 0, 10), 0, 0));
        panelBody.add((Component)this.totalsTable.getScrollPane(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 0, 10), 0, 0));
        panelFooter.add((Component)this.packAllButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 0), 0, 0));
        panelFooter.add((Component)this.pickupAllButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 0), 0, 0));
        panelFooter.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(10, 10, 10, 20), 0, 0));
        panelFooter.add((Component)this.okButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> tabOrder = new Vector<Component>();
        tabOrder.add(this.search.getBarcodeSearchField());
        tabOrder.add(this.custRefField);
        tabOrder.add(this.scanPackTable);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(tabOrder);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        PosUtils.centreWindow(this);
    }

    private void manageManualPacking() {
        if (this.isManualPackingAllowed()) {
            this.enableManualPackingButton.setVisible(false);
            this.packAllButton.setEnabled(true);
        } else {
            this.enableManualPackingButton.setVisible(true);
            this.packAllButton.setEnabled(false);
        }
    }

    private boolean packSku(long skuidx) {
        ScanPackResult result = this.scanPackTable.packSku(skuidx);
        if (result != ScanPackResult.SUCCESS) {
            DlgMessage.showMessage(this, result.getMessage(), SP.getRS("Error"), 0);
            return false;
        }
        return true;
    }

    public String getCustomerReference() {
        return StringUtils.nullToEmpty(this.custRefField.getText());
    }

    public void setCustomerReference(String customerReference) {
        this.custRefField.setText(customerReference);
    }

    public boolean getResult() {
        return this.result;
    }

    public boolean isFullyPacked() {
        return this.scanPackTable.isFullyPacked();
    }

    public boolean isFullyPickedUp() {
        return this.scanPackTable.isFullyPickedUp();
    }

    @Override
    public void cancelDialog() {
        this.save();
        this.result = false;
        this.dispose();
    }

    @Override
    public void okDialog() {
        boolean shouldShowPartialPackingError = this.shouldShowPartialPackingError();
        if (shouldShowPartialPackingError) {
            long vhidx = this.frParent.getVhidx();
            if (vhidx == -1L) {
                String textContent = SP.getRS("Partial_Packing_Not_Allow");
                String[] parts = textContent.split("\\.");
                String textContentModified = parts[0] + ".";
                DlgMessage.showMessage(this, textContentModified, SP.getRS("Partial_Packing_Not_Allow_Title"), -1, 0);
                this.scanPackTable.unpackAll();
            } else if (DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("Partial_Packing_Not_Allow"), "\n"), SP.getRS("Partial_Packing_Not_Allow_Title"), 0, 2) == 0) {
                Security.OverrideUser overrideUser = new Security.OverrideUser();
                if (Security.hasSecurity(this.frParent, 11178L, this.frParent.getUser().getMemidx(), 2, true, overrideUser)) {
                    if (Security.hasSecurity(this.frParent, 11177L, this.frParent.getUser().getMemidx(), 2, true, overrideUser)) {
                        this.dispose();
                        this.scanPackTable.unpackAll();
                        StringBuffer reasonIdx = new StringBuffer("-1");
                        StringBuffer notes = new StringBuffer();
                        DlgReason reason = new DlgReason(PosMenuController.getInstance().getOpenFrame(), SP.getRS("Reassign_Order_Reason"), true, 462L, reasonIdx, notes, true, "", 250, SystemSettings.getInstance().getText(SystemSettings.SystemSetting.ORDER_REASSIGNMENT_REASON_REQUIRED) == YES_NOTES_MANDATORY, false);
                        reason.setVisible(true);
                        this.frParent.setCursor(StoreParams.waitCursor);
                        if (!reasonIdx.toString().equals("-1") && vhidx != -1L) {
                            HashMap<String, Object> payload = new HashMap<String, Object>();
                            payload.put("vhidx", vhidx);
                            payload.put("memidx", this.frParent.getUser().getMemidx());
                            payload.put("widx", this.sParams.getStoreIdx());
                            payload.put("reason_rcidx", reasonIdx);
                            payload.put("reason_notes", notes);
                            if (((FrSales)this.frParent).rejectCustOrder(payload)) {
                                ((FrSales)this.frParent).voidTrans(false);
                                this.frParent.setCursor(StoreParams.normalCursor);
                                this.dispose();
                                return;
                            }
                        }
                        this.frParent.setCursor(StoreParams.normalCursor);
                    } else {
                        DlgMessage.showMessage(this, SP.getRS("Insufficient_security_reassign_customer_pickup_order"), SP.getRS("Insufficient_security"), -1, 0);
                    }
                } else {
                    DlgMessage.showMessage(this, SP.getRS("Insufficient_security_reassign_partially_packed_pickup_order"), SP.getRS("Insufficient_security"), -1, 0);
                }
            } else {
                this.scanPackTable.unpackAll();
            }
        } else {
            if (this.scanPackTable.getHasCustomisation() && DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("Product_Has_Customisation"), "\n"), SP.getRS("Product_Has_Customisation_Title"), 2, 2) == 2) {
                this.dispose();
                return;
            }
            this.save();
            this.result = true;
            this.dispose();
        }
    }

    private boolean shouldShowPartialPackingError() {
        boolean isCustomerPickUp = this.deliveryOption == DeliveryInfo.DeliveryOptions.CUSTOMER_PICKUP;
        boolean isPartiallyPacked = this.scanPackTable.isPartiallyPacked();
        boolean transactionAvailable = this.frParent.transactionAvailable;
        boolean partialPackingAllowed = transactionAvailable ? this.frParent.partialCCAllowed : SP.sParams.allowPartialPacking;
        return isCustomerPickUp && !partialPackingAllowed && isPartiallyPacked;
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 115 && this.enableManualPackingButton.isVisible() && this.enableManualPackingButton.isEnabled()) {
            this.enableManualPackingButton.doClick();
            return true;
        }
        if (e.getKeyCode() == 116 && this.packAllButton.isVisible() && this.packAllButton.isEnabled()) {
            this.packAllButton.doClick();
            return true;
        }
        if (e.getKeyCode() == 117 && this.pickupAllButton.isVisible() && this.pickupAllButton.isEnabled()) {
            this.pickupAllButton.doClick();
            return true;
        }
        if (e.getKeyCode() == 10 && !this.search.hasValue()) {
            this.okDialog();
            return true;
        }
        return false;
    }

    private void save() {
        if (this.deliveryOption == DeliveryInfo.DeliveryOptions.DELIVERY || this.deliveryOption == DeliveryInfo.DeliveryOptions.SPLIT) {
            this.scanPackTable.pickupRemaining();
        }
    }

    private void packRemaining() {
        if (!this.isManualPackingAllowed()) {
            return;
        }
        int packedCount = this.scanPackTable.packRemaining();
        if (packedCount == 0) {
            DlgMessage.showMessage(this, SP.getRS("Nothing_To_Pack_Message"), SP.getRS("Nothing_To_Pack_Title"), 1);
        }
    }

    private void pickupRemaining() {
        int pickupCount = this.scanPackTable.pickupRemaining();
        if (pickupCount == 0) {
            if (this.scanPackTable.isFullyPickedUp()) {
                DlgMessage.showMessage(this, SP.getRS("Nothing_To_Pickup_Message"), SP.getRS("Nothing_To_Pickup_Title"), 1);
            } else {
                DlgMessage.showMessage(this, SP.getRS("Pack_Before_Pickup_Message"), SP.getRS("Nothing_To_Pickup_Title"), 1);
            }
        }
    }

    private boolean isManualPackingAllowed() {
        return this.manualPackSecurityGranted || this.newOrder;
    }

    private boolean requestManualPackSecurity() {
        if (this.manualPackSecurityGranted) {
            return true;
        }
        if (Security.hasSecurity(this.frParent, 11173L, this.frParent.getUser().getMemidx(), 2, true)) {
            this.manualPackSecurityGranted = true;
            this.manageManualPacking();
            return true;
        }
        return false;
    }

    public int getRowCount() {
        return this.scanPackTable.getModel().getRowCount();
    }

    private static String getOptionTitle(DeliveryInfo.DeliveryOptions deliveryOption) {
        switch (deliveryOption) {
            case CUSTOMER_PICKUP: {
                return PICKUP_TITLE;
            }
            case DELIVERY: {
                return DELIVERY_TITLE;
            }
            case SPLIT: {
                return SPLIT_TITLE;
            }
        }
        return SP.getRS("Scan_Pack_Title");
    }

    private static ImageIcon getOptionIcon(DeliveryInfo.DeliveryOptions deliveryOption) {
        switch (deliveryOption) {
            case CUSTOMER_PICKUP: {
                return PICKUP_ICON;
            }
            case DELIVERY: {
                return DELIVERY_ICON;
            }
            case SPLIT: {
                return SPLIT_ICON;
            }
        }
        return null;
    }
}

