/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.SwingUtilities;
import jpos.FrSales;
import jpos.PosFocusTraversalPolicy;
import jpos.PosUtils;
import jpos.SP;
import jpos.pay.PayDialog;
import jpos.pay.RetTranP;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;
import jpos.voucher.CreditNoteRedeemAdapter;
import jpos.voucher.VoucherUtils;

public class CreditNoteNumDlg
extends PayDialog {
    private LabelSubHeading lCreditNoteNum = new LabelSubHeading();
    private TouchTextField tfCreditNoteNum = new TouchTextField();
    private DialogButton bOk = new DialogButton("", this);
    private DialogButton bCancel = new DialogButton("", this);
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private Vector<RetTranP> vRetTranPs;
    private RetTranP retTranP;

    public CreditNoteNumDlg(FrSales parentFrame, String title) {
        super((Frame)parentFrame, title);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.panelAll.setLayout(this.gridBagLayout1);
        this.lCreditNoteNum.setText("");
        this.tfCreditNoteNum.setText("");
        this.tfCreditNoteNum.setFieldWidth(100);
        this.tfCreditNoteNum.setHorizontalAlignment(4);
        this.setOkButton(this.bOk);
        this.setCancelButton(this.bCancel);
        this.getContentPane().add(this.panelAll);
        this.panelAll.add((Component)this.lCreditNoteNum, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 0, new Insets(20, 20, 10, 10), 0, 0));
        this.panelAll.add((Component)this.tfCreditNoteNum, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 20, 10, 20), 100, 0));
        this.panelAll.add((Component)this.bOk, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 20, 20, 10), 0, 0));
        this.panelAll.add((Component)this.bCancel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 10, 20, 20), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.tfCreditNoteNum);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    public void setRetTranPs(Vector<RetTranP> pVRetTranPs, RetTranP pRetTranP) {
        this.vRetTranPs = pVRetTranPs;
        this.retTranP = pRetTranP;
    }

    public RetTranP getRetTranP() {
        return this.retTranP;
    }

    @Override
    public boolean initDialog() {
        this.tfCreditNoteNum.setText(this.retTranP.getPaymentNum());
        this.lCreditNoteNum.setText(SP.getRS("scan_creditNote"));
        this.setTitle(SP.getRS("validate_credit_note"));
        this.pack();
        return super.initDialog();
    }

    @Override
    public void okDialog() {
        if (this.validateCreditNoteNum()) {
            super.okDialog();
        }
    }

    @Override
    public boolean myKeyPressed(KeyEvent k) {
        return false;
    }

    @Override
    public boolean getResult() {
        return this.result;
    }

    private boolean validateCreditNoteNum() {
        this.tfCreditNoteNum.setText(VoucherUtils.cleanVoucherNumber(this.tfCreditNoteNum.getText()));
        try {
            if (this.tfCreditNoteNum.getText().length() > 0 && this.tfCreditNoteNum.getText(0, 1).toUpperCase().equals("C")) {
                this.tfCreditNoteNum.setText(this.tfCreditNoteNum.getText().substring(1));
            }
        }
        catch (Exception e) {
            this.tfCreditNoteNum.setText("");
        }
        if (this.retTranP.getCreditNoteAdapter() == null) {
            this.retTranP.setCreditNoteAdapter(new CreditNoteRedeemAdapter(this.frSales, this.vRetTranPs));
        }
        if (this.retTranP.getCreditNoteAdapter().processNumber(this.tfCreditNoteNum.getText())) {
            this.retTranP.setAmount(this.retTranP.getCreditNoteAdapter().getVoucher().getAvailableAmount());
            this.retTranP.setPaymentNum(this.retTranP.getCreditNoteAdapter().getVoucher().getNumber());
            return true;
        }
        this.tfCreditNoteNum.requestFocus();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CreditNoteNumDlg.this.tfCreditNoteNum.selectAll();
            }
        });
        return false;
    }
}

