/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.sql.Connection;
import java.sql.Date;
import java.util.List;
import java.util.Vector;
import jpos.FrSales;
import jpos.PaSales;
import jpos.PosDateFormatter;
import jpos.SP;
import jpos.StyleLine;
import jpos.SystemSettings;
import jpos.TransTypes;
import jpos.basscom.IntBuffer;
import jpos.pay.CustOrderCancelDlg;
import jpos.pay.CustOrderPaymentDlg;
import jpos.pay.LaybyCancelDlg;
import jpos.pay.LaybyDepositDlg;
import jpos.pay.LaybyPaymentDlg;
import jpos.pay.OrderHistoryDlg;
import jpos.pay.PayDialog;
import jpos.pay.PayDlgs;
import jpos.pay.PayType;
import jpos.pay.PayTypeFilter;
import jpos.pay.PayTypes;
import jpos.pay.PayUtils;
import jpos.pay.PaymentDlg;
import jpos.pay.PaymentHistoryDlg;
import jpos.pay.RefsDlg;
import jpos.pay.RetTranP;
import org.jdom.Element;

public class DoPayments {
    private PaymentDlg dlgPayment;
    private PayDlgs payDlgs;
    private FrSales frSales;
    private double orderTotal;
    private double pickupTotal;
    private double takenTotal;
    private double adminFee;
    private double cancelFee;
    private boolean cancelOrder = false;
    private double paymentDue;
    private List<?> oldTendersXML;
    private double oldOrderTotal;
    private String orderNumDesc;
    private String transNumber;
    private PosDateFormatter nextPayDate = new PosDateFormatter(null, 3, 3, 0);
    private PosDateFormatter finalPayDate = new PosDateFormatter(null, 3, 3, 0);
    private int transType;
    private Vector<RetTranP> vOldRetTranPs = new Vector();
    private String oldDocketNumber = "";

    public DoPayments(FrSales pFrSales) {
        this.frSales = pFrSales;
        this.payDlgs = new PayDlgs(this.frSales);
        this.dlgPayment = new PaymentDlg(this.frSales, "", this.payDlgs);
        this.dlgPayment.setNextPayDate(this.nextPayDate);
        this.dlgPayment.setFinalPayDate(this.finalPayDate);
    }

    public PaymentDlg getPaymentDlg() {
        return this.dlgPayment;
    }

    public boolean isPrintingGiftDocket() {
        return this.dlgPayment.isPrintingGiftDocket();
    }

    public boolean isPrintingCustAddr() {
        return this.dlgPayment.isPrintingCustAddr();
    }

    public boolean doPayment(String pTitle, int pTransType) {
        this.payDlgs.addPaymentHistoryDlg().setSaleDets();
        Vector<PayDialog> vDlgs = new Vector<PayDialog>();
        this.setTransType(pTransType);
        if (pTransType == 240 || pTransType == 243) {
            LaybyDepositDlg dLaybyDepositDlg = this.payDlgs.addLaybyDepositDlg(vDlgs);
            dLaybyDepositDlg.setLaybyDets(TransTypes.isLayby(this.transType), this.orderTotal + this.adminFee, this.adminFee, this.frSales.nextPayDate, this.frSales.dueDate);
        } else if (pTransType == 241 || pTransType == 242 || pTransType == 244 || pTransType == 245) {
            if (this.cancelOrder) {
                LaybyCancelDlg dLaybyCancelDlg = this.payDlgs.addLaybyCancelDlg(vDlgs);
                dLaybyCancelDlg.setLaybyDets(TransTypes.isLayby(this.transType), this.cancelFee, this.oldTendersXML);
            } else {
                LaybyPaymentDlg dLaybyPaymentDlg = this.payDlgs.addLaybyPaymentDlg(vDlgs);
                dLaybyPaymentDlg.setLaybyDets(TransTypes.isLayby(this.transType), this.orderTotal, this.adminFee, this.oldTendersXML, this.frSales.nextPayDate, this.frSales.dueDate, this.frSales.getFromWidx());
            }
        } else if (TransTypes.isCustOrder(this.transType)) {
            if (this.cancelOrder) {
                CustOrderCancelDlg dCustOrderCancelDlg = this.payDlgs.addCustOrderCancelDlg(vDlgs);
                dCustOrderCancelDlg.setOrderDets(this.oldTendersXML);
            } else {
                CustOrderPaymentDlg dCustOrderPaymentDlg = this.payDlgs.addCustOrderPaymentDlg(vDlgs);
                dCustOrderPaymentDlg.setOrderDets(this.orderTotal, this.pickupTotal, this.takenTotal, this.oldTendersXML, ((PaSales)this.frSales.paBody).tblStyles.getOutstandingQty() - ((PaSales)this.frSales.paBody).tblStyles.getPickUpQty() == 0.0, this.frSales.deliveryInfo, this.frSales.isRefundFloorToDoorOrder());
            }
        }
        RefsDlg dRefsDlg = this.payDlgs.addRefsDlg(vDlgs);
        if (dRefsDlg.getRefCount() == 0 || pTransType != 714 && pTransType != 240 && pTransType != 243 && pTransType != 239) {
            vDlgs.remove(vDlgs.size() - 1);
            dRefsDlg.setRefsXML(null);
        }
        if (this.frSales.transRoot == null) {
            dRefsDlg.setRefsXML(null);
        } else {
            dRefsDlg.setRefsXML(this.frSales.transRoot.getChild("refs"));
        }
        vDlgs.add(this.dlgPayment);
        for (PayDialog p : vDlgs) {
            p.setStealthModeDone(false);
        }
        int step = 0;
        while (step < vDlgs.size()) {
            PayDialog dlgPay = vDlgs.get(step);
            boolean bRoundingOnly = false;
            if (dlgPay instanceof PaymentDlg) {
                if (pTransType == 240 || pTransType == 243) {
                    this.setPaymentDue(this.payDlgs.dLaybyDepositDlg.getDepositAmt());
                    this.adminFee = this.payDlgs.dLaybyDepositDlg.getLaybyFee();
                } else if (pTransType == 241 || pTransType == 242 || pTransType == 244 || pTransType == 245) {
                    if (this.cancelOrder) {
                        this.setPaymentDue(-this.payDlgs.dLaybyCancelDlg.getRefundAmt());
                    } else {
                        this.setPaymentDue(this.payDlgs.dLaybyPaymentDlg.getPaymentAmt());
                    }
                } else if (TransTypes.isCustOrder(pTransType)) {
                    if (this.cancelOrder) {
                        this.setPaymentDue(-this.payDlgs.dCustOrderCancelDlg.getRefundAmt());
                    } else {
                        this.setPaymentDue(this.payDlgs.dCustOrderPaymentDlg.getPaymentAmt());
                        double roundingVarianceThreshhold = Math.pow(0.1, SP.sParams.storeCurrency.getPrecision()) * (double)SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.AUTO_ROUNDING_FOR_ORDER_PAYMENT_VARIANCE);
                        if (this.paymentDue != 0.0 && Math.abs(this.paymentDue) <= roundingVarianceThreshhold && ((PaSales)this.frSales.paBody).tblStyles.getOutstandingQty() - ((PaSales)this.frSales.paBody).tblStyles.getPickUpQty() == 0.0) {
                            bRoundingOnly = true;
                        }
                    }
                }
                PayTypeFilter payTypeFilter = new PayTypeFilter(this.frSales, pTransType, this.paymentDue);
                this.dlgPayment.setPaymentDetails(pTitle, this.paymentDue, pTransType, payTypeFilter);
                this.dlgPayment.setOldRetTranPs(this.oldDocketNumber, this.vOldRetTranPs, this.oldTendersXML);
                this.dlgPayment.setRoundVariancePay(bRoundingOnly);
            }
            if (this.frSales.isLoggedIn(false)) {
                dlgPay.setVisible(true);
            }
            if (dlgPay.getResult() && (this.frSales.isLoggedIn(false) || dlgPay instanceof PaymentDlg)) {
                if (dlgPay instanceof LaybyDepositDlg) {
                    if (this.payDlgs.dLaybyDepositDlg.isLayby) {
                        this.nextPayDate.setTime(this.payDlgs.dLaybyDepositDlg.getNextPayDate().getTime());
                        this.finalPayDate.setTime(this.payDlgs.dLaybyDepositDlg.getFinalPayDate().getTime());
                    }
                } else if (dlgPay instanceof LaybyPaymentDlg) {
                    if (this.payDlgs.dLaybyPaymentDlg.isLayby) {
                        this.nextPayDate.setTime(this.payDlgs.dLaybyPaymentDlg.getNextPayDate().getTime());
                        this.finalPayDate.setTime(this.payDlgs.dLaybyPaymentDlg.getFinalPayDate().getTime());
                    }
                } else if (dlgPay instanceof LaybyCancelDlg) {
                    this.cancelFee = this.payDlgs.dLaybyCancelDlg.getLaybyFee();
                }
                ++step;
                continue;
            }
            if (--step >= 0) continue;
            return false;
        }
        return true;
    }

    public void setPaymentDue(double pPaymentDue) {
        this.paymentDue = pPaymentDue;
    }

    public void setOrderDepositDets(double pOrderTotal, double pAdminFee) {
        this.orderTotal = pOrderTotal;
        this.adminFee = pAdminFee;
        this.cancelOrder = false;
    }

    public void setOrderPaymentDets(double pOrderTotal, double pPickupTotal, double pTakenTotal, double pAdminFee, Element pTransRoot) {
        this.orderTotal = pOrderTotal;
        this.pickupTotal = pPickupTotal;
        this.takenTotal = pTakenTotal;
        this.adminFee = pAdminFee;
        this.setOrderXMLTransDets(pTransRoot);
        this.setXMLOldRetTranPs(pTransRoot);
        this.cancelOrder = false;
    }

    public void setOrderCancelDets(double pCancelFee, double pAdminFee, Element pTransRoot) {
        this.orderTotal = 0.0;
        this.adminFee = pAdminFee;
        this.cancelFee = pCancelFee;
        this.setOrderXMLTransDets(pTransRoot);
        this.setXMLOldRetTranPs(pTransRoot);
        this.cancelOrder = true;
    }

    public void setTansNumber(String pTransNumber) {
        this.transNumber = pTransNumber;
    }

    public boolean dbInserts(Connection con) throws Exception {
        RetTranP p;
        long payType;
        StyleLine slLBAdminFee;
        long sku;
        IntBuffer sequence = new IntBuffer(0);
        if (this.transType == 240 || this.transType == 243) {
            if (this.adminFee != 0.0) {
                sku = this.transType == 240 ? SP.sParams.lbAdminFeeSku : SP.sParams.specOrdAdminFeeSku;
                slLBAdminFee = new StyleLine(sku, 1.0, SP.sParams);
                slLBAdminFee.setPrice(this.adminFee);
                if (slLBAdminFee.isValid()) {
                    slLBAdminFee.db_insertline();
                }
            }
            payType = this.transType == 240 ? 456L : 642L;
            p = new RetTranP(PayTypes.getPayType(payType), this.orderTotal + this.adminFee);
            p.setRef1(this.transNumber);
            p.dbInsert(this.dlgPayment, con, SP.sParams.currVal("XRET_TRANH"), sequence);
        } else if (this.transType == 241 || this.transType == 244) {
            if (!this.cancelOrder) {
                this.cancelFee = 0.0;
            }
            if (this.cancelFee != 0.0) {
                sku = this.transType == 241 ? SP.sParams.lbCancFeeSku : SP.sParams.specOrdCancFeeSku;
                slLBAdminFee = new StyleLine(sku, 1.0, SP.sParams);
                slLBAdminFee.setPrice(this.cancelFee);
                if (slLBAdminFee.isValid()) {
                    slLBAdminFee.db_insertline();
                }
            }
            if (PayType.roundDec(this.orderTotal - this.oldOrderTotal + this.cancelFee) != 0.0) {
                payType = this.transType == 241 ? 456L : 642L;
                p = new RetTranP(PayTypes.getPayType(payType), this.orderTotal - this.oldOrderTotal + this.cancelFee);
                p.setRef1(this.transNumber);
                p.dbInsert(this.dlgPayment, con, SP.sParams.currVal("XRET_TRANH"), sequence);
            }
        }
        if (TransTypes.isLayby(this.transType) || TransTypes.isSpecialOrder(this.transType)) {
            payType = TransTypes.isLayby(this.transType) ? 457L : 643L;
            p = new RetTranP(PayTypes.getPayType(payType), -this.paymentDue);
            p.setRef1(this.transNumber);
            p.dbInsert(this.dlgPayment, con, SP.sParams.currVal("XRET_TRANH"), sequence);
        } else if (TransTypes.isCustOrder(this.transType)) {
            RetTranP p2 = new RetTranP(PayTypes.getPayType(716L), -this.paymentDue);
            p2.setRef1(this.transNumber);
            p2.dbInsert(this.dlgPayment, con, SP.sParams.currVal("XRET_TRANH"), sequence);
        }
        sequence.setValue(100);
        return this.dlgPayment.dbInsertRetTranPs(con, sequence);
    }

    public void doPaymentHistory(double pSaleTotal, Element pTransRoot) {
        this.setXMLOldRetTranPs(pTransRoot);
        PaymentHistoryDlg dPaymentHistoryDlg = this.payDlgs.addPaymentHistoryDlg();
        this.oldDocketNumber = PayUtils.getDocketNumber(pTransRoot);
        dPaymentHistoryDlg.setSaleDets(this.oldDocketNumber, this.oldTendersXML);
        dPaymentHistoryDlg.setVisible(true);
        if (dPaymentHistoryDlg.getResult()) {
            // empty if block
        }
    }

    public void doOrderHistory(boolean pEditable, boolean pCanceled, int pTransType, double pLaybyTotal, Element pTransRoot) {
        this.setTransType(pTransType);
        this.setOrderXMLTransDets(pTransRoot);
        this.setXMLOldRetTranPs(pTransRoot);
        OrderHistoryDlg dOrderHistoryDlg = this.payDlgs.addLaybyHistoryDlg();
        dOrderHistoryDlg.setOrderDets(pEditable, pCanceled, this.transType, this.orderNumDesc, pLaybyTotal, new Date(this.nextPayDate.getTime()), new Date(this.finalPayDate.getTime()), this.oldTendersXML);
        dOrderHistoryDlg.setVisible(true);
        if (dOrderHistoryDlg.getResult() && dOrderHistoryDlg.getAllowChangeLaybyDate()) {
            this.frSales.changeLayByDates(dOrderHistoryDlg.getNextPayDate(), dOrderHistoryDlg.getFinalPayDate());
        }
    }

    public void setTransType(int pTransType) {
        this.transType = pTransType;
    }

    public String[] getRefTblIdxs() {
        String[] refs = new String[10];
        if (this.payDlgs.dRefsDlg != null) {
            this.payDlgs.dRefsDlg.tblRefs.getIdxsByTbl(refs, 23);
        } else {
            for (int i = 0; i < 10; ++i) {
                refs[i] = "null";
            }
        }
        return refs;
    }

    public void setOrderXMLTransDets(Element pTransRoot) {
        if (pTransRoot == null) {
            this.setOrderXMLTransDetsNull();
        } else if (TransTypes.isLayby(this.transType)) {
            this.orderNumDesc = SP.getRS("Layby_") + " L" + PayUtils.getTransNumber(pTransRoot);
            PayUtils.getLaybyDates(pTransRoot, this.nextPayDate, this.finalPayDate);
        } else if (TransTypes.isSpecialOrder(this.transType)) {
            this.orderNumDesc = SP.getRS("SpecialOrder_") + " S" + PayUtils.getTransNumber(pTransRoot);
            PayUtils.getLaybyDates(pTransRoot, this.nextPayDate, this.finalPayDate);
        } else if (TransTypes.isCustOrder(this.transType)) {
            this.orderNumDesc = this.frSales.isRefundFloorToDoorOrder() && pTransRoot.getAttribute("sordidx") != null ? SP.getRS("Customer_order_feedback_message_simple", pTransRoot.getAttribute("trans_number").getValue()) : SP.getRS("CustomerOrder_") + " O" + PayUtils.getTransNumber(pTransRoot);
        }
    }

    public void setOrderXMLTransDetsNull() {
        this.transNumber = "";
        this.orderNumDesc = "";
        this.nextPayDate.setTimestampInternal("");
        this.finalPayDate.setTimestampInternal("");
    }

    public void setXMLOldRetTranPs(Element pTransRoot) {
        if (pTransRoot == null) {
            this.setXMLOldRetTranPsNull();
        } else {
            this.oldDocketNumber = PayUtils.getDocketNumber(pTransRoot);
            try {
                this.oldTendersXML = pTransRoot.getChildren("payments").size() > 0 ? pTransRoot.getChildren("payments") : null;
                PayUtils.tendersXMLToVRetTranPs(this.oldTendersXML, this.vOldRetTranPs);
                this.oldOrderTotal = PayUtils.getLaybyTotal(this.oldTendersXML);
            }
            catch (Exception e) {
                this.setXMLOldRetTranPsNull();
            }
        }
    }

    public void setXMLOldRetTranPsNull() {
        this.oldTendersXML = null;
        this.oldOrderTotal = 0.0;
        this.vOldRetTranPs.removeAllElements();
    }

    public boolean hasAfterpayHistory(Element pTransRoot) {
        if (pTransRoot != null && pTransRoot.getChildren("payments").size() > 0) {
            List tenderXml = pTransRoot.getChildren("payments");
            Vector<RetTranP> tenders = new Vector<RetTranP>();
            PayUtils.tendersXMLToVRetTranPs(tenderXml, tenders);
            return tenders.stream().anyMatch(p -> p.getPayType().idx == 776L);
        }
        return false;
    }
}

