/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jpos.DecimalField;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.PosDateField;
import jpos.PosDateFormatter;
import jpos.PosFocusTraversalPolicy;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.pay.PayDialog;
import jpos.pay.PayType;
import jpos.pay.PayUtils;
import jpos.pay.RetTranP;
import jpos.ui.Colours;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;

public class LaybyPaymentDlg
extends PayDialog {
    protected boolean isLayby = true;
    private long nOrigWidx = 0L;
    private boolean bReducePaymentSec = false;
    private RetTranP lastRetTranP;
    private GridBagLayout gridBagLayoutAll = new GridBagLayout();
    private boolean bAllowChangeLaybyDateSec = false;
    private GridBagLayout gridBagLayoutDates = new GridBagLayout();
    private JPanel panelDates = new JPanel(this.gridBagLayoutDates);
    private LabelNormal lNextPayDate = new LabelNormal();
    private PosDateField dfNextPayDate = new PosDateField(this);
    private PosDateFormatter nextPayDate = new PosDateFormatter(null, 3, 3, 0);
    private DialogButton bNextPayDate = new DialogButton("", this);
    private LabelNormal lFinalPayDate = new LabelNormal();
    private PosDateField dfFinalPayDate = new PosDateField(this);
    private PosDateFormatter finalPayDate = new PosDateFormatter(null, 3, 3, 0);
    private DialogButton bFinalPayDate = new DialogButton("", this);
    private GridBagLayout gridBagLayoutDets = new GridBagLayout();
    private JPanel panelDets = new JPanel(this.gridBagLayoutDets);
    private LabelSubHeading lLaybyTotal = new LabelSubHeading();
    private DecimalField dfLaybyTotal;
    private double laybyTotal;
    private LabelSubHeading lTotalPaid;
    private DecimalField dfTotalPaid;
    private double totalPaid;
    private LabelNormal lOutstanding;
    private DecimalField dfOutstanding;
    private double outstanding;
    private LabelNormal lThisPayment;
    private DecimalField dfThisPayment;
    private double thisPayment;
    private double minPayment;
    private GridBagLayout gridBagLayoutFooter;
    private JPanel panelFooter;
    private DialogButton bOk;
    private DialogButton bCancel;
    private DialogButton bReverseLast;
    private double fee;

    public LaybyPaymentDlg(FrSales parentFrame, String title) {
        super((Frame)parentFrame, title);
        this.dfLaybyTotal = new DecimalField(SP.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.lTotalPaid = new LabelSubHeading();
        this.dfTotalPaid = new DecimalField(SP.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.lOutstanding = new LabelNormal();
        this.dfOutstanding = new DecimalField(SP.sParams.storeCurrency);
        this.lThisPayment = new LabelNormal();
        this.dfThisPayment = new DecimalField(SP.sParams.storeCurrency);
        this.gridBagLayoutFooter = new GridBagLayout();
        this.panelFooter = new JPanel(this.gridBagLayoutFooter);
        this.bOk = new DialogButton("", this);
        this.bCancel = new DialogButton("", this);
        this.bReverseLast = new DialogButton("", this);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.lNextPayDate.setText(SP.getRS("next_payment_due"));
        this.setDateFieldProp(this.dfNextPayDate);
        this.dfNextPayDate.setEnabled(false);
        this.dfNextPayDate.setDisabledTextColor(Colours.BLACK);
        this.bNextPayDate.setText(SP.getRS("F7_change_date"));
        this.bNextPayDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LaybyPaymentDlg.this.isRunning && LaybyPaymentDlg.this.isVisible()) {
                    LaybyPaymentDlg.this.isRunning = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LaybyPaymentDlg.this.changeNextLaybyDate();
                            LaybyPaymentDlg.this.isRunning = false;
                        }
                    });
                }
            }
        });
        this.lFinalPayDate.setText(SP.getRS("final_payment_due"));
        this.setDateFieldProp(this.dfFinalPayDate);
        this.dfFinalPayDate.setEnabled(false);
        this.dfFinalPayDate.setDisabledTextColor(Colours.BLACK);
        this.bFinalPayDate.setText(SP.getRS("F5_change_date"));
        this.bFinalPayDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LaybyPaymentDlg.this.isRunning && LaybyPaymentDlg.this.isVisible()) {
                    LaybyPaymentDlg.this.isRunning = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LaybyPaymentDlg.this.changeFinalLaybyDate();
                            LaybyPaymentDlg.this.isRunning = false;
                        }
                    });
                }
            }
        });
        this.panelDates.setBorder(BorderFactory.createEtchedBorder());
        this.panelDates.add((Component)this.lNextPayDate, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(20, 20, 10, 10), 0, 0));
        this.panelDates.add((Component)this.dfNextPayDate, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(20, 10, 10, 10), 0, 0));
        this.panelDates.add((Component)this.bNextPayDate, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(20, 10, 10, 20), 0, 0));
        this.panelDates.add((Component)this.lFinalPayDate, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 20, 20, 10), 0, 0));
        this.panelDates.add((Component)this.dfFinalPayDate, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 10, 20, 10), 0, 0));
        this.panelDates.add((Component)this.bFinalPayDate, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 10, 20, 20), 0, 0));
        this.lLaybyTotal.setText(SP.getRS("layby_total"));
        this.setAmtFieldProp(this.dfLaybyTotal);
        this.dfLaybyTotal.setEnabled(false);
        this.lTotalPaid.setText(SP.getRS("total_paid"));
        this.setAmtFieldProp(this.dfTotalPaid);
        this.dfTotalPaid.setEnabled(false);
        this.lOutstanding.setText(SP.getRS("balance_due"));
        this.setAmtFieldProp(this.dfOutstanding);
        this.dfOutstanding.setEnabled(false);
        this.lThisPayment.setText(SP.getRS("this_payment"));
        this.setAmtFieldProp(this.dfThisPayment);
        this.panelDets.setBorder(BorderFactory.createEtchedBorder());
        this.panelDets.add((Component)this.lLaybyTotal, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(20, 20, 10, 10), 0, 0));
        this.panelDets.add((Component)this.dfLaybyTotal, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(20, 10, 10, 20), 0, 0));
        this.panelDets.add((Component)this.lTotalPaid, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 20, 10, 10), 0, 0));
        this.panelDets.add((Component)this.dfTotalPaid, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 10, 20), 0, 0));
        this.panelDets.add((Component)this.lOutstanding, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 20, 10, 10), 0, 0));
        this.panelDets.add((Component)this.dfOutstanding, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 10, 20), 0, 0));
        this.panelDets.add((Component)this.lThisPayment, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 20, 20, 10), 0, 0));
        this.panelDets.add((Component)this.dfThisPayment, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 20, 20), 0, 0));
        this.panelDets.add((Component)this.bReverseLast, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 20, 10), 0, 0));
        this.dfNextPayDate.setValue("");
        this.dfFinalPayDate.setValue("");
        this.dfLaybyTotal.setText("");
        this.dfTotalPaid.setText("");
        this.dfOutstanding.setText("");
        this.dfThisPayment.setText("");
        this.setOkButton(this.bOk);
        this.setCancelButton(this.bCancel);
        this.bReverseLast.setText(SP.getRS("reverse_last_payment"));
        this.bReverseLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LaybyPaymentDlg.this.isRunning && LaybyPaymentDlg.this.isVisible()) {
                    LaybyPaymentDlg.this.isRunning = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LaybyPaymentDlg.this.ReverseLast();
                            LaybyPaymentDlg.this.isRunning = false;
                        }
                    });
                }
            }
        });
        this.panelFooter.add((Component)this.bOk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 20, 10), 0, 0));
        this.panelFooter.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 20, 10), 0, 0));
        this.panelFooter.setLayout(this.gridBagLayoutFooter);
        this.panelAll.setLayout(this.gridBagLayoutAll);
        this.panelAll.add((Component)this.panelDates, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(20, 20, 10, 20), 1, 1));
        this.panelAll.add((Component)this.panelDets, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(10, 20, 10, 20), 1, 1));
        this.panelAll.add((Component)this.panelFooter, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 1, 1));
        this.getContentPane().add(this.panelAll);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.dfThisPayment);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    public void changeNextLaybyDate() {
        if (this.bAllowChangeLaybyDateSec) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (LaybyPaymentDlg.this.frSales != null && LaybyPaymentDlg.this.frSales.isLoggedIn(false)) {
                        LaybyPaymentDlg.this.dfNextPayDate.actionSearch();
                    }
                }
            });
        }
    }

    public void changeFinalLaybyDate() {
        if (this.bAllowChangeLaybyDateSec) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (LaybyPaymentDlg.this.frSales != null && LaybyPaymentDlg.this.frSales.isLoggedIn(false)) {
                        LaybyPaymentDlg.this.dfFinalPayDate.actionSearch();
                    }
                }
            });
        }
    }

    @Override
    public boolean initDialog() {
        this.bAllowChangeLaybyDateSec = this.frSales.hasSecurity(11131L, 0);
        this.bReducePaymentSec = this.frSales.hasSecurity(11138L, 0);
        this.populateFields();
        return super.initDialog();
    }

    private void populateFields() {
        this.dfOutstanding.setText(this.outstanding);
        this.dfTotalPaid.setText(this.totalPaid);
        this.dfLaybyTotal.setText(this.laybyTotal);
        this.dfThisPayment.setText(this.thisPayment);
        if (this.nextPayDate.getTimestamp() != null) {
            this.dfNextPayDate.setValue(new Timestamp(this.nextPayDate.getTime()));
        } else {
            this.dfNextPayDate.setValue("");
        }
        if (this.finalPayDate.getTimestamp() != null) {
            this.dfFinalPayDate.setValue(new Timestamp(this.finalPayDate.getTime()));
        } else {
            this.dfFinalPayDate.setValue("");
        }
        this.bNextPayDate.setEnabled(this.bAllowChangeLaybyDateSec);
        this.bFinalPayDate.setEnabled(this.bAllowChangeLaybyDateSec);
        this.bReverseLast.setEnabled(this.lastRetTranP != null);
    }

    public double getPaymentAmt() {
        return this.dfThisPayment.getDouble();
    }

    @Override
    public void okDialog() {
        if (PayType.roundDec(this.dfThisPayment.getDouble()) > this.outstanding) {
            this.dfThisPayment.setText(this.outstanding);
            this.dfThisPayment.requestFocus();
            this.dfThisPayment.selectAll();
            return;
        }
        if (PayType.roundDec(this.dfThisPayment.getDouble()) < this.minPayment) {
            this.dfThisPayment.setText(this.thisPayment);
            this.dfThisPayment.requestFocus();
            this.dfThisPayment.selectAll();
            return;
        }
        double termsMinPayment = PayType.roundDec(this.isLayby ? SP.sParams.getMinLbDep(this.laybyTotal - this.fee) : SP.sParams.getMinSpecOrdDep(this.laybyTotal - this.fee));
        if (termsMinPayment > this.outstanding) {
            termsMinPayment = this.outstanding;
        }
        if (this.isLayby && !this.bReducePaymentSec && SP.sParams.getLbMinDeposAll() && PayType.roundDec(this.dfThisPayment.getDouble()) < termsMinPayment) {
            Object[] objs = new Object[]{"\n"};
            DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("no_reduce_payment_security"), objs), StoreParams.res.getString("Insufficient_security"));
            this.dfThisPayment.setText(termsMinPayment);
            this.dfThisPayment.requestFocus();
            this.dfThisPayment.selectAll();
            return;
        }
        if (PayType.roundDec(this.dfThisPayment.getDouble()) >= this.outstanding && SP.sParams.getStoreIdx() != this.nOrigWidx) {
            if (this.isLayby) {
                DlgMessage.showMessage(this, StoreParams.res.getString("layby_complete_message"), StoreParams.res.getString("layby_complete_title"), 2);
            } else {
                DlgMessage.showMessage(this, StoreParams.res.getString("specialorder_complete_message"), StoreParams.res.getString("specialorder_complete_title"), 2);
            }
            return;
        }
        this.getDates();
        this.thisPayment = this.dfThisPayment.getDouble();
        this.frSales.setCompletingOrder(PayType.roundDec(this.thisPayment) == PayType.roundDec(this.outstanding));
        super.okDialog();
    }

    private void getDates() {
        if (this.isLayby) {
            long newFinalPayDate;
            long newNextPayDate;
            try {
                newNextPayDate = this.dfNextPayDate.getDateFormatter().getTime();
            }
            catch (Exception ex) {
                this.dfNextPayDate.requestFocus();
                this.dfNextPayDate.selectAll();
                return;
            }
            try {
                newFinalPayDate = this.dfFinalPayDate.getDateFormatter().getTime();
            }
            catch (Exception ex) {
                this.dfFinalPayDate.requestFocus();
                this.dfFinalPayDate.selectAll();
                return;
            }
            if (newNextPayDate > newFinalPayDate) {
                newNextPayDate = newFinalPayDate;
                this.dfNextPayDate.setValue(new Timestamp(newFinalPayDate));
                return;
            }
            this.nextPayDate.setTime(newNextPayDate);
            this.finalPayDate.setTime(newFinalPayDate);
        }
    }

    @Override
    public boolean myKeyPressed(KeyEvent k) {
        if (k.getKeyCode() == 116) {
            this.bFinalPayDate.doClick();
            return true;
        }
        if (k.getKeyCode() == 118) {
            this.bNextPayDate.doClick();
            return true;
        }
        if (k.getKeyCode() == 117) {
            this.bReverseLast.doClick();
            return true;
        }
        return false;
    }

    @Override
    public boolean getResult() {
        return this.result;
    }

    public void setLaybyDets(boolean pIsLayby, double pLaybyTotal, double pFee, List<?> pOldTendersXML, Date pNextPayDate, Date pFinalPayDate, long npOrigWidx) {
        this.isLayby = pIsLayby;
        Vector<RetTranP> vOldRetTranPs = new Vector<RetTranP>();
        this.totalPaid = PayUtils.tendersXMLToVRetTranPs(pOldTendersXML, vOldRetTranPs);
        this.lastRetTranP = PayUtils.tendersXMLToLastLaybyRetTranP(pOldTendersXML);
        this.outstanding = PayType.roundDec(pLaybyTotal - this.totalPaid);
        this.laybyTotal = pLaybyTotal;
        this.fee = pFee;
        this.nOrigWidx = npOrigWidx;
        if (this.isLayby) {
            this.nextPayDate.setTime(pNextPayDate.getTime());
            this.finalPayDate.setTime(pFinalPayDate.getTime());
            this.lLaybyTotal.setText(SP.getRS("layby_total"));
            this.setTitle(SP.getRS("layby_payment"));
            this.panelDates.setVisible(true);
            this.thisPayment = PayType.roundDec(SP.sParams.getMinLbDep(pLaybyTotal - pFee));
            if (this.thisPayment > this.outstanding) {
                this.thisPayment = this.outstanding;
            }
        } else {
            this.lLaybyTotal.setText(SP.getRS("special_order_total"));
            this.setTitle(SP.getRS("special_order_payment"));
            this.panelDates.setVisible(false);
            this.thisPayment = PayType.roundDec(this.outstanding);
        }
        this.minPayment = this.thisPayment < 0.0 ? this.thisPayment : 0.0;
    }

    public Date getNextPayDate() {
        return new Date(this.nextPayDate.getTime());
    }

    public Date getFinalPayDate() {
        return new Date(this.finalPayDate.getTime());
    }

    public void ReverseLast() {
        if (this.lastRetTranP != null) {
            this.dfThisPayment.setText(this.lastRetTranP.getAmount());
            this.getDates();
            super.okDialog();
        }
    }
}

