/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import jpos.FrSales;
import jpos.TransTypes;
import jpos.custorder.DeliveryInfo;

public class PayTypeFilter {
    boolean bAccount;
    boolean bDebtor;
    boolean bDebtorOnly;
    boolean bAfterpay;

    public PayTypeFilter(FrSales pFrSales, int pTransType, double pDue) {
        this.bAccount = this.getAccoutFlag(pFrSales, pTransType, pDue);
        this.bDebtor = false;
        this.bDebtorOnly = false;
        this.setDebtorFlags(pFrSales, pDue);
        this.bAfterpay = pTransType == 239 && !pFrSales.isExchange() || pTransType == 714 && (pFrSales.deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.DELIVERY || pFrSales.deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.SPLIT) || TransTypes.isCustOrder(pTransType) && Math.signum(pDue) == -1.0;
    }

    public PayTypeFilter() {
        this.bAccount = false;
        this.bDebtor = false;
        this.bDebtorOnly = false;
        this.bAfterpay = false;
    }

    public PayTypeFilter cloneMe() {
        PayTypeFilter clone = new PayTypeFilter();
        clone.bAccount = this.bAccount;
        clone.bDebtor = this.bDebtor;
        clone.bDebtorOnly = this.bDebtorOnly;
        clone.bAfterpay = this.bAfterpay;
        return clone;
    }

    private boolean getAccoutFlag(FrSales pFrSales, int pTransType, double pDue) {
        return (pTransType != 242 && pTransType != 245 || pFrSales.totOrder != 0.0) && (pTransType != 241 && pTransType != 244 || pDue != 0.0) && pFrSales.isAccountCustomer() && pFrSales.frameType != 10;
    }

    private void setDebtorFlags(FrSales pFrSales, double pDue) {
        if (pFrSales.frameType == 10) {
            if (pFrSales.transnum != null) {
                this.bDebtor = false;
            } else if (pDue < 0.0) {
                this.bDebtor = true;
                this.bDebtorOnly = true;
            }
            this.bDebtor = true;
        } else {
            this.bDebtor = false;
        }
    }
}

