/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import bass.eftpos.ETran;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.PosDateFormatter;
import jpos.PosFrame;
import jpos.PosMenuController;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.SystemSettings;
import jpos.basscom.DecBuffer;
import jpos.basscom.utils.Utils;
import jpos.custorder.DeliveryInfo;
import jpos.pay.PayType;
import jpos.pay.PayTypeFilter;
import jpos.pay.PayTypes;
import jpos.pay.ReceiptDeliveryMethodDlg;
import jpos.pay.RetTranP;
import jpos.pay.eftpos.EFTRecoveryDlg;
import jpos.pay.eftpos.EftposUtils;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class PayUtils {
    static long savedInactiveLogoffTime = 0L;
    static boolean isLoginTimeoutEnabled = true;
    private static PayType defaultRoundingPayType = null;
    private static String email = "";
    private static String phone = "";

    public static PayType getDefaultRoundingPayType() {
        if (defaultRoundingPayType == null) {
            Vector<PayType> vPayTypes = PayTypes.getSalePayTypes(new PayTypeFilter());
            for (int i = 0; i < vPayTypes.size(); ++i) {
                defaultRoundingPayType = vPayTypes.get(i);
                if (PayUtils.defaultRoundingPayType.round) break;
            }
        }
        return defaultRoundingPayType;
    }

    public static void getLaybyDates(Element pTransRoot, PosDateFormatter pNextPayDate, PosDateFormatter pFinalPayDate) {
        if (pTransRoot != null && pTransRoot.getChildren("payments").size() > 0) {
            Attribute dateAtt = pTransRoot.getChild("layby_payduedates") == null ? pTransRoot.getAttribute("trand") : pTransRoot.getChild("layby_payduedates").getAttribute("payment_due");
            try {
                pNextPayDate.setTimestampInternal(dateAtt.getValue());
            }
            catch (Exception e) {
                // empty catch block
            }
            dateAtt = pTransRoot.getAttribute("layby_due") == null ? pTransRoot.getAttribute("trand") : pTransRoot.getAttribute("layby_due");
            try {
                pFinalPayDate.setTimestampInternal(dateAtt.getValue());
            }
            catch (Exception e) {
                // empty catch block
            }
            PosDateFormatter.truncateTime(pNextPayDate.getTimestamp());
            PosDateFormatter.truncateTime(pFinalPayDate.getTimestamp());
        } else {
            pNextPayDate.setTimestampInternal("");
            pFinalPayDate.setTimestampInternal("");
        }
    }

    public static void setTableTabing(JTable pTbl) {
        pTbl.setRowSelectionAllowed(true);
        InputMap inpMap = pTbl.getInputMap(1);
        KeyStroke ksTab = KeyStroke.getKeyStroke(9, 0);
        KeyStroke ksEnter = KeyStroke.getKeyStroke(10, 0);
        final Action oldTabAction = pTbl.getActionMap().get(inpMap.get(ksTab));
        AbstractAction newTabAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                oldTabAction.actionPerformed(e);
                JTable table = (JTable)e.getSource();
                int rowCount = table.getRowCount();
                int columnCount = table.getColumnCount();
                int row = table.getSelectedRow();
                int column = table.getSelectedColumn();
                while (!table.isCellEditable(row, column)) {
                    if (++column == columnCount) {
                        column = 0;
                        ++row;
                    }
                    if (row == rowCount) {
                        row = 0;
                    }
                    if (row != table.getSelectedRow() || column != table.getSelectedColumn()) continue;
                }
                table.editCellAt(row, column);
                table.changeSelection(row, column, false, false);
            }
        };
        pTbl.getActionMap().put(inpMap.get(ksTab), newTabAction);
        pTbl.getActionMap().put(inpMap.get(ksEnter), newTabAction);
        KeyStroke ksShiftTab = KeyStroke.getKeyStroke(9, 64);
        final Action oldShiftTabAction = pTbl.getActionMap().get(inpMap.get(ksShiftTab));
        AbstractAction newShiftTabAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                oldShiftTabAction.actionPerformed(e);
                JTable table = (JTable)e.getSource();
                int rowCount = table.getRowCount();
                int columnCount = table.getColumnCount();
                int row = table.getSelectedRow();
                int column = table.getSelectedColumn();
                while (!table.isCellEditable(row, column)) {
                    if (--column < 0) {
                        column = columnCount - 1;
                        --row;
                    }
                    if (row < 0) {
                        row = rowCount - 1;
                    }
                    if (row != table.getSelectedRow() || column != table.getSelectedColumn()) continue;
                }
                table.editCellAt(row, column);
                table.changeSelection(row, column, false, false);
            }
        };
        pTbl.getActionMap().put(inpMap.get(ksShiftTab), newShiftTabAction);
    }

    public static String getTransNumber(Element pTransRoot) {
        String fullTransNumber = null;
        try {
            String storeno = pTransRoot.getAttribute("widx") != null ? SP.sParams.getStore(pTransRoot.getAttribute("widx").getLongValue()).getStoreNo() : "000";
            String transNumber = pTransRoot.getAttribute("trans_number") != null ? pTransRoot.getAttribute("trans_number").getValue() : "";
            fullTransNumber = storeno + transNumber;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fullTransNumber == null ? "" : fullTransNumber;
    }

    public static String getDocketNumber(Element pTransRoot) {
        String fullDocketNumber = null;
        try {
            String storeno = pTransRoot.getAttribute("widx") != null ? SP.sParams.getStore(pTransRoot.getAttribute("widx").getLongValue()).getStoreNo() : "000";
            String docketNumber = pTransRoot.getAttribute("docket_number") != null ? pTransRoot.getAttribute("docket_number").getValue() : "";
            fullDocketNumber = "D" + storeno + docketNumber;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fullDocketNumber == null ? "" : fullDocketNumber;
    }

    public static RetTranP tendersXMLToLastLaybyRetTranP(List<?> pOldTendersXML) {
        RetTranP retTranP;
        block9: {
            retTranP = null;
            if (pOldTendersXML != null) {
                try {
                    try {
                        if (pOldTendersXML.size() <= 1) break block9;
                        int i = pOldTendersXML.size() - 1;
                        Element elem = (Element)pOldTendersXML.get(i);
                        List subTenders = elem.getChildren("tender");
                        for (int j = 0; j < subTenders.size(); ++j) {
                            Element tenXML = (Element)subTenders.get(j);
                            long payTyIdx = tenXML.getAttribute("payment_typeidx").getLongValue();
                            try {
                                if (PayTypes.getPayType((long)payTyIdx).idx != 457L && PayTypes.getPayType((long)payTyIdx).idx != 643L) continue;
                                retTranP = new RetTranP(elem, tenXML);
                                if (retTranP.getAmount() >= 0.0) {
                                    retTranP = null;
                                }
                                break;
                            }
                            catch (Exception e) {
                                PosUtils.logError(e);
                            }
                        }
                    }
                    catch (DataConversionException e) {
                        PosUtils.logError(e);
                    }
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
        }
        return retTranP;
    }

    public static double tendersXMLToVRetTranPs(List<?> pOldTendersXML, Vector<RetTranP> vOldRetTranPs) {
        int i;
        double nOldPaymentTotal = 0.0;
        vOldRetTranPs.removeAllElements();
        if (pOldTendersXML != null) {
            try {
                try {
                    for (i = 0; i < pOldTendersXML.size(); ++i) {
                        Element elem = (Element)pOldTendersXML.get(i);
                        List subTenders = elem.getChildren("tender");
                        Hashtable<PayType, RetTranP> htTenders = new Hashtable<PayType, RetTranP>();
                        for (int j = 0; j < subTenders.size(); ++j) {
                            Element tenXML = (Element)subTenders.get(j);
                            long payTyIdx = tenXML.getAttribute("payment_typeidx").getLongValue();
                            try {
                                if (PayTypes.getPayType((long)payTyIdx).isExcluded && PayTypes.getPayType((long)payTyIdx).idx != 518L && PayTypes.getPayType((long)payTyIdx).idx != 647L) continue;
                                RetTranP payment = new RetTranP(elem, tenXML);
                                RetTranP retTranPInHash = (RetTranP)htTenders.get(payment.getPayType());
                                if (retTranPInHash != null) {
                                    retTranPInHash.setAmount(retTranPInHash.getAmount() + payment.getAmount());
                                    if (retTranPInHash.getPayType().isEFT && (retTranPInHash.getETran() == null || retTranPInHash.getETran().getStan().equals("") || !retTranPInHash.getETran().getPaymentGWProvider().equalsIgnoreCase("adyen"))) {
                                        retTranPInHash.eftposTran = null;
                                    }
                                } else {
                                    vOldRetTranPs.add(payment);
                                    htTenders.put(payment.getPayType(), payment);
                                }
                                nOldPaymentTotal += payment.getAmount();
                                continue;
                            }
                            catch (Exception e) {
                                PosUtils.logError(e);
                            }
                        }
                    }
                }
                catch (DataConversionException e) {
                    PosUtils.logError(e);
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
        if (SP.sParams.isEftposProviderAdyen()) {
            for (i = 0; i < vOldRetTranPs.size(); ++i) {
                PayType eftWallet;
                if (!vOldRetTranPs.get((int)i).getPayType().isEFT || (eftWallet = PayTypes.getEftposWalletPayType(vOldRetTranPs.get(i))) == null) continue;
                vOldRetTranPs.get(i).setPayType(eftWallet);
            }
        }
        return nOldPaymentTotal;
    }

    public static double getLaybyTotal(List<?> pOldTendersXML) {
        double nOldLaybyTotal = 0.0;
        if (pOldTendersXML != null) {
            try {
                try {
                    for (int i = 0; i < pOldTendersXML.size(); ++i) {
                        Element elem = (Element)pOldTendersXML.get(i);
                        List subTenders = elem.getChildren("tender");
                        for (int j = 0; j < subTenders.size(); ++j) {
                            Element tenXML = (Element)subTenders.get(j);
                            long payTyIdx = tenXML.getAttribute("payment_typeidx").getLongValue();
                            if (payTyIdx != 456L && payTyIdx != 642L) continue;
                            RetTranP retTranP = new RetTranP(elem, tenXML);
                            nOldLaybyTotal += retTranP.getAmount();
                        }
                    }
                }
                catch (DataConversionException e) {
                    PosUtils.logError(e);
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
        return nOldLaybyTotal;
    }

    public static String trimCleanUp(String sIn) {
        StringBuffer sOut = new StringBuffer();
        try {
            int i;
            sOut.append(sIn);
            int nLength = sOut.length();
            for (i = 0; i < nLength; ++i) {
                if (sOut.charAt(i) >= ' ' && sOut.charAt(i) <= '~') continue;
                sOut.deleteCharAt(i);
                nLength = sOut.length();
            }
            for (i = sOut.length() - 1; i > 0 && sOut.charAt(i) == ' '; --i) {
                sOut.deleteCharAt(i);
            }
            for (i = 0; i < sOut.length() && sOut.charAt(i) == ' '; ++i) {
                sOut.deleteCharAt(i);
                --i;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
            sOut.setLength(0);
        }
        return sOut.toString();
    }

    public static DecBuffer getBalance(JDialog flgParent, FrSales frSales) {
        DecBuffer balance = new DecBuffer();
        try {
            Element person = frSales.getPerson();
            SP.sParams.root = SP.sParams.OnlineQueryProvider.getOnlineQuery("cust", person.getAttribute("custidx").getValue()).getXML();
            if (SP.sParams.root != null) {
                Element cust = (Element)SP.sParams.root.clone();
                if (cust.getAttribute("custidx") == null) {
                    DlgMessage.showMessage(flgParent, SP.getRS("no_cust_dets"), SP.getRS("Error"), 0);
                } else {
                    balance.setValue(cust.getAttribute("balance").getDoubleValue());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return balance;
    }

    public static void checkEFTsInProgessDet(Window parent) {
        block88: {
            try (PreparedStatement stmtDetails = SP.sParams.conn.prepareStatement("SELECT D.VSHIDX, D.CRDT, D.REQUEST_ID, P.PAYMENT_AMOUNT, P.EFTPOS_ATTEMPTS, RP.VSHIDX AS REVERSING_VSHIDX FROM EFTPOS_INCOMPLETE_DET D JOIN RET_TRANP P ON D.VSHIDX = P.VSHIDX LEFT JOIN RET_TRANP RP ON D.REVERSING_VSHIDX = RP.VSHIDX WHERE D.TILL_NUMBER = ?");){
                stmtDetails.setString(1, SP.sParams.tillnum);
                try (ResultSet resultDetails = stmtDetails.executeQuery();){
                    Object message;
                    boolean manualConfirmationRequired;
                    if (!resultDetails.next()) break block88;
                    long vshidx = resultDetails.getLong("VSHIDX");
                    Timestamp createdDate = resultDetails.getTimestamp("CRDT");
                    double amount = resultDetails.getDouble("PAYMENT_AMOUNT");
                    int lastAttemptCount = resultDetails.getInt("EFTPOS_ATTEMPTS");
                    String requestId = resultDetails.getString("REQUEST_ID");
                    String lastTransactionReference = Long.toString(vshidx);
                    long reversingVshidx = resultDetails.getLong("REVERSING_VSHIDX");
                    if (SP.sParams.isEftposProviderAdyen() && requestId != null && !requestId.isEmpty()) {
                        lastTransactionReference = requestId;
                    }
                    EftposUtils.debugPoint(PosMenuController.getInstance().getOpenFrame(), "Found incomplete eftpos transaction\nTransaction Reference: " + lastTransactionReference + ", Date/Time: " + createdDate.toString());
                    String lastReceipt = null;
                    boolean lastTransactionSuccessful = false;
                    boolean bl = manualConfirmationRequired = SP.sParams.eftpos.getProviderName().equals("Tyro") || SP.sParams.eftpos.getProviderName().equals("POSNET");
                    while (true) {
                        if (manualConfirmationRequired) {
                            String question;
                            EftposUtils.debugPoint(PosMenuController.getInstance().getOpenFrame(), "Asking user to determine result of last Eftpos transaction...");
                            lastReceipt = "Receipt is unavailable";
                            String string = question = reversingVshidx > 0L ? MessageFormat.format(SP.getRS("eftpos_recovery_manual_confirmation_reversal"), SP.sParams.eftpos.getProviderName(), "\n", SP.sParams.currFormat.format(amount)) : MessageFormat.format(SP.getRS("eftpos_recovery_manual_confirmation"), SP.sParams.eftpos.getProviderName(), "\n", SP.sParams.currFormat.format(amount));
                            if (DlgMessage.showMessage(PosMenuController.getInstance().getOpenFrame(), question, StoreParams.res.getString("eftpos_recovery"), 0, 3) == 0) {
                                lastTransactionSuccessful = true;
                                EftposUtils.logInfo(SP.sParams.conn, lastTransactionReference, EftposUtils.Action.INFORMATION, "User manually determined that the transaction was successful");
                                break;
                            }
                            EftposUtils.logInfo(SP.sParams.conn, lastTransactionReference, EftposUtils.Action.INFORMATION, "User manually determined that the transaction was not successful");
                            break;
                        }
                        EftposUtils.debugPoint(PosMenuController.getInstance().getOpenFrame(), "Attempting to automatically determine result of last Eftpos transaction...");
                        StringBuffer sbResult = new StringBuffer();
                        if (!SP.sParams.eftpos.getLastTransactionDetails(parent, lastTransactionReference, lastAttemptCount, sbResult)) {
                            String message2 = "Unable to get last EFTPOS transaction details\n" + sbResult;
                            EftposUtils.debugPoint(PosMenuController.getInstance().getOpenFrame(), message2);
                            if (SP.sParams.eftpos.getProviderName().equalsIgnoreCase("Payment Express")) break;
                            if (DlgMessage.showMessage(PosMenuController.getInstance().getOpenFrame(), SP.getRS("eftpos_recovery_retry_get_last"), SP.getRS("eftpos_recovery"), 0, 3) == 0) continue;
                            manualConfirmationRequired = true;
                            continue;
                        }
                        String sEftposRef = Utils.stringReplace(SP.sParams.eftpos.getLastTranRef(), " ", "");
                        EftposUtils.debugPoint(PosMenuController.getInstance().getOpenFrame(), "Reprinting last receipt");
                        if (!SP.sParams.eftpos.reprintLast()) {
                            String message3 = "Unable to reprint last EFTPOS transaction details\n" + sbResult;
                            EftposUtils.debugPoint(PosMenuController.getInstance().getOpenFrame(), message3);
                        }
                        if ((lastReceipt = SP.sParams.eftposReceipt) == null || lastReceipt.isEmpty()) {
                            lastReceipt = "Receipt is unavailable";
                        }
                        EftposUtils.debugPoint(PosMenuController.getInstance().getOpenFrame(), "Last transaction reference: " + sEftposRef + "\nLast transaction receipt:\n" + lastReceipt);
                        if (lastTransactionReference.equals(sEftposRef) && SP.sParams.eftpos.getLastTranSuccessful()) {
                            lastTransactionSuccessful = true;
                            break;
                        }
                        PosDateFormatter dateFormatter = new PosDateFormatter(createdDate, 3, 3, 2);
                        message = "Mismatch on last eftpos transaction.\nLast AP21POS transaction reference = \"" + lastTransactionReference + "\".\n" + "Last eftpos machine reference = \"" + sEftposRef + "\".\n" + "Transaction timestamp = " + dateFormatter.toString();
                        EftposUtils.debugPoint(PosMenuController.getInstance().getOpenFrame(), (String)message);
                        if (SP.sParams.isEftposProviderAdyen()) break;
                        manualConfirmationRequired = true;
                    }
                    try {
                        Throwable throwable;
                        PosUtils.startTrans(SP.sParams.conn);
                        if (lastTransactionSuccessful) {
                            EftposUtils.debugPoint(PosMenuController.getInstance().getOpenFrame(), "Last eftpos transaction was successful\nUpdating RET_TRANP table with reprinted receipt info\nVSHIDX: " + vshidx);
                            long nBlobidx = SP.sParams.nextVal("XBLOBTEXT") * -1L;
                            PreparedStatement stmtBlobText = SP.sParams.conn.prepareStatement("INSERT INTO BLOBTEXT(BLOBIDX, BLOBTEXT) VALUES(?, ?)");
                            message = null;
                            try {
                                stmtBlobText.setLong(1, nBlobidx);
                                stmtBlobText.setString(2, lastReceipt);
                                stmtBlobText.executeUpdate();
                            }
                            catch (Throwable throwable2) {
                                message = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (stmtBlobText != null) {
                                    if (message != null) {
                                        try {
                                            stmtBlobText.close();
                                        }
                                        catch (Throwable throwable3) {
                                            ((Throwable)message).addSuppressed(throwable3);
                                        }
                                    } else {
                                        stmtBlobText.close();
                                    }
                                }
                            }
                            String eftposStan = null;
                            if (SP.sParams.isEftposProviderAdyen()) {
                                eftposStan = String.valueOf(SP.sParams.eftpos.getLastTranAdditionalData());
                            }
                            try (PreparedStatement stmtRetTranP = SP.sParams.conn.prepareStatement("UPDATE RET_TRANP SET EFTPOS_BLOBIDX = ?, EFTPOS_STAN = ? WHERE VSHIDX = ?");){
                                stmtRetTranP.setLong(1, nBlobidx);
                                stmtRetTranP.setString(2, eftposStan);
                                stmtRetTranP.setLong(3, vshidx);
                                stmtRetTranP.executeUpdate();
                            }
                            if (reversingVshidx > 0L) {
                                EftposUtils.debugPoint(PosMenuController.getInstance().getOpenFrame(), "Last eftpos transaction was a reversal on another transaction.\nDeactivating both RET_TRANP records\nVSHIDX: " + vshidx + "\nREVERSED VSHIDX: " + reversingVshidx);
                                SqlQuery.executeUpdate(SP.sParams.conn, "UPDATE RET_TRANP SET \"ACTIVE\" = 0 WHERE VSHIDX = ? OR VSHIDX = ?", vshidx, reversingVshidx);
                            }
                        } else {
                            EftposUtils.debugPoint(PosMenuController.getInstance().getOpenFrame(), "Last eftpos transaction was not successful\n Inactivating RET_TRANP record\nVSHIDX: " + vshidx);
                            throwable = null;
                            try (PreparedStatement stmtRetTranP = SP.sParams.conn.prepareStatement("UPDATE RET_TRANP SET \"ACTIVE\" = 0 WHERE VSHIDX = ?");){
                                stmtRetTranP.setLong(1, vshidx);
                                stmtRetTranP.executeUpdate();
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                                throw throwable4;
                            }
                        }
                        EftposUtils.debugPoint(PosMenuController.getInstance().getOpenFrame(), "Deleting from EFTPOS_INCOMPLETE_DET table\nVSHIDX: " + vshidx);
                        throwable = null;
                        try (PreparedStatement stmtIncomplete = SP.sParams.conn.prepareStatement("DELETE FROM EFTPOS_INCOMPLETE_DET WHERE VSHIDX = ? AND TILL_NUMBER = ?");){
                            stmtIncomplete.setLong(1, vshidx);
                            stmtIncomplete.setString(2, SP.sParams.tillnum);
                            stmtIncomplete.executeUpdate();
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        PosUtils.endTrans(SP.sParams.conn);
                    }
                    catch (Exception e) {
                        PosUtils.releaseTrans(SP.sParams.conn);
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    public static boolean checkEFTsInProgessHdr() {
        boolean foundIncompleteTrans = false;
        try (PreparedStatement stmtHdr = SP.sParams.conn.prepareStatement("SELECT E.VHIDX, E.CRDT, W.STORENO, H.DOCKET_NUMBER \nFROM EFTPOS_INCOMPLETE_HDR E, RET_TRANH H, WHSE W \nWHERE E.TILL_NUMBER = ? AND E.VHIDX = H.VHIDX AND  W.WIDX = H.WIDX ORDER BY H.VHIDX");){
            stmtHdr.setString(1, SP.sParams.tillnum);
            try (ResultSet resultHdr = stmtHdr.executeQuery();){
                while (resultHdr.next()) {
                    foundIncompleteTrans = true;
                    long vhidx = resultHdr.getLong(1);
                    Timestamp createdDate = resultHdr.getTimestamp(2);
                    String storeNumber = resultHdr.getString(3);
                    String docketNumber = resultHdr.getString(4);
                    Vector<RetTranP> vRetTranPs = new Vector<RetTranP>();
                    boolean bFoundDetails = false;
                    try (PreparedStatement stmtDets = SP.sParams.conn.prepareStatement("SELECT P.VSHIDX, P.PAYMENT_TYPEIDX, P.PAYMENT_AMOUNT, P.CASHOUT_AMOUNT, P.EFTPOS_ACTYPE, P.EFTPOS_CARDTYPE, P.EFTPOS_STAN, EFTPOS_REFERENCE \nFROM RET_TRANP P \nWHERE P.\"ACTIVE\" = 1 AND P.EFTPOS_BLOBIDX IS NOT NULL AND P.VHIDX = ? \nORDER BY P.SEQUENCE_NUMBER");){
                        stmtDets.setLong(1, vhidx);
                        try (ResultSet resultDets = stmtDets.executeQuery();){
                            while (resultDets.next()) {
                                bFoundDetails = true;
                                long vshidx = resultDets.getLong(1);
                                long payTypeidx = resultDets.getLong(2);
                                double eftposAmt = resultDets.getDouble(3);
                                double eftposCashout = resultDets.getDouble(4);
                                String accountType = resultDets.getString(5);
                                String cardType = resultDets.getString(6);
                                String eftposStan = resultDets.getString(7);
                                String eftposReference = resultDets.getString(8);
                                RetTranP rtpReversing = new RetTranP(PayTypes.getPayType(payTypeidx), eftposAmt);
                                rtpReversing.setCashout(eftposCashout);
                                rtpReversing.vshIdx.setValue(vshidx);
                                rtpReversing.tranDate = createdDate;
                                rtpReversing.eftposTran = new ETran(String.valueOf(vshidx), accountType, cardType, eftposAmt < 0.0, Math.abs(eftposAmt), Math.abs(eftposCashout), SP.sParams.storeCurrency.getCode(), "");
                                rtpReversing.eftposTran.setStan(eftposStan);
                                if (SP.sParams.isEftposProviderAdyen() && eftposAmt < 0.0) {
                                    rtpReversing.eftposTran.setReference(eftposReference);
                                }
                                vRetTranPs.add(rtpReversing);
                            }
                        }
                    }
                    if (bFoundDetails) {
                        EFTRecoveryDlg eftRecoveryDlg = null;
                        eftRecoveryDlg = new EFTRecoveryDlg((Frame)PosMenuController.getInstance().getOpenFrame(), SP.getRS("eftpos_recovery"));
                        PosDateFormatter df = new PosDateFormatter(createdDate, 3, 3, 2);
                        String docketText = docketNumber == null || docketNumber.length() == 0 ? "Unassigned" : "D" + storeNumber + docketNumber;
                        eftRecoveryDlg.setSaleDets(vhidx, MessageFormat.format(SP.getRS("receipt_date"), docketText, df.toString()), vRetTranPs);
                        eftRecoveryDlg.setVisible(true);
                        if (eftRecoveryDlg.getResult()) {
                            EftposUtils.debugPoint(PosMenuController.getInstance().getOpenFrame(), "Eftpos reversal successful\nVHIDX: " + vhidx);
                            PayUtils.deleteEftposIncompleteHdr(PosMenuController.getInstance().getOpenFrame(), vhidx);
                            continue;
                        }
                        EftposUtils.debugPoint(PosMenuController.getInstance().getOpenFrame(), "Eftpos reversal unsuccessful\nVHIDX: " + vhidx);
                        continue;
                    }
                    EftposUtils.debugPoint(PosMenuController.getInstance().getOpenFrame(), "No lines to reverse\nVHIDX: " + vhidx);
                    PayUtils.deleteEftposIncompleteHdr(PosMenuController.getInstance().getOpenFrame(), vhidx);
                    DlgMessage.showMessage(PosMenuController.getInstance().getOpenFrame(), MessageFormat.format(SP.getRS("last_trans_not_successful"), "\n"), SP.getRS("unexpected_shutdown_during_transaction"), 1);
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return foundIncompleteTrans;
    }

    public static void deleteEftposIncompleteHdr(Window parent, long vhidx) throws SQLException {
        EftposUtils.debugPoint(parent, "Deleting from EFTPOS_INCOMPLETE_HDR table\nVHIDX: " + vhidx);
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("DELETE FROM EFTPOS_INCOMPLETE_HDR WHERE VHIDX = ?");){
            stmt.setLong(1, vhidx);
            stmt.executeUpdate();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasCreditNote(long vhidx) {
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT COUNT(*) FROM RET_TRANP P, RET_PAY_TYPES T WHERE P.PAYMENT_TYPEIDX = T.RCIDX AND P.\"ACTIVE\" = 1 AND T.IS_CREDIT_NOTE = 1 AND P.PAYMENT_AMOUNT < 0 AND P.VHIDX = ?");){
            stmt.setLong(1, vhidx);
            try (ResultSet result = stmt.executeQuery();){
                if (result.next()) {
                    boolean bl = result.getInt(1) > 0;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    public static ReceiptDeliveryMethod getReceiptDeliveryMethod(PosFrame parent, String origEmail, String origPhone, String country) {
        email = "";
        phone = "";
        if (!SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.PROMPT_FOR_DIGITAL_RECEIPT)) {
            return ReceiptDeliveryMethod.PRINT_ONLY;
        }
        ReceiptDeliveryMethod deliveryMethod = ReceiptDeliveryMethod.PRINT_ONLY;
        if (SP.sParams.sPromptForEmailReceipt != null && SP.sParams.sPromptForEmailReceipt.length() > 0) {
            Vector<String> settings = new Vector<String>();
            int tokenCount = Utils.stringTokenize(SP.sParams.sPromptForEmailReceipt, "@", settings);
            boolean emailActive = false;
            boolean smsActive = false;
            boolean smsParamActive = false;
            if (tokenCount >= 1) {
                deliveryMethod = PayUtils.intToReceiptDeliveryMethod(PosUtils.intVal(settings.elementAt(0)));
                if (tokenCount >= 3) {
                    if (tokenCount >= 4) {
                        emailActive = PosUtils.intVal(settings.elementAt(3)) == 1;
                        boolean bl = smsParamActive = PosUtils.intVal(settings.elementAt(4)) == 1;
                    }
                    if (smsParamActive) {
                        String slypId = SP.sParams.getSlypStoreId();
                        boolean bl = smsActive = slypId != null && !slypId.isEmpty();
                    }
                    if (parent.transType == 240 || parent.transType == 242 || parent.transType == 241) {
                        if (PosUtils.intVal(settings.elementAt(1)) == 0) {
                            return ReceiptDeliveryMethod.PRINT_ONLY;
                        }
                        smsActive = false;
                    }
                    if (parent.transType == 714 && ((FrSales)parent).deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.DELIVERY) {
                        if (tokenCount < 6 || PosUtils.intVal(settings.elementAt(5)) == 0) {
                            return ReceiptDeliveryMethod.PRINT_ONLY;
                        }
                        smsActive = false;
                    }
                    if (parent.transType == 714 && ((FrSales)parent).deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.CUSTOMER_PICKUP) {
                        if (tokenCount < 7 || PosUtils.intVal(settings.elementAt(6)) == 0) {
                            return ReceiptDeliveryMethod.PRINT_ONLY;
                        }
                        smsActive = false;
                    }
                    if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.EYOS_API_SETTINGS)) {
                        smsActive = smsParamActive;
                        emailActive = true;
                    }
                }
                ReceiptDeliveryMethodDlg dlg = new ReceiptDeliveryMethodDlg(parent, deliveryMethod, emailActive, smsActive, origEmail, origPhone, country);
                deliveryMethod = dlg.getDeliveryMethod();
                email = dlg.getEmail();
                phone = dlg.getSms();
            }
        }
        return deliveryMethod;
    }

    public static int ReceiptDeliveryMethodToInt(ReceiptDeliveryMethod deliveryMethod) {
        switch (deliveryMethod) {
            case EMAIL_ONLY: {
                return 0;
            }
            case EMAIL_AND_PRINT: {
                return 1;
            }
            case PRINT_ONLY: {
                return 2;
            }
            case SMS_ONLY: {
                return 3;
            }
            case EMAIL_AND_SMS: {
                return 4;
            }
            case SMS_AND_PRINT: {
                return 5;
            }
            case EMAIL_AND_SMS_AND_PRINT: {
                return 6;
            }
        }
        return 2;
    }

    public static ReceiptDeliveryMethod intToReceiptDeliveryMethod(int value) {
        switch (value) {
            case 0: {
                return ReceiptDeliveryMethod.EMAIL_ONLY;
            }
            case 1: {
                return ReceiptDeliveryMethod.EMAIL_AND_PRINT;
            }
            case 2: {
                return ReceiptDeliveryMethod.PRINT_ONLY;
            }
            case 3: {
                return ReceiptDeliveryMethod.SMS_ONLY;
            }
            case 4: {
                return ReceiptDeliveryMethod.EMAIL_AND_SMS;
            }
            case 5: {
                return ReceiptDeliveryMethod.SMS_AND_PRINT;
            }
            case 6: {
                return ReceiptDeliveryMethod.EMAIL_AND_SMS_AND_PRINT;
            }
        }
        return ReceiptDeliveryMethod.PRINT_ONLY;
    }

    public static boolean isNonPrint(ReceiptDeliveryMethod check) {
        return check == ReceiptDeliveryMethod.EMAIL_ONLY || check == ReceiptDeliveryMethod.SMS_ONLY || check == ReceiptDeliveryMethod.EMAIL_AND_SMS;
    }

    public static String getEmail() {
        return email;
    }

    public static String getSms() {
        return phone;
    }

    public static enum ReceiptDeliveryMethod {
        EMAIL_ONLY,
        EMAIL_AND_PRINT,
        PRINT_ONLY,
        SMS_ONLY,
        EMAIL_AND_SMS,
        SMS_AND_PRINT,
        EMAIL_AND_SMS_AND_PRINT,
        PRINT_GIFT_ONLY,
        EMAIL_AND_PRINT_GIFT,
        PRINT_AND_PRINT_GIFT,
        EMAIL_AND_PRINT_AND_PRINT_GIFT;

    }
}

