/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import JCP.JcpApi;
import JCP.JcpObject;
import JCP.JcpRequestResult;
import java.io.BufferedReader;
import java.io.FileReader;
import java.nio.file.Paths;
import jpos.PosUtils;

public class PrinterProvider
extends JcpObject {
    private int printerProviderID = -1;

    private int getPrinterProviderInstance() {
        if (this.printerProviderID == -1) {
            try {
                JcpRequestResult result = JcpApi.CreateObject((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (String)"Bass.Ap21.Pos.PosPlatformExchange.PrinterProvider", (Object[])new Object[0]);
                if (!result.getSuccess()) {
                    throw new Exception(result.getCustomMessage() + "\r\n" + result.getErrorMessage() + "\r\n" + result.getStackTrace());
                }
                this.printerProviderID = result.getRequestResultAsInt();
            }
            catch (Exception e) {
                PosUtils.logError(e);
                this.printerProviderID = -1;
            }
        }
        return this.printerProviderID;
    }

    public String getPrinterName(String serverName, String shareName) throws Exception {
        if (this.getPrinterProviderInstance() > 0) {
            JcpRequestResult result = JcpApi.InvokeMethod((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (int)this.printerProviderID, (String)"GetPrinterName", (Object[])new Object[]{serverName, shareName});
            if (result.getSuccess()) {
                return result.getRequestResultAsString(0);
            }
            throw new Exception(result.getErrorMessage());
        }
        return null;
    }

    public String getPrinterStatus(String printerName) throws Exception {
        if (this.getPrinterProviderInstance() > 0) {
            JcpRequestResult result = JcpApi.InvokeMethod((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (int)this.printerProviderID, (String)"GetPrinterStatus", (Object[])new Object[]{printerName});
            if (result.getSuccess()) {
                return result.getRequestResultAsString(0);
            }
            throw new Exception(result.getErrorMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String openDocument(String fileName) throws Exception {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(fileName));){
            if (bufferedReader.readLine() == null) {
                String string = null;
                return string;
            }
        }
        catch (Exception e) {
            return "File does not exist: " + Paths.get(fileName, new String[0]).getFileName().toString();
        }
        if (this.getPrinterProviderInstance() <= 0) return null;
        JcpRequestResult result = JcpApi.InvokeMethod((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (int)this.printerProviderID, (String)"OpenDocument", (Object[])new Object[]{fileName});
        if (!result.getSuccess()) throw new Exception(result.getErrorMessage());
        return result.getRequestResultAsString(0);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.printerProviderID > 0) {
            JcpApi.ReleaseObject((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (int)this.printerProviderID);
            this.printerProviderID = -1;
        }
    }
}

