/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay.braintree;

import bass.eftpos.StringUtils;
import com.braintreegateway.BraintreeGateway;
import com.braintreegateway.Configuration;
import com.braintreegateway.Environment;
import com.braintreegateway.Result;
import com.braintreegateway.Transaction;
import com.braintreegateway.TransactionRefundRequest;
import com.braintreegateway.exceptions.NotFoundException;
import com.braintreegateway.exceptions.TimeoutException;
import com.braintreegateway.exceptions.UnexpectedException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.math.BigDecimal;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpos.SP;
import jpos.logging.RollingLog;
import jpos.pay.PaymentGatewayConfig;
import jpos.pay.RetTranP;
import jpos.pay.braintree.BraintreeTran;

public class Braintree {
    private String merchantId;
    private String merchantAccountId;
    private String publicKey;
    private String privateKey;
    private Environment environment;
    private BraintreeGateway gateway;

    public Braintree(PaymentGatewayConfig gatewayConfig) {
        this.merchantId = gatewayConfig.getMerchantID();
        this.merchantAccountId = gatewayConfig.getMerchantAccountID();
        this.publicKey = gatewayConfig.getPublicKey();
        this.privateKey = gatewayConfig.getPrivateKey();
        this.environment = gatewayConfig.getConnectTo().equals("Test") ? Environment.SANDBOX : Environment.PRODUCTION;
        this.gateway = new BraintreeGateway(this.environment, this.merchantId, this.publicKey, this.privateKey);
        Configuration config = this.gateway.getConfiguration();
        Logger log = config.getLogger();
        log.setLevel(Level.OFF);
        config.setLogger(log);
    }

    public boolean RefundRequest(RetTranP retTranP, StringBuilder processMsg) {
        try {
            BraintreeTran braintreeTran = (BraintreeTran)retTranP.getETran();
            TransactionRefundRequest refundRequest = new TransactionRefundRequest();
            refundRequest.amount(new BigDecimal(Math.abs(retTranP.getAmount())).setScale(2, 6));
            refundRequest.merchantAccountId(this.merchantAccountId);
            if (StringUtils.isNullOrEmpty((String)braintreeTran.getOrigStan())) {
                this.SetProcessMessage(processMsg, "Cannot find original Braintree payment ID");
                return false;
            }
            RollingLog.log(RollingLog.LogType.BRAINTREE, Level.INFO, this.GetRequestLog(braintreeTran.getOrigStan(), refundRequest));
            Result result = this.gateway.transaction().refund(braintreeTran.getOrigStan(), refundRequest);
            RollingLog.log(RollingLog.LogType.BRAINTREE, Level.INFO, "Braintree Refund Result" + System.lineSeparator() + this.GetResponseLog(result));
            if (result.isSuccess()) {
                braintreeTran.setReference(((Transaction)result.getTarget()).getId().toString());
                return true;
            }
            if (!StringUtils.isNullOrEmpty((String)result.getMessage())) {
                this.SetProcessMessage(processMsg, result.getMessage());
            }
        }
        catch (Exception e) {
            RollingLog.log(RollingLog.LogType.BRAINTREE, Level.INFO, this.GetResponseLog(e));
            if (e instanceof NotFoundException) {
                this.SetProcessMessage(processMsg, "The original payment reference provided is invalid");
            }
            if (e instanceof UnexpectedException) {
                StringBuilder sb = new StringBuilder();
                sb.append("Error communicating with Braintree.");
                sb.append("\r\n");
                sb.append("Please check your internet connection and try again.");
                this.SetProcessMessage(processMsg, sb.toString());
            }
            if (e instanceof TimeoutException) {
                this.SetProcessMessage(processMsg, "The refund request has timed out. Please try again.");
            }
            this.SetProcessMessage(processMsg, e.getMessage());
        }
        return false;
    }

    private void SetProcessMessage(StringBuilder processMsg, String error) {
        if (!StringUtils.isNullOrEmpty((String)error)) {
            try {
                String err = error.replace(" ", "_");
                if (!StringUtils.isNullOrEmpty((String)SP.getRS(err))) {
                    processMsg.append(SP.getRS(err));
                    processMsg.append("\r\n");
                }
            }
            catch (Exception e) {
                processMsg.append(error);
                processMsg.append("\r\n");
            }
        }
    }

    private String GetRequestLog(String origStan, TransactionRefundRequest refundRequest) {
        StringBuilder requestLog = new StringBuilder();
        requestLog.append("Braintree Refund Request");
        requestLog.append("\r\n");
        requestLog.append("Original Payment Stan: " + origStan);
        requestLog.append("\r\n");
        Gson prettyJson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        requestLog.append("Braintree Refund Request: " + prettyJson.toJson((Object)refundRequest));
        return requestLog.toString();
    }

    private String GetResponseLog(Object e) {
        Gson prettyJson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return "Braintree Refund Response: " + prettyJson.toJson(e);
    }
}

