/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay.eftpos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jpos.DecimalField;
import jpos.DlgMessage;
import jpos.PosFocusTraversalPolicy;
import jpos.PosScrollPane;
import jpos.PosUtils;
import jpos.SP;
import jpos.basscom.IntBuffer;
import jpos.pay.PayDialog;
import jpos.pay.PayHistTM;
import jpos.pay.PayHistTbl;
import jpos.pay.PayUtils;
import jpos.pay.RetTranP;
import jpos.pay.eftpos.EftposUtils;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;

public class EFTRecoveryDlg
extends PayDialog {
    GridBagLayout gridBagLayoutAll = new GridBagLayout();
    LabelSubHeading lDocketNumber = new LabelSubHeading();
    GridBagLayout gridBagLayoutDets = new GridBagLayout();
    JPanel panelDets = new JPanel(this.gridBagLayoutDets);
    PayHistTM payHistTM = new PayHistTM();
    PayHistTbl payHistTbl = new PayHistTbl(this.payHistTM);
    PosScrollPane spPayHist = new PosScrollPane(this.payHistTbl);
    LabelNormal lMessage = new LabelNormal();
    LabelNormal lTotalPaid = new LabelNormal();
    DecimalField dfTotalPaid;
    double totalPaid;
    GridBagLayout gridBagLayoutFooter;
    JPanel panelFooter;
    DialogButton bOk;
    DialogButton bCancel;
    long vhIdx;
    Vector<RetTranP> vRetTranPs;

    public EFTRecoveryDlg(Frame parentFrame, String title) {
        super(parentFrame, title);
        this.dfTotalPaid = new DecimalField(SP.sParams.storeCurrency);
        this.gridBagLayoutFooter = new GridBagLayout();
        this.panelFooter = new JPanel(this.gridBagLayoutFooter);
        this.bOk = new DialogButton("", this);
        this.bCancel = new DialogButton("", this);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.panelAll.setLayout(this.gridBagLayoutAll);
        this.lDocketNumber.setText("D123456789");
        this.lMessage.setText(MessageFormat.format(SP.getRS("eftpos_recovery_message"), SP.sParams.eftpos.getProviderName()));
        this.initPanelDetails();
        this.initPanelFooter();
        this.panelAll.add((Component)this.lMessage, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(20, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.lDocketNumber, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(20, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.panelDets, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(10, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.panelFooter, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add(this.panelAll);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    private void initPanelDetails() {
        this.payHistTbl.revalidate();
        this.spPayHist.setPreferredSize(new Dimension(500, 100));
        this.spPayHist.setMinimumSize(new Dimension(500, 100));
        this.lTotalPaid.setText(SP.getRS("total_paid"));
        this.setAmtFieldProp(this.dfTotalPaid);
        this.dfTotalPaid.setEnabled(false);
        this.panelDets.setBorder(BorderFactory.createEtchedBorder());
        this.panelDets.add((Component)new JLabel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 10, 10), 0, 0));
        this.panelDets.add((Component)this.spPayHist, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(10, 20, 10, 20), 0, 100));
        this.panelDets.add((Component)this.lTotalPaid, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 20, 10, 10), 0, 0));
        this.panelDets.add((Component)this.dfTotalPaid, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 20), 0, 0));
        this.dfTotalPaid.setText("");
    }

    private void initPanelFooter() {
        this.setOkButton(this.bOk);
        this.setCancelButton(this.bCancel);
        this.bOk.setText(SP.getRS("Process"));
        this.bCancel.setText(SP.getRS("Skip"));
        this.panelFooter.add((Component)this.bOk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 20, 10), 0, 0));
        this.panelFooter.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 20, 10), 0, 0));
        this.panelFooter.setLayout(this.gridBagLayoutFooter);
    }

    @Override
    public boolean initDialog() {
        this.populateFields();
        return super.initDialog();
    }

    private void populateFields() {
        this.dfTotalPaid.setText(this.totalPaid);
    }

    @Override
    public void okDialog() {
        if (this.reverseEFTPOS()) {
            super.okDialog();
        } else {
            super.cancelDialog();
        }
    }

    @Override
    public void cancelDialog() {
        EftposUtils.debugPoint(this, "Eftpos reversal process skipped by user\nVHIDX: " + this.vhIdx);
        super.cancelDialog();
    }

    @Override
    public boolean myKeyPressed(KeyEvent k) {
        return false;
    }

    @Override
    public boolean getResult() {
        return this.result;
    }

    private boolean reverseEFTPOS() {
        EftposUtils.debugPoint(this, "Starting eftpos reversal process");
        boolean firstEftposPayment = true;
        for (int i = 0; i < this.vRetTranPs.size(); ++i) {
            RetTranP rtpReversing = this.vRetTranPs.get(i);
            RetTranP rtp = new RetTranP(rtpReversing.getPayType(), -rtpReversing.getAmount());
            rtp.setCashout(-rtpReversing.getCashout());
            rtp.setReversingRetTranP(rtpReversing);
            this.payHistTbl.setRowSelectionInterval(i, i);
            IntBuffer sequence = new IntBuffer(100);
            try {
                rtp.dbInsert(this, SP.sParams.conn, this.vhIdx, sequence);
                StringBuffer sbMessage = new StringBuffer();
                if (!firstEftposPayment) {
                    EftposUtils.eftposPaymentDelay();
                }
                firstEftposPayment = false;
                while (!rtp.doEFT(this, sbMessage)) {
                    if (!this.processRetryMessage(rtp)) {
                        return false;
                    }
                    sbMessage.setLength(0);
                }
                continue;
            }
            catch (Exception ex) {
                PosUtils.logError(ex);
                return false;
            }
        }
        EftposUtils.debugPoint(this, "Eftpos reversal process complete");
        return true;
    }

    private boolean processRetryMessage(RetTranP retTranP) throws SQLException {
        DlgMessage dlgMessage = new DlgMessage(this, SP.getRS("eftpos_try_again"), MessageFormat.format(SP.getRS("eftpos_try_again_yes_no"), "", "\n"), 1, 3);
        dlgMessage.getNoButton().setText(SP.getRS("Not_Now"));
        dlgMessage.getCancelButton().setText(SP.getRS("Never"));
        dlgMessage.setCloseAction(1);
        int result = dlgMessage.showMessage();
        if (result == 2) {
            EftposUtils.logInfo(SP.sParams.conn, Long.toString(retTranP.vshIdx.longValue()), EftposUtils.Action.INFORMATION, "Eftpos reversal process permanently cancelled by user. Contact bank to reverse payment. Record has been deactivated");
            this.deactivateRetTranP(retTranP);
            PayUtils.deleteEftposIncompleteHdr(this, retTranP.vhIdx.longValue());
            DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("permanently_cancel_recovery_message"), "\n"), SP.getRS("eftpos_recovery"), -1, 1);
            return false;
        }
        if (result == 1) {
            EftposUtils.logInfo(SP.sParams.conn, Long.toString(retTranP.vshIdx.longValue()), EftposUtils.Action.INFORMATION, "Eftpos reversal process temporarily cancelled by user. Record has been deactivated");
            this.deactivateRetTranP(retTranP);
            DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("temporarily_cancel_recovery_message"), "\n"), SP.getRS("eftpos_recovery"), -1, 1);
            return false;
        }
        return true;
    }

    private void deactivateRetTranP(RetTranP retTranP) throws SQLException {
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("UPDATE RET_TRANP SET \"ACTIVE\" = 0 WHERE VSHIDX = ?");){
            stmt.setLong(1, retTranP.vshIdx.longValue());
            stmt.execute();
        }
    }

    public void setSaleDets(long pVHIdx, String pDocketNumber, Vector<RetTranP> pRetTranPs) {
        this.lDocketNumber.setText(pDocketNumber);
        this.vRetTranPs = pRetTranPs;
        this.vhIdx = pVHIdx;
        this.payHistTM.setRetTranPs(pRetTranPs);
        this.totalPaid = this.payHistTbl.getTotal();
        this.payHistTM.fireTableDataChanged();
        this.payHistTbl.revalidate();
    }
}

