/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import jpos.PosDialog;
import jpos.PosScrollPane;
import jpos.PosTable;
import jpos.PosUtils;
import jpos.SP;
import jpos.person.CustSummaryItem;
import jpos.rewards.LegacyRewardsProgramPanel;
import jpos.rewards.RewardsAccount;
import jpos.rewards.RewardsUtils;
import jpos.ui.Colours;

public class LegacyFrCustHistSummary
extends JPanel {
    private static final int Period_COLUMN = 0;
    private static final int Total_Spend_COLUMN = 1;
    private static final String PERIOD = SP.getRS("Period");
    private static final String TOTAL = SP.getRS("Total_Spend");
    private static final int COL_COUNT = 2;
    private static final int MAX_COLUMN_WIDTH = 700;
    private static final int MIN_COLUMN_WIDTH = 130;
    private static final int PREFERRED_COLUMN_WIDTH = 250;
    private PosScrollPane scrollPaneSummary = new PosScrollPane();
    private PosDialog parentDlg;
    private SummaryTblModel summaryModel;
    private PosTable tblSummary;
    private LegacyRewardsProgramPanel rewardsPanel;

    public LegacyFrCustHistSummary(PosDialog parentDlg) {
        try {
            this.parentDlg = parentDlg;
            this.jbInit();
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    private void jbInit() {
        this.setBackground(Color.WHITE);
        this.setLayout(new GridBagLayout());
        this.summaryModel = new SummaryTblModel();
        this.tblSummary = new PosTable(this.parentDlg, this.summaryModel);
        this.tblInit();
        this.scrollPaneSummary.setPreferredSize(new Dimension(380, 400));
        this.scrollPaneSummary.setBorder(BorderFactory.createLineBorder(Colours.BLACK, 1));
        this.scrollPaneSummary.getViewport().add(this.tblSummary);
        if (RewardsUtils.usingAp21RetailRewards()) {
            this.rewardsPanel = new LegacyRewardsProgramPanel(this.parentDlg);
            this.add((Component)this.rewardsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.add((Component)this.scrollPaneSummary, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void tblInit() {
        this.tblSummary.getColumnModel().getColumn(0).setHeaderRenderer(this.tblSummary.headerLeftRen);
        this.tblSummary.getColumnModel().getColumn(1).setHeaderRenderer(this.tblSummary.headerRightRen);
        this.tblSummary.getTableHeader().setResizingAllowed(false);
        this.tblSummary.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.tblSummary.getColumnModel().getColumn(0).setMinWidth(130);
        this.tblSummary.getColumnModel().getColumn(0).setMaxWidth(700);
        this.tblSummary.getColumnModel().getColumn(1).setPreferredWidth(130);
        this.tblSummary.getColumnModel().getColumn(1).setMinWidth(130);
        this.tblSummary.renderer.setColumnFormat(0, null, 2);
        this.tblSummary.renderer.setColumnFormat(1, null, 4);
        this.tblSummary.getTableHeader().setResizingAllowed(true);
        this.tblSummary.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    public void reset() {
        if (RewardsUtils.usingAp21RetailRewards()) {
            this.rewardsPanel.reset();
        }
        this.summaryModel.data.removeAllElements();
        this.summaryModel.fireTableDataChanged();
    }

    public void populateSummaryData(Vector<CustSummaryItem> data) {
        for (int i = 0; i < data.size(); ++i) {
            this.summaryModel.data.add(data.get(i));
        }
        this.summaryModel.fireTableDataChanged();
    }

    public void populateRewards(long peridx, RewardsAccount customerRewardsProgram) {
        if (RewardsUtils.usingAp21RetailRewards()) {
            this.rewardsPanel.populateRewards(peridx, customerRewardsProgram);
        }
    }

    public boolean completeRequestedRewardsSignup(long peridx) {
        if (RewardsUtils.usingAp21RetailRewards() && this.rewardsPanel.isSignupRequested()) {
            return this.rewardsPanel.completeRequestedSignup(peridx);
        }
        return true;
    }

    public boolean isRewardsSignupRequested() {
        return RewardsUtils.usingAp21RetailRewards() && this.rewardsPanel.isSignupRequested();
    }

    public boolean rewardsSignUpIfRequired() {
        return RewardsUtils.usingAp21RetailRewards() && this.rewardsPanel.signUpIfRequired();
    }

    private class SummaryTblModel
    extends AbstractTableModel {
        private static final String PAD = "  ";
        Vector<CustSummaryItem> data = new Vector();

        private SummaryTblModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return PAD + this.data.elementAt(row).getDesc();
                }
                case 1: {
                    return this.data.elementAt(row).getSpend() + PAD;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return PERIOD;
            }
            return TOTAL;
        }
    }
}

