/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Vector;
import jpos.PosUtils;
import jpos.SP;

public class Location {
    private String city;
    private String state;
    private String postcode;

    public Location(String city, String state, String postcode) {
        this.city = city;
        this.state = state;
        this.postcode = postcode;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public String getPostcode() {
        return this.postcode;
    }

    public String toString() {
        return String.format("%s %s %s", this.city, this.state, this.postcode);
    }

    public static Vector<Location> getLocationList(String country) {
        Vector<Location> locations = new Vector<Location>();
        try (PreparedStatement pstmt = SP.sParams.conn.prepareStatement("SELECT TRIM(COALESCE(CITY,'')), TRIM(COALESCE(STATE,'')), TRIM(COALESCE(PCODE,'')) FROM POSTCODE WHERE COUNTRY = ? AND \"ACTIVE\" = 1 ORDER BY CITY, STATE, PCODE ");){
            pstmt.setString(1, country);
            try (ResultSet result = pstmt.executeQuery();){
                while (result.next()) {
                    locations.addElement(new Location(result.getString(1), result.getString(2), result.getString(3)));
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return locations;
    }
}

