/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="person")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Person
implements Comparable<Person> {
    @XmlAttribute(name="peridx")
    private Long peridx;
    @XmlAttribute(name="first_name")
    private String firstName;
    @XmlAttribute(name="surname")
    private String surname;
    @XmlAttribute(name="phone")
    private String phone;
    @XmlAttribute(name="email")
    private String email;
    @XmlAttribute(name="postcode")
    private String postcode;
    @XmlAttribute(name="rewards_loyalty")
    private String rewardsLoyalty;
    private String queryable = "";

    public Long getPeridx() {
        return this.peridx;
    }

    public void setPeridx(Long peridx) {
        this.peridx = peridx;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.surname;
    }

    public void setLastName(String lastName) {
        this.surname = lastName;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPostcode() {
        return this.postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public String getRewardsLoyalty() {
        return this.rewardsLoyalty;
    }

    public void setRewardsLoyalty(String rewardsLoyalty) {
        this.rewardsLoyalty = rewardsLoyalty;
    }

    public String getQueryString() {
        if (this.queryable.isEmpty() || this.queryable.equals("")) {
            this.setQueryString();
        }
        return this.queryable;
    }

    private void setQueryString() {
        this.queryable = new String(this.firstName.toUpperCase() + " " + this.surname.toUpperCase() + " " + this.phone.toUpperCase() + " " + this.email.toUpperCase());
    }

    public Person(Long peridx, String firstname, String lastname, String phone, String email, String postcode, String rewardsLoyalty) {
        this.peridx = peridx;
        this.firstName = firstname;
        this.surname = lastname;
        this.phone = phone;
        this.email = email;
        this.postcode = postcode;
        this.rewardsLoyalty = rewardsLoyalty;
    }

    public Person() {
    }

    public boolean search(String text) {
        String[] words;
        boolean found = false;
        for (String word : words = text.trim().toUpperCase().split("\\s+")) {
            if (word.length() <= 0 || (found = this.queryable.contains(word))) continue;
            return false;
        }
        return found;
    }

    @Override
    public int compareTo(Person p2) {
        int compare = this.compareFields(this.firstName, p2.firstName);
        if (compare != 0) {
            return compare;
        }
        compare = this.compareFields(this.surname, p2.surname);
        if (compare != 0) {
            return compare;
        }
        return this.compareFields(this.postcode, p2.postcode);
    }

    private int compareFields(String string1, String string2) {
        if (string1 == null) {
            string1 = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return string1.compareToIgnoreCase(string2);
    }

    public static Person getPersonFromXml(String personXml) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Person.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        StringReader reader = new StringReader(personXml);
        Person person = (Person)unmarshaller.unmarshal((Reader)reader);
        person.setQueryString();
        return person;
    }
}

