/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Vector;
import javax.swing.JComboBox;
import jpos.Reference;
import jpos.SP;
import jpos.basscom.swing.BJTextField;

public class PersonRefGrp {
    private Vector<Reference> references = new Vector();
    private Long rgidx;
    private String shortName;
    private String longName;
    private Integer flag;
    private JComboBox<Reference> combo;
    private BJTextField offlineTextField;

    public PersonRefGrp(Long rgidx, String shortName, String longName) throws Exception {
        this.rgidx = rgidx;
        this.shortName = shortName;
        this.longName = longName;
        try (PreparedStatement pstmt = SP.sParams.conn.prepareStatement("SELECT RCIDX, CODE, NAME FROM REFCODE WHERE RGIDX = ? AND \"ACTIVE\" = 1  ORDER BY NAME");){
            pstmt.setLong(1, rgidx);
            try (ResultSet result = pstmt.executeQuery();){
                this.references.add(new Reference("", "", 0L, 0L, "", 0.0));
                while (result.next()) {
                    Reference reference = new Reference(result.getString(3), result.getString(2), result.getLong(1), rgidx, "", 0.0);
                    reference.setShowName(true);
                    this.references.add(reference);
                }
            }
        }
    }

    public void setComboSelected(Long rcidx) {
        for (Reference ref : this.references) {
            if (ref.getIdx() != rcidx.longValue()) continue;
            this.combo.setSelectedItem(ref);
            this.offlineTextField.setText(ref.getName());
            this.offlineTextField.setCaretPosition(0);
            return;
        }
        this.combo.setSelectedIndex(-1);
    }

    public Vector<Reference> getReferences() {
        return this.references;
    }

    public Long getRgidx() {
        return this.rgidx;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public Integer getFlag() {
        return this.flag;
    }

    public void setFlag(Integer flag) {
        this.flag = flag;
    }

    public JComboBox<Reference> getCombo() {
        return this.combo;
    }

    public void setCombo(JComboBox<Reference> combo) {
        this.combo = combo;
    }

    public BJTextField getOfflineTextField() {
        return this.offlineTextField;
    }

    public void setOfflineTextField(BJTextField offlineTextField) {
        this.offlineTextField = offlineTextField;
    }

    public void setOfflineVisible(boolean isOnline) {
        this.combo.setVisible(isOnline);
        this.offlineTextField.setVisible(!isOnline);
    }
}

