/*
 * Decompiled with CFR 0.152.
 */
package jpos.quickreceipts;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jpos.DecimalField;
import jpos.DlgMessage;
import jpos.PosDouble;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StatusBar;
import jpos.StoreParams;
import jpos.TotalsTable;
import jpos.TotalsTableModel;
import jpos.quickreceipts.Carton;
import jpos.quickreceipts.CartonException;
import jpos.quickreceipts.FrQuickReceipts;
import jpos.quickreceipts.QuickReceiptsLine;
import jpos.quickreceipts.QuickReceiptsTable;
import jpos.searchfields.BarcodeSearchField;
import jpos.ui.TouchTextField;
import org.jdom.Element;

public class PaQuickReceipts
extends JPanel {
    protected BarcodeSearchField tfBarcode = new BarcodeSearchField(TouchTextField.FontSize.LARGE){

        @Override
        public void actionSearch() {
        }

        @Override
        public void actionValidate() {
        }
    };
    protected QuickReceiptsTable tblCartons;
    private TotalsTable tblTotals;
    protected DecimalField tfTotalUnits;
    protected DecimalField tfTotalCartons;
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private PosFrame frParent;
    private StoreParams sParams;
    private HashMap<String, Integer> barcodeMap = new HashMap();

    protected PaQuickReceipts(PosFrame pfrParent) {
        this.frParent = pfrParent;
        this.sParams = this.frParent.sParams;
        try {
            this.init();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void init() throws Exception {
        this.tfTotalUnits = new DecimalField(StoreParams.qtyFormat, 4);
        this.tfTotalCartons = new DecimalField(StoreParams.qtyFormat, 4);
        this.tblCartons = new QuickReceiptsTable(this.frParent, null);
        this.tblCartons.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                PaQuickReceipts.this.update();
            }
        });
        TotalsTableModel totalsTableModel = new TotalsTableModel(this.tblCartons.getModel()){

            @Override
            public Object getValueAt(int row, int col) {
                if (row != 0) {
                    return "";
                }
                switch (col) {
                    case 0: {
                        return StoreParams.totalText;
                    }
                    case 4: {
                        return new PosDouble(PaQuickReceipts.this.tblCartons.getTotalQty());
                    }
                    case 5: {
                        for (int i = 0; i < PaQuickReceipts.this.tblCartons.getRowCount(); ++i) {
                            if (PaQuickReceipts.this.barcodeMap.containsKey(PaQuickReceipts.this.tblCartons.getBarcode(i))) continue;
                            PaQuickReceipts.this.barcodeMap.put(PaQuickReceipts.this.tblCartons.getBarcode(i), 1);
                        }
                        PaQuickReceipts.this.tfTotalCartons.setText(PaQuickReceipts.this.barcodeMap.entrySet().size());
                        return PaQuickReceipts.this.barcodeMap.entrySet().size() > 0 ? String.valueOf(PaQuickReceipts.this.barcodeMap.entrySet().size()) : "";
                    }
                }
                return "";
            }
        };
        this.tblTotals = new TotalsTable(this.frParent, this.tblCartons, totalsTableModel);
        this.setLayout(this.gridBagLayout);
        this.tfBarcode.setHint(SP.getRS("Scan_Carton"));
        this.tfBarcode.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PaQuickReceipts.this.tfBarcode_focusGained(e);
            }
        });
        this.tfBarcode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaQuickReceipts.this.tfBarcode_actionPerformed(e);
            }
        });
        this.add((Component)this.tfBarcode, new GridBagConstraints(0, 1, 2, 2, 1.0, 0.0, 17, 0, new Insets(5, 10, 10, 0), 0, 0));
        this.add((Component)this.tblCartons.getScrollPane(), new GridBagConstraints(0, 3, 5, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.tblTotals.getScrollPane(), new GridBagConstraints(0, 4, 5, 1, 1.0, 0.0, 15, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.tfBarcode);
        v.add(this.tblCartons);
        v.add(this.tfBarcode);
        v.add(this.frParent.paHead.signInButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    private void tfBarcode_actionPerformed(ActionEvent e) {
        if (!this.tfBarcode.getText().isEmpty() && !this.tfBarcode.getText().equals(StoreParams.invalidBarcode)) {
            this.frParent.setCursor(StoreParams.waitCursor);
            try {
                this.processCartonScan(this.tfBarcode.getText());
                this.tfBarcode.setText("");
                this.tfBarcode.selectAll();
                this.tfBarcode.requestFocus();
            }
            catch (CartonException ex) {
                if (ex.getMessageDetail() != null) {
                    DlgMessage.showMessage(this.frParent, ex.getMessageDetail(), StoreParams.res.getString("Stop"), 0);
                }
                this.tfBarcode.setText(StoreParams.invalidBarcode);
                this.tfBarcode.selectAll();
                this.tfBarcode.requestFocus();
            }
            this.frParent.setCursor(StoreParams.normalCursor);
        }
    }

    private void processCartonScan(String barcode) throws CartonException {
        this.validateBarcode(barcode);
        if (!this.sParams.checkIConn()) {
            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
            return;
        }
        this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("receipt_carton", barcode + "," + this.sParams.getStoreIdx()).getXML();
        if (this.sParams.root != null) {
            for (Object child : this.sParams.root.getChildren()) {
                Carton carton = Carton.createCartonFromXml((Element)child);
                if (carton == null) continue;
                this.tblCartons.addRow(new QuickReceiptsLine(carton));
            }
        }
    }

    private void validateBarcode(String barcode) throws CartonException {
        for (int i = 0; i < this.tblCartons.getRowCount(); ++i) {
            if (!this.tblCartons.getBarcode(i).equals(barcode)) continue;
            throw new CartonException("Error", StoreParams.res.getString("barcode_scanned_in_this_session"));
        }
        try (PreparedStatement stmt = this.sParams.conn.prepareStatement("SELECT RECEIVE_DATE FROM CARTONS_RECEIVED WHERE CARTON = ?");){
            stmt.setString(1, barcode);
            try (ResultSet r = stmt.executeQuery();){
                if (r.next()) {
                    throw new CartonException("Error", StoreParams.res.getString("barcode_scanned_in_previous_session"));
                }
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    protected void delLines() {
        for (int idx : this.tblCartons.getSelectedRows()) {
            String deleteBarcode = this.tblCartons.getBarcode(idx);
            if (!this.barcodeMap.containsKey(deleteBarcode)) continue;
            this.barcodeMap.remove(deleteBarcode);
        }
        this.tblCartons.deleteSelectedLines();
    }

    protected void barcodeClear() {
        this.barcodeMap.clear();
    }

    private void update() {
        if (this.tblCartons.getRowCount() > 0) {
            this.tfTotalUnits.setText(this.tblCartons.getTotalQty());
            this.tfTotalCartons.setText(this.barcodeMap.entrySet().size());
        } else {
            this.tfTotalUnits.setText("");
            this.tfTotalCartons.setText("");
        }
        ((FrQuickReceipts)this.frParent).setButtons();
    }

    private void tfBarcode_focusGained(FocusEvent e) {
        this.tfBarcode.selectAll();
        this.frParent.setStatusMsg(StatusBar.status_EANQuickReceipts);
    }
}

