/*
 * Decompiled with CFR 0.152.
 */
package jpos.quickreceipts;

import java.util.Arrays;
import java.util.Vector;
import jpos.PosFrame;
import jpos.PosTable;
import jpos.PosUtils;
import jpos.StoreParams;
import jpos.quickreceipts.QuickReceiptsLine;
import jpos.quickreceipts.QuickReceiptsTableModel;

public class QuickReceiptsTable
extends PosTable {
    private QuickReceiptsTableModel model;

    protected QuickReceiptsTable(PosFrame parent, QuickReceiptsTableModel model) {
        super(parent, model);
        this.model = model;
        try {
            this.defineColumns();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    protected void defineColumns() throws Exception {
        if (this.model == null) {
            this.model = new QuickReceiptsTableModel();
        }
        this.setModel(this.model);
        this.columnModel.getColumn(0).setPreferredWidth(200);
        this.columnModel.getColumn(0).setMinWidth(200);
        this.columnModel.getColumn(0).setMaxWidth(600);
        this.columnModel.getColumn(1).setPreferredWidth(300);
        this.columnModel.getColumn(1).setMinWidth(200);
        this.columnModel.getColumn(1).setMaxWidth(600);
        this.columnModel.getColumn(2).setPreferredWidth(150);
        this.columnModel.getColumn(2).setMinWidth(130);
        this.columnModel.getColumn(2).setMaxWidth(600);
        this.columnModel.getColumn(3).setPreferredWidth(200);
        this.columnModel.getColumn(3).setMinWidth(130);
        this.columnModel.getColumn(3).setMaxWidth(600);
        this.columnModel.getColumn(4).setPreferredWidth(80);
        this.columnModel.getColumn(4).setMinWidth(80);
        this.columnModel.getColumn(4).setMaxWidth(80);
        this.columnModel.getColumn(5).setPreferredWidth(120);
        this.columnModel.getColumn(5).setMinWidth(120);
        this.columnModel.getColumn(5).setMaxWidth(120);
        this.columnModel.getColumn(0).setHeaderRenderer(this.headerLeftRen);
        this.columnModel.getColumn(1).setHeaderRenderer(this.headerLeftRen);
        this.columnModel.getColumn(2).setHeaderRenderer(this.headerLeftRen);
        this.columnModel.getColumn(3).setHeaderRenderer(this.headerLeftRen);
        this.columnModel.getColumn(4).setHeaderRenderer(this.headerRightRen);
        this.columnModel.getColumn(5).setHeaderRenderer(this.headerRightRen);
        this.renderer.setColumnFormat(4, StoreParams.qtyFormat, 4);
        this.renderer.setColumnFormat(5, null, 4);
        this.sizeColumnsToFit(-1);
    }

    @Override
    public QuickReceiptsTableModel getModel() {
        return this.model;
    }

    protected int addRow(QuickReceiptsLine row) {
        int rownum = this.model.addLine(row);
        this.selectRow(rownum);
        return rownum;
    }

    protected String getBarcode(int row) {
        return this.model.getBarcode(row);
    }

    protected double getQty(int row) {
        return this.model.getQty(row);
    }

    protected double getTotalQty() {
        int tot = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            tot = (int)((double)tot + this.model.getQty(i));
        }
        return tot;
    }

    protected void clear() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        this.clearSelection();
        this.model.clear();
    }

    protected void deleteSelectedLines() {
        int[] rows = this.getSelectedRows();
        Vector<Integer> rowList = new Vector<Integer>();
        String oldBarcode = "";
        for (int i = 0; i < rows.length; ++i) {
            rowList.add(new Integer(rows[i]));
            String newBarcode = this.model.getBarcode(rows[i]);
            if (newBarcode.equals(oldBarcode)) continue;
            for (int j = 0; j < this.model.getRowCount(); ++j) {
                if (rows[i] == j || !this.model.getBarcode(j).equals(newBarcode)) continue;
                rowList.add(new Integer(j));
            }
            oldBarcode = newBarcode;
        }
        this.deleteLines(rowList);
    }

    protected void deleteLines(Vector<Integer> rows) {
        if (this.getCellEditor() != null) {
            this.getCellEditor().cancelCellEditing();
        }
        Object[] sortedRows = rows.toArray();
        Arrays.sort(sortedRows);
        for (int i = sortedRows.length - 1; i >= 0; --i) {
            this.model.deleteLine((Integer)sortedRows[i]);
        }
    }
}

