/*
 * Decompiled with CFR 0.152.
 */
package jpos.rewards;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import jpos.DlgMessage;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StringUtils;
import jpos.rewards.Gift;
import jpos.searchfields.ProductClrSizeSearch;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelStrong;
import jpos.ui.LabelSubHeadingStrong;
import jpos.ui.TouchTextArea;
import jpos.ui.TouchTextField;

public class GiftSkuScanDlg
extends PosDialog {
    private Gift gift;
    private boolean okPressed = false;
    private long selectedSkuidx;
    private LabelNormal labelImage = new LabelNormal();
    private LabelSubHeadingStrong labelGiftName = new LabelSubHeadingStrong();
    private TouchTextArea textAreaGiftDescription = new TouchTextArea();
    private LabelStrong labelScanGiftBarcode = new LabelStrong();
    private ProductClrSizeSearch search;
    private DialogButton bCancel = new DialogButton("");

    public GiftSkuScanDlg(PosFrame frame, Gift gift) {
        super(frame, SP.getRS("Scan_Gift"), true, true);
        this.gift = gift;
        try {
            this.init();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.setResizable(false);
        this.labelImage.setIcon(new ImageIcon(SP.sParams.imagepath + "GiftIconLarge.png"));
        this.labelImage.setHorizontalAlignment(0);
        this.textAreaGiftDescription.setEditable(false);
        this.textAreaGiftDescription.setFocusable(false);
        this.textAreaGiftDescription.setBackground(Color.WHITE);
        this.textAreaGiftDescription.setLineWrap(true);
        this.textAreaGiftDescription.setWrapStyleWord(true);
        this.labelGiftName.setText(this.gift.getName());
        this.textAreaGiftDescription.setText(this.gift.getDescription());
        this.labelScanGiftBarcode.setText(SP.getRS("Scan_Gift"));
        this.search = new ProductClrSizeSearch(this, TouchTextField.FontSize.LARGE){

            @Override
            public boolean processSku(long skuidx, String barcode) {
                GiftSkuScanDlg.this.UpdateselectedSku(skuidx);
                GiftSkuScanDlg.this.okDialog();
                return true;
            }
        };
        this.search.getBarcodeSearchField().setShowSearchForOneResult(true);
        String validstyleIdxs = String.join((CharSequence)",", this.gift.getValidStyles());
        if (!StringUtils.isNullOrEmpty(validstyleIdxs)) {
            this.search.getBarcodeSearchField().setWhere(String.format("AND S.STYLEIDX IN (%s)", validstyleIdxs));
        } else {
            this.search.getBarcodeSearchField().setWhere("AND 1=2");
        }
        this.bCancel.setText(SP.getRS("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftSkuScanDlg.this.cancelDialog();
            }
        });
        JPanel panelMain = new JPanel(new GridBagLayout());
        JPanel panelHeader = new JPanel(new GridBagLayout());
        JPanel panelBody = new JPanel(new GridBagLayout());
        JPanel panelFooter = new JPanel(new GridBagLayout());
        panelMain.setBackground(Color.WHITE);
        panelHeader.setBackground(Color.WHITE);
        panelBody.setBackground(Color.WHITE);
        panelFooter.setBackground(Color.WHITE);
        this.getContentPane().add((Component)panelMain, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelHeader, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelBody, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelFooter, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelHeader.add((Component)this.labelImage, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 5, 10), 0, 0));
        panelHeader.add((Component)this.labelGiftName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 20, 0, 20), 0, 0));
        panelHeader.add((Component)this.textAreaGiftDescription, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        panelBody.add((Component)this.labelScanGiftBarcode, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(40, 10, 2, 10), 0, 0));
        panelBody.add((Component)this.search.getSearchPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 50, 40, 50), 0, 0));
        panelFooter.add((Component)this.bCancel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 32, 10), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.search.getBarcodeSearchField());
        v.add(this.bCancel);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        this.pack();
        PosUtils.centreWindow(this);
    }

    private void UpdateselectedSku(long skuidx) {
        this.selectedSkuidx = skuidx;
    }

    @Override
    public void cancelDialog() {
        this.okPressed = false;
        this.dispose();
    }

    @Override
    public void okDialog() {
        if (this.validateSku()) {
            this.okPressed = true;
            this.dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateSku() {
        if (this.selectedSkuidx <= 0L) return false;
        try (SqlQuery query = new SqlQuery(SP.sParams.conn, "SELECT C.STYLEIDX FROM CLR C JOIN SKU K ON C.CLRIDX = K.CLRIDX WHERE K.SKUIDX = " + this.selectedSkuidx);){
            if (query.next()) {
                String styleidx = query.getString(1);
                if (this.gift.getValidStyles().contains(styleidx)) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        DlgMessage.showMessage(this, SP.getRS("Product_not_in_gift"), SP.getRS("Error"), 0);
        return false;
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    public long getSelectedSkuidx() {
        if (this.okPressed) {
            return this.selectedSkuidx;
        }
        return 0L;
    }
}

