/*
 * Decompiled with CFR 0.152.
 */
package jpos.rewards;

import java.util.Vector;
import jpos.Currency;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;

public class RewardsProgram {
    private long id;
    private String name;
    private Currency currency;
    private boolean preventPrepopAmtFlag = false;
    private boolean reissueRewards = false;
    private boolean immediatelyIssueRewards = false;

    public RewardsProgram(long id, String name, Currency currency, boolean preventPrepopAmtFlag, boolean reissueRewards, boolean immediateRewards) {
        this.id = id;
        this.name = name;
        this.currency = currency;
        this.preventPrepopAmtFlag = preventPrepopAmtFlag;
        this.reissueRewards = reissueRewards;
        this.immediatelyIssueRewards = immediateRewards;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public boolean getPreventPrepopAmtFlag() {
        return this.preventPrepopAmtFlag;
    }

    public boolean getReissueRewards() {
        return this.reissueRewards;
    }

    public boolean getImmediatelyIssueRewards() {
        return this.immediatelyIssueRewards;
    }

    public String toString() {
        return this.name;
    }

    public static Vector<RewardsProgram> getAllPrograms() {
        Vector<RewardsProgram> programs = new Vector<RewardsProgram>();
        try (SqlQuery query = new SqlQuery(SP.sParams.conn, "SELECT P.PROGRAM_IDX, P.PROGRAM_NAME, P.REISSUE_REWARDS_ON_RETURN, COALESCE(P.IMMEDIATE_PROCESSING_FLAG, 0) AS IMMEDIATE_PROCESSING_FLAG FROM REWARDS_PROGRAM P WHERE P.\"ACTIVE\" = 1 ORDER BY P.PROGRAM_NAME");){
            while (query.next()) {
                programs.add(new RewardsProgram(query.getLong("PROGRAM_IDX"), query.getString("PROGRAM_NAME"), SP.sParams.storeCurrency, false, query.getBoolean("REISSUE_REWARDS_ON_RETURN"), query.getBoolean("IMMEDIATE_PROCESSING_FLAG")));
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return programs;
    }
}

