/*
 * Decompiled with CFR 0.152.
 */
package jpos.taxlookup;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import jpos.DlgMessage;
import jpos.PosFrame;
import jpos.SP;
import jpos.menu.PosMenuItem;
import jpos.taxlookup.AvaTaxLookup;
import jpos.taxlookup.AvaTaxSettings;
import jpos.taxlookup.TaxMenu;

public class AvaTaxMenu
extends TaxMenu {
    private PosFrame parent;
    private PosMenuItem testRemoteConnection = new PosMenuItem();
    private PosMenuItem disableAvaTax = new PosMenuItem();
    private PosMenuItem enableAvaTax = new PosMenuItem();

    public AvaTaxMenu(PosFrame parent) {
        this.parent = parent;
        this.setupMenu();
    }

    @Override
    public void refreshMenu() {
        if (this.parent.isTaxLookupDisabled()) {
            this.disableAvaTax.setVisible(false);
            this.enableAvaTax.setVisible(true);
            this.testRemoteConnection.setEnabled(false);
        } else {
            this.disableAvaTax.setVisible(true);
            this.enableAvaTax.setVisible(false);
            this.testRemoteConnection.setEnabled(true);
        }
    }

    private void setupMenu() {
        this.setText("AvaTax");
        ActionListener menuListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AvaTaxMenu.this.parent.isLoggedIn(true)) {
                    return;
                }
                if (e.getActionCommand().equals("TEST_REMOTE")) {
                    AvaTaxLookup taxLookup = new AvaTaxLookup();
                    if (taxLookup.testConnection(true)) {
                        AvaTaxSettings settings = new AvaTaxSettings();
                        DlgMessage.showMessage(AvaTaxMenu.this.parent, MessageFormat.format(SP.getRS("AvaTax_Remote_Test_Success"), "\n", settings.getRemoteUrl()), SP.getRS("AvaTax"), 1);
                    } else {
                        DlgMessage.showMessage(AvaTaxMenu.this.parent, taxLookup.getLastErrorMessage(), SP.getRS("AvaTax"), 0);
                    }
                } else if (e.getActionCommand().equals("DISABLE_AVATAX")) {
                    DlgMessage dlgMessage = new DlgMessage(AvaTaxMenu.this.parent, SP.getRS("Warning"), SP.getRS("Disable_AvaTax_Confirmation"), 0, 3);
                    int response = dlgMessage.showMessage();
                    if (response == 0) {
                        AvaTaxMenu.this.parent.setTaxLookupDisabledForSession(true);
                    }
                } else if (e.getActionCommand().equals("ENABLE_AVATAX")) {
                    AvaTaxMenu.this.parent.setTaxLookupDisabledForSession(false);
                    AvaTaxMenu.this.parent.refreshTransaction();
                }
            }
        };
        this.disableAvaTax.setText(SP.getRS("AvaTax_Disable"));
        this.disableAvaTax.setActionCommand("DISABLE_AVATAX");
        this.disableAvaTax.addActionListener(menuListener);
        this.add(this.disableAvaTax);
        this.enableAvaTax.setText(SP.getRS("AvaTax_Enable"));
        this.enableAvaTax.setActionCommand("ENABLE_AVATAX");
        this.enableAvaTax.addActionListener(menuListener);
        this.add(this.enableAvaTax);
        this.testRemoteConnection.setText(SP.getRS("AvaTax_Remote_Test"));
        this.testRemoteConnection.setActionCommand("TEST_REMOTE");
        this.testRemoteConnection.addActionListener(menuListener);
        this.add(this.testRemoteConnection);
    }
}

