/*
 * Decompiled with CFR 0.152.
 */
package jpos.taxlookup;

import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StringUtils;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class TaxLookupPerson {
    private String customerCode;
    private long taxExemptIdx;
    private String taxExemptCertificate;
    private String avaTaxExemptCode;
    private final String NOT_DEFINED_CUST_CODE = "PENDING";

    public TaxLookupPerson() {
        this.taxExemptIdx = 0L;
        this.customerCode = "";
        this.avaTaxExemptCode = "";
        this.taxExemptCertificate = "";
    }

    public TaxLookupPerson(Element person) {
        this.customerCode = person.getAttribute("peridx") != null ? (person.getAttribute("code") != null ? person.getAttribute("code").getValue() : "PENDING") : "";
        if (person.getAttribute("tax_exemptidx") != null) {
            try {
                this.taxExemptIdx = person.getAttribute("tax_exemptidx").getLongValue();
            }
            catch (DataConversionException e) {
                this.taxExemptIdx = 0L;
            }
        }
        if (person.getAttribute("tax_exempt_certificate") != null) {
            this.taxExemptCertificate = person.getAttribute("tax_exempt_certificate").getValue();
        }
        this.loadTaxExemptReasaon();
    }

    private void loadTaxExemptReasaon() {
        if (this.taxExemptIdx != 0L) {
            try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT AVATAX_CODE FROM TAX_EXEMPT_REASONS WHERE EXEMPTIDX = " + this.taxExemptIdx);){
                if (sql.next()) {
                    this.avaTaxExemptCode = sql.getString(1);
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    public String getCustomerCode() {
        return StringUtils.nullToEmpty(this.customerCode);
    }

    public String getTaxExemptCertificate() {
        return StringUtils.nullToEmpty(this.taxExemptCertificate);
    }

    public String getAvaTaxExemptCode() {
        return StringUtils.nullToEmpty(this.avaTaxExemptCode);
    }

    public String getCountry() {
        return null;
    }
}

