/*
 * Decompiled with CFR 0.152.
 */
package jpos.tillbalance;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jpos.DecimalField;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.tillbalance.TenDets;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;

public class DlgTillBalanceFloat
extends PosDialog {
    private TenDets tenDet;
    private double floatAmount;
    private LabelSubHeading lAmount = new LabelSubHeading();
    private JPanel panelMain = new JPanel();
    private DecimalField dfAmount;
    private DialogButton bOk;
    private DialogButton bCancel;
    private GridBagLayout gridBagLayout1;

    public DlgTillBalanceFloat(PosFrame frParent, TenDets tenDet, double floatAmount, String title) {
        super(frParent, title, true);
        this.dfAmount = new DecimalField(SP.sParams.storeCurrency);
        this.bOk = new DialogButton("");
        this.bCancel = new DialogButton("");
        this.gridBagLayout1 = new GridBagLayout();
        this.tenDet = tenDet;
        this.floatAmount = floatAmount;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.panelMain.setLayout(this.gridBagLayout1);
        this.bOk.setText(StoreParams.res.getString("OK"));
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTillBalanceFloat.this.okDialog();
            }
        });
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTillBalanceFloat.this.cancelDialog();
            }
        });
        this.dfAmount.setText(this.floatAmount);
        this.lAmount.setText(SP.getRS("enter_new_float"));
        this.getContentPane().add(this.panelMain);
        this.panelMain.add((Component)this.lAmount, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(20, 20, 10, 20), 0, 0));
        this.panelMain.add((Component)this.dfAmount, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 20, 10, 20), 100, 0));
        this.panelMain.add((Component)this.bOk, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 20, 10), 0, 0));
        this.panelMain.add((Component)this.bCancel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 20, 20), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.dfAmount);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        PosUtils.centreWindow(this);
    }

    @Override
    public void okDialog() {
        boolean bOk = true;
        double amountRnd = this.tenDet.payType.roundAmt(this.dfAmount.getDouble());
        if (bOk && amountRnd > this.tenDet.nCounted) {
            bOk = false;
            this.dfAmount.setText(this.tenDet.nCounted);
        }
        if (bOk && amountRnd != this.dfAmount.getDouble()) {
            bOk = false;
            this.dfAmount.setText(amountRnd);
        }
        if (bOk && amountRnd < 0.0) {
            bOk = false;
            this.dfAmount.setText(0.0);
        }
        if (bOk && amountRnd > 9.9999999999E10) {
            bOk = false;
            this.dfAmount.setText(0.0);
        }
        if (bOk) {
            this.floatAmount = this.dfAmount.getDouble();
            this.setVisible(false);
        } else {
            this.dfAmount.requestFocus();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DlgTillBalanceFloat.this.dfAmount.selectAll();
                }
            });
        }
    }

    @Override
    public void cancelDialog() {
        this.setVisible(false);
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    public double getFloat() {
        return this.floatAmount;
    }
}

