/*
 * Decompiled with CFR 0.152.
 */
package jpos.tillbalance;

import ReceiptPrinter.EODReport;
import ReceiptPrinter.OpenCashDrawer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import jpos.DlgMessage;
import jpos.Note;
import jpos.PosFrame;
import jpos.PosMenuController;
import jpos.PosUtils;
import jpos.SP;
import jpos.Settings;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.StyleLine;
import jpos.SystemSettings;
import jpos.Tender;
import jpos.basscom.utils.Utils;
import jpos.custorder.auspost.DlgManifestShipments;
import jpos.tillbalance.PaTillBalance;
import jpos.tillbalance.PaTillBalanceFoot;
import jpos.tillbalance.TillBalanceUtils;
import org.jdom.Element;

public class FrTillBalance
extends PosFrame {
    private TillBalanceUtils.TillBalanceType tillBalanceType = null;
    private boolean history = false;
    StringBuffer oldNotes = new StringBuffer();
    StringBuffer dummy = new StringBuffer();
    Vector<Tender> vNonCountedTenders = new Vector();
    protected static final boolean promptForBankBagNumber = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.PROMPT_FOR_BANK_BAG_NUMBER);

    public FrTillBalance(PosMenuController pmenu, StoreParams psParams, TillBalanceUtils.TillBalanceType tillBalanceType) {
        super(pmenu, null, tillBalanceType.getFrameType(), 11123L, psParams, tillBalanceType.getDisplayValue());
        this.tillBalanceType = tillBalanceType;
        this.paBody = new PaTillBalance(psParams, this);
        this.contentPane.add((Component)this.paBody, "Center");
        this.paFoot = new PaTillBalanceFoot(this);
        this.contentPane.add((Component)this.paFoot, "South");
        this.voidTrans(false);
        if (Settings.isUsingAusPostIntegration() && tillBalanceType != TillBalanceUtils.TillBalanceType.START_OF_DAY) {
            DlgManifestShipments manifest;
            try {
                manifest = new DlgManifestShipments(this);
                manifest.handleForceManifesting();
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
            try {
                manifest = new DlgManifestShipments(this);
                manifest.handleOptionalManifesting();
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    public TillBalanceUtils.TillBalanceType getBalanceType() {
        return this.tillBalanceType;
    }

    @Override
    public boolean validateTrans() {
        StyleLine varStyle;
        if (!((PaTillBalanceFoot)this.paFoot).bComplete.isEnabled()) {
            return false;
        }
        if (promptForBankBagNumber && ((PaTillBalance)this.paBody).tfBankBagNumber.getText().trim().length() == 0 && (((PaTillBalance)this.paBody).tfBank.getDouble() > 0.0 || ((PaTillBalance)this.paBody).getTotalCountedCheque() > 0.0)) {
            DlgMessage.showMessage(this, SP.getRS("Bank_Bag_Number_Must_Be_Entered"), SP.getRS("Bank_Bag_Number"), 0);
            ((PaTillBalance)this.paBody).tfBankBagNumber.requestFocus();
            return false;
        }
        double nTotalVariance = ((PaTillBalance)this.paBody).getTotalValiance();
        if (nTotalVariance != 0.0 && this.hasSecurity(11116L, 0)) {
            Object[] objs = new Object[]{this.sParams.currFormat.format(nTotalVariance)};
            String msg = MessageFormat.format(StoreParams.res.getString("You_have_a_variance_of"), objs) + "\n" + StoreParams.res.getString("Do_you_wish_to");
            if (DlgMessage.showMessage(this, msg, StoreParams.res.getString("Till_Variance"), 0, 2) != 0) {
                return false;
            }
        } else if (DlgMessage.showMessage(this, StoreParams.res.getString("cash_up"), StoreParams.res.getString("Continue_"), 0, 3) != 0) {
            return false;
        }
        if (!(varStyle = new StyleLine(this.sParams.getVarianceSku(), 1.0, this.sParams)).isValid()) {
            Object[] objs = new Object[]{"\n", "\n"};
            if (DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("There_is_no_valid_sku"), objs), StoreParams.res.getString("Unable_to_post"), 0, 3) != 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean completeTrans(boolean pcomplete) {
        try {
            StyleLine varStyle = new StyleLine(this.sParams.getVarianceSku(), 1.0, this.sParams);
            varStyle.setPrice(((PaTillBalance)this.paBody).getTotalValiance());
            String bankBagNumber = ((PaTillBalance)this.paBody).tfBankBagNumber.getText();
            if (bankBagNumber.length() > 30) {
                bankBagNumber = bankBagNumber.substring(0, 30);
            }
            PosUtils.startTrans(this.sParams.conn);
            this.vhidx = this.sParams.nextVal("XRET_TRANH");
            try (Statement stmt = this.sParams.conn.createStatement();){
                stmt.executeUpdate("INSERT INTO RET_TRANH(VHIDX, TR_TYPE, \"ACTIVE\", WIDX, TRAND, TILL_NUMBER, SREPIDX, MEMBER_GENERATEDIDX, TRANSSREPIDX, TRANSMEMIDX, DOCKET_NUMBER, COMPLETE, LAYBY_CANCEL, NOTES1, NOTES2, SALE_DATE, BANK_BAG_NUM, TILL_BALANCE_TYPE) VALUES(" + this.vhidx + ", " + this.transType + ", 1, " + this.sParams.getStoreIdx() + ", CURRENT_TIMESTAMP, " + PosUtils.StringToSqlString(this.sParams.tillnum) + ", " + this.getUser().getPeridx() + "," + this.getUser().getMemidx() + ", " + this.getUser().getPeridx() + ", " + this.getUser().getMemidx() + ", " + PosUtils.StringToSqlString(this.docknum) + ", 0, 2, " + PosUtils.StringToSqlString(this.oldNotes.toString()) + ", " + PosUtils.StringToSqlString(StoreParams.VERSION) + ", TRUNC_DATE(current_timestamp), " + PosUtils.StringToSqlString(bankBagNumber) + ", " + this.tillBalanceType.getDatabaseValue() + ")");
            }
            Utils.CopyLikeReferences(this.sParams.conn, 18L, "WHSE", "WIDX", this.sParams.getStoreIdx(), 23L, "RET_TRANH", "VHIDX", this.vhidx);
            if (varStyle.getPrice() != 0.0 && varStyle.isValid()) {
                varStyle.db_insertline();
            }
            ((PaTillBalance)this.paBody).db_updateVariances(varStyle.isValid());
            stmt = this.sParams.conn.createStatement();
            var5_6 = null;
            try {
                stmt.executeUpdate("UPDATE RET_TRANH SET COMPLETE = 2 WHERE VHIDX = " + this.vhidx + " AND TILL_NUMBER = " + PosUtils.StringToSqlString(this.sParams.tillnum));
                this.sParams.yTabInsert("RET_TRANH", "VHIDX", "" + this.vhidx);
                stmt.executeUpdate("UPDATE RET_TRANH SET COMPLETE = 2, EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum) + " " + "WHERE COMPLETE = 4 AND TILL_NUMBER = " + PosUtils.StringToSqlString(this.sParams.tillnum));
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
            finally {
                if (stmt != null) {
                    if (var5_6 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            var5_6.addSuppressed(throwable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            PosUtils.endTrans(this.sParams.conn);
        }
        catch (Exception e) {
            PosUtils.releaseTrans(this.sParams.conn);
            PosUtils.logError(e);
            return false;
        }
        this.removeHeldSales();
        return true;
    }

    private void removeHeldSales() {
        ArrayList<Long> idxs = new ArrayList<Long>();
        try (SqlQuery query = new SqlQuery(this.sParams.conn, "SELECT H.VHIDX FROM RET_TRANH H WHERE H.COMPLETE = 0 AND H.DOCKET_NUMBER IS NULL AND H.\"ACTIVE\" = 1 AND H.TR_TYPE <> 247 AND NOT EXISTS (SELECT 1 FROM RET_TRANP P WHERE P.VHIDX = H.VHIDX) AND (H.TILL_NUMBER = ? OR H.TRAND < CURRENT_TIMESTAMP - 1)", this.sParams.tillnum);){
            while (query.next()) {
                idxs.add(query.getLong("VHIDX"));
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        for (Long idx : idxs) {
            this.deleteTrans(idx);
        }
    }

    @Override
    protected void setTransType() {
        this.transType = 564;
    }

    @Override
    public void setFocus() {
        if (this.isLoggedIn(false)) {
            ((PaTillBalance)this.paBody).tblTenders.requestFocus();
            if (((PaTillBalance)this.paBody).tblTenders.getRowCount() > 0 && ((PaTillBalance)this.paBody).tblTenders.getSelectedRow() < 0) {
                ((PaTillBalance)this.paBody).selectNextCountableTender(-1);
            }
        } else {
            this.paHead.setFocus();
        }
    }

    @Override
    public void voidTrans(boolean logout) {
        if (((PaTillBalanceFoot)this.paFoot).bRecount.isEnabled() && (!logout || this.isLoggedIn(!logout))) {
            ((PaTillBalance)this.paBody).tfBankBagNumber.setText("");
            ((PaTillBalance)this.paBody).load();
            this.oldNotes.replace(0, this.oldNotes.length(), "");
            ((PaTillBalance)this.paBody).lFeedBack.setForeground(this.getDefaultColor());
            super.voidTrans(logout);
        }
    }

    private boolean canTrade() {
        switch (this.tillBalanceType) {
            case TILL_BALANCE: {
                if (TillBalanceUtils.canTrade()) break;
                DlgMessage.showMessage(this, StoreParams.res.getString("start_of_day_required_before_continuing"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
            case END_OF_DAY: {
                if (TillBalanceUtils.canDoEndOfDay()) break;
                DlgMessage.showMessage(this, StoreParams.res.getString("start_of_day_required_before_continuing"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
            case START_OF_DAY: {
                if (TillBalanceUtils.canDoStartOfDay()) break;
                DlgMessage.showMessage(this, StoreParams.res.getString("end_of_day_required_before_continuing"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
        }
        return true;
    }

    @Override
    public void delLines() {
    }

    @Override
    protected void updateSec(boolean[] formSec) {
        ((PaTillBalance)this.paBody).updateSec(this.hasSecurity(11116L, 0));
        if (this.isLoggedIn(false) && !this.history) {
            if (!this.canTrade()) {
                this.setEditable(false);
            } else if (!this.getUser().isTraningUser()) {
                OpenCashDrawer o = new OpenCashDrawer(this.sParams.printerPort, "");
                o.start();
            }
        }
    }

    @Override
    public void setStatusText(String msg) {
        ((PaTillBalanceFoot)this.paFoot).statusBar.setText(msg);
    }

    @Override
    public void setStatusMsg(String msg) {
        ((PaTillBalanceFoot)this.paFoot).statusBar.setMessage(msg);
    }

    @Override
    public void resetStatus() {
        ((PaTillBalanceFoot)this.paFoot).statusBar.reset();
    }

    @Override
    public boolean keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 116 && ((PaTillBalance)this.paBody).bChangeFloat.isEnabled()) {
            ((PaTillBalance)this.paBody).bChangeFloat.doClick();
            return true;
        }
        if (e.getKeyCode() == 114 && ((PaTillBalanceFoot)this.paFoot).bRecount.isEnabled()) {
            ((PaTillBalanceFoot)this.paFoot).bRecount.doClick();
            return true;
        }
        return false;
    }

    @Override
    public boolean isVoid() {
        return !this.isLoggedIn(false);
    }

    @Override
    protected void setEditable(boolean peditable) {
        super.setEditable(peditable);
        ((PaTillBalance)this.paBody).setEditable(this.editable);
        ((PaTillBalanceFoot)this.paFoot).bComplete.setEnabled(this.editable);
        ((PaTillBalanceFoot)this.paFoot).bRecount.setEnabled(this.editable);
    }

    @Override
    public boolean populate(Element trans) {
        this.setEditable(false);
        if (super.populate(trans)) {
            if (((PaTillBalance)this.paBody).populate(trans)) {
                if (trans.getAttribute("notes1") != null) {
                    this.oldNotes.replace(0, this.oldNotes.length(), trans.getAttribute("notes1").getValue());
                }
                return true;
            }
            Object[] objs = new Object[]{"\n"};
            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("Unable_retrieve"), objs), StoreParams.res.getString("Error"), 0);
        }
        return false;
    }

    @Override
    public void printReceipt(boolean reprint) {
        EODReport r1 = new EODReport(this, StoreParams.res.getString("Print_End_of_Day"), false, this.sParams.getDocketConnection(), this.docknum, reprint);
        r1.PrintEODReport();
        r1.close();
    }

    @Override
    public boolean completeTrans() {
        if (super.completeTrans()) {
            this.voidTrans(false);
            this.menu.openFrame(this.menu.defaultFrame, true, this.getUser());
            this.dispatchEvent(new WindowEvent(this, 201));
            return true;
        }
        return false;
    }

    @Override
    protected void setTransnum() {
        this.transnum = null;
    }

    @Override
    protected void search(boolean allStores) {
        if (!((PaTillBalanceFoot)this.paFoot).bRecount.isEnabled()) {
            super.search(allStores);
        }
    }

    @Override
    public void menuFile_actionPerformed(ActionEvent e) {
        if (!e.getActionCommand().equals(String.valueOf(-1)) && this.editable) {
            if (DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("close_eod"), "\n", "\n"), StoreParams.res.getString("Continue_"), 0, 3) != 0) {
                return;
            }
            super.menuFile_actionPerformed(e);
            this.dispose(false);
            return;
        }
        super.menuFile_actionPerformed(e);
    }

    @Override
    public void notesSet() {
        for (int i = 0; i < this.getNotes().size(); ++i) {
            Note note = this.getNotes().elementAt(i);
            if (note.getNoteType().getTblidx() != 23L) continue;
            ((PaTillBalance)this.paBody).lFeedBack.setForeground(this.notesColor);
        }
    }

    @Override
    public boolean checkExit() {
        if (((PaTillBalance)this.paBody).isEditable() && ((PaTillBalance)this.paBody).getTotalCounted() > 0.0) {
            return super.checkExit();
        }
        return true;
    }

    @Override
    public void refreshImage() {
    }

    @Override
    public void processLogin() {
    }

    public void setHistory(boolean history) {
        this.history = history;
    }
}

