/*
 * Decompiled with CFR 0.152.
 */
package jpos.tillbalance;

import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.SystemSettings;

public class TillBalanceUtils {
    public static boolean canTrade() {
        TillBalanceType lastTillBalance;
        return !SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.ENFORCE_START_OF_DAY_TILL_BALANCE) || (lastTillBalance = TillBalanceUtils.getLastTillBalance()) != TillBalanceType.END_OF_DAY;
    }

    public static boolean canDoEndOfDay() {
        TillBalanceType lastTillBalance;
        return !SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.ENFORCE_START_OF_DAY_TILL_BALANCE) || (lastTillBalance = TillBalanceUtils.getLastTillBalance()) != TillBalanceType.END_OF_DAY;
    }

    public static boolean canDoStartOfDay() {
        TillBalanceType lastTillBalance;
        return !SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.ENFORCE_START_OF_DAY_TILL_BALANCE) || (lastTillBalance = TillBalanceUtils.getLastTillBalance()) == TillBalanceType.END_OF_DAY;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TillBalanceType getLastTillBalance() {
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT TILL_BALANCE_TYPE FROM RET_TRANH WHERE \"ACTIVE\" = 1 AND TR_TYPE = 564 AND TILL_BALANCE_TYPE IN (1,2) AND TILL_NUMBER = " + PosUtils.StringToSqlString(SP.sParams.tillnum) + " " + "ORDER BY VHIDX DESC");){
            if (!sql.next()) return TillBalanceType.TILL_BALANCE;
            TillBalanceType tillBalanceType = TillBalanceType.getTillBalanceTypeFromDatabaseValue(sql.getInt(1));
            return tillBalanceType;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return TillBalanceType.TILL_BALANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TillBalanceType getTillBalanceType(String docketNumber) {
        if (docketNumber != null && docketNumber.length() > 3) {
            docketNumber = docketNumber.substring(3);
        }
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT TILL_BALANCE_TYPE FROM RET_TRANH WHERE \"ACTIVE\" = 1 AND TR_TYPE = 564 AND DOCKET_NUMBER = ? AND WIDX = ?", docketNumber, SP.sParams.getStoreIdx());){
            if (!sql.next()) return TillBalanceType.TILL_BALANCE;
            TillBalanceType tillBalanceType = TillBalanceType.getTillBalanceTypeFromDatabaseValue(sql.getInt(1));
            return tillBalanceType;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return TillBalanceType.TILL_BALANCE;
    }

    public static enum TillBalanceType {
        TILL_BALANCE(0, SP.getRS("Till_Balance"), 6),
        START_OF_DAY(1, SP.getRS("Till_Balance_Start_Of_Day"), 14),
        END_OF_DAY(2, SP.getRS("Till_Balance_End_Of_Day"), 15);

        private int databaseValue;
        private String displayValue;
        private int frameType;

        private TillBalanceType(int intValue, String displayValue, int frameType) {
            this.databaseValue = intValue;
            this.displayValue = displayValue;
            this.frameType = frameType;
        }

        public int getDatabaseValue() {
            return this.databaseValue;
        }

        public String getDisplayValue() {
            return this.displayValue;
        }

        public int getFrameType() {
            return this.frameType;
        }

        public static TillBalanceType getTillBalanceTypeFromDatabaseValue(int databaseValue) {
            for (TillBalanceType t : TillBalanceType.values()) {
                if (t.getDatabaseValue() != databaseValue) continue;
                return t;
            }
            return TILL_BALANCE;
        }
    }
}

