/*
 * Decompiled with CFR 0.152.
 */
package jpos.transreq;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jpos.PosDouble;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.Reference;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StatusBar;
import jpos.StoreParams;
import jpos.StyleTable;
import jpos.TotalsTable;
import jpos.TotalsTableModel;
import jpos.searchfields.BarcodeSearchField;
import jpos.searchfields.ClrSearchField;
import jpos.searchfields.HintTextField;
import jpos.searchfields.SearchPanel;
import jpos.searchfields.SizeSearchField;
import jpos.transreq.FrTransferRequest;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;

public class PaTransferRequest
extends JPanel {
    private SizeSearchField tfSize = new SizeSearchField(){

        @Override
        public void actionValidate() {
            super.actionValidate();
            String barcode = "";
            try (SqlQuery sql = new SqlQuery(((PaTransferRequest)PaTransferRequest.this).sParams.conn, "SELECT DB.CODE FROM DEFAULT_BARCODE DB, SKU K WHERE DB.SKUIDX = K.SKUIDX AND K.SKUIDX = " + this.getidx());){
                if (sql.next()) {
                    barcode = sql.getString(1);
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
            PaTransferRequest.this.tfBarcode.clear();
            PaTransferRequest.this.tfBarcode.setText(barcode);
            PaTransferRequest.this.insertStyleLineLater(barcode);
        }
    };
    private ClrSearchField tfClr = new ClrSearchField(){

        @Override
        public void actionValidate() {
            super.actionValidate();
            try (SqlQuery sql = new SqlQuery(((PaTransferRequest)PaTransferRequest.this).sParams.conn, "SELECT K.SKUIDX, DB.CODE FROM DEFAULT_BARCODE DB, SKU K WHERE DB.SKUIDX = K.SKUIDX AND K.CLRIDX = " + this.getidx());){
                if (sql.next()) {
                    String barcode = sql.getString(2);
                    if (sql.next()) {
                        PaTransferRequest.this.tfSize.search(this.getidx(), PaTransferRequest.this.tfBarcode.getText(), this.getText());
                    } else {
                        PaTransferRequest.this.tfBarcode.clear();
                        PaTransferRequest.this.tfBarcode.setText(barcode);
                        PaTransferRequest.this.insertStyleLineLater(barcode);
                    }
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    };
    protected BarcodeSearchField tfBarcode = new BarcodeSearchField(TouchTextField.FontSize.LARGE){

        @Override
        public void actionSearch() {
            if (PaTransferRequest.this.frParent.isLoggedIn(true)) {
                PaTransferRequest.this.search = true;
                if (this.getText().equals(StoreParams.invalidBarcode) || this.getText().equals(StoreParams.noTrans) || this.getText().equals(StoreParams.invalidTrans)) {
                    this.setText("");
                }
                super.actionSearch();
                this.requestFocus();
                this.selectAll();
            }
        }

        @Override
        public void actionValidate() {
            if (!PaTransferRequest.this.search) {
                return;
            }
            PaTransferRequest.this.search = false;
            if (!(this.getText().equals(StoreParams.invalidBarcode) || this.getText().equals(StoreParams.noTrans) || this.getText().equals(StoreParams.invalidTrans))) {
                super.actionValidate();
                try (SqlQuery sqlClr = new SqlQuery(((PaTransferRequest)PaTransferRequest.this).sParams.conn, "SELECT C.CLRIDX, C.CLRNAME FROM CLR C WHERE C.STYLEIDX = " + this.getidx());){
                    if (sqlClr.next()) {
                        long clridx = sqlClr.getLong(1);
                        String clrname = sqlClr.getString(2);
                        if (sqlClr.next()) {
                            PaTransferRequest.this.tfClr.search(this.getidx(), this.getText());
                        } else {
                            try (SqlQuery sqlSku = new SqlQuery(((PaTransferRequest)PaTransferRequest.this).sParams.conn, "SELECT K.SKUIDX, DB.CODE FROM DEFAULT_BARCODE DB, SKU K WHERE DB.SKUIDX = K.SKUIDX AND K.CLRIDX = " + clridx);){
                                if (sqlSku.next()) {
                                    String apn = sqlSku.getString(2);
                                    if (sqlSku.next()) {
                                        PaTransferRequest.this.tfSize.search(clridx, this.getText(), clrname);
                                    } else {
                                        PaTransferRequest.this.tfBarcode.clear();
                                        this.setText(apn);
                                        PaTransferRequest.this.insertStyleLineLater(apn);
                                    }
                                }
                            }
                        }
                    }
                    PaTransferRequest.this.tfBarcode.clear();
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
        }
    };
    private SearchPanel barcodeSearchPanel = new SearchPanel(this.tfBarcode);
    private boolean search = false;
    protected StyleTable tblStyles;
    private TotalsTable tblTotals;
    protected LabelSubHeading lFrom = new LabelSubHeading();
    protected HintTextField tfWhse = new HintTextField(SP.getRS("Search_F12"), TouchTextField.FontSize.LARGE);
    private SearchPanel whseSearchPanel = new SearchPanel(this.tfWhse);
    private Vector<Reference> stores = new Vector();
    private GridBagLayout gridBagLayout = new GridBagLayout();
    protected LabelSubHeading lFeedBack = new LabelSubHeading();
    protected LabelSubHeading lFeedBack2 = new LabelSubHeading();
    private PosFrame frParent;
    private StoreParams sParams;

    public PaTransferRequest(PosFrame pfrParent) {
        this.frParent = pfrParent;
        this.sParams = this.frParent.sParams;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT R.RCIDX, R.CODE, R.NAME FROM REFCODE R, WHSE W WHERE R.RCIDX = W.WIDX AND W.\"TYPE\" <> 'V' AND R.\"ACTIVE\" = 1 AND R.RCIDX <> " + this.sParams.getStoreIdx() + "  AND (W.DATE_CLOSE IS NULL OR W.DATE_CLOSE >= CURRENT_TIMESTAMP) " + this.sParams.sWhseRefSecWhereWHSETransRequests + " " + "ORDER BY R.CODE");){
            while (sql.next()) {
                this.stores.add(new Reference(sql.getString(3), sql.getString(2), sql.getLong(1)));
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        this.tfWhse.setCache(this.sParams.cacher, 985L, "3798,3797", "", "R.RCIDX <> " + this.sParams.getStoreIdx() + "  AND (W.DATE_CLOSE IS NULL OR W.DATE_CLOSE >= CURRENT_TIMESTAMP) " + this.sParams.sWhseRefSecWhereWHSETransRequests);
        this.tfWhse.setSearchKey(123);
        this.tfWhse.searchWithEnter(true);
        this.tfWhse.setShowSearchForOneResult(true);
        this.tblStyles = new StyleTable(this.frParent, null);
        this.tblStyles.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                PaTransferRequest.this.update();
            }
        });
        TotalsTableModel totalsTableModel = new TotalsTableModel(this.tblStyles.getModel()){

            @Override
            public Object getValueAt(int row, int col) {
                if (row != 0) {
                    return "";
                }
                switch (col) {
                    case 0: {
                        return StoreParams.totalText;
                    }
                    case 4: {
                        return new PosDouble(PaTransferRequest.this.tblStyles.getQty());
                    }
                }
                return "";
            }
        };
        this.tblTotals = new TotalsTable(this.frParent, this.tblStyles, totalsTableModel);
        this.setLayout(this.gridBagLayout);
        this.tfBarcode.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PaTransferRequest.this.tfBarcode_focusGained(e);
            }
        });
        this.tfBarcode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaTransferRequest.this.tfBarcode_actionPerformed(e);
            }
        });
        this.lFrom.setText(StoreParams.res.getString("From"));
        this.tfWhse.setFieldWidth(200);
        this.lFeedBack.setText(StoreParams.res.getString("Transfer_Request"));
        this.add((Component)this.barcodeSearchPanel, new GridBagConstraints(0, 1, 2, 2, 1.0, 0.0, 17, 0, new Insets(5, 10, 10, 0), 0, 0));
        this.add((Component)this.lFeedBack2, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 220, 0, 0), 0, 0));
        this.add((Component)this.lFrom, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 10, 10), 0, 0));
        this.add((Component)this.whseSearchPanel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 10, 10), 0, 0));
        this.add((Component)this.tblStyles.getScrollPane(), new GridBagConstraints(0, 3, 5, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.tblTotals.getScrollPane(), new GridBagConstraints(0, 4, 5, 1, 1.0, 0.0, 15, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.tfClr, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.tfSize, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.tfClr.setVisible(false);
        this.tfSize.setVisible(false);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.tfBarcode);
        v.add(this.tfWhse);
        v.add(this.tblStyles);
        v.add(this.tfBarcode);
        v.add(this.frParent.paHead.signInButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    private void insertStyleLineLater(final String barcode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PaTransferRequest.this.insertStyleLine(barcode);
            }
        });
    }

    protected boolean insertStyleLine(String barcode) {
        if (!barcode.equals("") && !barcode.equals(StoreParams.invalidBarcode)) {
            try {
                if (this.tblStyles.addEAN(barcode) == -1) {
                    this.tfBarcode.setText(StoreParams.invalidBarcode);
                    this.tfBarcode.selectAll();
                } else {
                    this.tfBarcode.setText("");
                }
                return true;
            }
            catch (NumberFormatException n) {
                return false;
            }
        }
        return false;
    }

    protected void tfBarcode_actionPerformed(ActionEvent e) {
        this.frParent.setCursor(StoreParams.waitCursor);
        if (this.insertStyleLine(this.tfBarcode.getText())) {
            this.tfBarcode.requestFocus();
            this.tfBarcode.selectAll();
        }
        this.frParent.setCursor(StoreParams.normalCursor);
    }

    protected void delLines() {
        int[] rows = this.tblStyles.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            this.tblStyles.delLine(rows[i], false, true);
        }
    }

    protected void update() {
        ((FrTransferRequest)this.frParent).setButtons();
    }

    protected void db_populateQty(String num, String vhidx) {
    }

    private void tfBarcode_focusGained(FocusEvent e) {
        this.tfBarcode.selectAll();
        this.frParent.setStatusMsg(StatusBar.status_EANTransferRequest);
    }

    public void addSku(Long skuidx) {
        int row = this.tblStyles.addSku(skuidx, 1.0, false, true);
        if (row > -1) {
            this.tblStyles.model.fireTableRowsUpdated(row, row);
        }
    }

    public Reference getSelectedStore() {
        if (this.tfWhse.getidx() <= 0L) {
            return null;
        }
        for (int i = 0; i < this.stores.size(); ++i) {
            if (this.stores.elementAt(i).getIdx() != this.tfWhse.getidx()) continue;
            return this.stores.elementAt(i);
        }
        return null;
    }

    public void setSelectedStore(Reference store) {
        if (store != null) {
            this.tfWhse.setAll(store.getIdx(), store.getCode(), store.getName());
        } else {
            this.tfWhse.clear();
        }
    }

    public Vector<Reference> getStores() {
        return this.stores;
    }
}

