/*
 * Decompiled with CFR 0.152.
 */
package jpos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import jpos.SP;
import jpos.StoreParams;
import jpos.ui.Colours;
import jpos.ui.TouchButton;
import jpos.ui.UIConstants;

public class ProgressPanel
extends JPanel
implements PropertyChangeListener {
    private static final String ICON_FILE = "abort20x20.png";
    private JProgressBar progressBar;
    private TouchButton abortButton;
    private SwingWorker<?, ?> task;
    private Color barColour = Colours.CHART_BLUE;

    public ProgressPanel(boolean paintProgressString) {
        super(new GridBagLayout());
        this.progressBar = new JProgressBar(0, 100){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.height = UIConstants.BUTTON_HEIGHT - 1;
                return d;
            }
        };
        this.progressBar.setStringPainted(paintProgressString);
        this.progressBar.setForeground(this.barColour);
        this.abortButton = new TouchButton(""){

            @Override
            public int getButtonWidth() {
                return this.getButtonHeight();
            }

            @Override
            public int getButtonHeight() {
                return UIConstants.BUTTON_HEIGHT;
            }
        };
        this.abortButton.setIcon(new ImageIcon(SP.sParams.imagepath + ICON_FILE));
        this.abortButton.setToolTipText(StoreParams.res.getString("Abort"));
        this.abortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressPanel.this.cancelTask();
            }
        });
        this.abortButton.setEnabled(false);
        this.abortButton.setBorder(this.progressBar.getBorder());
        this.add((Component)this.progressBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(1, 0, 0, 0), 0, 0));
        this.add((Component)this.abortButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, -1, 0, 0), 0, 0));
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public TouchButton getAbortButton() {
        return this.abortButton;
    }

    public SwingWorker<?, ?> getTask() {
        return this.task;
    }

    public void executeTask(SwingWorker<?, ?> task) {
        this.executeTask(task, null);
    }

    public void executeTask(SwingWorker<?, ?> task, PropertyChangeListener listener) {
        this.reset();
        this.progressBar.setValue(0);
        this.task = task;
        this.task.addPropertyChangeListener(this);
        if (listener != null) {
            this.task.addPropertyChangeListener(listener);
        }
        this.abortButton.setEnabled(true);
        this.task.execute();
    }

    public boolean cancelTask() {
        if (this.task != null) {
            return this.task.cancel(false);
        }
        return false;
    }

    public void reset() {
        this.cancelTask();
        this.task = null;
        this.progressBar.setValue(0);
        this.progressBar.setForeground(this.barColour);
    }

    public void markAsFinished(boolean success) {
        if (success) {
            this.progressBar.setForeground(Colours.CHART_GREEN);
        } else {
            this.progressBar.setForeground(Colours.CHART_RED);
        }
    }

    public void setBarColour(Color colour) {
        this.barColour = colour;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.task) {
            if (evt.getPropertyName() == "progress") {
                this.progressBar.setValue((Integer)evt.getNewValue());
            }
            if (evt.getPropertyName() == "state" && evt.getNewValue() == SwingWorker.StateValue.DONE) {
                this.abortButton.setEnabled(false);
            }
        }
    }
}

