/*
 * Decompiled with CFR 0.152.
 */
package jpos.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jpos.FadeLabel;
import jpos.StringUtils;

public class ValidationIconPanel
extends JPanel {
    private JComponent editField;
    private FadeLabel fadeLabel = new FadeLabel(800, 50);
    private ImageIcon currentIcon = null;
    private String message;
    private final ImageIcon errorIcon = new ImageIcon(this.getClass().getClassLoader().getResource("images/validation_problem.png"));
    private final ImageIcon warningIcon = new ImageIcon(this.getClass().getClassLoader().getResource("images/validation_question.png"));

    public ValidationIconPanel(JComponent editField) {
        super(new GridBagLayout());
        this.editField = editField;
        this.init();
    }

    private void init() {
        this.setIcon(this.errorIcon);
        this.add((Component)this.editField, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.fadeLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 3, 0, 0), 0, 0));
    }

    private void showIcon(String tooltip, ImageIcon icon) {
        this.setIcon(icon);
        this.message = tooltip;
        this.fadeLabel.setToolTipMessage(this.message);
        this.fadeLabel.fadeIn();
    }

    private void setIcon(ImageIcon icon) {
        if (this.currentIcon != icon) {
            this.fadeLabel.setIcon(icon);
            this.currentIcon = icon;
        }
    }

    public void showError() {
        this.showError("");
    }

    public void showError(String tooltip) {
        this.showIcon(tooltip, this.errorIcon);
    }

    public void showWarning() {
        this.showWarning("");
    }

    public void showWarning(String tooltip) {
        this.showIcon(tooltip, this.warningIcon);
    }

    public void clear() {
        this.fadeLabel.fadeOut();
        this.message = "";
        this.fadeLabel.setToolTipMessage(this.message);
    }

    public FadeLabel getFadeLabel() {
        return this.fadeLabel;
    }

    public JComponent getEditField() {
        return this.editField;
    }

    public String getMessage() {
        return StringUtils.nullToEmpty(this.message);
    }
}

