/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.TouchTextArea;
import jpos.ui.TouchTextField;
import jpos.voucher.BaseAdapter;
import jpos.voucher.IVoucherGateway;
import jpos.voucher.VoucherGatewayManager;
import jpos.voucher.VoucherIssueAdapter;
import jpos.voucher.vii.ViiGateway;

public class DlgDigitalVoucherIssue
extends PosDialog {
    private boolean result = false;
    private DialogButton bCancel = new DialogButton("");
    private DialogButton bOk = new DialogButton("");
    private LabelNormal lEmail = new LabelNormal(SP.getRS("Dlg_Dig_Email"));
    private TouchTextField ttEmail = new TouchTextField();
    private LabelNormal lRecipientFirstName = new LabelNormal(SP.getRS("Dlg_Dig_Name"));
    private TouchTextField ttFirstname = new TouchTextField();
    private LabelNormal lRecipientSurname = new LabelNormal(SP.getRS("Dlg_Dig_Surname"));
    private TouchTextField ttSurname = new TouchTextField();
    private LabelNormal lMessage = new LabelNormal(SP.getRS("Dlg_Dig_Message"));
    private TouchTextArea ttMessageInner = new TouchTextArea();
    private String _attachedPersonEmail = "";
    private String _attachedPersonFirstname = "";
    private String _attachedPersonSurname = "";
    private boolean _isMessageEnabled = false;
    private BaseAdapter _adapter;

    public DlgDigitalVoucherIssue(PosFrame frame, String title, BaseAdapter adapter, Boolean includeMessage) {
        super(frame, SP.getRS("Dlg_DigPhy_Title"), true);
        if (frame instanceof FrSales) {
            this._attachedPersonEmail = ((FrSales)frame).getAttachedPersonEmail();
            this._attachedPersonFirstname = ((FrSales)frame).getAttachedPersonFirstname();
            this._attachedPersonSurname = ((FrSales)frame).getAttachedPersonSurname();
        }
        this._isMessageEnabled = includeMessage;
        this._adapter = adapter;
        this.init();
    }

    private void init() {
        this.setAcceptOnEnter(false);
        this.setResizable(false);
        this.bCancel.setText(StoreParams.res.getString(SP.getRS("Dlg_Dig_Cancel")));
        this.bOk.setText(SP.getRS("Dlg_Dig_Ok"));
        this.ttEmail.setFieldWidth(300);
        this.ttEmail.setText(this._attachedPersonEmail);
        this.ttFirstname.setFieldWidth(300);
        this.ttFirstname.setText(this._attachedPersonFirstname);
        this.ttSurname.setFieldWidth(300);
        this.ttSurname.setText(this._attachedPersonSurname);
        JPanel panelFields = new JPanel(new GridBagLayout());
        panelFields.add((Component)this.lEmail, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 4), 0, 0));
        panelFields.add((Component)this.ttEmail, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 10, 4, 0), 0, 0));
        panelFields.add((Component)this.lRecipientFirstName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 4), 0, 0));
        panelFields.add((Component)this.ttFirstname, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 10, 4, 0), 0, 0));
        panelFields.add((Component)this.lRecipientSurname, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 4), 0, 0));
        panelFields.add((Component)this.ttSurname, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 10, 4, 0), 0, 0));
        if (this._isMessageEnabled) {
            panelFields.add((Component)this.lMessage, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 4), 0, 0));
            this.ttMessageInner.setAutoscrolls(true);
            this.ttMessageInner.setLineWrap(true);
            this.ttMessageInner.setWrapStyleWord(true);
            this.ttMessageInner.setRows(3);
            JScrollPane ttMessage = new JScrollPane(this.ttMessageInner);
            panelFields.add((Component)ttMessage, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 10, 4, 0), 0, 0));
        }
        JPanel panelButtons = new JPanel(new GridBagLayout());
        panelButtons.add((Component)this.bOk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panelButtons.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panelMain = new JPanel(new GridBagLayout());
        panelMain.add((Component)panelFields, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 20, 4, 4), 0, 0));
        panelMain.add((Component)panelButtons, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 20, 4, 4), 0, 0));
        this.getContentPane().add(panelMain);
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgDigitalVoucherIssue.this.okDialog();
            }
        });
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgDigitalVoucherIssue.this.cancelDialog();
            }
        });
        this.ttMessageInner.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    e.consume();
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
                if (e.getKeyCode() == 9 && e.isShiftDown()) {
                    e.consume();
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                }
            }
        });
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.ttEmail);
        v.add(this.ttFirstname);
        v.add(this.ttSurname);
        v.add(this.ttMessageInner);
        v.add(this.bOk);
        v.add(this.bCancel);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        PosUtils.centreWindow(this);
    }

    private boolean isNameRequired() {
        IVoucherGateway viiGatewayCheck = VoucherGatewayManager.getInstance().getGateway();
        if (viiGatewayCheck instanceof ViiGateway) {
            return ((ViiGateway)viiGatewayCheck).getIsNameRequired();
        }
        return true;
    }

    private boolean validateDetails() {
        if (this.isNameRequired()) {
            if (this.ttFirstname.getText().length() == 0) {
                DlgMessage.showMessage(this.frParent, SP.getRS("Dlg_Dig_Msg_IvldNameContent"), SP.getRS("Dlg_Dig_Msg_IvldName"), 0);
                return false;
            }
            if (this.ttSurname.getText().length() == 0) {
                DlgMessage.showMessage(this.frParent, SP.getRS("Dlg_Dig_Msg_IvldSurnameContent"), SP.getRS("Dlg_Dig_Msg_IvldSurname"), 0);
                return false;
            }
        }
        if (this.ttEmail.getText().length() == 0) {
            // empty if block
        }
        if (this.ttMessageInner.getText().length() > 400) {
            DlgMessage.showMessage(this.frParent, SP.getRS("Dlg_Dig_Msg_IvlMsgContent"), SP.getRS("Dlg_Dig_Msg_IvldMsg"), 0);
            return false;
        }
        if (!this.sParams.getEmailValidator().validate(this.ttEmail.getText())) {
            DlgMessage.showMessage(this.frParent, SP.getRS("Dlg_Dig_Msg_IvldEmailContentStruct"), SP.getRS("Dlg_Dig_Msg_IvldEmail"), 0);
            return false;
        }
        return true;
    }

    private void populateAdapterDetails() {
        VoucherIssueAdapter digitalVoucherAdapter = (VoucherIssueAdapter)this._adapter;
        digitalVoucherAdapter.SetRecipientEmail(this.ttEmail.getText());
        digitalVoucherAdapter.SetRecipientFirstName(this.ttFirstname.getText());
        digitalVoucherAdapter.SetRecipientSurname(this.ttSurname.getText());
        digitalVoucherAdapter.SetMessage(this.ttMessageInner.getText());
        digitalVoucherAdapter.SetDigital(true);
        this._adapter = digitalVoucherAdapter;
    }

    public boolean getResult() {
        return this.result;
    }

    public void setIsMessageEnabled(boolean value) {
        this._isMessageEnabled = value;
    }

    public boolean getIsMessageEnabled() {
        return this._isMessageEnabled;
    }

    @Override
    public void cancelDialog() {
        this.result = false;
        this.dispose();
    }

    @Override
    public void okDialog() {
        if (this.validateDetails()) {
            this.populateAdapterDetails();
            this.result = true;
            ((FrSales)this.frParent).setFilledEmail(this.ttEmail.getText());
            IVoucherGateway viiGatewayCheck = VoucherGatewayManager.getInstance().getGateway();
            if (viiGatewayCheck instanceof ViiGateway) {
                ((ViiGateway)viiGatewayCheck).setisNameRequried(true);
            }
            this.dispose();
        }
        this.result = false;
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }
}

