/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.StoreParams;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;
import jpos.voucher.BaseAdapter;
import jpos.voucher.VoucherUtils;

public class DlgVoucherIssue
extends PosDialog {
    private LabelSubHeading lTitle = new LabelSubHeading();
    private JPanel panelMain = new JPanel();
    private TouchTextField dfVoucherNumber = new TouchTextField();
    private DialogButton bOk = new DialogButton("");
    private DialogButton bCancel = new DialogButton("");
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private BaseAdapter adapter;
    private boolean _result = false;

    public DlgVoucherIssue(PosFrame frParent, String title, BaseAdapter adapter) {
        super(frParent, title, true);
        this.adapter = adapter;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.panelMain.setLayout(this.gridBagLayout1);
        this.lTitle.setText(this.adapter.getDisplayText(BaseAdapter.DisplayText.ScanDialogTitle));
        this.dfVoucherNumber.setText("");
        this.dfVoucherNumber.setFieldWidth(100);
        this.dfVoucherNumber.setHorizontalAlignment(4);
        this.dfVoucherNumber.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '?' && DlgVoucherIssue.this.dfVoucherNumber.getText().length() > 1 && (DlgVoucherIssue.this.dfVoucherNumber.getText().substring(0, 1).equals(";") || DlgVoucherIssue.this.dfVoucherNumber.getText().substring(0, 1).equals("%"))) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DlgVoucherIssue.this.okDialog();
                        }
                    });
                }
            }
        });
        this.bOk.setText(StoreParams.res.getString("OK"));
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgVoucherIssue.this.okDialog();
            }
        });
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgVoucherIssue.this.cancelDialog();
            }
        });
        this.getContentPane().add(this.panelMain);
        this.panelMain.add((Component)this.lTitle, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(20, 20, 10, 20), 0, 0));
        this.panelMain.add((Component)this.dfVoucherNumber, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 20, 10, 20), 100, 0));
        this.panelMain.add((Component)this.bOk, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 20, 10), 0, 0));
        this.panelMain.add((Component)this.bCancel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 20, 20), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.dfVoucherNumber);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        PosUtils.centreWindow(this);
    }

    @Override
    public void okDialog() {
        this.dfVoucherNumber.setText(VoucherUtils.cleanVoucherNumber(this.dfVoucherNumber.getText()));
        if (this.adapter.processNumber(this.dfVoucherNumber.getText())) {
            this._result = true;
            this.setVisible(false);
        } else {
            this.dfVoucherNumber.requestFocus();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DlgVoucherIssue.this.dfVoucherNumber.selectAll();
                }
            });
        }
    }

    public boolean GetResult() {
        return this._result;
    }

    @Override
    public void cancelDialog() {
        this._result = false;
        this.setVisible(false);
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }
}

