/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher.vii;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.UUID;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import jpos.SP;
import jpos.voucher.vii.ViiConfig;
import jpos.voucher.vii.XmlSerialiser;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Request {
    private static final String NEW_ORDER_REQUEST = "NewOrder";
    @XmlTransient
    private DecimalFormat amountFormatter;
    @XmlTransient
    private ViiConfig config;
    @XmlElement(name="RequestType")
    private String requestType;
    @XmlElement(name="viiTranId")
    private String transactionId;

    public String getRequestType() {
        return this.requestType;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @XmlElement(name="viiUserName")
    public String getUsername() {
        return this.config != null ? (this.requestType.equals(NEW_ORDER_REQUEST) ? this.config.getDigitalConfig().getUsername() : this.config.getUsername()) : null;
    }

    @XmlElement(name="viiPassword")
    public String getPassword() {
        return this.config != null ? (this.requestType.equals(NEW_ORDER_REQUEST) ? this.config.getDigitalConfig().getPassword() : this.config.getPassword()) : null;
    }

    @XmlElement(name="StoreId")
    public String getStoreId() {
        return this.config != null ? this.config.getStoreId() : null;
    }

    @XmlElement(name="AIIC")
    public String getAIIC() {
        return this.config != null ? this.config.getAIIC() : null;
    }

    @XmlElement(name="CATI")
    public String getCATI() {
        return this.config != null ? this.config.getCATI() : null;
    }

    @XmlElement(name="CAIC")
    public String getCAIC() {
        return this.config != null ? this.config.getCAIC() : null;
    }

    public void setConfig(ViiConfig config) {
        this.config = config;
    }

    protected Request() {
    }

    public Request(ViiConfig config, String requestType) {
        this.requestType = requestType;
        this.config = config;
        this.transactionId = UUID.randomUUID().toString();
    }

    public String serialise() throws JAXBException {
        return this.serialise(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serialise(boolean withConfig) throws JAXBException {
        ViiConfig tempConfig = this.config;
        try {
            if (!withConfig) {
                this.config = null;
            }
            String string = XmlSerialiser.serialise(this);
            return string;
        }
        finally {
            this.config = tempConfig;
        }
    }

    protected String formatAmount(double amount) {
        if (this.amountFormatter == null) {
            if (SP.sParams.storeCurrency.getPrecision() <= 0) {
                this.amountFormatter = new DecimalFormat("0");
            } else {
                char[] format = new char[SP.sParams.storeCurrency.getPrecision() + 2];
                format[0] = 48;
                format[1] = 46;
                Arrays.fill(format, 2, SP.sParams.storeCurrency.getPrecision() + 2, '0');
                this.amountFormatter = new DecimalFormat(new String(format));
            }
            this.amountFormatter.setRoundingMode(RoundingMode.FLOOR);
        }
        return this.amountFormatter.format(amount);
    }
}

