/*
 * Decompiled with CFR 0.152.
 */
package ReceiptPrinter;

import java.sql.Connection;
import java.util.Vector;
import jpos.PosUtils;
import jpos.SqlQuery;

public class Comments {
    private Vector<DocketText> texts = new Vector();

    public Comments(Connection conn) {
        this.loadComments(conn);
    }

    private void loadComments(Connection conn) {
        this.texts.clear();
        try (SqlQuery sql = new SqlQuery(conn, "SELECT T.DOCKET_TEXT_RCIDX, T.TEXT FROM POS_DOCKET_TEXT T ");){
            while (sql.next()) {
                DocketTextType docketTextType = DocketTextType.getDocketTextType(sql.getLong(1));
                if (docketTextType == null) continue;
                this.texts.add(new DocketText(docketTextType, sql.getString(2)));
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public String getString(DocketTextType docketTextType) {
        for (int i = 0; i < this.texts.size(); ++i) {
            if (this.texts.elementAt((int)i).docketTextType != docketTextType) continue;
            return this.texts.elementAt((int)i).text;
        }
        return "";
    }

    private class DocketText {
        DocketTextType docketTextType;
        String text;

        DocketText(DocketTextType docketTextType, String text) {
            this.docketTextType = docketTextType;
            this.text = text;
        }
    }

    public static enum DocketTextType {
        DOCKET_HDR(522L),
        DOCKET_FTR(523L),
        SALE_LEGAL(524L),
        CREDIT_LEGAL(525L),
        CREDIT_TERMS(520L),
        LAYBY_TERMS(521L),
        LAYBY_LEGAL(526L),
        TRANSFER(527L),
        STK_TAKE(613L),
        RESERVATION(615L),
        SPECIAL_ORDER_TERMS(640L),
        SPECIAL_ORDER_LEGAL(641L),
        CUST_ORDER_LEGAL(717L),
        CUST_ORDER_TERMS(718L),
        FLOOR_TO_DOOR_LEGAL(778L),
        FLOOR_TO_DOOR_TERMS(779L),
        PROMO_VOUCHER_FOOTER(785L),
        VOUCHER_GATEWAY_LOAD_FOOTER(798L),
        QR_CODE_PERSON_SIGNUP(807L),
        VOUCHER_GATEWAY_DIGITAL_FOOTER(860L),
        VOUCHER_GATEWAY_DIGITAL_REFUND(861L);

        private long docketTextId;

        private DocketTextType(long docketTextId) {
            this.docketTextId = docketTextId;
        }

        public long getId() {
            return this.docketTextId;
        }

        public static DocketTextType getDocketTextType(long docketTextId) throws Exception {
            for (DocketTextType d : DocketTextType.values()) {
                if (d.getId() != docketTextId) continue;
                return d;
            }
            return null;
        }
    }
}

