/*
 * Decompiled with CFR 0.152.
 */
package ReceiptPrinter;

import ReceiptPrinter.Gen;
import ReceiptPrinter.IOErrorHandler;
import ReceiptPrinter.PrintReceipt;
import ReceiptPrinter.StoreDetails;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import jpos.PosDateFormatter;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.SystemSettings;
import jpos.tillbalance.TillBalanceUtils;

public class ThreadEODReport
extends Thread {
    private Connection conn;
    private String sPrinterPort = null;
    private String sPrinterFont = null;
    private String sImagePath = null;
    private DecimalFormat dfQty;
    private DecimalFormat dfDet;
    private int nPrec;
    private String docknum = "";
    private boolean reprint;
    private IOErrorHandler errorHandler;

    public ThreadEODReport(Connection conn, String docket_number, boolean preprint, IOErrorHandler errorHandler) {
        this.docknum = docket_number;
        this.conn = conn;
        this.reprint = preprint;
        this.errorHandler = errorHandler;
        this.commonConstruct();
    }

    private void commonConstruct() {
        Gen.populateNumCopies(this.conn);
        StringBuffer sDet = new StringBuffer();
        StringBuffer sTot = new StringBuffer();
        StringBuffer sPrec = new StringBuffer();
        Gen.getCurrencyFmt(this.conn, sTot, sDet, sPrec);
        this.dfQty = new DecimalFormat("");
        this.dfDet = new DecimalFormat(sDet.toString());
        this.nPrec = PosUtils.intVal(sPrec.toString());
        this.sPrinterPort = StoreDetails.getString("printerport");
        this.sPrinterFont = Gen.NVLString(StoreDetails.getString("printerfont"), "");
        this.sImagePath = StoreDetails.getString("imagepath");
    }

    @Override
    public void run() {
        this.PrintEODReport();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean PrintEODReport() {
        if (this.sPrinterPort == null) {
            return false;
        }
        i = 0;
        while (i < Gen.EOD_COPIES) {
            try {
                r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);
                var3_4 = null;
                try {
                    try {
                        sTillNumber = "";
                        sUser = "";
                        transactionDate = null;
                        sBankBagNumber = "";
                        nTillBalanceType = 0;
                        try {
                            sql = new SqlQuery(this.conn, "SELECT H.TILL_NUMBER, COALESCE(P.FIRSTNAME, '') || ' ' || COALESCE(P.SURNAME, ''), H.TRAND, H.BANK_BAG_NUM, COALESCE(H.TILL_BALANCE_TYPE, 0) FROM RET_TRANH H, PERSON P WHERE H.TRANSSREPIDX = P.PERIDX AND H.DOCKET_NUMBER = ? AND H.WIDX = ?", new Object[]{this.docknum, SP.sParams.getStoreIdx()});
                            var10_16 = null;
                            try {
                                if (sql.next()) {
                                    sTillNumber = sql.getString(1);
                                    sUser = sql.getString(2);
                                    transactionDate = new PosDateFormatter(sql.getTimestamp(3));
                                    sBankBagNumber = sql.getString(4);
                                    nTillBalanceType = sql.getInt(5);
                                }
                            }
                            catch (Throwable var11_19) {
                                var10_16 = var11_19;
                                throw var11_19;
                            }
                            finally {
                                if (sql != null) {
                                    if (var10_16 != null) {
                                        try {
                                            sql.close();
                                        }
                                        catch (Throwable var11_18) {
                                            var10_16.addSuppressed(var11_18);
                                        }
                                    } else {
                                        sql.close();
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            PosUtils.logError(e);
                        }
                        nQty = 0.0;
                        nValue = 0.0;
                        nTotQty = 0.0;
                        nTotValue = 0.0;
                        sName = null;
                        nLBCancSku = SP.sParams.lbCancFeeSku;
                        nLBAdminSku = SP.sParams.lbAdminFeeSku;
                        nSOCancSku = SP.sParams.specOrdCancFeeSku;
                        nSOAdminSku = SP.sParams.specOrdAdminFeeSku;
                        sGiftSkus = String.join((CharSequence)",", SP.sParams.gvSkus);
                        sExcludeIdxs = this.getExcludedSkuFilter();
                        r1.PrintString("\u001b\u0006");
                        r1.PrintString("\u001b\u0001");
                        if (this.reprint) {
                            r1.PrintString(r1.FormatCentre(StoreParams.res.getString("REPRINT"), 42));
                            r1.Feed(1);
                        }
                        if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.ENFORCE_START_OF_DAY_TILL_BALANCE) && nTillBalanceType > TillBalanceUtils.TillBalanceType.TILL_BALANCE.getDatabaseValue()) {
                            if (nTillBalanceType == TillBalanceUtils.TillBalanceType.START_OF_DAY.getDatabaseValue()) {
                                r1.PrintString(r1.FormatCentre(SP.getRS("TILL_BALANCE_START_OF_DAY_REPORT"), 42));
                            } else {
                                r1.PrintString(r1.FormatCentre(SP.getRS("TILL_BALANCE_END_OF_DAY_REPORT"), 42));
                            }
                        } else {
                            r1.PrintString(r1.FormatCentre(SP.getRS("TILL_BALANCE_REPORT"), 42));
                        }
                        r1.Feed(1);
                        this.reprint = true;
                        r1.PrintString("\u001b\u0007");
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Store_No"), 15));
                        r1.PrintString(StoreDetails.getString("storeno") + "\n");
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Store_Name"), 15));
                        r1.PrintString(StoreDetails.getString("storename") + "\n");
                        if (transactionDate != null) {
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Date"), 15));
                            transactionDate.setFormat(1, 0);
                            r1.PrintString(transactionDate + "\n");
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Time"), 15));
                            transactionDate.setFormat(2, 1);
                            r1.PrintString(transactionDate + "\n");
                        }
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("POS_No"), 15));
                        r1.PrintString(sTillNumber + "\n");
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Docket_No"), 15));
                        r1.PrintString("D" + StoreDetails.getString("storeno") + this.docknum + "\n");
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Processed_By"), 15));
                        r1.PrintString(sUser + "\n");
                        r1.Feed(1);
                        r1.PrintString("\u001b\u0007");
                        r1.PrintString(StoreParams.res.getString("Counts") + "\n");
                        r1.PrintString("\u001b\u0005");
                        nTrType = 0;
                        nSaleCount = 0;
                        nLayByCount = 0;
                        nLayByUpPayCount = 0;
                        nSpecialOrderCount = 0;
                        nSpecialOrderUpPayCount = 0;
                        nTransInCount = 0;
                        nTransOutCount = 0;
                        nAccountCount = 0;
                        nOpenTillCount = 0;
                        nSaleLoyaltyCount = 0;
                        nLBLoyaltyCount = 0;
                        nLBUPLoyaltyCount = 0;
                        nSOLoyaltyCount = 0;
                        nSOUPLoyaltyCount = 0;
                        sTmp = null;
                        sql = new SqlQuery(this.conn, "SELECT H.TR_TYPE FROM RET_TRANH H WHERE H.TR_TYPE IN(239,240,241,242,243,244,245,248,249,250,251,252,556,620) AND H.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum));
                        var45_47 = null;
                        try {
                            block316: while (sql.next()) {
                                nTrType = sql.getInt(1);
                                switch (nTrType) {
                                    case 239: {
                                        ++nSaleCount;
                                        break;
                                    }
                                    case 240: {
                                        ++nLayByCount;
                                        break;
                                    }
                                    case 241: {
                                        ++nLayByUpPayCount;
                                        break;
                                    }
                                    case 242: {
                                        ++nLayByUpPayCount;
                                        break;
                                    }
                                    case 243: {
                                        ++nSpecialOrderCount;
                                        break;
                                    }
                                    case 244: {
                                        ++nSpecialOrderUpPayCount;
                                        break;
                                    }
                                    case 245: {
                                        ++nSpecialOrderUpPayCount;
                                        break;
                                    }
                                    case 248: {
                                        ++nTransInCount;
                                        break;
                                    }
                                    case 249: {
                                        ++nTransOutCount;
                                        break;
                                    }
                                    case 250: {
                                        ++nTransInCount;
                                        break;
                                    }
                                    case 251: {
                                        ++nTransInCount;
                                        break;
                                    }
                                    case 252: {
                                        ++nTransOutCount;
                                        break;
                                    }
                                    case 556: {
                                        ++nAccountCount;
                                        break;
                                    }
                                    case 620: {
                                        ++nOpenTillCount;
                                        continue block316;
                                    }
                                }
                            }
                        }
                        catch (Throwable var46_50) {
                            var45_47 = var46_50;
                            throw var46_50;
                        }
                        finally {
                            if (sql != null) {
                                if (var45_47 != null) {
                                    try {
                                        sql.close();
                                    }
                                    catch (Throwable var46_49) {
                                        var45_47.addSuppressed(var46_49);
                                    }
                                } else {
                                    sql.close();
                                }
                            }
                        }
                        sql = new SqlQuery(this.conn, "SELECT H.TR_TYPE, COUNT(DISTINCT(H.VHIDX)) FROM RET_TRANH H, RET_TRAND D WHERE H.VHIDX = D.VHIDX AND H.TR_TYPE IN(239,240,241,243,244) AND D.LINE_TYPE = 7 AND H.\"ACTIVE\" = 1 AND D.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum) + " " + "GROUP BY H.TR_TYPE");
                        var45_47 = null;
                        try {
                            block317: while (sql.next()) {
                                nTrType = sql.getInt(1);
                                switch (nTrType) {
                                    case 239: {
                                        nSaleLoyaltyCount = sql.getInt(2);
                                        break;
                                    }
                                    case 240: {
                                        nLBLoyaltyCount = sql.getInt(2);
                                        break;
                                    }
                                    case 241: {
                                        nLBUPLoyaltyCount = sql.getInt(2);
                                        break;
                                    }
                                    case 243: {
                                        nSOLoyaltyCount = sql.getInt(2);
                                        break;
                                    }
                                    case 244: {
                                        nSOUPLoyaltyCount = sql.getInt(2);
                                        continue block317;
                                    }
                                }
                            }
                        }
                        catch (Throwable var46_52) {
                            var45_47 = var46_52;
                            throw var46_52;
                        }
                        finally {
                            if (sql != null) {
                                if (var45_47 != null) {
                                    try {
                                        sql.close();
                                    }
                                    catch (Throwable var46_51) {
                                        var45_47.addSuppressed(var46_51);
                                    }
                                } else {
                                    sql.close();
                                }
                            }
                        }
                        sTmp = String.valueOf(nSaleCount);
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("No_Sales_Transactions"), 30));
                        r1.PrintString(r1.FormatRight(sTmp, 10) + "\n");
                        if (nSaleLoyaltyCount > 0) {
                            sTmp = String.valueOf(nSaleLoyaltyCount);
                            r1.PrintString(r1.FormatLeft("  " + StoreParams.res.getString("No_with_loyalty"), 30));
                            r1.PrintString(r1.FormatRight(sTmp, 10) + "\n");
                        }
                        if (SP.sParams.bUsingLaybys) {
                            sTmp = String.valueOf(nLayByCount);
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("No_Lay_by"), 30));
                            r1.PrintString(r1.FormatRight(sTmp, 10) + "\n");
                            if (nLBLoyaltyCount > 0) {
                                sTmp = String.valueOf(nLBLoyaltyCount);
                                r1.PrintString(r1.FormatLeft("  " + StoreParams.res.getString("No_with_loyalty"), 30));
                                r1.PrintString(r1.FormatRight(sTmp, 10) + "\n");
                            }
                            sTmp = String.valueOf(nLayByUpPayCount);
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("No_Lay_by_up_pay"), 30));
                            r1.PrintString(r1.FormatRight(sTmp, 10) + "\n");
                            if (nLBUPLoyaltyCount > 0) {
                                sTmp = String.valueOf(nLBUPLoyaltyCount);
                                r1.PrintString(r1.FormatLeft("  " + StoreParams.res.getString("No_with_loyalty"), 30));
                                r1.PrintString(r1.FormatRight(sTmp, 10) + "\n");
                            }
                        }
                        if (SP.sParams.bUsingSpecialOrders) {
                            sTmp = String.valueOf(nSpecialOrderCount);
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("No_Special_Order"), 30));
                            r1.PrintString(r1.FormatRight(sTmp, 10) + "\n");
                            if (nSOLoyaltyCount > 0) {
                                sTmp = String.valueOf(nSOLoyaltyCount);
                                r1.PrintString(r1.FormatLeft("  " + StoreParams.res.getString("No_with_loyalty"), 30));
                                r1.PrintString(r1.FormatRight(sTmp, 10) + "\n");
                            }
                            sTmp = String.valueOf(nSpecialOrderUpPayCount);
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("No_Special_Order_up_pay"), 30));
                            r1.PrintString(r1.FormatRight(sTmp, 10) + "\n");
                            if (nSOUPLoyaltyCount > 0) {
                                sTmp = String.valueOf(nSOUPLoyaltyCount);
                                r1.PrintString(r1.FormatLeft("  " + StoreParams.res.getString("No_with_loyalty"), 30));
                                r1.PrintString(r1.FormatRight(sTmp, 10) + "\n");
                            }
                        }
                        if (SP.sParams.bUsingDebtorSale) {
                            sTmp = String.valueOf(nAccountCount);
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("No_Debtor_Sale"), 30));
                            r1.PrintString(r1.FormatRight(sTmp, 10) + "\n");
                        }
                        sTmp = String.valueOf(nTransInCount);
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("No_Transfers_In"), 30));
                        r1.PrintString(r1.FormatRight(sTmp, 10) + "\n");
                        sTmp = String.valueOf(nTransOutCount);
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("No_Transfers_Out"), 30));
                        r1.PrintString(r1.FormatRight(sTmp, 10) + "\n");
                        sTmp = String.valueOf(nOpenTillCount);
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("No_Open_Till"), 30));
                        r1.PrintString(r1.FormatRight(sTmp, 10) + "\n");
                        r1.Feed(1);
                        r1.PrintString("\u001b\u0007");
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Sale_Transactions"), 30));
                        r1.PrintString(r1.FormatRight(StoreParams.res.getString("Units1"), 10));
                        r1.PrintString(r1.FormatRight(StoreParams.res.getString("Value"), 16) + "\n");
                        r1.PrintString("\u001b\u0005");
                        sName = null;
                        nTotQty = 0.0;
                        nTotValue = 0.0;
                        nQty = 0.0;
                        nValue = 0.0;
                        sql = new SqlQuery(this.conn, "SELECT SUM(D.QTY), SUM(D.NET) FROM RET_TRAND D, RET_TRANH H WHERE D.VHIDX = H.VHIDX AND ((D.NET > 0 AND D.LINE_TYPE in (0,2)) OR (D.NET < 0 AND D.LINE_TYPE IN(6,7))) AND H.TR_TYPE = 239 AND D.LINE_TYPE IN(0,2,6,7) AND H.\"ACTIVE\" = 1 AND D.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum) + sExcludeIdxs);
                        var45_47 = null;
                        try {
                            if (sql.next()) {
                                nQty = sql.getDouble(1);
                                nValue = sql.getDouble(2);
                                nTotQty += nQty;
                                nTotValue += nValue;
                            }
                        }
                        catch (Throwable var46_54) {
                            var45_47 = var46_54;
                            throw var46_54;
                        }
                        finally {
                            if (sql != null) {
                                if (var45_47 != null) {
                                    try {
                                        sql.close();
                                    }
                                    catch (Throwable var46_53) {
                                        var45_47.addSuppressed(var46_53);
                                    }
                                } else {
                                    sql.close();
                                }
                            }
                        }
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Sales"), 30));
                        sTmp = this.dfQty.format(nQty);
                        r1.PrintString(r1.FormatRight(sTmp, 10));
                        sTmp = this.dfDet.format(nValue);
                        r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                        sName = null;
                        nQty = 0.0;
                        nValue = 0.0;
                        sql = new SqlQuery(this.conn, "SELECT SUM(D.QTY), SUM(D.NET) FROM RET_TRAND D, RET_TRANH H WHERE D.VHIDX = H.VHIDX AND ((D.NET < 0 AND D.LINE_TYPE in (0,2)) OR (D.NET > 0 AND D.LINE_TYPE IN(6,7)))AND H.TR_TYPE = 239 AND D.LINE_TYPE IN (0,2,6,7) AND H.\"ACTIVE\" = 1 AND D.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum) + sExcludeIdxs);
                        var45_47 = null;
                        try {
                            if (sql.next()) {
                                nQty = sql.getDouble(1);
                                nValue = sql.getDouble(2);
                                nTotQty += nQty;
                                nTotValue += nValue;
                            }
                        }
                        catch (Throwable var46_56) {
                            var45_47 = var46_56;
                            throw var46_56;
                        }
                        finally {
                            if (sql != null) {
                                if (var45_47 != null) {
                                    try {
                                        sql.close();
                                    }
                                    catch (Throwable var46_55) {
                                        var45_47.addSuppressed(var46_55);
                                    }
                                } else {
                                    sql.close();
                                }
                            }
                        }
                        if (Gen.RoundNumber(nQty, this.nPrec) != 0.0) {
                            nQty *= -1.0;
                        }
                        if (Gen.RoundNumber(nValue, this.nPrec) != 0.0) {
                            nValue *= -1.0;
                        }
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Returns"), 30));
                        sTmp = this.dfQty.format(nQty);
                        r1.PrintString(r1.FormatRight(sTmp, 10));
                        sTmp = this.dfDet.format(nValue);
                        r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                        if (SP.sParams.bUsingDebtorSale) {
                            sName = null;
                            nQty = 0.0;
                            nValue = 0.0;
                            sql = new SqlQuery(this.conn, "SELECT SUM(D.QTY), SUM(D.NET)+SUM(D.NET*(D.TAXPER/100)) FROM RET_TRAND D, RET_TRANH H WHERE D.VHIDX = H.VHIDX AND ((D.NET > 0 AND D.LINE_TYPE in (0,2)) OR (D.NET < 0 AND D.LINE_TYPE IN(6,7))) AND H.TR_TYPE = 556 AND D.LINE_TYPE IN(0,2,6,7) AND H.\"ACTIVE\" = 1 AND D.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum) + sExcludeIdxs);
                            var45_47 = null;
                            try {
                                if (sql.next()) {
                                    nQty = sql.getDouble(1);
                                    nValue = sql.getDouble(2);
                                    nTotQty += nQty;
                                    nTotValue += nValue;
                                }
                            }
                            catch (Throwable var46_58) {
                                var45_47 = var46_58;
                                throw var46_58;
                            }
                            finally {
                                if (sql != null) {
                                    if (var45_47 != null) {
                                        try {
                                            sql.close();
                                        }
                                        catch (Throwable var46_57) {
                                            var45_47.addSuppressed(var46_57);
                                        }
                                    } else {
                                        sql.close();
                                    }
                                }
                            }
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Total_Debtor_Sale"), 30));
                            sTmp = this.dfQty.format(nQty);
                            r1.PrintString(r1.FormatRight(sTmp, 10));
                            sTmp = this.dfDet.format(nValue);
                            r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                            sName = null;
                            nQty = 0.0;
                            nValue = 0.0;
                            sql = new SqlQuery(this.conn, "SELECT SUM(D.QTY), (SUM(D.NET)+SUM(D.NET*(D.TAXPER/100))) FROM RET_TRAND D, RET_TRANH H WHERE D.VHIDX = H.VHIDX AND ((D.NET < 0 AND D.LINE_TYPE in (0,2)) OR (D.NET > 0 AND D.LINE_TYPE IN(6,7)))AND H.TR_TYPE = 556 AND D.LINE_TYPE IN (0,2,6,7) AND H.\"ACTIVE\" = 1 AND D.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum) + sExcludeIdxs);
                            var45_47 = null;
                            try {
                                if (sql.next()) {
                                    nQty = sql.getDouble(1);
                                    nValue = sql.getDouble(2);
                                    nTotQty += nQty;
                                    nTotValue += nValue;
                                }
                            }
                            catch (Throwable var46_60) {
                                var45_47 = var46_60;
                                throw var46_60;
                            }
                            finally {
                                if (sql != null) {
                                    if (var45_47 != null) {
                                        try {
                                            sql.close();
                                        }
                                        catch (Throwable var46_59) {
                                            var45_47.addSuppressed(var46_59);
                                        }
                                    } else {
                                        sql.close();
                                    }
                                }
                            }
                            if (Gen.RoundNumber(nQty, this.nPrec) != 0.0) {
                                nQty *= -1.0;
                            }
                            if (Gen.RoundNumber(nValue, this.nPrec) != 0.0) {
                                nValue *= -1.0;
                            }
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Debtor_Sale_Returns"), 30));
                            sTmp = this.dfQty.format(nQty);
                            r1.PrintString(r1.FormatRight(sTmp, 10));
                            sTmp = this.dfDet.format(nValue);
                            r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                        }
                        if (SP.sParams.bUsingLaybys) {
                            sName = null;
                            nQty = 0.0;
                            nValue = 0.0;
                            if (SP.sParams.bAccuralAccounting) {
                                sTransNumber = null;
                                sql = new SqlQuery(this.conn, "SELECT DISTINCT(H.TRANS_NUMBER) FROM RET_TRANH H WHERE H.TR_TYPE IN(240,241,242) AND H.SALE_DATE IS NOT NULL AND H.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum));
                                var46_48 = null;
                                try {
                                    while (sql.next()) {
                                        block480: {
                                            sTransNumber = sql.getString(1);
                                            sqlSub = new SqlQuery(this.conn, "SELECT SUM(D.QTY), SUM(D.NET) FROM RET_TRAND D, RET_TRANH H WHERE D.VHIDX = H.VHIDX AND H.TR_TYPE IN(240,241,242) AND D.LINE_TYPE IN (0,2,6,7) AND H.\"ACTIVE\" = 1 AND D.\"ACTIVE\" = 1 AND H.SALE_DATE IS NOT NULL AND H.TRANS_NUMBER = " + PosUtils.StringToSqlString(sTransNumber) + sExcludeIdxs);
                                            var48_89 = null;
                                            try {
                                                if (sqlSub.next()) {
                                                    nQty += sqlSub.getDouble(1);
                                                    nValue += sqlSub.getDouble(2);
                                                }
                                                if (sqlSub == null) continue;
                                                if (var48_89 == null) break block480;
                                            }
                                            catch (Throwable var49_96) {
                                                try {
                                                    var48_89 = var49_96;
                                                    throw var49_96;
                                                }
                                                catch (Throwable var59_146) {
                                                    if (sqlSub == null) throw var59_146;
                                                    if (var48_89 == null) {
                                                        sqlSub.close();
                                                        throw var59_146;
                                                    }
                                                    try {
                                                        sqlSub.close();
                                                        throw var59_146;
                                                    }
                                                    catch (Throwable var60_124) {
                                                        var48_89.addSuppressed(var60_124);
                                                        throw var59_146;
                                                    }
                                                }
                                            }
                                            try {
                                                sqlSub.close();
                                                continue;
                                            }
                                            catch (Throwable var49_95) {
                                                var48_89.addSuppressed(var49_95);
                                                continue;
                                            }
                                        }
                                        sqlSub.close();
                                    }
                                }
                                catch (Throwable sqlSub) {
                                    var46_48 = sqlSub;
                                    throw sqlSub;
                                }
                                finally {
                                    if (sql != null) {
                                        if (var46_48 != null) {
                                            try {
                                                sql.close();
                                            }
                                            catch (Throwable sqlSub) {
                                                var46_48.addSuppressed(sqlSub);
                                            }
                                        } else {
                                            sql.close();
                                        }
                                    }
                                }
                            }
                            sql = new SqlQuery(this.conn, "SELECT SUM(D.QTY), SUM(D.NET) FROM RET_TRAND D, RET_TRANH H WHERE D.VHIDX = H.VHIDX AND H.TR_TYPE IN(240,241,242) AND D.LINE_TYPE IN (0,2,6,7) AND H.\"ACTIVE\" = 1 AND D.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum) + sExcludeIdxs);
                            sql = null;
                            try {
                                if (sql.next()) {
                                    nQty = sql.getDouble(1);
                                    nValue = sql.getDouble(2);
                                }
                            }
                            catch (Throwable var46_62) {
                                sql = var46_62;
                                throw var46_62;
                            }
                            finally {
                                if (sql != null) {
                                    if (sql != null) {
                                        try {
                                            sql.close();
                                        }
                                        catch (Throwable var46_61) {
                                            sql.addSuppressed(var46_61);
                                        }
                                    } else {
                                        sql.close();
                                    }
                                }
                            }
                            nTotQty += nQty;
                            nTotValue += nValue;
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Laybys"), 30));
                            sTmp = this.dfQty.format(nQty);
                            r1.PrintString(r1.FormatRight(sTmp, 10));
                            sTmp = this.dfDet.format(nValue);
                            r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                        }
                        if (SP.sParams.bUsingSpecialOrders) {
                            sName = null;
                            nQty = 0.0;
                            nValue = 0.0;
                            if (SP.sParams.bAccuralAccounting) {
                                sTransNumber = null;
                                sql = new SqlQuery(this.conn, "SELECT DISTINCT(H.TRANS_NUMBER) FROM RET_TRANH H WHERE H.TR_TYPE IN(243,244,245) AND H.SALE_DATE IS NOT NULL AND H.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum));
                                var46_48 = null;
                                try {
                                    while (sql.next()) {
                                        block482: {
                                            sTransNumber = sql.getString(1);
                                            sqlSub = new SqlQuery(this.conn, "SELECT SUM(D.QTY), SUM(D.NET) FROM RET_TRAND D, RET_TRANH H WHERE D.VHIDX = H.VHIDX AND H.TR_TYPE IN(243,244,245) AND D.LINE_TYPE IN (0,2,6,7) AND H.\"ACTIVE\" = 1 AND D.\"ACTIVE\" = 1 AND H.SALE_DATE IS NOT NULL AND H.TRANS_NUMBER = " + PosUtils.StringToSqlString(sTransNumber) + sExcludeIdxs);
                                            var48_89 = null;
                                            try {
                                                if (sqlSub.next()) {
                                                    nQty += sqlSub.getDouble(1);
                                                    nValue += sqlSub.getDouble(2);
                                                }
                                                if (sqlSub == null) continue;
                                                if (var48_89 == null) break block482;
                                            }
                                            catch (Throwable var49_98) {
                                                try {
                                                    var48_89 = var49_98;
                                                    throw var49_98;
                                                }
                                                catch (Throwable var65_130) {
                                                    if (sqlSub == null) throw var65_130;
                                                    if (var48_89 == null) {
                                                        sqlSub.close();
                                                        throw var65_130;
                                                    }
                                                    try {
                                                        sqlSub.close();
                                                        throw var65_130;
                                                    }
                                                    catch (Throwable var66_132) {
                                                        var48_89.addSuppressed(var66_132);
                                                        throw var65_130;
                                                    }
                                                }
                                            }
                                            try {
                                                sqlSub.close();
                                                continue;
                                            }
                                            catch (Throwable var49_97) {
                                                var48_89.addSuppressed(var49_97);
                                                continue;
                                            }
                                        }
                                        sqlSub.close();
                                    }
                                }
                                catch (Throwable sqlSub) {
                                    var46_48 = sqlSub;
                                    throw sqlSub;
                                }
                                finally {
                                    if (sql != null) {
                                        if (var46_48 != null) {
                                            try {
                                                sql.close();
                                            }
                                            catch (Throwable sqlSub) {
                                                var46_48.addSuppressed(sqlSub);
                                            }
                                        } else {
                                            sql.close();
                                        }
                                    }
                                }
                            }
                            sql = new SqlQuery(this.conn, "SELECT SUM(D.QTY), SUM(D.NET) FROM RET_TRAND D, RET_TRANH H WHERE D.VHIDX = H.VHIDX AND H.TR_TYPE IN(243,244,245) AND D.LINE_TYPE IN (0,2,6,7) AND H.\"ACTIVE\" = 1 AND D.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum) + sExcludeIdxs);
                            sql = null;
                            try {
                                if (sql.next()) {
                                    nQty = sql.getDouble(1);
                                    nValue = sql.getDouble(2);
                                }
                            }
                            catch (Throwable var46_64) {
                                sql = var46_64;
                                throw var46_64;
                            }
                            finally {
                                if (sql != null) {
                                    if (sql != null) {
                                        try {
                                            sql.close();
                                        }
                                        catch (Throwable var46_63) {
                                            sql.addSuppressed(var46_63);
                                        }
                                    } else {
                                        sql.close();
                                    }
                                }
                            }
                            nTotQty += nQty;
                            nTotValue += nValue;
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Special_Orders"), 30));
                            sTmp = this.dfQty.format(nQty);
                            r1.PrintString(r1.FormatRight(sTmp, 10));
                            sTmp = this.dfDet.format(nValue);
                            r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                        }
                        r1.PrintString(r1.FormatLeft("_______________________", 30));
                        r1.PrintString(r1.FormatRight("________", 10));
                        r1.PrintString(r1.FormatRight("________", 16) + "\n");
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Total_Sales"), 30));
                        sTmp = this.dfQty.format(nTotQty);
                        r1.PrintString(r1.FormatRight(sTmp, 10));
                        sTmp = this.dfDet.format(nTotValue);
                        r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                        if (SP.sParams.bUsingLaybys) {
                            sName = null;
                            nQty = 0.0;
                            nValue = 0.0;
                            r1.Feed(1);
                            r1.PrintString("\u001b\u0007");
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Laybys"), 30) + "\n");
                            r1.PrintString("\u001b\u0005");
                            sql = new SqlQuery(this.conn, "SELECT SUM(D.QTY), SUM(D.NET) FROM RET_TRAND D, RET_TRANH H WHERE D.VHIDX = H.VHIDX AND H.TR_TYPE IN(240,241,242) AND ((D.NET > 0 AND D.LINE_TYPE in (0,2)) OR (D.NET < 0 AND D.LINE_TYPE IN(6,7))) AND D.LINE_TYPE IN (0,2,6,7) AND H.\"ACTIVE\" = 1 AND D.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum) + sExcludeIdxs);
                            sql = null;
                            try {
                                if (sql.next()) {
                                    nQty = sql.getDouble(1);
                                    nValue = sql.getDouble(2);
                                }
                            }
                            catch (Throwable var46_66) {
                                sql = var46_66;
                                throw var46_66;
                            }
                            finally {
                                if (sql != null) {
                                    if (sql != null) {
                                        try {
                                            sql.close();
                                        }
                                        catch (Throwable var46_65) {
                                            sql.addSuppressed(var46_65);
                                        }
                                    } else {
                                        sql.close();
                                    }
                                }
                            }
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Items_Added"), 30));
                            sTmp = this.dfQty.format(nQty);
                            r1.PrintString(r1.FormatRight(sTmp, 10));
                            sTmp = this.dfDet.format(nValue);
                            r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                            sName = null;
                            nQty = 0.0;
                            nValue = 0.0;
                            sql = new SqlQuery(this.conn, "SELECT SUM(D.QTY), SUM(D.NET) FROM RET_TRAND D, RET_TRANH H WHERE D.VHIDX = H.VHIDX AND H.TR_TYPE IN(240,241,242) AND ((D.NET < 0 AND D.LINE_TYPE in (0,2)) OR (D.NET > 0 AND D.LINE_TYPE IN(6,7))) AND D.LINE_TYPE IN (0,2,6,7) AND H.\"ACTIVE\" = 1 AND D.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum) + sExcludeIdxs);
                            sql = null;
                            try {
                                if (sql.next()) {
                                    nQty = sql.getDouble(1);
                                    nValue = sql.getDouble(2);
                                }
                            }
                            catch (Throwable var46_68) {
                                sql = var46_68;
                                throw var46_68;
                            }
                            finally {
                                if (sql != null) {
                                    if (sql != null) {
                                        try {
                                            sql.close();
                                        }
                                        catch (Throwable var46_67) {
                                            sql.addSuppressed(var46_67);
                                        }
                                    } else {
                                        sql.close();
                                    }
                                }
                            }
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Items_Removed"), 30));
                            sTmp = this.dfQty.format(nQty);
                            r1.PrintString(r1.FormatRight(sTmp, 10));
                            sTmp = this.dfDet.format(nValue);
                            r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                            sName = null;
                            nQty = 0.0;
                            nValue = 0.0;
                            sql = new SqlQuery(this.conn, "SELECT COUNT(DISTINCT(H.VHIDX)), SUM(P.PAYMENT_AMOUNT) FROM RET_TRANP P, RET_TRANH H WHERE P.VHIDX = H.VHIDX AND H.TR_TYPE IN(240,241,242) AND P.PAYMENT_TYPEIDX NOT IN (456,457) AND H.\"ACTIVE\" = 1 AND P.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum));
                            sql = null;
                            try {
                                if (sql.next()) {
                                    nQty = sql.getDouble(1);
                                    nValue = sql.getDouble(2);
                                }
                            }
                            catch (Throwable var46_70) {
                                sql = var46_70;
                                throw var46_70;
                            }
                            finally {
                                if (sql != null) {
                                    if (sql != null) {
                                        try {
                                            sql.close();
                                        }
                                        catch (Throwable var46_69) {
                                            sql.addSuppressed(var46_69);
                                        }
                                    } else {
                                        sql.close();
                                    }
                                }
                            }
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Payments"), 30));
                            sTmp = this.dfQty.format(nQty);
                            r1.PrintString(r1.FormatRight(sTmp, 10));
                            sTmp = this.dfDet.format(nValue);
                            r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                            sName = null;
                            nQty = 0.0;
                            nValue = 0.0;
                            sql = new SqlQuery(this.conn, "SELECT SUM(D.QTY), SUM(D.NET) FROM RET_TRAND D, RET_TRANH H WHERE H.VHIDX = D.VHIDX AND H.TR_TYPE IN(240,241,242) AND D.SKUIDX IN(" + nLBAdminSku + "," + nLBCancSku + ") AND " + "D.LINE_TYPE IN (0,2,6,7)AND H.\"ACTIVE\" = 1 AND D.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum));
                            sql = null;
                            try {
                                if (sql.next()) {
                                    nQty = sql.getDouble(1);
                                    nValue = sql.getDouble(2);
                                }
                            }
                            catch (Throwable var46_72) {
                                sql = var46_72;
                                throw var46_72;
                            }
                            finally {
                                if (sql != null) {
                                    if (sql != null) {
                                        try {
                                            sql.close();
                                        }
                                        catch (Throwable var46_71) {
                                            sql.addSuppressed(var46_71);
                                        }
                                    } else {
                                        sql.close();
                                    }
                                }
                            }
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Fees"), 30));
                            sTmp = this.dfQty.format(nQty);
                            r1.PrintString(r1.FormatRight(sTmp, 10));
                            sTmp = this.dfDet.format(nValue);
                            r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                        }
                        if (SP.sParams.bUsingSpecialOrders) {
                            sName = null;
                            nQty = 0.0;
                            nValue = 0.0;
                            r1.Feed(1);
                            r1.PrintString("\u001b\u0007");
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Special_Orders"), 30) + "\n");
                            r1.PrintString("\u001b\u0005");
                            sql = new SqlQuery(this.conn, "SELECT SUM(D.QTY), SUM(D.NET) FROM RET_TRAND D, RET_TRANH H WHERE D.VHIDX = H.VHIDX AND H.TR_TYPE IN(243,244,245) AND ((D.NET > 0 AND D.LINE_TYPE in (0,2)) OR (D.NET < 0 AND D.LINE_TYPE IN(6,7))) AND D.LINE_TYPE IN (0,2,6,7) AND H.\"ACTIVE\" = 1 AND D.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum) + sExcludeIdxs);
                            sql = null;
                            try {
                                if (sql.next()) {
                                    nQty = sql.getDouble(1);
                                    nValue = sql.getDouble(2);
                                }
                            }
                            catch (Throwable var46_74) {
                                sql = var46_74;
                                throw var46_74;
                            }
                            finally {
                                if (sql != null) {
                                    if (sql != null) {
                                        try {
                                            sql.close();
                                        }
                                        catch (Throwable var46_73) {
                                            sql.addSuppressed(var46_73);
                                        }
                                    } else {
                                        sql.close();
                                    }
                                }
                            }
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Items_Added"), 30));
                            sTmp = this.dfQty.format(nQty);
                            r1.PrintString(r1.FormatRight(sTmp, 10));
                            sTmp = this.dfDet.format(nValue);
                            r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                            sName = null;
                            nQty = 0.0;
                            nValue = 0.0;
                            sql = new SqlQuery(this.conn, "SELECT SUM(D.QTY), SUM(D.NET) FROM RET_TRAND D, RET_TRANH H WHERE D.VHIDX = H.VHIDX AND H.TR_TYPE IN(243,244,245) AND ((D.NET < 0 AND D.LINE_TYPE in (0,2)) OR (D.NET > 0 AND D.LINE_TYPE IN(6,7))) AND D.LINE_TYPE IN (0,2,6,7) AND H.\"ACTIVE\" = 1 AND D.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum) + sExcludeIdxs);
                            sql = null;
                            try {
                                if (sql.next()) {
                                    nQty = sql.getDouble(1);
                                    nValue = sql.getDouble(2);
                                }
                            }
                            catch (Throwable var46_76) {
                                sql = var46_76;
                                throw var46_76;
                            }
                            finally {
                                if (sql != null) {
                                    if (sql != null) {
                                        try {
                                            sql.close();
                                        }
                                        catch (Throwable var46_75) {
                                            sql.addSuppressed(var46_75);
                                        }
                                    } else {
                                        sql.close();
                                    }
                                }
                            }
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Items_Removed"), 30));
                            sTmp = this.dfQty.format(nQty);
                            r1.PrintString(r1.FormatRight(sTmp, 10));
                            sTmp = this.dfDet.format(nValue);
                            r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                            sName = null;
                            nQty = 0.0;
                            nValue = 0.0;
                            sql = new SqlQuery(this.conn, "SELECT COUNT(DISTINCT(H.VHIDX)), SUM(P.PAYMENT_AMOUNT) FROM RET_TRANP P, RET_TRANH H WHERE P.VHIDX = H.VHIDX AND H.TR_TYPE IN(243,244,245) AND P.PAYMENT_TYPEIDX NOT IN (456,457) AND H.\"ACTIVE\" = 1 AND P.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum));
                            sql = null;
                            try {
                                if (sql.next()) {
                                    nQty = sql.getDouble(1);
                                    nValue = sql.getDouble(2);
                                }
                            }
                            catch (Throwable var46_78) {
                                sql = var46_78;
                                throw var46_78;
                            }
                            finally {
                                if (sql != null) {
                                    if (sql != null) {
                                        try {
                                            sql.close();
                                        }
                                        catch (Throwable var46_77) {
                                            sql.addSuppressed(var46_77);
                                        }
                                    } else {
                                        sql.close();
                                    }
                                }
                            }
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Payments"), 30));
                            sTmp = this.dfQty.format(nQty);
                            r1.PrintString(r1.FormatRight(sTmp, 10));
                            sTmp = this.dfDet.format(nValue);
                            r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                            sName = null;
                            nQty = 0.0;
                            nValue = 0.0;
                            sql = new SqlQuery(this.conn, "SELECT SUM(D.QTY), SUM(D.NET) FROM RET_TRAND D, RET_TRANH H WHERE H.VHIDX = D.VHIDX AND H.TR_TYPE IN(243,244,245) AND D.SKUIDX IN(" + nSOAdminSku + "," + nSOCancSku + ") AND " + "D.LINE_TYPE IN (0,2,6,7)AND H.\"ACTIVE\" = 1 AND D.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum));
                            sql = null;
                            try {
                                if (sql.next()) {
                                    nQty = sql.getDouble(1);
                                    nValue = sql.getDouble(2);
                                }
                            }
                            catch (Throwable var46_80) {
                                sql = var46_80;
                                throw var46_80;
                            }
                            finally {
                                if (sql != null) {
                                    if (sql != null) {
                                        try {
                                            sql.close();
                                        }
                                        catch (Throwable var46_79) {
                                            sql.addSuppressed(var46_79);
                                        }
                                    } else {
                                        sql.close();
                                    }
                                }
                            }
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Fees"), 30));
                            sTmp = this.dfQty.format(nQty);
                            r1.PrintString(r1.FormatRight(sTmp, 10));
                            sTmp = this.dfDet.format(nValue);
                            r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                        }
                        r1.Feed(1);
                        r1.PrintString("\u001b\u0007");
                        objs1 = new Object[]{"\n"};
                        r1.PrintString(MessageFormat.format(StoreParams.res.getString("Discount_Breakdown_n"), objs1));
                        r1.PrintString("\u001b\u0005");
                        sName = null;
                        nQty = 0.0;
                        nValue = 0.0;
                        nTotQty = 0.0;
                        nTotValue = 0.0;
                        sql = new SqlQuery(this.conn, "SELECT R.NAME, SUM(SKU_LINE.QTY), SUM(D.NET) FROM RET_TRAND D, RET_TRANH H, REFCODE R, RET_TRAND SKU_LINE WHERE D.VHIDX = H.VHIDX AND D.LINE_TYPE IN (6, 7) AND H.\"ACTIVE\" = 1 AND D.\"ACTIVE\" = 1 AND D.DISCOUNT_REASIDX = R.RCIDX AND D.FROM_VSHIDX = SKU_LINE.VSHIDX AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum) + " " + "GROUP BY R.NAME ");
                        var46_48 = null;
                        try {
                            while (sql.next()) {
                                sName = sql.getString(1);
                                nQty = sql.getDouble(2);
                                nValue = sql.getDouble(3);
                                if (Gen.RoundNumber(nValue, this.nPrec) != 0.0) {
                                    nValue *= -1.0;
                                }
                                nTotQty += nQty;
                                nTotValue += nValue;
                                r1.PrintString(r1.FormatLeft(sName, 30));
                                sTmp = this.dfQty.format(nQty);
                                r1.PrintString(r1.FormatRight(sTmp, 10));
                                sTmp = this.dfDet.format(nValue);
                                r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                            }
                        }
                        catch (Throwable sqlSub) {
                            var46_48 = sqlSub;
                            throw sqlSub;
                        }
                        finally {
                            if (sql != null) {
                                if (var46_48 != null) {
                                    try {
                                        sql.close();
                                    }
                                    catch (Throwable sqlSub) {
                                        var46_48.addSuppressed(sqlSub);
                                    }
                                } else {
                                    sql.close();
                                }
                            }
                        }
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Total"), 30));
                        sTmp = this.dfQty.format(nTotQty);
                        r1.PrintString(r1.FormatRight(sTmp, 10));
                        sTmp = this.dfDet.format(nTotValue);
                        r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                        r1.Feed(1);
                        r1.PrintString("________________________________________________________\n");
                        r1.PrintString("\u001b\u0007");
                        objs7 = new Object[]{"\n"};
                        r1.PrintString(MessageFormat.format(StoreParams.res.getString("Tender_Breakdown_n"), objs7));
                        r1.PrintString("\u001b\u0005");
                        sName = null;
                        nQty = 0.0;
                        nValue = 0.0;
                        nTotQty = 0.0;
                        nTotValue = 0.0;
                        sql = new SqlQuery(this.conn, "SELECT COALESCE(PT.ALT_CODE, R.NAME), COUNT(DISTINCT(H.VHIDX)), SUM(P.PAYMENT_AMOUNT) FROM RET_TRANH H, RET_TRANP P, REFCODE R LEFT OUTER JOIN RET_PAY_TYPES PT ON R.RCIDX = PT.RCIDX WHERE H.VHIDX = P.VHIDX AND PAYMENT_TYPEIDX = R.RCIDX AND R.RCIDX NOT IN (456,457,642,643,548,647) AND P.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum) + " " + "GROUP BY COALESCE(PT.ALT_CODE, R.NAME) " + "ORDER BY COALESCE(PT.ALT_CODE, R.NAME) ");
                        sqlSub = null;
                        try {
                            while (sql.next()) {
                                sName = sql.getString(1);
                                nQty = sql.getDouble(2);
                                nValue = sql.getDouble(3);
                                nTotQty += nQty;
                                nTotValue += nValue;
                                r1.PrintString(r1.FormatLeft(sName, 30));
                                sTmp = this.dfQty.format(nQty);
                                r1.PrintString(r1.FormatRight(sTmp, 10));
                                sTmp = this.dfDet.format(nValue);
                                r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                            }
                        }
                        catch (Throwable var48_92) {
                            sqlSub = var48_92;
                            throw var48_92;
                        }
                        finally {
                            if (sql != null) {
                                if (sqlSub != null) {
                                    try {
                                        sql.close();
                                    }
                                    catch (Throwable var48_91) {
                                        sqlSub.addSuppressed(var48_91);
                                    }
                                } else {
                                    sql.close();
                                }
                            }
                        }
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Total"), 30));
                        sTmp = this.dfQty.format(nTotQty);
                        r1.PrintString(r1.FormatRight(sTmp, 10));
                        sTmp = this.dfDet.format(nTotValue);
                        r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                        r1.Feed(1);
                        r1.PrintString("\u001b\u0007");
                        objs2 = new Object[]{"\n"};
                        r1.PrintString(MessageFormat.format(StoreParams.res.getString("Credit_Notes_n"), objs2));
                        r1.PrintString("\u001b\u0005");
                        nQty = 0.0;
                        nValue = 0.0;
                        sql = new SqlQuery(this.conn, "SELECT COUNT(P.PAYMENT_TYPEIDX), SUM(P.PAYMENT_AMOUNT) FROM RET_TRANH H, RET_TRANP P, RET_PAY_TYPES T WHERE H.VHIDX = P.VHIDX AND P.PAYMENT_TYPEIDX = T.RCIDX AND T.IS_CREDIT_NOTE = 1 AND P.PAYMENT_AMOUNT < 0 AND P.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum));
                        var48_89 = null;
                        try {
                            if (sql.next()) {
                                nQty = sql.getDouble(1);
                                nValue = sql.getDouble(2);
                            }
                        }
                        catch (Throwable var49_100) {
                            var48_89 = var49_100;
                            throw var49_100;
                        }
                        finally {
                            if (sql != null) {
                                if (var48_89 != null) {
                                    try {
                                        sql.close();
                                    }
                                    catch (Throwable var49_99) {
                                        var48_89.addSuppressed(var49_99);
                                    }
                                } else {
                                    sql.close();
                                }
                            }
                        }
                        if (Gen.RoundNumber(nValue, this.nPrec) != 0.0) {
                            nValue *= -1.0;
                        }
                        nQty = Gen.RoundNumber(nQty, this.nPrec);
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Issued"), 30));
                        sTmp = this.dfQty.format(nQty);
                        r1.PrintString(r1.FormatRight(sTmp, 10));
                        sTmp = this.dfDet.format(nValue);
                        r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                        nQty = 0.0;
                        nValue = 0.0;
                        sql = new SqlQuery(this.conn, "SELECT COUNT(P.PAYMENT_TYPEIDX), SUM(P.PAYMENT_AMOUNT) FROM RET_TRANH H, RET_TRANP P, RET_PAY_TYPES T WHERE H.VHIDX = P.VHIDX AND P.PAYMENT_TYPEIDX = T.RCIDX AND T.IS_CREDIT_NOTE = 1 AND P.PAYMENT_AMOUNT >= 0 AND P.\"ACTIVE\" = 1  AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum));
                        var48_89 = null;
                        try {
                            if (sql.next()) {
                                nQty = sql.getDouble(1);
                                nValue = sql.getDouble(2);
                            }
                        }
                        catch (Throwable var49_102) {
                            var48_89 = var49_102;
                            throw var49_102;
                        }
                        finally {
                            if (sql != null) {
                                if (var48_89 != null) {
                                    try {
                                        sql.close();
                                    }
                                    catch (Throwable var49_101) {
                                        var48_89.addSuppressed(var49_101);
                                    }
                                } else {
                                    sql.close();
                                }
                            }
                        }
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Tendered"), 30));
                        sTmp = this.dfQty.format(nQty);
                        r1.PrintString(r1.FormatRight(sTmp, 10));
                        sTmp = this.dfDet.format(nValue);
                        r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                        r1.Feed(1);
                        r1.PrintString("\u001b\u0007");
                        objs = new Object[]{"\n"};
                        r1.PrintString(MessageFormat.format(StoreParams.res.getString("Gift_Vouchers_n"), objs));
                        r1.PrintString("\u001b\u0005");
                        nQty = 0.0;
                        nValue = 0.0;
                        if (!sGiftSkus.equals("")) {
                            sql = new SqlQuery(this.conn, "SELECT SUM(D.QTY), SUM(D.NET) FROM RET_TRAND D, RET_TRANH H WHERE D.VHIDX = H.VHIDX AND D.LINE_TYPE in (0,2) AND H.\"ACTIVE\" = 1 AND D.\"ACTIVE\" = 1 AND D.SKUIDX IN(" + sGiftSkus + ") AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum));
                            var49_93 = null;
                            try {
                                if (!sql.next()) ** GOTO lbl1031
                                nQty = sql.getDouble(1);
                                nValue = sql.getDouble(2);
                            }
                            catch (Throwable var50_106) {
                                var49_93 = var50_106;
                                throw var50_106;
                            }
                            finally {
                                if (sql != null) {
                                    if (var49_93 != null) {
                                        try {
                                            sql.close();
                                        }
                                        catch (Throwable var50_105) {
                                            var49_93.addSuppressed(var50_105);
                                        }
                                    } else {
                                        sql.close();
                                    }
                                }
                            }
                        } else {
                            nQty = 0.0;
                            nValue = 0.0;
                        }
lbl1031:
                        // 3 sources

                        nQty = Gen.RoundNumber(nQty, this.nPrec);
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Issued"), 30));
                        sTmp = this.dfQty.format(nQty);
                        r1.PrintString(r1.FormatRight(sTmp, 10));
                        sTmp = this.dfDet.format(nValue);
                        r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                        nQty = 0.0;
                        nValue = 0.0;
                        sql = new SqlQuery(this.conn, "SELECT COUNT(P.PAYMENT_TYPEIDX), SUM(P.PAYMENT_AMOUNT) FROM RET_TRANH H, RET_TRANP P, RET_PAY_TYPES T WHERE H.VHIDX = P.VHIDX AND P.PAYMENT_TYPEIDX = T.RCIDX AND T.IS_VOUCHER = 1 AND P.PAYMENT_AMOUNT >= 0 AND P.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum));
                        var49_93 = null;
                        try {
                            if (sql.next()) {
                                nQty = sql.getDouble(1);
                                nValue = sql.getDouble(2);
                            }
                        }
                        catch (Throwable var50_108) {
                            var49_93 = var50_108;
                            throw var50_108;
                        }
                        finally {
                            if (sql != null) {
                                if (var49_93 != null) {
                                    try {
                                        sql.close();
                                    }
                                    catch (Throwable var50_107) {
                                        var49_93.addSuppressed(var50_107);
                                    }
                                } else {
                                    sql.close();
                                }
                            }
                        }
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Tendered"), 30));
                        sTmp = this.dfQty.format(nQty);
                        r1.PrintString(r1.FormatRight(sTmp, 10));
                        sTmp = this.dfDet.format(nValue);
                        r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                        r1.Feed(1);
                        r1.PrintString("\u001b\u0007");
                        objs3 = new Object[]{"\n"};
                        r1.PrintString(MessageFormat.format(StoreParams.res.getString("Expenses_n"), objs3));
                        r1.PrintString("\u001b\u0005");
                        sName = null;
                        nQty = 0.0;
                        nValue = 0.0;
                        nTotQty = 0.0;
                        nTotValue = 0.0;
                        sql = new SqlQuery(this.conn, "SELECT R.NAME, COUNT(D.VSHIDX), SUM(D.NET) FROM RET_TRAND D, RET_TRANH H, REFCODE R WHERE D.VHIDX = H.VHIDX AND H.TR_TYPE = 547 AND D.\"ACTIVE\" = 1 AND D.LINE_CODE = CAST(R.RCIDX AS VARCHAR(50)) AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum) + " " + "GROUP BY R.NAME ");
                        var50_103 = null;
                        try {
                            while (sql.next()) {
                                sName = sql.getString(1);
                                nQty = sql.getDouble(2);
                                nValue = sql.getDouble(3);
                                nTotQty += nQty;
                                nTotValue += nValue;
                                r1.PrintString(r1.FormatLeft(sName, 30));
                                sTmp = this.dfQty.format(nQty);
                                r1.PrintString(r1.FormatRight(sTmp, 10));
                                sTmp = this.dfDet.format(nValue);
                                r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                            }
                        }
                        catch (Throwable var51_112) {
                            var50_103 = var51_112;
                            throw var51_112;
                        }
                        finally {
                            if (sql != null) {
                                if (var50_103 != null) {
                                    try {
                                        sql.close();
                                    }
                                    catch (Throwable var51_111) {
                                        var50_103.addSuppressed(var51_111);
                                    }
                                } else {
                                    sql.close();
                                }
                            }
                        }
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Total_Expenses"), 30));
                        sTmp = this.dfQty.format(nTotQty);
                        r1.PrintString(r1.FormatRight(sTmp, 10));
                        sTmp = this.dfDet.format(nTotValue);
                        r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                        nQty = 0.0;
                        nValue = 0.0;
                        sql = new SqlQuery(this.conn, "SELECT COUNT(P.VSHIDX), SUM(P.PAYMENT_AMOUNT) FROM RET_TRANP P, RET_TRANH H WHERE P.VHIDX = H.VHIDX AND H.TR_TYPE = 546 AND P.PAYMENT_TYPEIDX != 548 AND P.\"ACTIVE\" = 1 AND H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum));
                        var50_103 = null;
                        try {
                            if (sql.next()) {
                                nQty = sql.getDouble(1);
                                nValue = sql.getDouble(2);
                            }
                        }
                        catch (Throwable var51_114) {
                            var50_103 = var51_114;
                            throw var51_114;
                        }
                        finally {
                            if (sql != null) {
                                if (var50_103 != null) {
                                    try {
                                        sql.close();
                                    }
                                    catch (Throwable var51_113) {
                                        var50_103.addSuppressed(var51_113);
                                    }
                                } else {
                                    sql.close();
                                }
                            }
                        }
                        if (nValue != 0.0) {
                            nValue = 0.0 - nValue;
                        }
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Total_Withdrawals"), 30));
                        sTmp = this.dfQty.format(nQty);
                        r1.PrintString(r1.FormatRight(sTmp, 10));
                        sTmp = this.dfDet.format(nValue);
                        r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                        r1.Feed(1);
                        r1.PrintString("________________________________________________________\n");
                        r1.PrintString("\u001b\u0007");
                        objs4 = new Object[]{"\n"};
                        r1.PrintString(MessageFormat.format(StoreParams.res.getString("Tender_Balances_n"), objs4));
                        r1.PrintString("\u001b\u0005");
                        sTypeIdx = null;
                        sTendType = null;
                        nBalance = 0.0;
                        nBanked = 0.0;
                        nTransactions = 0.0;
                        nFloat = 0.0;
                        nLastFloat = 0.0;
                        nVariance = 0.0;
                        sLastUpdt = null;
                        sql = new SqlQuery(this.conn, "SELECT R.RCIDX, COALESCE(PT.ALT_CODE, R.NAME), T.LAST_UPDT, T.LAST_FLOAT, T.UPDT, T.FLOATAMT, T.BANKED, T.VARIANCE, T.BALANCE FROM TILL_BALANCES T, REFCODE R LEFT OUTER JOIN RET_PAY_TYPES PT ON R.RCIDX = PT.RCIDX WHERE T.TYPEIDX = R.RCIDX AND T.DOCKET_NUMBER = '" + this.docknum + "' " + "ORDER BY T.TBIDX");
                        var66_131 = null;
                        try {
                            while (sql.next()) {
                                sTypeIdx = sql.getString(1);
                                sTendType = sql.getString(2);
                                nBalance = sql.getDouble(9);
                                nBanked = sql.getDouble(7);
                                nLastFloat = sql.getDouble(4);
                                nFloat = sql.getDouble(6);
                                nVariance = sql.getDouble(8);
                                sqlSub = new SqlQuery(this.conn, "SELECT SUM(P.PAYMENT_AMOUNT) FROM RET_TRANH H, RET_TRANP P WHERE H.VHIDX = P.VHIDX AND P.\"ACTIVE\" = 1 AND P.PAYMENT_TYPEIDX = " + sTypeIdx + " AND " + "H.EOD_DOCKET = " + PosUtils.StringToSqlString(this.docknum));
                                var68_137 = null;
                                try {
                                    nTransactions = sqlSub.next() ? sqlSub.getDouble(1) : 0.0;
                                }
                                catch (Throwable var69_141) {
                                    var68_137 = var69_141;
                                    throw var69_141;
                                }
                                finally {
                                    if (sqlSub != null) {
                                        if (var68_137 != null) {
                                            try {
                                                sqlSub.close();
                                            }
                                            catch (Throwable var69_139) {
                                                var68_137.addSuppressed(var69_139);
                                            }
                                        } else {
                                            sqlSub.close();
                                        }
                                    }
                                }
                                if (nBanked == 0.0 && nTransactions == 0.0 && nFloat == 0.0 && nVariance == 0.0 && nBalance == 0.0 && nLastFloat == 0.0) continue;
                                r1.PrintString(sTendType + "\n");
                                if (sTypeIdx.equals("" + SP.getCashPayType())) {
                                    sLastUpdt = sLastUpdt == null ? StoreParams.res.getString("Initial_Float") : StoreParams.res.getString("Original_Float") + " " + sLastUpdt;
                                    r1.PrintString(r1.FormatLeft(sLastUpdt, 40));
                                    sTmp = this.dfDet.format(nLastFloat);
                                    r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                                }
                                r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Transactions"), 40));
                                sTmp = this.dfDet.format(nTransactions);
                                r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                                if (sTypeIdx.equals("" + SP.getCashPayType())) {
                                    r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Total_Day"), 40));
                                    sTmp = this.dfDet.format(nLastFloat + nTransactions);
                                    r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                                }
                                r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Counted"), 40));
                                sTmp = this.dfDet.format(nBalance);
                                r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                                r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Variance"), 40));
                                sTmp = this.dfDet.format(nVariance);
                                r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                                if (sTypeIdx.equals("" + SP.getCashPayType())) {
                                    r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Banked"), 40));
                                    sTmp = this.dfDet.format(nBanked);
                                    r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                                    r1.PrintString(r1.FormatLeft(StoreParams.res.getString("New_Float"), 40));
                                    sTmp = this.dfDet.format(nFloat);
                                    r1.PrintString(r1.FormatRight(sTmp, 16) + "\n");
                                }
                                r1.Feed(1);
                            }
                        }
                        catch (Throwable var67_136) {
                            var66_131 = var67_136;
                            throw var67_136;
                        }
                        finally {
                            if (sql != null) {
                                if (var66_131 != null) {
                                    try {
                                        sql.close();
                                    }
                                    catch (Throwable var67_135) {
                                        var66_131.addSuppressed(var67_135);
                                    }
                                } else {
                                    sql.close();
                                }
                            }
                        }
                        if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.PROMPT_FOR_BANK_BAG_NUMBER) && sBankBagNumber != null && !sBankBagNumber.isEmpty()) {
                            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Bank_Bag_Number"), 26));
                            r1.PrintString(r1.FormatRight(sBankBagNumber, 30) + "\n");
                            r1.Feed(1);
                        }
                        r1.PrintString("\u001b\u0006");
                        r1.PrintString(r1.FormatCentre("END OF REPORT", 42));
                        r1.PrintString("\u001b\u0005");
                    }
                    catch (Exception s) {
                        PosUtils.logError(s);
                    }
                    r1.FeedAndCut();
                }
                catch (Throwable var4_8) {
                    var3_4 = var4_8;
                    throw var4_8;
                }
                finally {
                    if (r1 != null) {
                        if (var3_4 != null) {
                            try {
                                r1.close();
                            }
                            catch (Throwable var4_7) {
                                var3_4.addSuppressed(var4_7);
                            }
                        } else {
                            r1.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                this.errorHandler.setError(e);
            }
            Gen.PrintImage(this.sPrinterPort, this.sImagePath);
            ++i;
        }
        return true;
    }

    private String getExcludedSkuFilter() {
        ArrayList<String> skus = new ArrayList<String>();
        if (SP.sParams.lbCancFeeSku != 0L) {
            skus.add(String.valueOf(SP.sParams.lbCancFeeSku));
        }
        if (SP.sParams.lbAdminFeeSku != 0L) {
            skus.add(String.valueOf(SP.sParams.lbAdminFeeSku));
        }
        if (SP.sParams.specOrdCancFeeSku != 0L) {
            skus.add(String.valueOf(SP.sParams.specOrdCancFeeSku));
        }
        if (SP.sParams.specOrdAdminFeeSku != 0L) {
            skus.add(String.valueOf(SP.sParams.specOrdAdminFeeSku));
        }
        skus.addAll(SP.sParams.gvSkus);
        return skus.size() > 0 ? " AND COALESCE(D.SKUIDX, 0) NOT IN (" + String.join((CharSequence)",", skus) + ") " : " ";
    }
}

