/*
 * Decompiled with CFR 0.152.
 */
package ReceiptPrinter;

import java.sql.Connection;
import java.sql.ResultSetMetaData;
import jpos.PosUtils;
import jpos.SqlQuery;

public class Warehouse {
    private String[] saColName;
    private String[] saColVal;
    private String[] saColType;
    private int nColCount = 0;
    private long nWIdx = 0L;

    public Warehouse(long nWIdx) {
        this.nWIdx = nWIdx;
    }

    public void loadWarehouse(Connection conn) {
        try (SqlQuery sql = new SqlQuery(conn, "SELECT L.LOCNIDX as \"locnidx\", L.TRADENAME as \"tradename\", L.ADRS1 as \"adrs1\", L.ADRS2 as \"adrs2\", L.CITY as \"city\", L.STATE as \"state\", L.POSTCODE as \"postcode\", L.ABN as \"abn\", R.CODE as \"storecode\", R.NAME as \"storename\", COALESCE(W.STORENO, '') as \"storeno\" FROM REFCODE R LEFT JOIN LOCN L ON R.LINKIDX = L.LOCNIDX, WHSE W WHERE R.RGIDX = 7 AND R.RCIDX = " + this.nWIdx + " AND R.RCIDX = W.WIDX ");){
            ResultSetMetaData rsmd = sql.getMetaData();
            this.nColCount = rsmd.getColumnCount();
            this.saColName = new String[this.nColCount];
            this.saColVal = new String[this.nColCount];
            this.saColType = new String[this.nColCount];
            for (int index = 0; index < this.nColCount; ++index) {
                this.saColName[index] = rsmd.getColumnLabel(index + 1);
                this.saColType[index] = rsmd.getColumnTypeName(index + 1);
            }
            if (sql.next()) {
                for (int col = 1; col <= this.nColCount; ++col) {
                    this.saColVal[col - 1] = sql.getString(col);
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public String getString(String sVarName) {
        int nIndex = -1;
        for (int i = 0; i < this.nColCount; ++i) {
            if (this.saColName[i] == null || !this.saColName[i].equals(sVarName)) continue;
            nIndex = i;
            break;
        }
        if (nIndex > -1) {
            return this.saColVal[nIndex];
        }
        return null;
    }
}

