/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Color;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import jpos.ClrSizeTableModel;
import jpos.NoteType;
import jpos.PosDialog;
import jpos.PosFrame;
import jpos.PosTable;
import jpos.PosUtils;
import jpos.Sku;
import jpos.StoreParams;
import jpos.ui.Colours;

public class ClrSizeTable
extends PosTable {
    ClrSizeTableModel model;
    DefaultCellEditor discEd;
    DefaultCellEditor sizeEd;
    PosFrame frParent;
    Vector<NoteType> styleNoteTypes = new Vector();

    public ClrSizeTable(PosFrame pFrame, boolean showPrice) {
        super(pFrame, null);
        this.frParent = (PosFrame)this.getParentWindow();
        try {
            this.jbInit(showPrice);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public ClrSizeTable(PosDialog pDlg, boolean showPrice) {
        super(pDlg, null);
        this.frParent = ((PosDialog)this.getParentWindow()).frParent;
        try {
            this.jbInit(showPrice);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit(boolean showPrice) throws Exception {
        NoteType.readNoteTypes(this.styleNoteTypes, 99L, 0L, this.sParams);
        this.model = new ClrSizeTableModel(this.frParent.frameType, showPrice, this.sParams);
        this.setModel(this.model);
        this.setAutoResizeMode(0);
        this.columnModel.getColumn(0).setMinWidth(60);
        this.columnModel.getColumn(1).setMinWidth(60);
        this.columnModel.getColumn(2).setMinWidth(180);
        if (showPrice) {
            this.renderer.setColumnFormat(3, this.sParams.currFormat, 4);
        }
        for (int i = this.model.numDescripCols; i < this.getColumnCount(); ++i) {
            this.columnModel.getColumn(i).setMinWidth(15);
            this.columnModel.getColumn(i).setMaxWidth(100);
            this.renderer.setColumnFormat(i, StoreParams.qtyFormat, 0);
        }
        this.getTableHeader().getColumnModel().getColumn(0).setHeaderRenderer(this.headerLeftRen);
        this.getTableHeader().getColumnModel().getColumn(1).setHeaderRenderer(this.headerLeftRen);
        this.getTableHeader().getColumnModel().getColumn(2).setHeaderRenderer(this.headerLeftRen);
        if (showPrice) {
            this.getTableHeader().getColumnModel().getColumn(3).setHeaderRenderer(this.headerRightRen);
        }
        this.setDefaultEditor(Object.class, this.qtyEd);
    }

    public int add_EAN(String EAN, boolean consolidateOnly) {
        double qty = 1.0;
        if (EAN.indexOf(",") != -1) {
            qty = PosUtils.doubleValFormatted(EAN.substring(EAN.indexOf(",") + 1));
            EAN = EAN.substring(0, EAN.indexOf(","));
        }
        if (qty == 0.0) {
            return -1;
        }
        int linenum = this.model.add_EAN(EAN, qty, consolidateOnly);
        return linenum;
    }

    public boolean isEditable() {
        return this.model.isEditable();
    }

    public int add_sku(long sku, double qty, boolean oldLine) {
        int linenum = this.model.add_sku(sku, qty, oldLine);
        return linenum;
    }

    public Sku getSku(long skuidx) {
        return this.model.getSku(skuidx);
    }

    public void setPopulateMethod(int type) {
        this.model.setPopulateMethod(type);
    }

    public double getQty() {
        return this.model.getTotQty();
    }

    public double getQty(int row) {
        return this.model.getQty(row);
    }

    public Object getItemAt(int row) {
        return this.model.getItemAt(row);
    }

    @Override
    public Color getDisplayForegroundAt(Object value, int row, int column) {
        if (this.model.sizeHeadings) {
            return Colours.BLUE;
        }
        return this.renderer.defaultColour;
    }

    public void hideUnusedCoulmns() {
        int i;
        int largest = 0;
        for (i = 0; i < this.model.styles.size(); ++i) {
            if (this.model.styles.elementAt((int)i).sizes.size() <= largest) continue;
            largest = this.model.styles.elementAt((int)i).sizes.size();
        }
        for (i = this.model.numDescripCols; i < this.getColumnCount(); ++i) {
            if (i + 1 > this.model.numDescripCols + largest) {
                this.columnModel.getColumn(i).setMinWidth(0);
                this.columnModel.getColumn(i).setMaxWidth(0);
                continue;
            }
            this.columnModel.getColumn(i).setMinWidth(15);
            this.columnModel.getColumn(i).setMaxWidth(100);
        }
    }
}

