/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JPanel;
import jpos.DlgMessage;
import jpos.PosDialog;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.ui.Colours;
import jpos.ui.Fonts;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;
import org.jdom.Element;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class DlgBudget
extends PosDialog {
    private int DEFAULT_WIDTH = 720;
    private int DEFAULT_HEIGHT = 540;
    private DecimalFormat dfDet;
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private GridBagLayout gridBagLayoutHeading = new GridBagLayout();
    private JPanel panel = new JPanel();
    private JPanel panelHeading = new JPanel();
    private ChartPanel panelToday;
    private ChartPanel panelWTD;
    private ChartPanel panelAvgSales;
    private DefaultCategoryDataset dataToday;
    private DefaultCategoryDataset dataWTD;
    private DefaultCategoryDataset dataAvgSales;
    private JFreeChart chartToday;
    private JFreeChart chartWTD;
    private JFreeChart chartAvgSales;
    private LabelSubHeading labelHeading;
    private LabelNormal labelTax;
    private String series1;
    private String series2;
    private String series3;

    public DlgBudget(PosFrame frParent, String title, boolean modal) {
        super(frParent, title, modal);
        try {
            this.frParent = frParent;
            this.jbInit();
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    private void jbInit() throws Exception {
        this.series1 = SP.getRS("Store");
        this.series2 = SP.getRS("Budget");
        this.series3 = SP.getRS("Web");
        StringBuffer sDet = new StringBuffer();
        this.dfDet = new DecimalFormat(sDet.toString());
        this.panel.setMinimumSize(new Dimension(this.DEFAULT_WIDTH, this.DEFAULT_HEIGHT));
        this.panel.setPreferredSize(new Dimension(this.DEFAULT_WIDTH, this.DEFAULT_HEIGHT));
        this.panel.setLayout(this.gridBagLayout);
        this.panelHeading.setLayout(this.gridBagLayoutHeading);
        this.labelHeading = new LabelSubHeading(SP.getRS("Budget"));
        this.labelHeading.setHorizontalAlignment(0);
        this.labelTax = new LabelNormal();
        this.labelTax.setHorizontalAlignment(0);
        this.dataToday = new DefaultCategoryDataset();
        this.dataWTD = new DefaultCategoryDataset();
        this.dataAvgSales = new DefaultCategoryDataset();
        this.dataToday.addValue(0.0, (Comparable)((Object)this.series1), (Comparable)((Object)""));
        this.dataToday.addValue(0.0, (Comparable)((Object)this.series3), (Comparable)((Object)""));
        this.dataToday.addValue(0.0, (Comparable)((Object)this.series2), (Comparable)((Object)""));
        this.dataWTD.addValue(0.0, (Comparable)((Object)this.series1), (Comparable)((Object)""));
        this.dataWTD.addValue(0.0, (Comparable)((Object)this.series3), (Comparable)((Object)""));
        this.dataWTD.addValue(0.0, (Comparable)((Object)this.series2), (Comparable)((Object)""));
        this.dataAvgSales.addValue(0.0, (Comparable)((Object)this.series1), (Comparable)((Object)""));
        this.dataAvgSales.addValue(0.0, (Comparable)((Object)this.series3), (Comparable)((Object)""));
        this.dataAvgSales.addValue(0.0, (Comparable)((Object)this.series2), (Comparable)((Object)""));
        this.chartToday = ChartFactory.createStackedBarChart((String)"", (String)SP.getRS("Today"), (String)"", (CategoryDataset)this.dataToday, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
        this.chartWTD = ChartFactory.createStackedBarChart((String)"", (String)(SP.sParams.nPlanningPeriodLevel == 0L ? SP.getRS("WTD") : SP.getRS("MTD")), (String)"", (CategoryDataset)this.dataWTD, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
        this.chartAvgSales = ChartFactory.createStackedBarChart((String)"", (String)SP.getRS("Avg_Units_per_Sale"), (String)"", (CategoryDataset)this.dataAvgSales, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)false, (boolean)false);
        this.formatChart(this.chartToday);
        this.formatChart(this.chartWTD);
        this.formatChart(this.chartAvgSales);
        this.panelToday = new ChartPanel(this.chartToday);
        this.panelWTD = new ChartPanel(this.chartWTD);
        this.panelAvgSales = new ChartPanel(this.chartAvgSales);
        this.getContentPane().add(this.panel);
        this.panelHeading.add((Component)this.labelHeading, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelHeading.add((Component)this.labelTax, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.panelHeading, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, 1));
        this.panel.add((Component)this.panelToday, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 1));
        this.panel.add((Component)this.panelWTD, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 1));
        this.panel.add((Component)this.panelAvgSales, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 1));
        this.pack();
        PosUtils.centreWindow(this);
    }

    public boolean populateBudget() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Element storeBudget = this.sParams.OnlineQueryProvider.getOnlineQuery("storebudget", "" + this.sParams.getStoreIdx() + "," + dateFormat.format(new Date())).getXML();
            if (storeBudget == null || storeBudget.getAttribute("totBudget").getDoubleValue() == 0.0) {
                DlgMessage.showMessage(this, StoreParams.res.getString("no_current_budget"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
            if (!storeBudget.getAttribute("viewExists").getBooleanValue()) {
                DlgMessage.showMessage(this, StoreParams.res.getString("no_budget_view_exists"), StoreParams.res.getString("Stop"), 2);
                return false;
            }
            double nTodaysActual = storeBudget.getAttribute("todaysActual").getDoubleValue();
            double nTodaysBudget = storeBudget.getAttribute("todaysBudget").getDoubleValue();
            double nTodaysActualWeb = storeBudget.getAttribute("todaysActualWeb").getDoubleValue();
            double nActualToDate = storeBudget.getAttribute("actualToDate").getDoubleValue();
            double nBudgetToDate = storeBudget.getAttribute("budgetToDate").getDoubleValue();
            double nActualToDateWeb = storeBudget.getAttribute("actualToDateWeb").getDoubleValue();
            double nAvgSaleActual = storeBudget.getAttribute("avgSaleActual").getDoubleValue();
            double nAvgSaleBudget = storeBudget.getAttribute("avgSaleBudget").getDoubleValue();
            double nTotBudget = storeBudget.getAttribute("totBudget").getDoubleValue();
            this.labelTax.setText(storeBudget.getAttribute("excludes_tax").getBooleanValue() ? SP.getRS("excluding_tax") : SP.getRS("including_tax"));
            Object[] objs = new Object[]{this.dfDet.format(PosUtils.scale(nTotBudget, 0))};
            this.labelHeading.setText(SP.sParams.nPlanningPeriodLevel == 0L ? MessageFormat.format(SP.getRS("This_Weeks_Budget_"), objs) : MessageFormat.format(SP.getRS("This_Months_Budget_"), objs));
            this.fillDataset(this.dataToday, PosUtils.scale(nTodaysActual, 0), PosUtils.scale(nTodaysBudget, 0), PosUtils.scale(nTodaysActualWeb, 0));
            this.fillDataset(this.dataWTD, PosUtils.scale(nActualToDate, 0), PosUtils.scale(nBudgetToDate, 0), PosUtils.scale(nActualToDateWeb, 0));
            this.fillDataset(this.dataAvgSales, PosUtils.scale(nAvgSaleActual, SP.sParams.storeCurrency.getPrecision()), PosUtils.scale(nAvgSaleBudget, SP.sParams.storeCurrency.getPrecision()), PosUtils.scale(0.0, SP.sParams.storeCurrency.getPrecision()));
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        return true;
    }

    private void fillDataset(DefaultCategoryDataset dataset, double series1Val, double series2Val) {
        dataset.setValue(series1Val, (Comparable)((Object)this.series1), (Comparable)((Object)""));
        dataset.setValue(series2Val, (Comparable)((Object)this.series2), (Comparable)((Object)" "));
    }

    private void fillDataset(DefaultCategoryDataset dataset, double series1Val, double series2Val, double series3Val) {
        this.fillDataset(dataset, series1Val, series2Val);
        dataset.setValue(series3Val, (Comparable)((Object)this.series3), (Comparable)((Object)""));
    }

    private void formatChart(JFreeChart chart) {
        chart.setBackgroundPaint((Paint)this.getBackground());
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Colours.WHITE);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(true);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperMargin(0.15);
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setDrawBarOutline(false);
        renderer.setSeriesPaint(0, (Paint)Colours.CHART_BLUE);
        renderer.setSeriesPaint(1, (Paint)Colours.CHART_GREEN);
        renderer.setSeriesPaint(2, (Paint)Colours.CHART_LIGHT_GREY);
        renderer.setBaseItemLabelsVisible(true);
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        renderer.setMaximumBarWidth(0.3);
        renderer.setBaseItemLabelFont(Fonts.BoldText);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.5235987755982988));
    }

    @Override
    public void cancelDialog() {
        this.dispose();
    }

    @Override
    public void okDialog() {
        this.dispose();
    }

    @Override
    public boolean myKeyPressed(KeyEvent e) {
        return false;
    }
}

