/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import jpos.DlgMessage;
import jpos.PosDialog;
import jpos.PosDouble;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosScrollPane;
import jpos.PosTable;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.XMLUtils;
import jpos.ui.Colours;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;
import jpos.weborder.Product;
import jpos.weborder.SplitTransaction;
import jpos.weborder.SplitTransactions;
import jpos.weborder.WebOrderStatus;
import org.jdom.Element;

public class DlgSplitOrderList
extends PosDialog {
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private PosScrollPane scrollPane = new PosScrollPane();
    private DialogButton bOK = new DialogButton("");
    private DialogButton bCancel = new DialogButton("");
    private LabelSubHeading labelMessage = new LabelSubHeading();
    private PosTable tblSplitOrders;
    private SplitOrdersModel tableModel;
    private Element splitOrdersXml;
    private String parentOrderNum;
    private StringBuffer wstIdx;

    public DlgSplitOrderList(PosFrame frame, Element splitOrdersXml, String orderNum, StringBuffer wstIdx) {
        super(frame, StoreParams.res.getString("Customer_Order"), true);
        this.splitOrdersXml = splitOrdersXml;
        this.parentOrderNum = orderNum;
        this.wstIdx = wstIdx;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    void jbInit() throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout);
        this.tableModel = new SplitOrdersModel(this.splitOrdersXml);
        this.tblSplitOrders = new PosTable(this, this.tableModel);
        this.tblSplitOrders.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.tblSplitOrders.getColumnModel().getColumn(0).setMinWidth(100);
        this.tblSplitOrders.getColumnModel().getColumn(0).setMaxWidth(200);
        this.tblSplitOrders.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.tblSplitOrders.getColumnModel().getColumn(1).setMinWidth(150);
        this.tblSplitOrders.getColumnModel().getColumn(1).setMaxWidth(200);
        this.tblSplitOrders.getColumnModel().getColumn(2).setPreferredWidth(700);
        this.tblSplitOrders.getColumnModel().getColumn(2).setMinWidth(700);
        this.tblSplitOrders.getColumnModel().getColumn(2).setMaxWidth(800);
        this.tblSplitOrders.getColumnModel().getColumn(2).setResizable(true);
        this.tblSplitOrders.updateRowHeightsToFitText();
        this.tblSplitOrders.getSelectionModel().setSelectionMode(0);
        this.tblSplitOrders.selectFirstRow();
        if (this.tblSplitOrders.getModel().getRowCount() == 1) {
            this.labelMessage.setText(StoreParams.res.getString("Select_single_tran_for_refund"));
        } else {
            this.labelMessage.setText(String.format("<html>%s</html>", SP.getRS("Select_from_multiple_tran_for_refund", this.parentOrderNum)));
        }
        this.bOK.setText(StoreParams.res.getString("Load_Order"));
        this.bOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSplitOrderList.this.okDialog();
            }
        });
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSplitOrderList.this.cancelDialog();
            }
        });
        this.tblSplitOrders.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    DlgSplitOrderList.this.okDialog();
                }
            }
        });
        this.scrollPane.setMinimumSize(new Dimension(800, 300));
        this.scrollPane.setPreferredSize(new Dimension(800, 400));
        this.getContentPane().add((Component)this.labelMessage, new GridBagConstraints(0, 0, 0, 1, 2.0, 1.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.getContentPane().add((Component)this.scrollPane, new GridBagConstraints(0, 1, 0, 1, 2.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.bOK, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.bCancel, new GridBagConstraints(2, 2, 1, 1, 0.5, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.scrollPane.getViewport().add((Component)this.tblSplitOrders, null);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.tblSplitOrders);
        v.add(this.bOK);
        v.add(this.bCancel);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        PosUtils.centreWindow(this);
    }

    @Override
    public void okDialog() {
        SplitTransaction tran = this.tableModel.data.get(this.tblSplitOrders.getSelectionModel().getMinSelectionIndex());
        boolean canRefund = false;
        for (Product product : tran.getProducts()) {
            if (product.getStatusNumber() != WebOrderStatus.Imported && product.getStatusNumber() != WebOrderStatus.ImportedOnHold || !(product.getQty() > product.getPackedQty() + product.getDespatchedQty()) || product.getPickRun() != null && !product.getPickRun().isEmpty()) continue;
            canRefund = true;
            break;
        }
        if (canRefund) {
            this.wstIdx.append(String.valueOf(this.tableModel.data.get(this.tblSplitOrders.getSelectionModel().getMinSelectionIndex()).getWstIdx()));
            this.dispose();
        } else {
            DlgMessage.showMessage(this, StoreParams.res.getString("cannot_refund_transaction"));
        }
    }

    @Override
    public void cancelDialog() {
        this.dispose();
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    public String getDetailsAsHtml(SplitTransaction tran) {
        StringBuilder html = new StringBuilder("<html>");
        String rgbBlue = String.format("rgb(%s,%s,%s)", Colours.BLUE.getRed(), Colours.BLUE.getGreen(), Colours.BLUE.getBlue());
        String template = SP.getRS("Split_Order_Detail_Html_Template");
        for (Product prod : tran.getProducts()) {
            html.append(MessageFormat.format(template, prod.getStyleClrSizeDisplay(), rgbBlue, PosDouble.valueOf(prod.getPrice()).toString(), PosDouble.valueOf(prod.getQty(), 0).toString(), prod.getStatus()));
        }
        html.append("</html>");
        return html.toString();
    }

    private class SplitOrdersModel
    extends AbstractTableModel {
        private static final int ORDER_COLUMN = 0;
        private static final int STORE_COLUMN = 1;
        private static final int DETAILS_COLUMN = 2;
        private String orderColumnName = SP.getRS("Order");
        private String storeName = SP.getRS("Store_Name");
        private String detailsColumnName = SP.getRS("Product");
        private static final int COL_COUNT = 3;
        List<SplitTransaction> data;

        public SplitOrdersModel(Element splitOrdersXml) throws Exception {
            String temp = XMLUtils.toString(splitOrdersXml);
            SplitTransactions splitTrans = SplitTransactions.createTransactionsFromXmlString(temp);
            this.data = splitTrans.getSplitTransactions();
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= this.data.size() || row < 0) {
                return "";
            }
            switch (col) {
                case 0: {
                    return this.data.get(row).getOrderNumber();
                }
                case 1: {
                    return this.data.get(row).getStore();
                }
                case 2: {
                    return DlgSplitOrderList.this.getDetailsAsHtml(this.data.get(row));
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return this.orderColumnName;
                }
                case 1: {
                    return this.storeName;
                }
                case 2: {
                    return this.detailsColumnName;
                }
            }
            return "";
        }
    }
}

