/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import ReceiptPrinter.Receipt;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import jpos.DlgMessage;
import jpos.DlgReason;
import jpos.Note;
import jpos.PaTransferFoot;
import jpos.PaTransferOut;
import jpos.PosFrame;
import jpos.PosMenuController;
import jpos.PosUtils;
import jpos.SP;
import jpos.SkuReservation;
import jpos.SqlQuery;
import jpos.Store;
import jpos.StoreParams;
import jpos.StyleLine;
import jpos.StyleTable;
import jpos.SystemSettings;
import jpos.XMLUtils;
import jpos.basscom.utils.Utils;
import org.jdom.Element;

public class FrTransferOut
extends PosFrame {
    private boolean completing = false;
    boolean forceScan = false;
    protected Element transRoot = null;
    long despatchWidx = 0L;
    long tr_vhidx = -1L;
    String tr_number = "";
    boolean canCancel = false;
    StringBuffer carrier = new StringBuffer("-1");
    StringBuffer delins = new StringBuffer();
    Vector<SkuReservation> reservations = new Vector();
    private boolean canUpdateTransferConnote = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.UPDATE_TRANSFER_CONNOTE);

    public FrTransferOut(PosMenuController pmenu, StoreParams psParams) {
        super(pmenu, null, 2, 11103L, psParams, StoreParams.res.getString("Transfer_Out"));
        this.forceScan = psParams.isForceScanInTransferOut();
        this.paBody = new PaTransferOut(this);
        this.contentPane.add((Component)this.paBody, "Center");
        this.paFoot = new PaTransferFoot(this);
        this.contentPane.add((Component)this.paFoot, "South");
        this.voidTrans(false);
    }

    @Override
    public void setFocus() {
        if (this.isLoggedIn(false)) {
            ((PaTransferOut)this.paBody).tfBarcode.requestFocus();
            this.setButtons();
        }
    }

    @Override
    protected void setTransType() {
        this.setTransType(-1);
    }

    @Override
    public void setTransType(int type) {
        if (type == -1) {
            if (this.paFoot != null) {
                ((PaTransferFoot)this.paFoot).bDirect.setEnabled(true);
                ((PaTransferFoot)this.paFoot).bTrReq.setEnabled(true);
            }
            this.transType = 249;
            return;
        }
        this.transType = type;
        if (this.paBody != null) {
            ((PaTransferOut)this.paBody).setToField(this.transType);
            if (this.transType == 252) {
                ((PaTransferOut)this.paBody).tfPurNum.setVisible(true);
                ((PaTransferOut)this.paBody).lPurNum.setText(StoreParams.res.getString("Order_"));
                ((PaTransferOut)this.paBody).tfPurNum.requestFocus();
                ((PaTransferOut)this.paBody).lFeedBack.setText(StoreParams.res.getString("Direct_Stock_Return"));
            }
            ((PaTransferFoot)this.paFoot).bDirect.setEnabled(false);
            ((PaTransferFoot)this.paFoot).bTrReq.setEnabled(false);
        }
    }

    @Override
    public boolean validateTrans() {
        PaTransferOut body = (PaTransferOut)this.paBody;
        if (body.tblStyles.isEditing()) {
            body.tblStyles.getCellEditor().stopCellEditing();
        }
        if (!((PaTransferFoot)this.paFoot).bComplete.isEnabled()) {
            return false;
        }
        if (body.tblStyles.getQty() <= 0.0) {
            return false;
        }
        if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.TRANS_OUT_CONNOTE_MANDATORY) && body.tfConnote.getText().trim().length() < 1) {
            DlgMessage.showMessage(this, StoreParams.res.getString("Con_note_to_be_mandatory"), StoreParams.res.getString("Stop"), 1);
            body.tfConnote.requestFocus();
            return false;
        }
        if (this.transType == 252) {
            if (body.tfSupplier.getText().length() == 0 || body.tfSupplier.getidx() <= 0L) {
                DlgMessage.showMessage(this, StoreParams.res.getString("You_must_enter_a6"), StoreParams.res.getString("Stop"), 1);
                body.tfSupplier.requestFocus();
                return false;
            }
            if (body.tfPurNum.getText().equals("")) {
                DlgMessage.showMessage(this, StoreParams.res.getString("You_must_enter_a1"), StoreParams.res.getString("Stop"), 1);
                body.tfPurNum.requestFocus();
                return false;
            }
            if (this.carrier.toString().equals("-1") && !this.delinstructions()) {
                return false;
            }
            String msg = body.tfTot.getText() + " " + StoreParams.res.getString(body.tfTot.getDouble() > 1.0 ? "units_transfered" : "unit_transfered") + " " + body.tfSupplier.getDesc() + "\n" + StoreParams.res.getString("Reference") + " : " + body.tfPurNum.getText();
            if (DlgMessage.showMessage(this, msg, StoreParams.res.getString("Confirm_trans"), 2, 3) != 0) {
                return false;
            }
        } else {
            if (body.tfWhse.getText().length() == 0 || body.tfWhse.getidx() <= 0L) {
                DlgMessage.showMessage(this, StoreParams.res.getString("You_must_enter_a8"), StoreParams.res.getString("Stop"), 1);
                body.tfWhse.requestFocus();
                return false;
            }
            if (this.carrier.toString().equals("-1") && !this.delinstructions()) {
                return false;
            }
            if (!this.validateTransferOnline()) {
                return false;
            }
            String msg = body.tfTot.getText() + " " + StoreParams.res.getString(body.tfTot.getDouble() > 1.0 ? "units_transfered" : "unit_transfered") + " " + body.tfWhse.getDesc();
            if (DlgMessage.showMessage(this, msg, StoreParams.res.getString("Confirm_trans"), 2, 3) != 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean completeTrans() {
        if (this.completing) {
            return false;
        }
        if (!((PaTransferFoot)this.paFoot).bComplete.isEnabled() && !((PaTransferFoot)this.paFoot).bComplete.isVisible() && ((PaTransferFoot)this.paFoot).bSaveConnote.isVisible() && ((PaTransferFoot)this.paFoot).bSaveConnote.isEnabled()) {
            this.saveConnoteNumber();
            return false;
        }
        if (((PaTransferOut)this.paBody).getIsOverReceipt()) {
            return false;
        }
        if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.TRANSFER_OUT_UNDER_TRANSFER_WARNING)) {
            PaTransferOut body = (PaTransferOut)this.paBody;
            for (int i = 0; i < body.tblStyles.getRowCount(); ++i) {
                if (!(body.tblStyles.model.getItemAt(i) instanceof StyleLine) || !(((StyleLine)body.tblStyles.model.getItemAt(i)).getQty() < ((StyleLine)body.tblStyles.model.getItemAt(i)).getReqQty())) continue;
                if (DlgMessage.showMessage(this, StoreParams.res.getString("You_cannot_under_receipt"), StoreParams.res.getString("Warning"), 0, 2) == 0) break;
                body.tblStyles.changeSelection(i, 0, false, false);
                this.completing = false;
                return false;
            }
        }
        this.completing = true;
        try {
            boolean bl = super.completeTrans();
            return bl;
        }
        finally {
            this.completing = false;
        }
    }

    @Override
    public boolean completeTrans(boolean pcomplete) {
        try {
            String carrieridx = this.carrier.toString().equals("-1") ? "null" : this.carrier.toString();
            String toWhseidx = this.transType != 252 && ((PaTransferOut)this.paBody).tfWhse.getidx() > 0L ? String.valueOf(((PaTransferOut)this.paBody).tfWhse.getidx()) : "null";
            String supplier = this.transType == 252 && ((PaTransferOut)this.paBody).tfSupplier.getidx() > 0L ? String.valueOf(((PaTransferOut)this.paBody).tfSupplier.getidx()) : "null";
            String connote = ((PaTransferOut)this.paBody).tfConnote.getText();
            if (connote.length() > 250) {
                connote = connote.substring(0, 250);
            }
            PosUtils.startTrans(this.sParams.conn);
            this.vhidx = this.sParams.nextVal("XRET_TRANH");
            try (Statement stmt = this.sParams.conn.createStatement();){
                stmt.executeUpdate(" INSERT INTO RET_TRANH(VHIDX, TR_TYPE, \"ACTIVE\", WIDX, TRANS_NUMBER, TRAND,  SREPIDX, MEMBER_GENERATEDIDX, TRANSSREPIDX, TRANSMEMIDX, DOCKET_NUMBER, COMPLETE,  CARRIERIDX, TO_WIDX, SUPPLIERIDX, TILL_NUMBER, NOTES1, NOTES2, SALE_DATE, ORIG_TRANIDX, CORDER)  VALUES (" + this.vhidx + ", " + this.transType + ", 1, " + this.sParams.getStoreIdx() + ", " + PosUtils.StringToSqlString(this.transnum) + ", current_timestamp, " + this.getUser().getPeridx() + "," + this.getUser().getMemidx() + ", " + this.getUser().getPeridx() + ", " + this.getUser().getMemidx() + ", " + PosUtils.StringToSqlString(this.docknum) + ", 0, " + carrieridx + ", " + toWhseidx + ", " + supplier + ", " + PosUtils.StringToSqlString(this.sParams.tillnum) + ", " + PosUtils.StringToSqlString(this.delins.toString()) + ", " + PosUtils.StringToSqlString(connote) + ", TRUNC_DATE(current_timestamp), " + (this.tr_vhidx == -1L ? "NULL" : Long.valueOf(this.tr_vhidx)) + "," + PosUtils.StringToSqlString(this.tr_number) + ")");
                Utils.CopyLikeReferences(this.sParams.conn, 18L, "WHSE", "WIDX", this.sParams.getStoreIdx(), 23L, "RET_TRANH", "VHIDX", this.vhidx);
                ((PaTransferOut)this.paBody).tblStyles.db_insertLines();
                stmt.executeUpdate("UPDATE RET_TRANH SET COMPLETE = 1 WHERE VHIDX = " + this.sParams.currVal("XRET_TRANH") + ";");
            }
            this.sParams.yTabInsert("RET_TRANH", "VHIDX", "" + this.sParams.currVal("XRET_TRANH"));
            for (int i = 0; i < this.reservations.size(); ++i) {
                this.reservations.elementAt(i).reverseReservation(this.getUser().getMemidx(), this.getUser().getPeridx(), this.docknum);
            }
            if (this.tr_vhidx != -1L) {
                if (!this.sParams.checkIConn()) {
                    PosUtils.releaseTrans(this.sParams.conn);
                    DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
                    return false;
                }
                SP.sParams.root = SP.sParams.OnlineQueryProvider.getOnlineQuery("comp_tr", this.tr_vhidx + "").getXML();
                if (SP.sParams.root == null) {
                    PosUtils.releaseTrans(this.sParams.conn);
                    DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
                    return false;
                }
            }
            PosUtils.endTrans(this.sParams.conn);
            return true;
        }
        catch (Exception e) {
            PosUtils.releaseTrans(this.sParams.conn);
            PosUtils.logError(e);
            return false;
        }
    }

    public void setButtons() {
        if (this.editable) {
            if (((PaTransferOut)this.paBody).tblStyles.getQty() > 0.0 && this.docknum == null) {
                ((PaTransferFoot)this.paFoot).bComplete.setEnabled(true);
            } else {
                ((PaTransferFoot)this.paFoot).bComplete.setEnabled(false);
                ((PaTransferFoot)this.paFoot).bComplete.setVisible(true);
                ((PaTransferFoot)this.paFoot).bSaveConnote.setVisible(false);
                ((PaTransferFoot)this.paFoot).bSaveConnote.setEnabled(false);
            }
            if (this.transRoot == null) {
                ((PaTransferFoot)this.paFoot).bPrintCheckList.setEnabled(false);
                ((PaTransferFoot)this.paFoot).bTrReqRecAll.setEnabled(false);
                ((PaTransferFoot)this.paFoot).bSaveConnote.setEnabled(false);
            } else {
                ((PaTransferFoot)this.paFoot).bPrintCheckList.setEnabled(true);
                ((PaTransferFoot)this.paFoot).bTrReqRecAll.setEnabled(true);
            }
            ((PaTransferFoot)this.paFoot).bCancelTransfer.setEnabled(false);
        } else {
            if (this.canCancel) {
                ((PaTransferFoot)this.paFoot).bCancelTransfer.setEnabled(true);
            } else {
                ((PaTransferFoot)this.paFoot).bCancelTransfer.setEnabled(false);
            }
            if (this.canUpdateTransferConnote && this.sParams.getStoreIdx() == this.despatchWidx) {
                ((PaTransferFoot)this.paFoot).bComplete.setVisible(false);
                ((PaTransferFoot)this.paFoot).bComplete.setEnabled(false);
                ((PaTransferFoot)this.paFoot).bSaveConnote.setVisible(true);
                ((PaTransferFoot)this.paFoot).bSaveConnote.setEnabled(false);
                this.addKeyListenerToConnoteField();
            }
        }
    }

    @Override
    public void voidTrans(boolean logout) {
        if (!logout || this.isLoggedIn(!logout)) {
            super.voidTrans(logout);
            this.reservations.clear();
            ((PaTransferOut)this.paBody).tfWhse.clear();
            ((PaTransferOut)this.paBody).tfPurNum.setVisible(false);
            ((PaTransferOut)this.paBody).lPurNum.setText("");
            ((PaTransferOut)this.paBody).tfPurNum.setText("");
            ((PaTransferOut)this.paBody).tfConnote.setText("");
            this.carrier.replace(0, this.carrier.length(), "-1");
            this.delins.replace(0, this.delins.length(), "");
            ((PaTransferOut)this.paBody).tblStyles.clear();
            ((PaTransferOut)this.paBody).tfBarcode.setText("");
            ((PaTransferOut)this.paBody).lFeedBack.setText(StoreParams.res.getString("Transfer"));
            ((PaTransferOut)this.paBody).lFeedBack2.setText("");
            ((PaTransferOut)this.paBody).lFeedBack.setForeground(this.getDefaultColor());
            this.tr_vhidx = -1L;
            this.canCancel = false;
            this.transRoot = null;
            ((PaTransferOut)this.paBody).tblStyles.showTrOutReqCol(false);
            ((PaTransferOut)this.paBody).setToField(this.transType);
            this.setButtons();
        }
    }

    @Override
    public void delLines() {
        if (((PaTransferFoot)this.paFoot).bDelete.isEnabled()) {
            Vector<Object> lines = ((PaTransferOut)this.paBody).delLines();
            for (int i = this.reservations.size() - 1; i >= 0; --i) {
                if (!lines.contains(this.reservations.elementAt(i).getStyleLine())) continue;
                this.reservations.remove(i);
            }
            this.setFocus();
        }
    }

    protected boolean delinstructions() {
        if (this.isLoggedIn(true)) {
            String carr = this.carrier.toString();
            String del = this.delins.toString();
            DlgReason dlgdelins = new DlgReason(this, StoreParams.res.getString("Delivery_Instructions"), true, 202L, this.carrier, this.delins, this.editable, "", false);
            dlgdelins.setVisible(true);
            if (carr.equals(this.carrier.toString()) && del.equals(this.delins.toString())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 116 && ((PaTransferFoot)this.paFoot).bDirect.isEnabled() && ((PaTransferFoot)this.paFoot).bDirect.isVisible()) {
            ((PaTransferFoot)this.paFoot).bDirect.doClick();
        } else if (e.getKeyCode() == 117 && ((PaTransferFoot)this.paFoot).bTrReq.isEnabled() && ((PaTransferFoot)this.paFoot).bTrReq.isVisible()) {
            ((PaTransferFoot)this.paFoot).bTrReq.doClick();
        } else if (e.getKeyCode() == 118 && ((PaTransferFoot)this.paFoot).bPrintCheckList.isEnabled() && ((PaTransferFoot)this.paFoot).bPrintCheckList.isVisible()) {
            ((PaTransferFoot)this.paFoot).bPrintCheckList.doClick();
        } else if (e.getKeyCode() == 119 && ((PaTransferFoot)this.paFoot).bTrReqRecAll.isEnabled() && ((PaTransferFoot)this.paFoot).bTrReqRecAll.isVisible()) {
            ((PaTransferFoot)this.paFoot).bTrReqRecAll.doClick();
        } else if (e.getKeyCode() == 115 && ((PaTransferFoot)this.paFoot).bCancelTransfer.isEnabled() && ((PaTransferFoot)this.paFoot).bCancelTransfer.isVisible()) {
            ((PaTransferFoot)this.paFoot).bCancelTransfer.doClick();
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void setStatusText(String msg) {
        ((PaTransferFoot)this.paFoot).statusBar.setText(msg);
    }

    @Override
    public void setStatusMsg(String msg) {
        ((PaTransferFoot)this.paFoot).statusBar.setMessage(msg);
    }

    @Override
    public void resetStatus() {
        ((PaTransferFoot)this.paFoot).statusBar.reset();
    }

    @Override
    public boolean isVoid() {
        return ((PaTransferOut)this.paBody).tblStyles.getRowCount() == 0 && this.transnum == null;
    }

    @Override
    protected void setEditable(boolean peditable) {
        super.setEditable(peditable);
        ((PaTransferOut)this.paBody).tblStyles.setEditable(this.editable);
        ((PaTransferOut)this.paBody).tfWhse.setEnabled(this.editable);
        ((PaTransferOut)this.paBody).tfSupplier.setEnabled(this.editable);
        ((PaTransferOut)this.paBody).tfPurNum.setEnabled(this.editable);
        ((PaTransferOut)this.paBody).tfConnote.setEnabled(this.editable || this.canUpdateTransferConnote && this.sParams.getStoreIdx() == this.despatchWidx);
        ((PaTransferFoot)this.paFoot).bDelete.setEnabled(this.editable);
        ((PaTransferFoot)this.paFoot).bDirect.setEnabled(this.editable);
        this.setButtons();
    }

    @Override
    public boolean populate(Element trans) {
        try {
            this.canCancel = false;
            if (super.populate(trans)) {
                Store store;
                String storeno = "000";
                if (trans.getAttribute("widx") != null && (store = ((PaTransferOut)this.paBody).getTransferOutStore(trans.getAttribute("widx").getLongValue())) != null) {
                    storeno = store.getStoreNo();
                }
                if (trans.getAttribute("notes2") != null) {
                    ((PaTransferOut)this.paBody).tfConnote.setText(trans.getAttribute("notes2").getValue());
                }
                if (this.transType == 252) {
                    ((PaTransferOut)this.paBody).tfPurNum.setText(trans.getAttribute("trans_number").getValue());
                    ((PaTransferOut)this.paBody).lFeedBack.setText(StoreParams.res.getString("Docket_") + " D" + storeno + trans.getAttribute("docket_number").getValue());
                    if (trans.getAttribute("supplieridx") != null) {
                        boolean bFound = false;
                        for (int j = 0; j < ((PaTransferOut)this.paBody).suppliers.size(); ++j) {
                            if (((PaTransferOut)this.paBody).suppliers.elementAt(j).getIdx() != trans.getAttribute("supplieridx").getLongValue()) continue;
                            ((PaTransferOut)this.paBody).tfSupplier.setAll(((PaTransferOut)this.paBody).suppliers.elementAt(j).getIdx(), ((PaTransferOut)this.paBody).suppliers.elementAt(j).getCode(), ((PaTransferOut)this.paBody).suppliers.elementAt(j).getName());
                            bFound = true;
                            break;
                        }
                        if (!bFound) {
                            Object[] objs = new Object[]{"\n"};
                            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("Unable_retrieve_no_supplier_sec"), objs), StoreParams.res.getString("Error"), 0);
                            return false;
                        }
                    }
                } else {
                    this.canCancel = this.canCancelTransfer(trans);
                    if (trans.getAttribute("widx") != null) {
                        this.despatchWidx = trans.getAttribute("widx").getLongValue();
                    }
                    String sComplete = "";
                    if (trans.getAttribute("transfer_complete_flag") != null) {
                        int nCompleteFlag = trans.getAttribute("transfer_complete_flag").getIntValue();
                        if (nCompleteFlag == 3) {
                            sComplete = StoreParams.res.getString("tr_cancelled");
                        } else if (nCompleteFlag > 0) {
                            sComplete = StoreParams.res.getString("tr_complete");
                        }
                    }
                    ((PaTransferOut)this.paBody).lFeedBack.setText(StoreParams.res.getString("Transfer_") + " " + trans.getAttribute("trans_number").getValue());
                    ((PaTransferOut)this.paBody).lFeedBack2.setText(StoreParams.res.getString("Docket_") + " D" + storeno + trans.getAttribute("docket_number").getValue() + " " + sComplete);
                    if (trans.getAttribute("to_widx") != null) {
                        Store store2 = ((PaTransferOut)this.paBody).getTransferOutStore(trans.getAttribute("to_widx").getLongValue());
                        if (store2 == null) {
                            ((PaTransferOut)this.paBody).tfWhse.clear();
                            Object[] objs = new Object[]{"\n"};
                            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("Unable_retrieve_no_security"), objs), StoreParams.res.getString("Error"), 0);
                            return false;
                        }
                        ((PaTransferOut)this.paBody).tfWhse.setAll(store2.getWidx(), store2.getCode(), store2.getName());
                    }
                }
                if (!((PaTransferOut)this.paBody).tblStyles.populate(trans)) {
                    ((PaTransferOut)this.paBody).tfBarcode.setText(StoreParams.res.getString("Error_loading"));
                    return false;
                }
                this.carrier.replace(0, this.carrier.length(), trans.getAttribute("carrier") != null ? trans.getAttribute("carrier").getValue() : "-1");
                if (trans.getAttribute("notes1") != null) {
                    this.delins.replace(0, this.delins.length(), trans.getAttribute("notes1") != null ? trans.getAttribute("notes1").getValue() : "");
                }
                this.setEditable(false);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        return true;
    }

    private void addKeyListenerToConnoteField() {
        ((PaTransferOut)this.paBody).tfConnote.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                ((PaTransferFoot)FrTransferOut.this.paFoot).bSaveConnote.setEnabled(true);
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private boolean canCancelTransfer(Element trans) {
        boolean result = false;
        try {
            if ((trans.getAttribute("transfer_complete_flag") == null || trans.getAttribute("transfer_complete_flag").getIntValue() == 0) && trans.getAttribute("widx") != null && trans.getAttribute("widx").getValue().equals(String.valueOf(this.sParams.getStoreIdx()))) {
                result = true;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return result;
    }

    @Override
    public void printReceipt(boolean reprint) {
        Receipt r1 = new Receipt(this, StoreParams.res.getString("Printing_Transfer"), false, this.sParams.getDocketConnection(), this.vhidx, reprint);
        if (r1.isValidReceipt()) {
            r1.PrintTransferOut();
        } else {
            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("Unable_retrieve"), "\n"), StoreParams.res.getString("Error"), 0);
        }
        r1.close();
    }

    public void printPickList() {
        Receipt r1 = new Receipt(this, StoreParams.res.getString("Printing_Pick"), false, this.sParams.getDocketConnection(), 0L, false);
        r1.printTransferChecklist(this.transRoot);
        r1.close();
    }

    @Override
    protected void setTransnum() {
        try {
            if (this.transType == 249) {
                this.transnum = PosUtils.padZeroes(this.sParams.getNextTransferNum("FrTransferOut.setTransnum"), 8);
            } else if (this.transType == 252) {
                this.transnum = ((PaTransferOut)this.paBody).tfPurNum.getText();
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    @Override
    protected void updateSec(boolean[] formSec) {
    }

    @Override
    public void notesSet() {
        for (int i = 0; i < this.notes.size(); ++i) {
            Note note = (Note)this.notes.elementAt(i);
            if (note.noteType.getTblidx() != 23L) continue;
            ((PaTransferOut)this.paBody).lFeedBack.setForeground(this.notesColor);
        }
    }

    @Override
    public boolean checkExit() {
        if (this.editable && ((PaTransferOut)this.paBody).tblStyles.model.getData().size() > 0) {
            return super.checkExit();
        }
        return true;
    }

    public void transferReqSearch() {
        if (this.hasSecurity(11150L, 0)) {
            if (this.sParams.checkIConn()) {
                ((PaTransferOut)this.paBody).tfTransferReqSearch.clear();
                boolean wasOnline = this.sParams.checkIConn();
                ((PaTransferOut)this.paBody).tfTransferReqSearch.doSearch();
                if (wasOnline && !this.sParams.checkIConn()) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("online_search_error"), StoreParams.res.getString("Error"), -1, 0);
                }
                if (((PaTransferOut)this.paBody).tfTransferReqSearch.getidx() > 0L) {
                    ((PaTransferOut)this.paBody).tfBarcode.setText(((PaTransferOut)this.paBody).tfTransferReqSearch.getText());
                    ((PaTransferOut)this.paBody).tfBarcode_actionPerformed(null);
                }
            } else {
                DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
            }
        } else {
            DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
        }
    }

    @Override
    public void refreshImage() {
        ((PaTransferOut)this.paBody).tblStyles.RefreshImage();
    }

    @Override
    public void processLogin() {
    }

    public void receiptAll() {
        if (this.hasSecurity(11118L, 0)) {
            ((PaTransferOut)this.paBody).receiptAll();
        } else {
            DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
        }
    }

    protected void cancelTransfer() {
        if (this.hasSecurity(11157L, 0)) {
            if (DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("Cancel_Transfer_Question"), this.docknum), StoreParams.res.getString("Cancel_Transfer_Msg_Hdr"), 0, 3) != 0) {
                return;
            }
            if (!this.sParams.checkIConn()) {
                DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
            } else {
                this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("cancel_tr", this.docknum + "," + this.sParams.getStoreIdx() + "," + this.getUser().getMemidx()).getXML();
                if (this.sParams.root != null) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("Cancel_Transfer_Msg_Body"), StoreParams.res.getString("Cancel_Transfer_Msg_Hdr"), -1, 1);
                    this.voidTrans(false);
                }
            }
        } else {
            DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
        }
    }

    public boolean validateTransferOnline() {
        if (!SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.PREVENT_TRANSFER_OF_INELIGIBLE_PRODUCTS)) {
            return true;
        }
        String toWhseidx = String.valueOf(((PaTransferOut)this.paBody).tfWhse.getidx());
        String skus = "";
        StyleTable styleTable = ((PaTransferOut)this.paBody).tblStyles;
        for (int i = 0; i < styleTable.getRowCount(); ++i) {
            if (!(styleTable.model.getRow(i) instanceof StyleLine)) continue;
            skus = skus + "," + ((StyleLine)styleTable.model.getRow(i)).getSkuidx();
        }
        if (skus.length() == 0 || toWhseidx.equals("0")) {
            return true;
        }
        if (!this.sParams.checkIConn()) {
            return DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("Cant_validate_transfer_online"), "\n", "\n"), StoreParams.res.getString("Offline"), 0, 2) == 0;
        }
        Element transferValidation = SP.sParams.OnlineQueryProvider.getOnlineQuery("transfer_validation", toWhseidx + skus).getXML();
        if (transferValidation == null) {
            return DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("Cant_validate_transfer_online"), "\n", "\n"), StoreParams.res.getString("Offline"), 0, 2) == 0;
        }
        String invaidStyles = "";
        Element invalidSkusHeader = transferValidation.getChild("invalid_skus");
        if (invalidSkusHeader != null) {
            List invalidSkus = invalidSkusHeader.getChildren("sku");
            for (int i = 0; i < invalidSkus.size(); ++i) {
                try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT S.STYLECODE || ' ' || S.NAME || ' ' || C.CLRCODE || ' ' || K.SIZEVAL FROM STYLE S, CLR C, SKU K WHERE S.STYLEIDX = C.STYLEIDX AND C.CLRIDX = K.CLRIDX AND K.SKUIDX = " + ((Element)invalidSkus.get(i)).getText());){
                    if (!sql.next()) continue;
                    invaidStyles = invaidStyles + "\n" + sql.getString(1);
                    continue;
                }
                catch (Exception e) {
                    Utils.logError(e);
                    return false;
                }
            }
        }
        if (invaidStyles.length() > 0) {
            DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("Invalid_Products_On_Transfer"), ((PaTransferOut)this.paBody).tfWhse.getText(), invaidStyles), SP.getRS("Error"), 0);
            return false;
        }
        return true;
    }

    protected void saveConnoteNumber() {
        long widx = this.sParams.getStoreIdx();
        long pos_vhidx = this.vhidx;
        String docket_number = this.docknum;
        String connote = ((PaTransferOut)this.paBody).tfConnote.getText();
        if (connote != null || !"".equals(connote)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < connote.length(); ++i) {
                char c = connote.charAt(i);
                if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') && (c < '\u10000' || c > '\u10ffff')) continue;
                sb.append(c);
            }
            connote = sb.toString();
        }
        if (this.sParams.checkIConn()) {
            Element onlineResult = this.sParams.OnlineQueryProvider.getOnlineQuery("updt_transfer_connote", widx + "," + pos_vhidx + "," + docket_number + "," + connote).getXML();
            if (XMLUtils.getValue(onlineResult, "result").equals("1")) {
                try (PreparedStatement prepStmt = this.sParams.conn.prepareStatement("UPDATE RET_TRANH SET NOTES2 = ? WHERE WIDX = ? AND VHIDX = ? AND DOCKET_NUMBER = ? AND TR_TYPE = 249");){
                    prepStmt.setString(1, connote);
                    prepStmt.setLong(2, widx);
                    prepStmt.setLong(3, pos_vhidx);
                    prepStmt.setString(4, docket_number);
                    prepStmt.executeUpdate();
                    ((PaTransferFoot)this.paFoot).bSaveConnote.setEnabled(false);
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            } else {
                DlgMessage.showMessage(this, SP.getRS("Save_Connote_Error"), SP.getRS("Save_Connote_Title"), -1, 64);
            }
        } else {
            DlgMessage.showMessage(this, SP.getRS("must_be_online"), SP.getRS("Error"), -1, 64);
        }
    }
}

