/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import jpos.DecimalField;
import jpos.DlgMessage;
import jpos.FrExpense;
import jpos.MLengthTextArea;
import jpos.PaPCFoot;
import jpos.PosDouble;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosTable;
import jpos.PosUtils;
import jpos.Reference;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StatusBar;
import jpos.StoreParams;
import jpos.TotalsTable;
import jpos.TotalsTableModel;
import jpos.pay.PayType;
import jpos.pay.PayTypes;
import jpos.searchfields.HintTextField;
import jpos.searchfields.SearchPanel;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;

public class PaExpense
extends JPanel {
    private static final int EXPENSE_REASON_RGIDX = 378;
    private PayType payType;
    GridBagLayout gridBagLayout = new GridBagLayout();
    HintTextField tfWNum = new HintTextField(SP.getRS("Search_F12"), TouchTextField.FontSize.LARGE){

        @Override
        public void actionSearch() {
            if (this.isEnabled() && PaExpense.this.parentfr.isLoggedIn(true)) {
                if (this.getText().equals(StoreParams.invalidWith)) {
                    this.setText("");
                }
                PaExpense.this.search = true;
                super.actionSearch();
                PaExpense.this.search = false;
            }
        }

        @Override
        public void actionValidate() {
            if (PaExpense.this.parentfr.isLoggedIn(false)) {
                if (!PaExpense.this.search) {
                    return;
                }
                PaExpense.this.search = false;
                super.actionValidate();
                if ((this.getidx() != -1L || this.getidx() != 0L) && this.getText().length() > 1) {
                    PaExpense.this.getWithdrawal(PaExpense.this.tfWNum.getText().substring(1));
                }
            }
        }
    };
    private SearchPanel searchPanel = new SearchPanel(this.tfWNum);
    private boolean search = false;
    DecimalField tfAmt;
    private LabelSubHeading lWNum = new LabelSubHeading();
    private LabelSubHeading lAmt = new LabelSubHeading();
    private EModel model = new EModel();
    PosTable tblExpenses;
    private TotalsTable tblTotals;
    Vector<Reference> reasons = new Vector();
    DecimalField tfReturn;
    private LabelSubHeading lReturn = new LabelSubHeading();
    MLengthTextArea tpNotes = new MLengthTextArea(250);
    PosFrame parentfr;
    StoreParams sParams;
    LabelSubHeading lFeedBack = new LabelSubHeading();

    public PaExpense(StoreParams psParams, PosFrame pparent) {
        try {
            this.parentfr = pparent;
            this.sParams = psParams;
            this.jbInit();
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    private void jbInit() throws Exception {
        this.payType = PayTypes.cashPayType;
        this.tblExpenses = new PosTable(this.parentfr, this.model);
        this.tblInit();
        this.tfWNum.setCache(this.sParams.cacher, 361L, "501,502,503", "", "");
        this.tfWNum.setSearchKey(123);
        this.tfWNum.searchWithEnter(true);
        this.reasons.clear();
        try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT R.RCIDX, R.CODE, R.NAME, R.LINKIDX FROM REFCODE R WHERE R.RGIDX = 378 AND R.\"ACTIVE\" = 1 ORDER BY R.NAME");){
            while (sql.next()) {
                Reference reason = new Reference(sql.getLong(1), 378L, sql.getString(2), sql.getString(3), sql.getLong(4), "", "", "", "");
                reason.setShowName(true);
                this.reasons.add(reason);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        TotalsTableModel totalsTableModel = new TotalsTableModel(this.tblExpenses.getModel()){

            @Override
            public Object getValueAt(int row, int col) {
                if (row != 0) {
                    return "";
                }
                switch (col) {
                    case 0: {
                        return StoreParams.totalText;
                    }
                    case 2: {
                        return new PosDouble(PaExpense.this.model.getTotalTax());
                    }
                    case 3: {
                        return new PosDouble(PaExpense.this.model.getTotalAmount());
                    }
                }
                return "";
            }
        };
        this.tblTotals = new TotalsTable(this.parentfr, this.tblExpenses, totalsTableModel);
        this.tfAmt = new DecimalField(this.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.tfReturn = new DecimalField(this.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.tfWNum.setFieldWidth(200);
        this.tfWNum.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                PaExpense.this.tfWNum_focusGained(e);
            }
        });
        this.tfWNum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaExpense.this.tfWNum_actionPerformed(e);
            }
        });
        this.setLayout(this.gridBagLayout);
        this.tfAmt.setEnabled(false);
        this.tfAmt.setFieldWidth(110);
        this.lWNum.setText(StoreParams.res.getString("Withdrawal_Number"));
        this.lAmt.setText(StoreParams.res.getString("Withdrawal_Amount"));
        this.tfReturn.setEnabled(false);
        this.tfReturn.setFieldWidth(110);
        this.lReturn.setText(StoreParams.res.getString("Return_To_Till") + " ");
        this.tpNotes.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PaExpense.this.tpNotes_focusGained(e);
            }
        });
        JPanel panelReturnToToll = new JPanel(new GridBagLayout());
        panelReturnToToll.add((Component)this.lReturn, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 10, 5), 0, 0));
        panelReturnToToll.add((Component)this.tfReturn, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 5, 10, 10), 0, 0));
        this.add((Component)this.searchPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.tblExpenses.getScrollPane(), new GridBagConstraints(0, 4, 4, 1, 1.0, 2.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.tblTotals.getScrollPane(), new GridBagConstraints(0, 5, 4, 1, 1.0, 0.0, 15, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.tfAmt, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.lWNum, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.lAmt, new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)panelReturnToToll, new GridBagConstraints(3, 7, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lFeedBack, new GridBagConstraints(1, 1, 1, 1, 3.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.tfWNum);
        v.add(this.tblExpenses);
        v.add(this.tfWNum);
        v.add(this.parentfr.paHead.signInButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    private void tblInit() {
        this.tblExpenses.renderer.setColumnFormat(2, this.sParams.currFormat, 4);
        this.tblExpenses.renderer.setColumnFormat(3, this.sParams.currFormat, 4);
        JTableHeader header = this.tblExpenses.getTableHeader();
        header.getColumnModel().getColumn(0).setHeaderRenderer(this.tblExpenses.headerLeftRen);
        header.getColumnModel().getColumn(1).setHeaderRenderer(this.tblExpenses.headerLeftRen);
        header.getColumnModel().getColumn(2).setHeaderRenderer(this.tblExpenses.headerRightRen);
        header.getColumnModel().getColumn(3).setHeaderRenderer(this.tblExpenses.headerRightRen);
        this.tblExpenses.getColumnModel().getColumn(1).setCellEditor(this.tblExpenses.stringEd);
        this.tblExpenses.getColumnModel().getColumn(2).setCellEditor(this.tblExpenses.currEd);
        this.tblExpenses.getColumnModel().getColumn(3).setCellEditor(this.tblExpenses.currEd);
        this.tblExpenses.getColumnModel().getColumn(0).setMinWidth(200);
        this.tblExpenses.getColumnModel().getColumn(0).setMaxWidth(200);
        this.tblExpenses.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.tblExpenses.getColumnModel().getColumn(2).setMinWidth(110);
        this.tblExpenses.getColumnModel().getColumn(2).setMaxWidth(110);
        this.tblExpenses.getColumnModel().getColumn(2).setPreferredWidth(110);
        this.tblExpenses.getColumnModel().getColumn(3).setMinWidth(110);
        this.tblExpenses.getColumnModel().getColumn(3).setMaxWidth(110);
        this.tblExpenses.getColumnModel().getColumn(3).setPreferredWidth(110);
        this.tblExpenses.sizeColumnsToFit(-1);
    }

    private void setTotals() {
        this.tfReturn.setText(this.tfAmt.getDouble() - this.model.getTotalAmount());
    }

    protected void insertRow(Reference reason, String details, double tax, double amount) {
        int newRow = this.model.insertRow(reason, details, tax, amount);
        this.setTotals();
        this.tblExpenses.requestFocus();
        this.tblExpenses.setRowSelectionInterval(newRow, newRow);
        this.tblExpenses.setColumnSelectionInterval(1, 1);
    }

    void clearFields() {
        ((EModel)this.tblExpenses.getModel()).clear();
        this.tpNotes.setText("");
        this.tfAmt.setText("");
        this.tfReturn.setText("");
        this.tfWNum.setEnabled(true);
        this.tfWNum.setText("");
        this.lFeedBack.setText("");
        ((PaPCFoot)this.parentfr.paFoot).bComplete.setEnabled(false);
        this.tpNotes.setEnabled(false);
    }

    void delLines() {
        int[] rows = this.tblExpenses.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            ((EModel)this.tblExpenses.getModel()).removeRow(rows[i]);
        }
        this.setTotals();
        if (this.tblExpenses.getRowCount() > 0) {
            this.tblExpenses.setRowSelectionInterval(0, 0);
        }
    }

    void tfWNum_actionPerformed(ActionEvent e) {
        if (this.tfWNum.getText().length() == 0) {
            this.tfWNum.setText(StoreParams.res.getString("Invalid_Withdrawal_"));
            this.tfWNum.selectAll();
            this.tfWNum.requestFocus();
        } else {
            this.getWithdrawal(this.tfWNum.getText().substring(1));
        }
    }

    private void getWithdrawal(String docketNum) {
        if (docketNum.length() >= 4) {
            this.parentfr.voidTrans(false);
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT H.VHIDX, P.PAYMENT_AMOUNT*-1, H.DOCKET_NUMBER FROM RET_TRANH H LEFT JOIN RET_TRANH E ON H.VHIDX = E.ORIG_TRANIDX, RET_TRANP P, WHSE W WHERE H.VHIDX = P.VHIDX AND W.WIDX = H.WIDX AND W.STORENO = " + PosUtils.StringToSqlString(docketNum.substring(0, 3)) + " " + " AND H.DOCKET_NUMBER = " + PosUtils.StringToSqlString(docketNum.substring(3)) + " AND P.\"ACTIVE\" = 1 AND H.\"ACTIVE\" = 1 " + " AND H.TR_TYPE = 546 " + " AND E.VHIDX IS NULL AND P.PAYMENT_TYPEIDX = " + SP.getCashPayType());){
                if (sql.next()) {
                    ((FrExpense)this.parentfr).fromVhidx = sql.getLong(1);
                    ((FrExpense)this.parentfr).transnum = sql.getString(3);
                    this.tfAmt.setText(sql.getDouble(2));
                    this.tfWNum.setText(docketNum);
                    this.tfWNum.setEnabled(false);
                    this.tpNotes.setEnabled(true);
                    this.setTotals();
                    ((PaPCFoot)this.parentfr.paFoot).bComplete.setEnabled(true);
                    ((FrExpense)this.parentfr).insertLine();
                } else {
                    this.tfWNum.setText(StoreParams.invalidWith);
                    this.tfWNum.selectAll();
                    this.tfWNum.requestFocus();
                }
            }
            catch (SQLException e) {
                PosUtils.logError(e);
            }
        } else {
            this.tfWNum.setText(StoreParams.invalidWith);
            this.tfWNum.selectAll();
            this.tfWNum.requestFocus();
        }
    }

    protected void db_insertExpenses() throws SQLException {
        ((EModel)this.tblExpenses.getModel()).db_insertExpenses();
    }

    void tfWNum_focusGained(FocusEvent e) {
        this.tfWNum.selectAll();
        ((PosFrame)this.getTopLevelAncestor()).setStatusMsg(StatusBar.status_WithdrawalNumber);
    }

    void tpNotes_focusGained(FocusEvent e) {
        ((PosFrame)this.getTopLevelAncestor()).setStatusMsg(StatusBar.status_Notes);
    }

    protected boolean validateData() {
        if (this.tblExpenses.getRowCount() == 0 && DlgMessage.showMessage(this.parentfr, StoreParams.res.getString("return_full"), StoreParams.res.getString("Warning"), 0, 3) != 0) {
            return false;
        }
        for (int i = 0; i < this.model.data.size(); ++i) {
            if (this.model.data.elementAt(i).amount <= 0.0) {
                this.tblExpenses.requestFocus();
                this.tblExpenses.setRowSelectionInterval(i, i);
                this.tblExpenses.setColumnSelectionInterval(3, 3);
                DlgMessage.showMessage(this.parentfr, StoreParams.res.getString("Zero_amount_on_expense"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
            if (this.model.data.elementAt(i).tax > this.model.data.elementAt(i).amount / 2.0) {
                this.tblExpenses.requestFocus();
                this.tblExpenses.setRowSelectionInterval(i, i);
                this.tblExpenses.setColumnSelectionInterval(2, 2);
                DlgMessage.showMessage(this.parentfr, StoreParams.res.getString("Tax_greater_than_half_expense_amount"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
            if (this.model.data.elementAt(i).amount > 9.99999999E8) {
                this.tblExpenses.requestFocus();
                this.tblExpenses.setRowSelectionInterval(i, i);
                this.tblExpenses.setColumnSelectionInterval(3, 3);
                DlgMessage.showMessage(this.parentfr, StoreParams.res.getString("value_too_large"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
            if (!(this.model.data.elementAt(i).tax > 9.99999999E8)) continue;
            this.tblExpenses.requestFocus();
            this.tblExpenses.setRowSelectionInterval(i, i);
            this.tblExpenses.setColumnSelectionInterval(2, 2);
            DlgMessage.showMessage(this.parentfr, StoreParams.res.getString("value_too_large"), StoreParams.res.getString("Stop"), 0);
            return false;
        }
        return true;
    }

    private class EModel
    extends AbstractTableModel {
        private static final int CODE_COLUMN = 0;
        private static final int DETAILS_COLUMN = 1;
        private static final int TAX_COLUMN = 2;
        private static final int AMOUNT_COLUMN = 3;
        private static final int COL_COUNT = 4;
        Vector<String> colNames = new Vector();
        Vector<Expense> data = new Vector();

        public EModel() {
            this.colNames.add(StoreParams.res.getString("Expense"));
            this.colNames.add(StoreParams.res.getString("Details"));
            this.colNames.add(StoreParams.res.getString("Tax"));
            this.colNames.add(StoreParams.res.getString("Amount"));
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return false;
                }
                case 1: {
                    return PaExpense.this.parentfr.editable;
                }
                case 2: {
                    return PaExpense.this.parentfr.editable;
                }
                case 3: {
                    return PaExpense.this.parentfr.editable;
                }
            }
            return false;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Reference.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return PosDouble.class;
                }
                case 3: {
                    return PosDouble.class;
                }
            }
            return super.getColumnClass(column);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (row >= this.data.size() || row < 0 || value == null) {
                return;
            }
            switch (col) {
                case 1: {
                    this.data.elementAt(row).details = (String)value;
                    break;
                }
                case 2: {
                    double tax = PosUtils.doubleValFormatted(value.toString());
                    if (!(tax >= 0.0)) break;
                    this.data.elementAt(row).tax = tax;
                    PaExpense.this.setTotals();
                    break;
                }
                case 3: {
                    double amount = PaExpense.this.payType.roundAmt(PosUtils.doubleValFormatted(value.toString()));
                    if (!(amount >= 0.0)) break;
                    this.data.elementAt(row).amount = amount;
                    PaExpense.this.setTotals();
                    break;
                }
            }
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= this.data.size() || row < 0) {
                return "";
            }
            switch (col) {
                case 0: {
                    return this.data.elementAt(row).reason.toString();
                }
                case 1: {
                    return this.data.elementAt(row).details;
                }
                case 2: {
                    return new PosDouble(this.data.elementAt(row).tax);
                }
                case 3: {
                    return new PosDouble(this.data.elementAt(row).amount);
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int col) {
            return this.colNames.elementAt(col);
        }

        public int insertRow(Reference reason, String details, double tax, double amount) {
            Expense expense = new Expense(reason, details, tax, amount);
            this.data.add(expense);
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
            return this.data.size() - 1;
        }

        public void removeRow(int row) {
            this.data.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        public double getTotalTax() {
            double tot = 0.0;
            for (int i = 0; i < this.data.size(); ++i) {
                tot += this.data.elementAt(i).tax;
            }
            return tot;
        }

        public double getTotalAmount() {
            double tot = 0.0;
            for (int i = 0; i < this.data.size(); ++i) {
                tot += this.data.elementAt(i).amount;
            }
            return tot;
        }

        public void clear() {
            this.data.clear();
            this.fireTableDataChanged();
        }

        private void db_insertExpenses() throws SQLException {
            for (int i = 0; i < this.data.size(); ++i) {
                long rcidx = this.data.elementAt(i).reason != null ? this.data.elementAt(i).reason.getIdx() : -1L;
                String sDetails = this.data.elementAt(i).details;
                if (sDetails != null && sDetails.length() > 250) {
                    sDetails = sDetails.substring(0, 250);
                }
                double taxper = this.data.elementAt(i).tax / (this.data.elementAt(i).amount - this.data.elementAt(i).tax) * 100.0;
                try (PreparedStatement prepStmt = PaExpense.this.sParams.conn.prepareStatement("INSERT INTO RET_TRAND(VSHIDX, VHIDX, \"ACTIVE\", LINE_CODE, DESCRIP1, GROSS, NET, PRICE, SEQUENCE_NUMBER, LINE_TYPE, TAXPER) SELECT ?, ?, 1, ?, ?, ?, ?, ?, COALESCE(MAX(SEQUENCE_NUMBER), -1)+1, 8, ? FROM RET_TRAND WHERE VHIDX = ? ");){
                    prepStmt.setLong(1, PaExpense.this.sParams.nextVal("XRET_TRAND"));
                    prepStmt.setLong(2, PaExpense.this.sParams.currVal("XRET_TRANH"));
                    if (rcidx > -1L) {
                        prepStmt.setLong(3, rcidx);
                    } else {
                        prepStmt.setNull(3, 2);
                    }
                    prepStmt.setString(4, sDetails);
                    prepStmt.setDouble(5, this.data.elementAt(i).amount);
                    prepStmt.setDouble(6, this.data.elementAt(i).amount);
                    prepStmt.setDouble(7, this.data.elementAt(i).amount);
                    prepStmt.setDouble(8, taxper);
                    prepStmt.setLong(9, PaExpense.this.sParams.currVal("XRET_TRANH"));
                    prepStmt.executeUpdate();
                    continue;
                }
            }
        }
    }

    private class Expense {
        private Reference reason;
        private String details;
        private double tax;
        private double amount;

        protected Expense(Reference reason, String details, double tax, double amount) {
            this.reason = reason;
            this.details = details;
            this.tax = tax;
            this.amount = amount;
        }

        public String toString() {
            return this.reason.toString();
        }
    }
}

