/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class PosCellEditor
extends DefaultCellEditor {
    private boolean abortStopCellEditing = false;
    private int stopCount = 0;

    public PosCellEditor(JTextField textField) {
        super(textField);
        textField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!PosCellEditor.this.stopCellEditingSuper() && e.getComponent() != null) {
                    e.getComponent().requestFocus();
                }
            }
        });
    }

    private boolean stopCellEditingSuper() {
        if (this.stopCount == 0) {
            ++this.stopCount;
            try {
                boolean bl = super.stopCellEditing();
                return bl;
            }
            finally {
                --this.stopCount;
            }
        }
        return true;
    }

    public PosCellEditor(JCheckBox checkBox) {
        super(checkBox);
    }

    public PosCellEditor(JComboBox<?> comboBox) {
        super(comboBox);
    }

    public void setAbortStopCellEditing(boolean value) {
        this.abortStopCellEditing = value;
    }

    @Override
    public boolean stopCellEditing() {
        this.abortStopCellEditing = false;
        try {
            boolean result = this.stopCellEditingSuper();
            boolean bl = !this.abortStopCellEditing && result;
            return bl;
        }
        finally {
            this.abortStopCellEditing = false;
        }
    }
}

