/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.text.DecimalFormat;
import java.text.ParseException;
import jpos.SP;

public class PosDouble
implements Comparable<PosDouble> {
    protected Double value;
    private DecimalFormat decFormat;

    public PosDouble(double d) {
        this.value = new Double(d);
        this.decFormat = SP.sParams.currFormat;
    }

    public PosDouble(String s) {
        this.decFormat = SP.sParams.currFormat;
        try {
            this.value = this.decFormat.parse(s).doubleValue();
        }
        catch (ParseException e1) {
            this.value = 0.0;
        }
    }

    public PosDouble(double d, int precision) {
        this.value = new Double(d);
        this.decFormat = new DecimalFormat();
        this.decFormat.setMaximumFractionDigits(precision);
    }

    public String toString() {
        return this.decFormat.format(this.value);
    }

    public double doubleValue() {
        return this.value;
    }

    public static PosDouble valueOf(double d) {
        return new PosDouble(d);
    }

    public static PosDouble valueOf(double d, int precision) {
        return new PosDouble(d, precision);
    }

    @Override
    public int compareTo(PosDouble anotherPosDouble) {
        if (anotherPosDouble == null || anotherPosDouble.value == null) {
            return 1;
        }
        return this.value.compareTo(anotherPosDouble.value);
    }
}

