/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import ReceiptPrinter.EODReport;
import ReceiptPrinter.OpenCashDrawer;
import ReceiptPrinter.Receipt;
import bass.eftpos.ui.BasicDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.lang.invoke.LambdaMetafactory;
import java.net.URISyntaxException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.function.Supplier;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jpos.ApiKeys;
import jpos.DlgAbout;
import jpos.DlgBudget;
import jpos.DlgClockAll;
import jpos.DlgDummyPrinter;
import jpos.DlgHistoryFilter;
import jpos.DlgImage;
import jpos.DlgImportAPNs;
import jpos.DlgKeys;
import jpos.DlgManualLoyaltyDiscount;
import jpos.DlgMessage;
import jpos.DlgNotes;
import jpos.DlgReason;
import jpos.FrSales;
import jpos.FrStkEnquiry;
import jpos.HistoryOptions;
import jpos.HistoryOptionsBuilder;
import jpos.IStatusListener;
import jpos.Note;
import jpos.NoteType;
import jpos.PaHead;
import jpos.PaSales;
import jpos.PosDateSearch;
import jpos.PosMenuController;
import jpos.PosUtils;
import jpos.RemPosReport;
import jpos.SP;
import jpos.Security;
import jpos.Settings;
import jpos.SignInSettings;
import jpos.SlideShow;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.SystemSettings;
import jpos.TransTypes;
import jpos.UareU.IUareUFingerprintListener;
import jpos.User;
import jpos.basscom.components.searchFrame;
import jpos.basscom.swing.BJTextField;
import jpos.basscom.utils.Utils;
import jpos.browser.BrowserFrame;
import jpos.capillary.CapillaryCustomer;
import jpos.capillary.CapillaryLoyaltySetup;
import jpos.crypt.PersonCrypt;
import jpos.custorder.DlgBookingSummary;
import jpos.custorder.DlgPacking;
import jpos.labelprinting.LabelDialogType;
import jpos.menu.PosMenu;
import jpos.menu.PosMenuItem;
import jpos.omneo.DlgOmneoPerson;
import jpos.omneo.OmneoLoyaltySetup;
import jpos.pay.PayTypes;
import jpos.pay.PayUtils;
import jpos.pay.ReceiptReDeliveryMethodDlg;
import jpos.pay.eftpos.EftposUtils;
import jpos.person.PersonDlgProxy;
import jpos.rewards.RewardsUtils;
import jpos.taxlookup.ITaxLookup;
import jpos.taxlookup.TaxLookupFactory;
import jpos.taxlookup.TaxMenu;
import jpos.tillbalance.FrTillBalance;
import jpos.tillbalance.TillBalanceUtils;
import jpos.ui.Colours;
import jpos.voucher.CreditNoteBalanceAdapter;
import jpos.voucher.DlgVoucherIssue;
import jpos.voucher.VoucherBalanceAdapter;
import jpos.voucher.VoucherUtils;
import org.apache.http.client.utils.URIBuilder;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Element;

public abstract class PosFrame
extends JFrame
implements KeyEventDispatcher,
IStatusListener,
IUareUFingerprintListener {
    protected static final int EXIT = -1;
    static final int CLOCKOFF = 4;
    static final int CLOCKOFFALL = 6;
    static final int PERSONMAINT = 5;
    static final int NOTES = 7;
    static final int RUNHOREPORT = 8;
    static final int RUNLOCALREPORT = 9;
    static final int OPENTILL = 10;
    static final int HISTOWN = 11;
    static final int HISTALL = 12;
    static final int REPRINT = 13;
    static final int PRODUCT_IMAGES = 14;
    static final int SLIDESHOW = 15;
    static final int STORE_BUDGET = 16;
    static final int GIFT_VOUCHER_BALANCE_ENQUIRY = 17;
    static final int CREDIT_NOTE_ENQUIRY = 18;
    static final int PACK_ORDERS = 19;
    static final int TURN_OFF_PROMOTIONS = 20;
    static final int LABEL_PRINTING = 21;
    static final int REASSIGN_DESPATCH = 22;
    static final int SET_PERSON_LOYALTY_AMOUNTS = 23;
    static final int DISABLE_ALTERNATIVE_PERSON_MAINT = 24;
    static final int REDEEM_REWARDS_GIFT = 25;
    static final int REMOVE_TAX = 26;
    static final int REFUND_FLOOR_TO_DOOR_ORDER = 27;
    static final int PERSON_OFFLINE_KEY = 28;
    static final int AP21_INSIGHT = 29;
    static final int TAF_FIT_SESSIONS = 30;
    private User user;
    private User lastLoggedInUser;
    public JPanel contentPane;
    BorderLayout borderLayout = new BorderLayout();
    public PaHead paHead;
    public JPanel paBody;
    GridBagLayout gridBagLayout = new GridBagLayout();
    public JPanel paFoot;
    private Color defaultColor;
    public final Color notesColor = Colours.RED;
    Vector<NoteType> noteTypes = new Vector();
    public Vector<Note> notes = new Vector();
    public PosMenuController menu;
    public StoreParams sParams;
    protected JMenuBar menuBar = new JMenuBar();
    private PosMenu menuHelp = new PosMenu();
    private PosMenu menuOrders = new PosMenu();
    private PosMenuItem menuKeys = new PosMenuItem();
    private PosMenuItem menuHelpAbout = new PosMenuItem();
    private PosMenuItem menuHelpTopics = new PosMenuItem();
    private PosMenuItem menuHelpOnlineTraining = new PosMenuItem();
    private PosMenu menuEFTPOS = new PosMenu();
    private PosMenu menuFile = new PosMenu();
    private PosMenuItem menuSales = new PosMenuItem();
    private PosMenuItem menuDebtorSale = new PosMenuItem();
    private PosMenuItem menuFileExit = new PosMenuItem();
    private PosMenuItem menuTransfersOut = new PosMenuItem();
    private PosMenuItem menuTransfersIn = new PosMenuItem();
    private PosMenuItem menuQuickReceipts = new PosMenuItem();
    private PosMenuItem menuCartonReceipt = new PosMenuItem();
    private PosMenuItem menuFITSessions = new PosMenuItem();
    private PosMenuItem menuTransferRequests = new PosMenuItem();
    private PosMenuItem menuStkEnquiry = new PosMenuItem();
    private PosMenuItem menuStkReservation = new PosMenuItem();
    private PosMenuItem menuStkTake = new PosMenuItem();
    private PosMenu menuAustPostFunctions = new PosMenu();
    private PosMenuItem menuAusGenManifest = new PosMenuItem();
    private PosMenuItem menuAusReprintManifest = new PosMenuItem();
    private PosMenu menuTillBalanceFunctions = new PosMenu();
    private PosMenuItem menuTillBalance = new PosMenuItem();
    private PosMenuItem menuTillBalanceStartOfDay = new PosMenuItem();
    private PosMenuItem menuTillBalanceEndOfDay = new PosMenuItem();
    private PosMenu menuPettyCash = new PosMenu();
    private PosMenuItem menuWithDrawal = new PosMenuItem();
    private PosMenuItem menuExpense = new PosMenuItem();
    private PosMenuItem menuCustOrder = new PosMenuItem();
    protected PosMenu menuFunc = new PosMenu();
    protected PosMenu menuPerson = new PosMenu();
    private PosMenuItem menuPersonMaintenance = new PosMenuItem();
    protected JPopupMenu.Separator menuPersonSeparator = new JPopupMenu.Separator();
    protected PosMenuItem menuPersonLoyaltyAmounts = new PosMenuItem();
    protected PosMenuItem menuPersonRedeemRewardsGift = new PosMenuItem();
    private PosMenuItem menuPersonOfflineKey = new PosMenuItem();
    private PosMenuItem menuDisableAlternativePersonMaint = new PosMenuItem();
    private PosMenuItem menuImages = new PosMenuItem();
    private PosMenuItem menuSlideShow = new PosMenuItem();
    private PosMenuItem menuBudget = new PosMenuItem();
    private PosMenuItem menuPackOrders = new PosMenuItem();
    private PosMenuItem menuGVBalanceEnquiry = new PosMenuItem();
    private PosMenuItem menuCNEnquiry = new PosMenuItem();
    protected PosMenuItem menuTurnOffPromotions = new PosMenuItem();
    private PosMenuItem menuLabelPrinting = new PosMenuItem();
    private PosMenuItem menuReassignDespatch = new PosMenuItem();
    private PosMenuItem menuClockOff = new PosMenuItem();
    protected PosMenuItem menuClockOffAll = new PosMenuItem();
    protected PosMenuItem menuNotes = new PosMenuItem();
    private PosMenuItem menuRemoveTax = new PosMenuItem();
    private PosMenuItem menuRefundFloorToDoorOrder = new PosMenuItem();
    private PosMenuItem menuHistHome = new PosMenuItem();
    private PosMenuItem menuHistAll = new PosMenuItem();
    private PosMenuItem menuReprint = new PosMenuItem();
    private PosMenuItem menuOpenTill = new PosMenuItem();
    private Vector<PosMenu> reportMenus = new Vector();
    private TaxMenu taxMenu = null;
    public String transnum = null;
    protected long vhidx = -1L;
    protected long sordidx = -1L;
    public String docknum = null;
    public int transType;
    public int frameType;
    public boolean autoSignOut;
    public String ownerCurrency = null;
    public boolean partialCCAllowed = true;
    public boolean transactionAvailable = false;
    protected long secidx;
    protected String title;
    protected boolean editable = true;
    protected StringBuffer reasonIdx = new StringBuffer("-1");
    protected StringBuffer reasonNotes = new StringBuffer();
    private long lastActionTime = Long.MAX_VALUE;
    private long lastKeyAction = 0L;
    private int lastKey = -1;
    private boolean promotionsEnabled = true;
    public boolean bCanceled = false;
    boolean bLoadingFingerprintScanner = false;
    DlgImage dlgImage = null;
    DlgBudget dlgBudget = null;
    SlideShow slideShow = null;
    private boolean taxLookupDisabledForTransaction = false;
    private boolean taxLookupDisabledForSession = false;
    private boolean usingOmneoPersonMaint = false;
    private boolean omneoPersonMaintIsEnabled = false;
    private boolean usingCapillaryMicrosite = false;
    private boolean capillaryMicrositeIsEnabled = false;
    private CapillaryCustomer capillaryCustomer = null;
    ActionListener menuEFTPOSListener = new ActionListener(){

        @Override
        public void actionPerformed(final ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!PosFrame.this.isLoggedIn(true)) {
                        return;
                    }
                    if (!PosFrame.this.hasSecurity(11134L, 0)) {
                        DlgMessage.showMessage(PosFrame.this, StoreParams.res.getString("no_security"), StoreParams.res.getString("error"), -1, 0);
                    } else if (e.getActionCommand().equals("REVERSE_INCOMPLETE")) {
                        if (!PosFrame.this.sParams.reverseIncompleteEFTs(PosFrame.this)) {
                            DlgMessage.showMessage(PosFrame.this, StoreParams.res.getString("no_incomplete_transactions"), StoreParams.res.getString("eftpos_recovery"), -1, 1);
                        }
                    } else {
                        StringBuffer retMessage = new StringBuffer();
                        PosFrame.this.setCursor(StoreParams.waitCursor);
                        try {
                            if (!PosFrame.this.sParams.eftpos.menuActionPerformed(e, retMessage)) {
                                DlgMessage.showMessage(PosFrame.this, retMessage.toString(), PosFrame.this.sParams.eftpos.getProviderName(), -1, 0);
                            }
                        }
                        finally {
                            PosFrame.this.setCursor(StoreParams.normalCursor);
                        }
                    }
                }
            });
        }
    };

    public abstract void setFocus();

    protected abstract void updateSec(boolean[] var1);

    protected abstract void setTransType();

    public abstract boolean completeTrans(boolean var1);

    public abstract void delLines();

    public abstract boolean isVoid();

    public abstract void setStatusText(String var1);

    public abstract void setStatusMsg(String var1);

    public abstract void resetStatus();

    public abstract void printReceipt(boolean var1);

    public abstract boolean validateTrans();

    protected abstract void setTransnum();

    protected abstract boolean keyPressed(KeyEvent var1);

    public abstract void notesSet();

    public abstract void refreshImage();

    public abstract void processLogin();

    public void refreshTransaction() {
    }

    public PosFrame(PosMenuController pmenu, JPanel ppaBody, int pFrameType, long psecidx, StoreParams psParams, String ptitle) {
        this.enableEvents(64L);
        try {
            this.sParams = psParams;
            this.secidx = psecidx;
            this.paBody = ppaBody;
            this.menu = pmenu;
            this.frameType = pFrameType;
            this.autoSignOut = this.menu.IsStockTypeTransaction(this.frameType) ? SignInSettings.getInstance().isAutoSignOutAfterStockTransactionEnabled() : SignInSettings.getInstance().isAutoSignOutAfterTransactionEnabled();
            this.title = ptitle;
            this.jbInit();
            this.setPosIcon();
            if (this.sParams.bUsingFingerprintLogin && !this.sParams.FingerprintProvider.registerFingerprintListener(this)) {
                DlgMessage.showMessage(this, StoreParams.res.getString("Fingerprint_Scanner_Registration_failed"), StoreParams.res.getString("Registration"), -1, 0);
                this.sParams.bUsingFingerprintLogin = false;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    protected void setPosIcon() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        ArrayList<Image> list = new ArrayList<Image>();
        list.add(tk.getImage(this.sParams.imagepath + "ap21_pos_16x16.png"));
        list.add(tk.getImage(this.sParams.imagepath + "ap21_pos_32x32.png"));
        this.setIconImages(list);
    }

    private void jbInit() throws Exception {
        ITaxLookup taxLookup;
        Object setup;
        try {
            this.setUser(new User(this.sParams));
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        this.sParams.getStatusListener().registerListener(this);
        if (SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.OMNEO_LOYALTY_SETUP) > 0L && ((OmneoLoyaltySetup)(setup = new OmneoLoyaltySetup())).isUsingOmneoPersonScreen()) {
            this.usingOmneoPersonMaint = true;
            this.omneoPersonMaintIsEnabled = true;
        }
        if (SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.CAPILLARY_LOYALTY_SETUP) > 0L && ((CapillaryLoyaltySetup)(setup = new CapillaryLoyaltySetup())).isUsingCapillaryMicrositeScreen()) {
            this.usingCapillaryMicrosite = true;
            this.capillaryMicrositeIsEnabled = true;
            SP.sParams.bUsingCapillaryRewards = true;
        }
        NoteType.readNoteTypes(this.noteTypes, 23L, 0L, this.sParams);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PosFrame.this.setLastAction();
                PosFrame.this.this_keyPressed(e);
            }
        });
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PosFrame.this.setLastAction();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                PosFrame.this.setLastAction();
            }
        });
        this.paHead = new PaHead(this, this.title);
        this.defaultColor = Colours.BLACK;
        this.setStatus(this.sParams.checkIConn());
        this.menu.countOrdersToPack(this.sParams.conn);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout);
        this.contentPane.add((Component)this.paHead, "North");
        ActionListener menuListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PosFrame.this.menuFile_actionPerformed(e);
            }
        };
        this.menuSales.setActionCommand(String.valueOf(1));
        this.menuSales.addActionListener(menuListener);
        this.menuDebtorSale.setActionCommand(String.valueOf(10));
        this.menuDebtorSale.addActionListener(menuListener);
        this.menuTransfersOut.setActionCommand(String.valueOf(2));
        this.menuTransfersOut.addActionListener(menuListener);
        this.menuTransfersIn.setActionCommand(String.valueOf(3));
        this.menuTransfersIn.addActionListener(menuListener);
        this.menuQuickReceipts.setActionCommand(String.valueOf(13));
        this.menuQuickReceipts.addActionListener(menuListener);
        this.menuTransferRequests.setActionCommand(String.valueOf(9));
        this.menuTransferRequests.addActionListener(menuListener);
        this.menuStkEnquiry.setActionCommand(String.valueOf(4));
        this.menuStkEnquiry.addActionListener(menuListener);
        this.menuStkReservation.setActionCommand(String.valueOf(11));
        this.menuStkReservation.addActionListener(menuListener);
        this.menuStkTake.setActionCommand(String.valueOf(5));
        this.menuStkTake.addActionListener(menuListener);
        this.menuTillBalance.setActionCommand(String.valueOf(6));
        this.menuTillBalance.addActionListener(menuListener);
        this.menuTillBalanceStartOfDay.setActionCommand(String.valueOf(14));
        this.menuTillBalanceStartOfDay.addActionListener(menuListener);
        this.menuTillBalanceEndOfDay.setActionCommand(String.valueOf(15));
        this.menuTillBalanceEndOfDay.addActionListener(menuListener);
        this.menuAusGenManifest.setActionCommand(String.valueOf(16));
        this.menuAusGenManifest.addActionListener(menuListener);
        this.menuAusReprintManifest.setActionCommand(String.valueOf(17));
        this.menuAusReprintManifest.addActionListener(menuListener);
        this.menuWithDrawal.setActionCommand(String.valueOf(7));
        this.menuWithDrawal.addActionListener(menuListener);
        this.menuExpense.setActionCommand(String.valueOf(8));
        this.menuExpense.addActionListener(menuListener);
        this.menuCustOrder.setActionCommand(String.valueOf(12));
        this.menuCustOrder.addActionListener(menuListener);
        this.menuFile.addActionListener(menuListener);
        ActionListener functionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PosFrame.this.menuFunc_actionPerformed(e);
            }
        };
        this.menuPersonMaintenance.setActionCommand(String.valueOf(5));
        this.menuPersonMaintenance.addActionListener(functionListener);
        this.menuPersonLoyaltyAmounts.setActionCommand(String.valueOf(23));
        this.menuPersonLoyaltyAmounts.addActionListener(functionListener);
        this.menuPersonRedeemRewardsGift.setActionCommand(String.valueOf(25));
        this.menuPersonRedeemRewardsGift.addActionListener(functionListener);
        this.menuPersonOfflineKey.setActionCommand(String.valueOf(28));
        this.menuPersonOfflineKey.addActionListener(functionListener);
        if (this.isUsingAlternativePersonMaint()) {
            this.menuDisableAlternativePersonMaint.setActionCommand(String.valueOf(24));
            this.menuDisableAlternativePersonMaint.addActionListener(functionListener);
        }
        this.menuClockOff.setActionCommand(String.valueOf(4));
        this.menuClockOff.addActionListener(functionListener);
        this.menuClockOffAll.setActionCommand(String.valueOf(6));
        this.menuClockOffAll.addActionListener(functionListener);
        this.menuNotes.setActionCommand(String.valueOf(7));
        this.menuNotes.addActionListener(functionListener);
        this.menuHistAll.setActionCommand(String.valueOf(12));
        this.menuHistAll.addActionListener(functionListener);
        this.menuHistHome.setActionCommand(String.valueOf(11));
        this.menuHistHome.addActionListener(functionListener);
        this.menuReprint.setActionCommand(String.valueOf(13));
        this.menuReprint.addActionListener(functionListener);
        this.menuOpenTill.setActionCommand(String.valueOf(10));
        this.menuOpenTill.addActionListener(functionListener);
        this.menuImages.setActionCommand(String.valueOf(14));
        this.menuImages.addActionListener(functionListener);
        this.menuSlideShow.setActionCommand(String.valueOf(15));
        this.menuSlideShow.addActionListener(functionListener);
        this.menuFITSessions.setActionCommand(String.valueOf(30));
        this.menuFITSessions.addActionListener(functionListener);
        this.menuBudget.setActionCommand(String.valueOf(16));
        this.menuBudget.addActionListener(functionListener);
        this.menuPackOrders.setActionCommand(String.valueOf(19));
        this.menuPackOrders.addActionListener(functionListener);
        this.menuGVBalanceEnquiry.setActionCommand(String.valueOf(17));
        this.menuGVBalanceEnquiry.addActionListener(functionListener);
        this.menuCNEnquiry.setActionCommand(String.valueOf(18));
        this.menuCNEnquiry.addActionListener(functionListener);
        this.menuTurnOffPromotions.setActionCommand(String.valueOf(20));
        this.menuTurnOffPromotions.addActionListener(functionListener);
        this.menuLabelPrinting.setActionCommand(String.valueOf(21));
        this.menuLabelPrinting.addActionListener(functionListener);
        this.menuReassignDespatch.setActionCommand(String.valueOf(22));
        this.menuReassignDespatch.addActionListener(functionListener);
        this.menuRemoveTax.setActionCommand(String.valueOf(26));
        this.menuRemoveTax.addActionListener(functionListener);
        this.menuRefundFloorToDoorOrder.setActionCommand(String.valueOf(27));
        this.menuRefundFloorToDoorOrder.addActionListener(functionListener);
        this.menuFunc.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                PosFrame.this.updateTurnOffPromotionsMenuItemCaption();
            }
        });
        this.menuPerson.add(this.menuPersonMaintenance);
        this.menuPerson.add(this.menuPersonSeparator);
        this.menuPerson.add(this.menuPersonLoyaltyAmounts);
        this.menuPerson.add(this.menuPersonRedeemRewardsGift);
        if (this.isUsingAlternativePersonMaint()) {
            this.menuPerson.add(this.menuDisableAlternativePersonMaint);
        }
        this.menuPerson.add(this.menuPersonOfflineKey);
        this.menuPersonSeparator.setVisible(false);
        this.menuPersonLoyaltyAmounts.setVisible(false);
        this.menuPersonRedeemRewardsGift.setVisible(false);
        this.menuPersonOfflineKey.setVisible(!PersonCrypt.getInstance().keyExists());
        this.menuFunc.add(this.menuNotes);
        this.menuFunc.add(this.menuHistAll);
        this.menuFunc.add(this.menuHistHome);
        this.menuFunc.add(this.menuReprint);
        this.menuFunc.add(this.menuOpenTill);
        if (this.frameType != 8 && this.frameType != 7 && this.frameType != 6 && this.frameType != 14 && this.frameType != 15) {
            this.menuFunc.add(this.menuImages);
        }
        this.menuFunc.add(this.menuSlideShow);
        if (this.sParams.bUsingBudgets) {
            this.menuFunc.add(this.menuBudget);
        }
        this.menuOrders.add(this.menuPackOrders);
        if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.CREATE_FLOOR_TO_DOOR_ORDERS)) {
            this.menuOrders.add(this.menuRefundFloorToDoorOrder);
        }
        String sessionsOn = "";
        if (this.frameType == 1 || this.frameType == 12) {
            try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT COALESCE(PARLNKIDX,0) as PARLNKIDX FROM SYSPARAM WHERE PARIDX = 824;");){
                if (sql.next()) {
                    sessionsOn = sql.getString("PARLNKIDX");
                }
            }
            catch (SQLException ex) {
                PosUtils.logError(ex);
            }
        }
        if (sessionsOn != null && sessionsOn.equals("1") && this.sParams.bMyFit) {
            this.menuOrders.add(this.menuFITSessions);
        }
        this.menuFunc.add(this.menuGVBalanceEnquiry);
        this.menuFunc.add(this.menuCNEnquiry);
        this.menuFunc.add(this.menuTurnOffPromotions);
        this.menuTurnOffPromotions.setVisible(false);
        if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.LABEL_PRINTING)) {
            this.menuFunc.add(this.menuLabelPrinting);
        }
        if (this.frameType == 12 && SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.SHIP_FROM_STORE) > 0L) {
            this.menuOrders.add(this.menuReassignDespatch);
        }
        if ((this.frameType == 1 || this.frameType == 12) && this.sParams.bCanRemoveTax) {
            this.menuFunc.add(this.menuRemoveTax);
        }
        PosMenu reports = null;
        int reportMenucount = 0;
        for (int i = 0; i < this.sParams.menuReports.size(); ++i) {
            if (i % 16 == 0) {
                reports = new PosMenu();
                reports.setActionCommand("report");
                reports.addActionListener(functionListener);
                reports.setText(StoreParams.res.getString("Reports") + (reportMenucount == 0 ? "" : " " + (reportMenucount + 1)));
                this.reportMenus.add(reports);
                ++reportMenucount;
            }
            PosMenuItem menuRunScript = new PosMenuItem(this.sParams.menuReports.elementAt(i).getText());
            menuRunScript.setActionCommand(this.sParams.menuReports.elementAt(i).getActionCommand());
            menuRunScript.addActionListener(functionListener);
            reports.add(menuRunScript);
        }
        this.menuFile.setText(StoreParams.res.getString("File"));
        this.menuFileExit.setText(StoreParams.res.getString("Exit"));
        this.menuFileExit.setActionCommand(String.valueOf(-1));
        this.menuFileExit.addActionListener(menuListener);
        this.menuFunc.setText(StoreParams.res.getString("Functions"));
        this.menuOrders.setText(StoreParams.res.getString("Orders"));
        this.menuEFTPOS.setText(StoreParams.res.getString("EFTPOS"));
        this.menuHelp.setText(StoreParams.res.getString("Help"));
        this.menuHelpAbout.setText(StoreParams.res.getString("About"));
        this.menuHelpTopics.setText(StoreParams.res.getString("Help_Topics"));
        this.menuHelpOnlineTraining.setText(StoreParams.res.getString("Online_Training"));
        ActionListener helplistener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PosFrame.this.menuHelp_actionPerformed(e);
            }
        };
        this.menuHelpAbout.addActionListener(helplistener);
        this.menuHelpAbout.setActionCommand("about");
        this.menuHelpTopics.addActionListener(helplistener);
        this.menuHelpTopics.setActionCommand("topics");
        this.menuHelpOnlineTraining.addActionListener(helplistener);
        this.menuHelpOnlineTraining.setActionCommand("online_training");
        this.menuKeys.setText(StoreParams.res.getString("Hot_Keys"));
        this.menuKeys.addActionListener(helplistener);
        this.menuKeys.setActionCommand("keys");
        this.menuSales.setText(StoreParams.res.getString("Sales"));
        this.menuDebtorSale.setText(StoreParams.res.getString("Debtor_Sale"));
        this.menuTransfersOut.setText(StoreParams.res.getString("Transfers_Out"));
        this.menuTransfersIn.setText(StoreParams.res.getString("Transfers_In"));
        this.menuQuickReceipts.setText(StoreParams.res.getString("Quick_Receipts"));
        this.menuCartonReceipt.setText(StoreParams.res.getString("Carton_Receipt"));
        this.menuTransferRequests.setText(StoreParams.res.getString("Transfer_Requests"));
        this.menuStkEnquiry.setText(StoreParams.res.getString("Stock_Enquiry"));
        this.menuStkReservation.setText(StoreParams.res.getString("Stock_Reservations"));
        this.menuStkTake.setText(StoreParams.res.getString("Stock_Take"));
        this.menuAustPostFunctions.setText(StoreParams.res.getString("Carrier_Menu_Header"));
        this.menuAusGenManifest.setText(StoreParams.res.getString("AusPost_Gen_Manifest"));
        this.menuAusReprintManifest.setText(StoreParams.res.getString("AusPost_Reprint_Manifest"));
        this.menuTillBalanceFunctions.setText(StoreParams.res.getString("End_of_Day_Functions"));
        this.menuTillBalance.setText(TillBalanceUtils.TillBalanceType.TILL_BALANCE.getDisplayValue());
        this.menuTillBalanceStartOfDay.setText(TillBalanceUtils.TillBalanceType.START_OF_DAY.getDisplayValue());
        this.menuTillBalanceEndOfDay.setText(TillBalanceUtils.TillBalanceType.END_OF_DAY.getDisplayValue());
        this.menuPettyCash.setText(StoreParams.res.getString("Petty_Cash"));
        this.menuWithDrawal.setText(StoreParams.res.getString("Withdrawal"));
        this.menuExpense.setText(StoreParams.res.getString("Expense"));
        this.menuCustOrder.setText(StoreParams.res.getString("Customer_Orders"));
        this.menuFile.setMnemonic(70);
        if (this.frameType != 1 && Settings.isScreenEnabled(1)) {
            this.menuFile.add(this.menuSales);
        }
        if (this.sParams.bUsingDebtorSale && this.frameType != 10 && Settings.isScreenEnabled(10)) {
            this.menuFile.add(this.menuDebtorSale);
        }
        if (this.sParams.bUsingCustOrders && this.frameType != 12 && Settings.isScreenEnabled(12)) {
            this.menuFile.add(this.menuCustOrder);
        }
        if (Settings.isScreenEnabled(7) || Settings.isScreenEnabled(8)) {
            this.menuFile.add(this.menuPettyCash);
        }
        if (this.frameType != 7 && Settings.isScreenEnabled(7)) {
            this.menuPettyCash.add(this.menuWithDrawal);
        }
        if (this.frameType != 8 && Settings.isScreenEnabled(8)) {
            this.menuPettyCash.add(this.menuExpense);
        }
        if (Settings.isUsingAusPostIntegration()) {
            if (Settings.isScreenEnabled(16) || Settings.isScreenEnabled(17)) {
                this.menuFile.add(this.menuAustPostFunctions);
            }
            if (this.frameType != 16 && Settings.isScreenEnabled(16)) {
                this.menuAustPostFunctions.add(this.menuAusGenManifest);
            }
            if (this.frameType != 17 && Settings.isScreenEnabled(17)) {
                this.menuAustPostFunctions.add(this.menuAusReprintManifest);
            }
        }
        if (this.frameType != 2 && Settings.isScreenEnabled(2)) {
            this.menuFile.add(this.menuTransfersOut);
        }
        if (this.frameType != 3 && Settings.isScreenEnabled(3)) {
            this.menuFile.add(this.menuTransfersIn);
        }
        if (this.frameType != 13 && Settings.isScreenEnabled(13)) {
            this.menuFile.add(this.menuQuickReceipts);
        }
        if (this.frameType != 9 && Settings.isScreenEnabled(9)) {
            this.menuFile.add(this.menuTransferRequests);
        }
        if (this.frameType != 4 && Settings.isScreenEnabled(4)) {
            this.menuFile.add(this.menuStkEnquiry);
        }
        if (this.frameType != 11 && Settings.isScreenEnabled(11)) {
            this.menuFile.add(this.menuStkReservation);
        }
        if (this.frameType != 5 && Settings.isScreenEnabled(5)) {
            this.menuFile.add(this.menuStkTake);
        }
        if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.ENFORCE_START_OF_DAY_TILL_BALANCE)) {
            if (Settings.isScreenEnabled(6) || Settings.isScreenEnabled(14) || Settings.isScreenEnabled(15)) {
                this.menuFile.add(this.menuTillBalanceFunctions);
            }
            if (this.frameType != 6 && Settings.isScreenEnabled(6)) {
                this.menuTillBalanceFunctions.add(this.menuTillBalance);
            }
            if (this.frameType != 14 && Settings.isScreenEnabled(14)) {
                this.menuTillBalanceFunctions.add(this.menuTillBalanceStartOfDay);
            }
            if (this.frameType != 15 && Settings.isScreenEnabled(15)) {
                this.menuTillBalanceFunctions.add(this.menuTillBalanceEndOfDay);
            }
        } else if (this.frameType != 6 && Settings.isScreenEnabled(6)) {
            this.menuFile.add(this.menuTillBalance);
        }
        this.menuFile.addSeparator();
        this.menuFile.add(this.menuFileExit);
        this.menuHelp.add(this.menuHelpAbout);
        this.menuHelp.add(this.menuKeys);
        this.menuHelp.add(this.menuHelpTopics);
        this.menuHelp.add(this.menuHelpOnlineTraining);
        this.menuPerson.setText(StoreParams.res.getString("Person"));
        this.menuPersonMaintenance.setText(StoreParams.res.getString("Person_Maint"));
        this.menuPersonLoyaltyAmounts.setText(RewardsUtils.usingAp21RetailRewards() ? SP.getRS("Redeem_Rewards") : SP.getRS("Person_Loyalty_Amount"));
        this.menuPersonLoyaltyAmounts.setAccelerator(KeyStroke.getKeyStroke(73, 8));
        this.menuPersonRedeemRewardsGift.setText(SP.getRS("Redeem_Gift"));
        this.menuPersonRedeemRewardsGift.setAccelerator(KeyStroke.getKeyStroke(74, 8));
        this.menuDisableAlternativePersonMaint.setText(this.isAlternativePersonMaintEnabled() ? SP.getRS("Disable_Alternative_Person_Maint") : SP.getRS("Enable_Alternative_Person_Maint"));
        this.menuPersonOfflineKey.setText(StoreParams.res.getString("Offline_Key_Acquire"));
        this.menuImages.setText(StoreParams.res.getString("ShowHideImages"));
        this.menuSlideShow.setText(StoreParams.res.getString("ShowHideSlideShow"));
        this.menuBudget.setText(StoreParams.res.getString("ShowHideStoreBudgets"));
        this.menuBudget.setAccelerator(KeyStroke.getKeyStroke(66, 8));
        this.menuPackOrders.setText(StoreParams.res.getString("Pack_Despatch_Orders"));
        this.menuPackOrders.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        this.menuFITSessions.setText(StoreParams.res.getString("My_Fit_Sessions_Button"));
        this.menuFITSessions.setAccelerator(KeyStroke.getKeyStroke(77, 8));
        this.menuGVBalanceEnquiry.setText(StoreParams.res.getString("Gift_Voucher_Balance_Enquiry"));
        this.menuGVBalanceEnquiry.setAccelerator(KeyStroke.getKeyStroke(71, 8));
        this.menuCNEnquiry.setText(StoreParams.res.getString("Credit_Note_Enquiry"));
        this.menuCNEnquiry.setAccelerator(KeyStroke.getKeyStroke(69, 8));
        this.menuClockOff.setText(StoreParams.res.getString("Clock_Off"));
        this.menuClockOffAll.setText(StoreParams.res.getString("Clock_Off_All"));
        this.menuNotes.setText(StoreParams.res.getString("Notes"));
        this.menuNotes.setAccelerator(KeyStroke.getKeyStroke(78, 8));
        this.menuHistAll.setText(StoreParams.res.getString("History_All"));
        this.menuHistAll.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        this.menuHistHome.setText(StoreParams.res.getString("History_Own"));
        this.menuHistHome.setAccelerator(KeyStroke.getKeyStroke(72, 8));
        this.menuReprint.setText(StoreParams.res.getString("Reprint_Trans"));
        this.menuReprint.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        this.menuOpenTill.setText(StoreParams.res.getString("Open_Till"));
        this.menuOpenTill.setAccelerator(KeyStroke.getKeyStroke(84, 8));
        this.menuLabelPrinting.setText(StoreParams.res.getString("Label_Printing"));
        this.menuReassignDespatch.setText(StoreParams.res.getString("Reassign_Despatch_Store"));
        this.menuReassignDespatch.setAccelerator(KeyStroke.getKeyStroke(82, 8));
        this.menuRemoveTax.setText(StoreParams.res.getString("Remove_tax"));
        this.menuRefundFloorToDoorOrder.setText(StoreParams.res.getString("Refund_Floor_To_Door_Order"));
        this.menuBar.add(this.menuFile);
        this.menuBar.add(this.menuFunc);
        this.menuBar.add(this.menuOrders);
        this.menuBar.add(this.menuPerson);
        for (PosMenu menu : this.reportMenus) {
            this.menuBar.add(menu);
        }
        this.menuBar.add(this.menuEFTPOS);
        this.configureEftposMenu();
        if ((this.frameType == 1 || this.frameType == 12) && (taxLookup = TaxLookupFactory.getTaxLookup()) != null) {
            this.taxMenu = taxLookup.getMenu(this);
            if (this.taxMenu != null) {
                this.menuBar.add(this.taxMenu);
            }
        }
        this.menuBar.add(this.menuHelp);
        this.setJMenuBar(this.menuBar);
        this.setTransType();
        PersonCrypt.getInstance().SetAcquiredAction(this.menuPersonOfflineKey, new Runnable(){

            @Override
            public void run() {
                if (PosFrame.this.menuPersonOfflineKey.isVisible()) {
                    PosFrame.this.menuPersonOfflineKey.setVisible(false);
                }
            }
        });
    }

    public void configureEftposMenu() {
        if (this.sParams.integratedEFT && this.sParams.isEFTPOSLoggedIn) {
            JMenuItem menuItem;
            Component comp;
            int i;
            this.menuEFTPOS.removeAll();
            this.sParams.eftpos.getMenu((JMenu)this.menuEFTPOS, this.menuEFTPOSListener);
            PosMenuItem reverseCompleteMenuItem = new PosMenuItem();
            reverseCompleteMenuItem.setActionCommand("REVERSE_INCOMPLETE");
            reverseCompleteMenuItem.addActionListener(this.menuEFTPOSListener);
            reverseCompleteMenuItem.setText(StoreParams.res.getString("Reverse_Incomplete_Transactions"));
            Dimension dimension = reverseCompleteMenuItem.getPreferredSize();
            for (i = 0; i < this.menuEFTPOS.getMenuComponentCount(); ++i) {
                comp = this.menuEFTPOS.getMenuComponent(i);
                if (!(comp instanceof JMenuItem)) continue;
                menuItem = (JMenuItem)comp;
                Dimension compDimension = menuItem.getPreferredSize();
                if (compDimension.width > dimension.width) {
                    dimension.width = compDimension.width;
                }
                if (compDimension.height <= dimension.height) continue;
                dimension.height = compDimension.height;
            }
            reverseCompleteMenuItem.setPreferredSize(dimension);
            for (i = 0; i < this.menuEFTPOS.getMenuComponentCount(); ++i) {
                comp = this.menuEFTPOS.getMenuComponent(i);
                if (!(comp instanceof JMenuItem)) continue;
                menuItem = (JMenuItem)comp;
                menuItem.setPreferredSize(dimension);
            }
            this.menuEFTPOS.add(reverseCompleteMenuItem);
        }
        this.menuEFTPOS.setVisible(this.sParams.integratedEFT);
    }

    public boolean completeTrans() {
        if (!this.isLoggedIn(false)) {
            return false;
        }
        this.setFocus();
        if (!this.validateTrans()) {
            return false;
        }
        if (this.getUser().isTraningUser()) {
            new DlgDummyPrinter(this, StoreParams.res.getString("Printing_Receipt"), false);
        } else {
            this.setTransnums();
            if (!this.completeTrans(true)) {
                return false;
            }
        }
        if (!SP.sParams.bDoingNewSave) {
            this.finishTransaction(!(this instanceof FrTillBalance));
        }
        return true;
    }

    public void finishTransaction() {
        this.finishTransaction(true);
    }

    public void finishTransaction(final boolean logout) {
        if (!this.getUser().isTraningUser()) {
            try {
                for (int i = 0; i < this.notes.size(); ++i) {
                    Note note = this.notes.elementAt(i);
                    if (note.nLogidx != 0L) continue;
                    note.noteType.setKeyIdx(this.vhidx, true);
                    note.db_save();
                }
            }
            catch (SQLException ex) {
                PosUtils.logError(ex);
            }
            this.printReceipt(false);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PosFrame.this.voidTrans(logout);
                PosFrame.this.setCursor(StoreParams.normalCursor);
                if (PosFrame.this.frameType == 1 || PosFrame.this.frameType == 10 || PosFrame.this.frameType == 12 || PosFrame.this.frameType == 8) {
                    PosFrame.this.checkTillAmts();
                }
            }
        });
    }

    public void setTransType(int type) {
        this.transType = type;
    }

    public void voidTrans(boolean logout) {
        this.docknum = null;
        this.transnum = null;
        this.ownerCurrency = null;
        this.partialCCAllowed = false;
        this.transactionAvailable = false;
        this.setEditable(true);
        this.setVhidx(-1L);
        this.setTransType();
        this.clearScreenLocks();
        this.notes.clear();
        for (int i = 0; i < this.noteTypes.size(); ++i) {
            this.noteTypes.elementAt(i).setKeyIdx(0L, true);
        }
        if (this.paHead.voidTrans(logout)) {
            return;
        }
        this.setFocus();
    }

    void menuHelp_actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("about")) {
            DlgAbout dlgAbout = new DlgAbout(this, StoreParams.res.getString("Bass_Software_Pty_Ltd"), true);
            dlgAbout.setVisible(true);
        } else if (e.getActionCommand().equals("keys")) {
            DlgKeys dlgKeys = new DlgKeys(this, StoreParams.res.getString("Hot_Keys"), true);
            dlgKeys.setVisible(true);
        } else if (e.getActionCommand().equals("topics")) {
            this.sParams.runHelp();
        } else if (e.getActionCommand().equals("online_training")) {
            this.sParams.runOnlineTraining();
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        switch (e.getID()) {
            case 201: {
                if (!this.checkExit()) {
                    return;
                }
                if (this.menu.frames.size() == 1 && !this.checkUsers()) {
                    return;
                }
                this.dispose();
                break;
            }
            case 205: {
                this.setLastAction();
                this.menu.setOpenFrame(this);
            }
        }
        super.processWindowEvent(e);
    }

    public void menuFile_actionPerformed(ActionEvent e) {
        int screenToLoad = PosUtils.intVal(e.getActionCommand());
        if (screenToLoad == -1) {
            this.menu.removeAll(true);
            return;
        }
        if (screenToLoad == 10 && !this.sParams.checkIConn()) {
            DlgMessage dlgMessage = new DlgMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
            int response = dlgMessage.showMessage();
            if (response != 0) {
                return;
            }
            return;
        }
        if (screenToLoad == 16 && !this.sParams.checkIConn()) {
            DlgMessage dlgMessage = new DlgMessage(this, StoreParams.res.getString("AusPost_Gen_Manifest"), StoreParams.res.getString("Offline"), 2, 1);
            int response = dlgMessage.showMessage();
            if (response != 0) {
                return;
            }
            System.out.println();
            return;
        }
        if (screenToLoad == 17 && !this.sParams.checkIConn()) {
            DlgMessage.showMessage(this, "AusPost_Reprint_Manifest", StoreParams.res.getString("Offline"), -1, 1);
            return;
        }
        if (screenToLoad == 6 || screenToLoad == 14 || screenToLoad == 15) {
            int currentScreen = PosMenuController.getInstance().getOpenFrame().frameType;
            if (currentScreen != 6 && currentScreen != 14 && currentScreen != 15 && DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("This_will_close_all"), "\n"), StoreParams.res.getString("Till_Balance"), 0, 3) != 0) {
                return;
            }
            if (!this.menu.removeAll(false)) {
                return;
            }
        }
        this.menu.openFrame(screenToLoad, true, this.getUser());
    }

    /*
     * Unable to fully structure code
     */
    void menuFunc_actionPerformed(ActionEvent e) {
        tokens = new StringTokenizer(e.getActionCommand(), "@");
        menuSelection = PosUtils.intVal(tokens.nextToken());
        switch (menuSelection) {
            case 5: {
                if (!this.isLoggedIn(true)) break;
                try {
                    permaint = new PersonDlgProxy(this, SP.getRS("Person_Maint"), new Element("person"), this.getSecurity(11106L), this.getSecurity(11104L), 0L, false, SP.getRS("Done"));
                    var5_14 = null;
                    permaint.setVisible(true);
                    if (permaint == null) break;
                    if (var5_14 == null) ** GOTO lbl19
                    try {
                        permaint.close();
                    }
                    catch (Throwable var6_19) {
                        var5_14.addSuppressed(var6_19);
                    }
                    break;
lbl19:
                    // 1 sources

                    permaint.close();
                    ** break;
                    catch (Throwable var6_20) {
                        try {
                            var5_14 = var6_20;
                            throw var6_20;
                        }
                        catch (Throwable var7_25) {
                            if (permaint != null) {
                                if (var5_14 != null) {
                                    try {
                                        permaint.close();
                                    }
                                    catch (Throwable var8_27) {
                                        var5_14.addSuppressed(var8_27);
                                    }
                                } else {
                                    permaint.close();
                                }
                            }
                            throw var7_25;
lbl36:
                            // 1 sources

                        }
                    }
                }
                catch (Exception ex) {
                    PosUtils.logError(ex);
                }
                break;
            }
            case 8: {
                if (!this.sParams.checkIConn()) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
                    return;
                }
            }
            case 9: {
                if (!this.isLoggedIn(true)) break;
                genrepidx = PosUtils.longVal(tokens.nextToken());
                report = new RemPosReport(this.sParams.conn, this, true, this.getUser().getMemidx(), genrepidx, this.sParams);
                report.setVisible(true);
                break;
            }
            case 4: {
                memidx = -1L;
                memidx = this.paHead.clockOff();
                if (memidx <= -1L) break;
                this.menu.logoff(memidx);
                break;
            }
            case 6: {
                dlgClockOff = new DlgClockAll(this, StoreParams.res.getString("Clock_Off_All"), true, this.getUser().isFingerprintLogin());
                if (dlgClockOff.tblUsers.getRowCount() == 0) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("no_other_users"), StoreParams.res.getString("Clock_Off_All"), -1, 1);
                    dlgClockOff.dispose();
                    dlgClockOff = null;
                    break;
                }
                dlgClockOff.setVisible(true);
                break;
            }
            case 7: {
                if (!this.isLoggedIn(true)) break;
                this.setNotes(this.noteTypes);
                break;
            }
            case 10: {
                if (!this.isLoggedIn(true)) break;
                this.openTill();
                break;
            }
            case 12: {
                if (!this.isLoggedIn(true)) break;
                this.search(true);
                if (!this.bCanceled) {
                    this.setFITVisible(false);
                }
                this.bCanceled = false;
                break;
            }
            case 11: {
                if (!this.isLoggedIn(true)) break;
                this.search(false);
                if (!this.bCanceled) {
                    this.setFITVisible(false);
                }
                this.bCanceled = false;
                break;
            }
            case 13: {
                if (!this.isLoggedIn(true)) break;
                this.reprintReceipt();
                break;
            }
            case 14: {
                if (!this.isLoggedIn(true)) break;
                this.ToggleImage();
                break;
            }
            case 15: {
                if (!this.isLoggedIn(true)) break;
                this.ToggleSlideshow();
                break;
            }
            case 16: {
                if (!this.isLoggedIn(true)) break;
                if (!this.hasSecurity(11152L, 0)) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Store_Budget"), -1, 0);
                    break;
                }
                this.ToggleBudget();
                break;
            }
            case 19: {
                if (!this.isLoggedIn(true)) break;
                this.paHead.panelOutstandingOrders.openCustOrdersToPack();
                break;
            }
            case 30: {
                if (!this.isLoggedIn(true) || !(this instanceof FrSales)) break;
                ((FrSales)this).MyFITSessions();
                break;
            }
            case 17: {
                if (!this.isLoggedIn(true)) break;
                if (!this.hasSecurity(11155L, 0)) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Gift_Voucher_Balance_Enquiry"), -1, 0);
                    break;
                }
                voucherBalanceAdapter = new VoucherBalanceAdapter(this);
                d = new DlgVoucherIssue(this, StoreParams.res.getString("Gift_Voucher_Balance_Enquiry"), voucherBalanceAdapter);
                d.setVisible(true);
                d.dispose();
                break;
            }
            case 18: {
                if (!this.isLoggedIn(true)) break;
                if (!this.hasSecurity(11158L, 0)) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Credit_Note_Enquiry"), -1, 0);
                    break;
                }
                creditNoteBalanceAdapter = new CreditNoteBalanceAdapter(this);
                d = new DlgVoucherIssue(this, StoreParams.res.getString("Credit_Note_Enquiry"), creditNoteBalanceAdapter);
                d.setVisible(true);
                d.dispose();
                break;
            }
            case 20: {
                if (!this.isLoggedIn(true)) break;
                if (this.promotionsEnabled && !Security.hasSecurity(this, 11162L, this.paHead.frParent.getUser().getMemidx(), 0, true)) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Turn_Off_Promotions"), -1, 0);
                    break;
                }
                this.promotionsEnabled = this.promotionsEnabled == false;
                this.refreshTransaction();
                break;
            }
            case 21: {
                if (!this.isLoggedIn(true)) break;
                labelDialog = LabelDialogType.SINGLE.generateDialog(this);
                while (labelDialog != null) {
                    labelDialog.showDialog();
                    labelDialog = labelDialog.getNextDialogType().generateDialog(this);
                }
                break;
            }
            case 22: {
                if (!(this instanceof FrSales)) break;
                ((FrSales)this).reassignDespatchLocation();
                break;
            }
            case 24: {
                if (!this.isLoggedIn(true)) break;
                this.omneoPersonMaintIsEnabled = this.omneoPersonMaintIsEnabled == false;
                this.capillaryMicrositeIsEnabled = this.capillaryMicrositeIsEnabled == false;
                this.menuDisableAlternativePersonMaint.setText(this.isAlternativePersonMaintEnabled() != false ? SP.getRS("Disable_Alternative_Person_Maint") : SP.getRS("Enable_Alternative_Person_Maint"));
                break;
            }
            case 26: {
                ((FrSales)this).removeTax();
                break;
            }
            case 27: {
                frameType = this.menu.getFrameType(714, null);
                frame = this.menu.openFrame(frameType, true, this.menu.getOpenFrame().getUser());
                if (frame == null) break;
                ((FrSales)frame).refundFloorToDoorOrder();
                break;
            }
            case 28: {
                PersonCrypt.getInstance().setRequestOfflineKey(true);
                PersonCrypt.getInstance().acquireKey(this);
                break;
            }
            case 29: {
                if (!this.isLoggedIn(true)) break;
                if (Security.hasSecurity(this, 11180L, this.paHead.frParent.getUser().getMemidx(), 0, true)) {
                    url = tokens.nextToken().replaceAll("^(.*:\\/\\/)?", "https://");
                    try {
                        code = tokens.nextToken();
                    }
                    catch (NoSuchElementException ex) {
                        code = "";
                    }
                    try {
                        uriBuilder = new URIBuilder(url);
                        uriBuilder.setPath("/login");
                        uriBuilder.addParameter("code", code);
                        uriBuilder.addParameter("id", ApiKeys.THE_RETAIL_SCORE.getKey());
                        finalUrl = uriBuilder.build().toString();
                        insightBrowser = (BrowserFrame)this.menu.showOtherWindow("ap21insight", (Supplier<JFrame>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$menuFunc_actionPerformed$0(), ()Ljavax/swing/JFrame;)());
                        insightBrowser.setUrl(finalUrl);
                    }
                    catch (URISyntaxException ex) {
                        DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("invalid_url"), new Object[]{url}), SP.getRS("Ap21_Insight"), -1, 0);
                    }
                    break;
                }
                DlgMessage.showMessage(this, SP.getRS("no_security"), SP.getRS("Ap21_Insight"), -1, 0);
                break;
            }
            default: {
                this.functionMenuUnhandledActionPerformed(menuSelection);
            }
        }
    }

    private void reprintReceipt() {
        if (this.vhidx > 0L) {
            if (!this.hasSecurity(11124L, 0)) {
                DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Reprint_Trans"), -1, 0);
            } else if (this instanceof FrSales && ((FrSales)this).retailEmailReceiptTriggerExists()) {
                PayUtils.ReceiptDeliveryMethod deliveryMethod = PayUtils.ReceiptDeliveryMethod.PRINT_ONLY;
                boolean valid = false;
                String originalEmail = null;
                if (this instanceof FrSales) {
                    originalEmail = ((FrSales)this).getAttachedPersonEmail();
                }
                String newEmail = "";
                ReceiptReDeliveryMethodDlg dlg = new ReceiptReDeliveryMethodDlg(this, deliveryMethod, ((FrSales)this).isSaleOrder(), ((FrSales)this).isLocalTransaction(), originalEmail, null, null);
                if ((deliveryMethod = dlg.getDeliveryMethod()) != null) {
                    newEmail = dlg.getEmail();
                    this.setCursor(StoreParams.waitCursor);
                    if (deliveryMethod == PayUtils.ReceiptDeliveryMethod.EMAIL_AND_PRINT) {
                        ((FrSales)this).sendRetailEmailReceipt(originalEmail, newEmail, PayUtils.ReceiptDeliveryMethod.EMAIL_AND_PRINT);
                        this.printReceipt(true);
                    } else if (deliveryMethod == PayUtils.ReceiptDeliveryMethod.PRINT_ONLY) {
                        this.printReceipt(true);
                    } else if (deliveryMethod == PayUtils.ReceiptDeliveryMethod.EMAIL_ONLY) {
                        ((FrSales)this).sendRetailEmailReceipt(originalEmail, newEmail, PayUtils.ReceiptDeliveryMethod.EMAIL_ONLY);
                    } else if (deliveryMethod == PayUtils.ReceiptDeliveryMethod.PRINT_GIFT_ONLY) {
                        Receipt receipt = new Receipt(this, StoreParams.res.getString("Printing_Receipt"), false, this.sParams.getDocketConnection(), this.vhidx, true);
                        receipt.PrintGiftPurchDoc(((FrSales)this).person.getAttribute("peridx") != null ? ((FrSales)this).person : null);
                    } else if (deliveryMethod == PayUtils.ReceiptDeliveryMethod.EMAIL_AND_PRINT_GIFT) {
                        ((FrSales)this).sendRetailEmailReceipt(originalEmail, newEmail, PayUtils.ReceiptDeliveryMethod.EMAIL_ONLY);
                        Receipt receipt = new Receipt(this, StoreParams.res.getString("Printing_Receipt"), false, this.sParams.getDocketConnection(), this.vhidx, true);
                        receipt.PrintGiftPurchDoc(((FrSales)this).person.getAttribute("peridx") != null ? ((FrSales)this).person : null);
                    } else if (deliveryMethod == PayUtils.ReceiptDeliveryMethod.PRINT_AND_PRINT_GIFT) {
                        Receipt receipt = new Receipt(this, StoreParams.res.getString("Printing_Receipt"), false, this.sParams.getDocketConnection(), this.vhidx, true);
                        receipt.PrintGiftPurchDoc(((FrSales)this).person.getAttribute("peridx") != null ? ((FrSales)this).person : null);
                        this.printReceipt(true);
                    } else if (deliveryMethod == PayUtils.ReceiptDeliveryMethod.EMAIL_AND_PRINT_AND_PRINT_GIFT) {
                        ((FrSales)this).sendRetailEmailReceipt(originalEmail, newEmail, PayUtils.ReceiptDeliveryMethod.EMAIL_AND_PRINT);
                        Receipt receipt = new Receipt(this, StoreParams.res.getString("Printing_Receipt"), false, this.sParams.getDocketConnection(), this.vhidx, true);
                        receipt.PrintGiftPurchDoc(((FrSales)this).person.getAttribute("peridx") != null ? ((FrSales)this).person : null);
                        this.printReceipt(true);
                    }
                    this.setCursor(StoreParams.normalCursor);
                }
            } else {
                this.setCursor(StoreParams.waitCursor);
                this.printReceipt(true);
                this.setCursor(StoreParams.normalCursor);
            }
        } else if (this.frameType == 11) {
            DlgMessage.showMessage(this, StoreParams.res.getString("select_line"), StoreParams.res.getString("Reprint"), -1, 1);
        } else {
            DlgMessage.showMessage(this, StoreParams.res.getString("select_transeaction"), StoreParams.res.getString("Reprint"), -1, 1);
        }
    }

    public void functionMenuUnhandledActionPerformed(int menuSelection) {
    }

    private void updateTurnOffPromotionsMenuItemCaption() {
        if (this.promotionsEnabled) {
            this.menuTurnOffPromotions.setText(StoreParams.res.getString("Turn_Off_Promotions"));
        } else {
            this.menuTurnOffPromotions.setText(StoreParams.res.getString("Turn_On_Promotions"));
        }
    }

    protected void logoff(long memidx) {
        this.paHead.logoff(memidx);
    }

    void setVhidx(long val) {
        this.vhidx = val;
    }

    public long getVhidx() {
        return this.vhidx;
    }

    public long getSordidx() {
        return this.sordidx;
    }

    public void setTransnum(String pnum) {
        this.transnum = pnum;
    }

    protected void setTransnums() {
        try {
            if (!this.sParams.bDoingNewSave && this.frameType != 13) {
                this.setDocketnum();
            }
            this.setTransnum();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    protected void setDocketnum() {
        try {
            this.docknum = PosUtils.padZeroes(this.sParams.getNextDocketNum("PosFrame.setDocketnum, Screen " + PosMenuController.getScreenName(this.frameType)), 8);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public void setStatus(boolean online) {
        if (online) {
            this.setTitle(this.title + StoreParams.res.getString("_Status_ONLINE"));
        } else {
            this.setTitle(this.title + StoreParams.res.getString("_Status_OFFLINE"));
        }
        this.paHead.setStatus(online);
    }

    public boolean hasSecurity(long secidx, int secLevel) {
        return this.paHead.hasSecurity(secidx, secLevel);
    }

    public boolean[] getSecurity(long secidx) {
        return this.paHead.getSecurity(secidx);
    }

    public boolean isLoggedIn(boolean promptForLogin) {
        if (this.getUser().isLoggedIn()) {
            return true;
        }
        if (!promptForLogin) {
            return false;
        }
        if (!this.paHead.signIn()) {
            DlgMessage.showMessage(this, StoreParams.res.getString("You_must_log_in"), StoreParams.res.getString("Not_logged_in"), -1, 0);
            return false;
        }
        return true;
    }

    public boolean autoSignIn(User origUser) {
        if (origUser == null || !origUser.isLoggedIn()) {
            return false;
        }
        if (this.getUser().isLoggedIn() && this.getUser().getMemidx() == origUser.getMemidx()) {
            return true;
        }
        if (this.getUser().isLoggedIn() && this.getUser().getMemidx() != origUser.getMemidx() && DlgMessage.showMessage(this, SP.getRS("Different_user_signed_in", this.getUser().getLoginName(), "\n"), SP.getRS("Sign_In"), 0, 3) != 0) {
            return true;
        }
        return this.paHead.login(origUser);
    }

    private boolean isFunctionKey(int keyCode) {
        switch (keyCode) {
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                return true;
            }
        }
        return false;
    }

    protected synchronized boolean this_keyPressed(KeyEvent e) {
        boolean subActionPerformed = false;
        boolean actionPerformed = true;
        if (e.getKeyCode() == 112) {
            this.sParams.runHelp();
        } else if (e.getKeyCode() != this.lastKey && (!this.isFunctionKey(e.getKeyCode()) || !this.isFunctionKey(this.lastKey)) || e.getWhen() > this.lastKeyAction + 200L) {
            this.lastKeyAction = new Date().getTime();
            this.lastKey = e.getKeyCode();
            if (e.getKeyCode() == 114 && !(this instanceof FrTillBalance) && !(this instanceof FrStkEnquiry) && this.isLoggedIn(true)) {
                if (this instanceof FrSales) {
                    ((FrSales)this).voidTrans(true, true, true);
                } else {
                    this.voidTrans(true);
                }
            } else if (e.getKeyCode() == 120 && !(this instanceof FrSales) && this.isLoggedIn(true)) {
                this.completeTrans();
            } else if (e.getKeyCode() == 113 && this.isLoggedIn(true)) {
                this.delLines();
                this.setFocus();
            } else {
                actionPerformed = false;
            }
            subActionPerformed = this.keyPressed(e);
            if (!actionPerformed && !subActionPerformed) {
                return false;
            }
        }
        return actionPerformed || subActionPerformed;
    }

    protected boolean deleteTrans(long deleteVhidx) {
        if (deleteVhidx > 0L) {
            try {
                PosUtils.startTrans(this.sParams.conn);
                EftposUtils.debugPoint(this, "DELETE TRANSACTION CALLED FROM:\n" + PosUtils.getStackTrace(new Throwable()));
                EftposUtils.debugPoint(this, "Deleting from RET_TRAND table\nVHIDX: " + deleteVhidx);
                EftposUtils.debugPoint(this, PosUtils.getDatabaseRecordAsText(SP.sParams.conn, "RET_TRAND", "VHIDX = " + deleteVhidx));
                try (Statement stmt = this.sParams.conn.createStatement();){
                    stmt.executeUpdate("DELETE FROM RET_TRAND WHERE VHIDX = " + deleteVhidx);
                }
                EftposUtils.debugPoint(this, "Deleting from RET_LOYALTY table\nVHIDX: " + deleteVhidx);
                EftposUtils.debugPoint(this, PosUtils.getDatabaseRecordAsText(SP.sParams.conn, "RET_LOYALTY", "VHIDX = " + deleteVhidx));
                stmt = this.sParams.conn.createStatement();
                var4_4 = null;
                try {
                    stmt.executeUpdate("DELETE FROM RET_LOYALTY WHERE VHIDX = " + deleteVhidx);
                }
                catch (Throwable throwable) {
                    var4_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (stmt != null) {
                        if (var4_4 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
                EftposUtils.debugPoint(this, "Deleting from RET_TRANP table\nVHIDX: " + deleteVhidx);
                EftposUtils.debugPoint(this, PosUtils.getDatabaseRecordAsText(SP.sParams.conn, "RET_TRANP", "VHIDX = " + deleteVhidx));
                stmt = this.sParams.conn.createStatement();
                var4_4 = null;
                try {
                    stmt.executeUpdate("DELETE FROM RET_TRANP WHERE VHIDX = " + deleteVhidx);
                }
                catch (Throwable throwable) {
                    var4_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (stmt != null) {
                        if (var4_4 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
                EftposUtils.debugPoint(this, "Deleting from RET_TRANH table\nVHIDX: " + deleteVhidx);
                EftposUtils.debugPoint(this, PosUtils.getDatabaseRecordAsText(SP.sParams.conn, "RET_TRANH", "VHIDX = " + deleteVhidx));
                stmt = this.sParams.conn.createStatement();
                var4_4 = null;
                try {
                    stmt.executeUpdate("DELETE FROM RET_TRANH WHERE VHIDX = " + deleteVhidx);
                }
                catch (Throwable throwable) {
                    var4_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (stmt != null) {
                        if (var4_4 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
                VoucherUtils.cancelPendingVouchers(this, this.sParams.conn, deleteVhidx);
                PosUtils.endTrans(this.sParams.conn);
                return true;
            }
            catch (Exception e) {
                PosUtils.releaseTrans(this.sParams.conn);
                PosUtils.logError(e);
                return false;
            }
        }
        return true;
    }

    public boolean deactivateTrans(long deactivateVhidx) {
        if (deactivateVhidx > 0L) {
            try {
                PosUtils.startTrans(this.sParams.conn);
                EftposUtils.debugPoint(this, "DEACTIVATE TRANSACTION CALLED FROM:\n" + PosUtils.getStackTrace(new Throwable()));
                EftposUtils.debugPoint(this, "Deactivating RET_TRAND record\nVHIDX: " + deactivateVhidx);
                EftposUtils.debugPoint(this, PosUtils.getDatabaseColumnAsText(SP.sParams.conn, "RET_TRAND", "VSHIDX", "\"ACTIVE\" = 1 AND VHIDX = " + deactivateVhidx));
                try (Statement stmt = this.sParams.conn.createStatement();){
                    stmt.executeUpdate("UPDATE RET_TRAND SET \"ACTIVE\" = 0 WHERE VHIDX = " + deactivateVhidx);
                }
                EftposUtils.debugPoint(this, "Deactivating RET_TRANP record\nVHIDX: " + deactivateVhidx);
                EftposUtils.debugPoint(this, PosUtils.getDatabaseColumnAsText(SP.sParams.conn, "RET_TRANP", "VSHIDX", "\"ACTIVE\" = 1 AND VHIDX = " + deactivateVhidx));
                stmt = this.sParams.conn.createStatement();
                var4_4 = null;
                try {
                    stmt.executeUpdate("UPDATE RET_TRANP SET \"ACTIVE\" = 0 WHERE VHIDX = " + deactivateVhidx);
                }
                catch (Throwable throwable) {
                    var4_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (stmt != null) {
                        if (var4_4 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
                EftposUtils.debugPoint(this, "Deactivating RET_TRANH record\nVHIDX: " + deactivateVhidx);
                stmt = this.sParams.conn.createStatement();
                var4_4 = null;
                try {
                    stmt.executeUpdate("UPDATE RET_TRANH SET \"ACTIVE\" = 0 WHERE VHIDX = " + deactivateVhidx);
                }
                catch (Throwable throwable) {
                    var4_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (stmt != null) {
                        if (var4_4 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
                VoucherUtils.cancelPendingVouchers(this, this.sParams.conn, deactivateVhidx);
                PosUtils.endTrans(this.sParams.conn);
                return true;
            }
            catch (Exception e) {
                PosUtils.releaseTrans(this.sParams.conn);
                PosUtils.logError(e);
                return false;
            }
        }
        return true;
    }

    protected void addClockOffMenu(String memname) {
        this.menuClockOff.setText(StoreParams.res.getString("Clock_Off") + " " + memname);
        this.menuFunc.add((Component)this.menuClockOff, 0);
    }

    protected void removeClockOffMenu() {
        this.menuFunc.remove(this.menuClockOff);
        this.menuFunc.remove(this.menuClockOffAll);
    }

    public boolean checkExit() {
        Object[] objs = new Object[]{"\n"};
        return DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("outstanding_edits"), objs), StoreParams.res.getString("Warning"), 0, 3) == 0;
    }

    protected boolean checkUsers() {
        String names = User.getClockedOnNames();
        if (names != null) {
            Object[] objs = new Object[]{"\n", names, "\n"};
            if (DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("The_following_users"), objs), StoreParams.res.getString("Clocked_In_users"), 0, 3) != 0) {
                return false;
            }
        }
        return true;
    }

    private String getTransactionIdx(String storeNumber, String docketNumber) throws SQLException {
        String vhIdx = null;
        String nextVhidx = null;
        try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT R.VHIDX, R.PAYMENT_FOR_VHIDX AS NEXT_VHIDX  FROM RET_TRANH R, WHSE W  WHERE R.\"ACTIVE\" = 1  AND R.DOCKET_NUMBER = ? AND W.WIDX = R.WIDX AND W.STORENO = ?", docketNumber, storeNumber);){
            if (sql.next()) {
                vhIdx = sql.getString("VHIDX");
                nextVhidx = sql.getString("NEXT_VHIDX");
            }
        }
        while (!StringUtils.isNullOrEmpty(nextVhidx)) {
            sql = new SqlQuery(this.sParams.conn, "SELECT R.VHIDX, R.PAYMENT_FOR_VHIDX AS NEXT_VHIDX  FROM RET_TRANH R  WHERE R.\"ACTIVE\" = 1  AND R.VHIDX = ?", nextVhidx);
            var6_6 = null;
            try {
                if (sql.next()) {
                    vhIdx = sql.getString("VHIDX");
                    nextVhidx = sql.getString("NEXT_VHIDX");
                    continue;
                }
                nextVhidx = null;
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
            finally {
                if (sql == null) continue;
                if (var6_6 != null) {
                    try {
                        sql.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                    continue;
                }
                sql.close();
            }
        }
        return vhIdx;
    }

    private String getPaymentTransactionIdx(String vhIdx) throws SQLException {
        try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT R.VHIDX  FROM RET_TRANH R  WHERE R.\"ACTIVE\" = 1  AND R.PAYMENT_FOR_VHIDX = ?", vhIdx);){
            if (sql.next()) {
                String string = sql.getString("VHIDX");
                return string;
            }
        }
        return vhIdx;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean db_getTransActionXML(Object pIdentifier, Element trans) {
        try {
            String where = null;
            String paymentWhere = null;
            if (pIdentifier instanceof Long) {
                where = " R.VHIDX = " + pIdentifier + " ";
            } else {
                String docketnum = (String)pIdentifier;
                trans.setName("transaction");
                trans.getChildren().clear();
                trans.getAttributes().clear();
                String storenum = docketnum.substring(0, 3);
                String docknum = docketnum.substring(3);
                String transIdx = this.getTransactionIdx(storenum, docknum);
                try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT R.VHIDX, R.TR_TYPE, R.TRANS_NUMBER, R.FROM_WIDX, COALESCE(R.SORDIDX, 0), R.WIDX FROM RET_TRANH R, WHSE W WHERE R.\"ACTIVE\" = 1  AND R.VHIDX = ?  AND W.WIDX = R.WIDX ", transIdx);){
                    if (!sql.next()) {
                        boolean bl = false;
                        return bl;
                    }
                    if (sql.getInt("TR_TYPE") == 239) {
                        where = " R.VHIDX = " + sql.getString("VHIDX") + " ";
                        paymentWhere = " R.VHIDX = " + this.getPaymentTransactionIdx(sql.getString("VHIDX")) + " ";
                    }
                    where = TransTypes.isLayby(sql.getInt("TR_TYPE")) ? " R.TRANS_NUMBER = " + PosUtils.StringToSqlString(sql.getString(3)) + " AND R.FROM_WIDX = " + sql.getLong(4) + " AND R.TR_TYPE IN (240, 241, 242) " : (TransTypes.isSpecialOrder(sql.getInt("TR_TYPE")) ? " R.TRANS_NUMBER = " + PosUtils.StringToSqlString(sql.getString(3)) + " AND R.FROM_WIDX = " + sql.getLong(4) + " AND R.TR_TYPE IN (243, 244, 245) " : (TransTypes.isCustOrder(sql.getInt("TR_TYPE")) ? " R.TRANS_NUMBER = " + PosUtils.StringToSqlString(sql.getString(3)) + " AND R.FROM_WIDX = " + sql.getLong(4) + " AND R.TR_TYPE IN (714, 715) " : (sql.getInt("TR_TYPE") == 614 ? " R.TRANS_NUMBER = " + PosUtils.StringToSqlString(sql.getString(3)) + " AND R.TR_TYPE = 614 AND R.WIDX = " + sql.getLong(6) : " R.VHIDX = " + sql.getString(1) + " ")));
                }
            }
            String header_capillary_red_id = RewardsUtils.usingCapillaryRewards() ? ", CAPILLARY_REDEMPTION_ID, CAPILLARY_POINTS_BALANCE" : "";
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT R.VHIDX, R.TRANS_NUMBER, R.CARRIERIDX, R.TO_WIDX, R.WIDX, R.TR_TYPE, R.CLIENTIDX,  1, 1, 1, R.DOCKET_NUMBER, R.LAYBY_DUE, R.TRAND, R.FROM_WIDX, COALESCE(R.LAYBY_CANCEL, 0),  1, 1, 1, 1, 1, 1, 1, R.NOTES1, R.NOTES2,  R.REF1, R.REF2, R.REF3, R.REF4, R.REF5, R.REF6, R.REF7, R.REF8, R.REF9, R.REF10,  R.MEMBER_GENERATEDIDX, R.SREPIDX, R.SUPPLIERIDX, W.STORENO, COALESCE(R.CUST_ORDER_COMPLETE, 0), R.ORIGIN,  R.POINTS_PARTNER_RCIDX, R.POINTS_PARTNER_NUM, R.SERVICETYPE_IDX, R.DESPATCH_WIDX, R.SALE_TYPE_IDX, R.SSCC " + header_capillary_red_id + ", R.FITSESSION, R.SELFFIT" + " FROM RET_TRANH R, WHSE W " + "WHERE R.\"ACTIVE\" = 1 AND R.WIDX = W.WIDX AND " + where + " " + "ORDER BY R.TRAND");){
                if (sql.next()) {
                    Object attributes;
                    if (sql.getString(7) != null && sql.getString(11) != null) {
                        this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("trans", sql.getString(38) + sql.getString(11)).getXML();
                        if (this.sParams.root != null && this.sParams.root.getAttribute("vhidx") != null) {
                            List contents = this.sParams.root.getChildren();
                            while (contents.size() > 0) {
                                trans.addContent((Content)((Element)((Element)contents.get(0)).detach()));
                            }
                            attributes = this.sParams.root.getAttributes();
                            while (true) {
                                if (attributes.size() <= 0) {
                                    trans.setAttribute("vhidx", sql.getString(1));
                                    trans.setAttribute("vhidx_local", "true");
                                    boolean bl = true;
                                    return bl;
                                }
                                trans.setAttribute(((Attribute)attributes.get(0)).detach());
                            }
                        }
                    }
                    trans.setAttribute("vhidx", sql.getString(1));
                    trans.setAttribute("vhidx_local", "true");
                    trans.setAttribute("loaded_offline", "true");
                    trans.setAttribute("tr_type", sql.getString(6));
                    trans.setAttribute("memidx", sql.getString(35));
                    trans.setAttribute("srepidx", sql.getString(36));
                    if (sql.getString("FITSESSION") == null) {
                        trans.setAttribute("fitsession", "");
                    } else {
                        trans.setAttribute("fitsession", sql.getString("FITSESSION"));
                    }
                    if (sql.getString("SELFFIT") == null) {
                        trans.setAttribute("selffit", "");
                    } else {
                        trans.setAttribute("selffit", sql.getString("SELFFIT"));
                    }
                    trans.setAttribute("trand", sql.getTimestamp(13).toString());
                    if (sql.getString("SSCC") == null) {
                        trans.setAttribute("sscc", "");
                    } else {
                        trans.setAttribute("sscc", sql.getString("SSCC"));
                    }
                    if (sql.getString(2) != null) {
                        trans.setAttribute("trans_number", sql.getString(2));
                    }
                    if (sql.getString(3) != null) {
                        trans.setAttribute("carrier", sql.getString(3));
                    }
                    if (sql.getString("SERVICETYPE_IDX") != null) {
                        trans.setAttribute("service_type", sql.getString("SERVICETYPE_IDX"));
                    }
                    if (sql.getString(4) != null) {
                        trans.setAttribute("to_widx", sql.getString(4));
                    }
                    if (sql.getString(37) != null) {
                        trans.setAttribute("supplieridx", sql.getString(37));
                    }
                    if (sql.getString(5) != null) {
                        trans.setAttribute("widx", sql.getString(5));
                    }
                    if (sql.getString(14) != null) {
                        trans.setAttribute("from_widx", sql.getString(14));
                    }
                    if (sql.getString(11) != null) {
                        trans.setAttribute("docket_number", sql.getString(11));
                    }
                    if (sql.getTimestamp(12) != null) {
                        trans.setAttribute("layby_due", sql.getTimestamp(12).toString());
                    }
                    if (sql.getString(23) != null) {
                        trans.setAttribute("notes1", sql.getString(23));
                    }
                    if (sql.getString(24) != null) {
                        trans.setAttribute("notes2", sql.getString(24));
                    }
                    if (sql.getString(40) != null) {
                        trans.setAttribute("origin", sql.getString(40));
                    }
                    if (sql.getString(41) != null) {
                        trans.setAttribute("points_partner_rcidx", sql.getString(41));
                    }
                    if (sql.getString(42) != null) {
                        trans.setAttribute("points_partner_num", sql.getString(42));
                    }
                    if (sql.getString("DESPATCH_WIDX") != null) {
                        trans.setAttribute("despatch_widx", sql.getString("DESPATCH_WIDX"));
                    }
                    if (sql.getString("SALE_TYPE_IDX") != null) {
                        trans.setAttribute("sale_type_idx", sql.getString("SALE_TYPE_IDX"));
                    }
                    if (sql.getInt(6) == 240) {
                        SqlQuery sqlDate = new SqlQuery(this.sParams.conn, "SELECT LBIDX, PAYMENT_DUE FROM LAYBY_PAYDUEDATES WHERE TRANS_NUMBER = " + PosUtils.StringToSqlString(sql.getString(2)) + " AND FROM_WIDX = " + sql.getString(14) + " " + "ORDER BY LBIDX DESC");
                        attributes = null;
                        try {
                            if (sqlDate.next() && sqlDate.getString(2) != null) {
                                Element pay_due = new Element("layby_payduedates");
                                pay_due.setAttribute("lbidx", sqlDate.getString(1));
                                pay_due.setAttribute("payment_due", sqlDate.getTimestamp(2).toString());
                                trans.addContent((Content)pay_due);
                            }
                        }
                        catch (Throwable pay_due) {
                            attributes = pay_due;
                            throw pay_due;
                        }
                        finally {
                            if (sqlDate != null) {
                                if (attributes != null) {
                                    try {
                                        sqlDate.close();
                                    }
                                    catch (Throwable pay_due) {
                                        ((Throwable)attributes).addSuppressed(pay_due);
                                    }
                                } else {
                                    sqlDate.close();
                                }
                            }
                        }
                    }
                    Vector<Element> notesXml = Note.getNotes(sql.getLong(1), "RET_TRANH", this.sParams.conn);
                    for (int i = 0; i < notesXml.size(); ++i) {
                        trans.addContent((Content)((Element)notesXml.get(i)));
                    }
                    Element refs = new Element("refs");
                    if (sql.getString(25) != null) {
                        refs.addContent((Content)new Element("ref1").setAttribute("rcidx", sql.getString(25)));
                    }
                    if (sql.getString(26) != null) {
                        refs.addContent((Content)new Element("ref2").setAttribute("rcidx", sql.getString(26)));
                    }
                    if (sql.getString(27) != null) {
                        refs.addContent((Content)new Element("ref3").setAttribute("rcidx", sql.getString(27)));
                    }
                    if (sql.getString(28) != null) {
                        refs.addContent((Content)new Element("ref4").setAttribute("rcidx", sql.getString(28)));
                    }
                    if (sql.getString(29) != null) {
                        refs.addContent((Content)new Element("ref5").setAttribute("rcidx", sql.getString(29)));
                    }
                    if (sql.getString(30) != null) {
                        refs.addContent((Content)new Element("ref6").setAttribute("rcidx", sql.getString(30)));
                    }
                    if (sql.getString(31) != null) {
                        refs.addContent((Content)new Element("ref7").setAttribute("rcidx", sql.getString(31)));
                    }
                    if (sql.getString(32) != null) {
                        refs.addContent((Content)new Element("ref8").setAttribute("rcidx", sql.getString(32)));
                    }
                    if (sql.getString(33) != null) {
                        refs.addContent((Content)new Element("ref9").setAttribute("rcidx", sql.getString(33)));
                    }
                    if (sql.getString(34) != null) {
                        refs.addContent((Content)new Element("ref10").setAttribute("rcidx", sql.getString(34)));
                    }
                    trans.addContent((Content)refs);
                    Element person = new Element("person");
                    if (sql.getString(7) != null) {
                        person.setAttribute("peridx", sql.getString(7));
                        if (RewardsUtils.usingCapillaryRewards() && ((PaSales)this.paBody).frParent.getCapillaryCustomer() != null) {
                            person.setAttribute("capillaryId", sql.getString(47));
                            person.setAttribute("capillaryPointBalance", sql.getString(48));
                            ((PaSales)this.paBody).frParent.getCapillaryCustomer().setExternalId(sql.getString(47));
                            ((PaSales)this.paBody).frParent.getCapillaryCustomer().setPointsBalance(sql.getDouble(48));
                        }
                        if (sql.getLong(7) < 0L || !this.sParams.checkIConn()) {
                            this.sParams.getXML(this, "person", sql.getString(7), false);
                        } else {
                            this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("person", sql.getString(7)).getXML();
                            if (this.sParams.root == null) {
                                boolean bl = false;
                                return bl;
                            }
                        }
                        try {
                            List contents = this.sParams.root.getChildren();
                            while (contents.size() > 0) {
                                person.addContent((Content)((Element)((Element)contents.get(0)).detach()));
                            }
                            List attributes2 = this.sParams.root.getAttributes();
                            while (attributes2.size() > 0) {
                                person.setAttribute(((Attribute)attributes2.get(0)).detach());
                            }
                        }
                        catch (Exception ex) {
                            PosUtils.logError(ex);
                        }
                    }
                    trans.addContent((Content)person);
                    Element subtrans = new Element("subtrans");
                    subtrans.setAttribute("vhidx", sql.getString(1));
                    subtrans.setAttribute("trand", sql.getTimestamp(13).toString());
                    subtrans.setAttribute("tr_type", sql.getString(6));
                    if (sql.getInt(15) != 0) {
                        subtrans.setAttribute("layby_cancel", sql.getString(15));
                    }
                    if (sql.getInt(39) != 0) {
                        subtrans.setAttribute("cust_order_complete", sql.getString(39));
                    }
                    if (sql.getString(11) != null) {
                        subtrans.setAttribute("docket_number", sql.getString(11));
                    }
                    if (sql.getString(5) != null) {
                        subtrans.setAttribute("widx", sql.getString(5));
                    }
                    trans.addContent((Content)subtrans);
                    while (sql.next()) {
                        subtrans = new Element("subtrans");
                        subtrans.setAttribute("vhidx", sql.getString(1));
                        subtrans.setAttribute("trand", sql.getTimestamp(13).toString());
                        subtrans.setAttribute("tr_type", sql.getString(6));
                        if (sql.getString(11) != null) {
                            subtrans.setAttribute("docket_number", sql.getString(11));
                        }
                        if (sql.getString(5) != null) {
                            subtrans.setAttribute("widx", sql.getString(5));
                        }
                        if (sql.getInt(15) != 0) {
                            subtrans.setAttribute("layby_cancel", sql.getString(15));
                        }
                        if (sql.getInt(39) != 0) {
                            subtrans.setAttribute("cust_order_complete", sql.getString(39));
                        }
                        trans.addContent((Content)subtrans);
                    }
                    if (StringUtils.isNullOrEmpty(paymentWhere)) {
                        paymentWhere = where;
                    }
                    try (SqlQuery sqlPay = new SqlQuery(this.sParams.conn, "SELECT R.VHIDX, RP.PAYMENT_TYPEIDX, RP.PAYMENT_AMOUNT, RP.CASHOUT_AMOUNT, R.TRAND, RP.PAYMENT_NUMBER, RP.VOUCH_TYPEIDX, RP.EFTPOS_CARDTYPE, RP.EFTPOS_ACTYPE, RP.ORIG_EXPIRY_DATE, RP.EXPIRY_DATE, RP.EFTPOS_STAN, RP.EFTPOS_REFERENCE, RP.EFTPOS_PROVIDER FROM RET_TRANH R, RET_TRANP RP WHERE R.VHIDX = RP.VHIDX AND RP.\"ACTIVE\" = 1 AND " + paymentWhere + " ORDER BY R.TRAND, R.VHIDX, RP.SEQUENCE_NUMBER");){
                        Element payments = null;
                        while (sqlPay.next()) {
                            if (payments == null) {
                                payments = new Element("payments");
                                payments.setAttribute("trand", sqlPay.getTimestamp(5).toString());
                                payments.setAttribute("vhidx", sqlPay.getString(1));
                            } else if (!payments.getAttribute("vhidx").getValue().equals(sqlPay.getString(1))) {
                                trans.addContent((Content)payments);
                                payments = new Element("payments");
                                payments.setAttribute("trand", sqlPay.getTimestamp(5).toString());
                                payments.setAttribute("vhidx", sqlPay.getString(1));
                            }
                            Element tender = new Element("tender");
                            if (sqlPay.getString(4) != null) {
                                tender.setAttribute("cashout_amount", sqlPay.getString(4));
                            }
                            if (sqlPay.getString(6) != null) {
                                tender.setAttribute("payment_number", sqlPay.getString(6));
                            }
                            if (sqlPay.getString(7) != null) {
                                tender.setAttribute("vouch_typeidx", sqlPay.getString(7));
                            }
                            if (sqlPay.getString(8) != null) {
                                tender.setAttribute("eftpos_cardtype", sqlPay.getString(8));
                            }
                            if (sqlPay.getString(9) != null) {
                                tender.setAttribute("eftpos_actype", sqlPay.getString(9));
                            }
                            if (sqlPay.getString(10) != null) {
                                tender.setAttribute("orig_expiry_date", sqlPay.getTimestamp(10).toString());
                            }
                            if (sqlPay.getString(11) != null) {
                                tender.setAttribute("expiry_date", sqlPay.getTimestamp(11).toString());
                            }
                            if (sqlPay.getString(12) != null) {
                                tender.setAttribute("eftpos_stan", sqlPay.getString(12));
                            }
                            if (sqlPay.getString(13) != null) {
                                tender.setAttribute("eftpos_reference", sqlPay.getString(13));
                            }
                            if (sqlPay.getString(14) != null) {
                                tender.setAttribute("eftpos_provider", sqlPay.getString(14));
                            }
                            tender.setAttribute("payment_typeidx", sqlPay.getString(2));
                            tender.setText(sqlPay.getString(3));
                            payments.addContent((Content)tender);
                        }
                        if (payments != null) {
                            trans.addContent(payments);
                        }
                    }
                    var13_32 = null;
                    try (SqlQuery sqlStyle = new SqlQuery(this.sParams.conn, "SELECT RD.VHIDX, RD.SKUIDX, RD.QTY, RD.LINE_TYPE, RD.DISCOUNT_PER,  RD.DISCOUNT_REASIDX, RD.LINE_CODE, RD.PRICE, RD.DESCRIP1, RD.DESCRIP2, RD.TAXPER, R.TRAND, RD.VSHIDX, RD.NET, RD.GVNUM, RD.GVGATE_ISDIGITAL, RD.GVGATE_REC_EMAIL, RD.VOUCHER_GATEWAY_IDX, RD.DELIVER_WIDX, RD.PURCHASE_COST, RD.RET_REASIDX, RD.ORIG_EXPIRY_DATE, RD.EXPIRY_DATE, RD.ORIG_PRICE, RD.POS_MKDMSGIDX, RD.EXT_TAXRATE, RD.TAKEN, RD.PACKED, RD.ORIG_VSHIDX, RD.PROMOIDX, RD.OLD_HELD_VALUE, RD.OVERRIDE_SREPIDX, RD.GIFT_IDX, RD.TAX_DONOTREFRESH_FLAG, RD.COUPON_IDX, RD.PROMO_V, RD.SREPIDX, RD.ASSOC_RCIDX FROM RET_TRANH R, RET_TRAND RD WHERE R.VHIDX = RD.VHIDX AND " + where + "ORDER BY R.TRAND, R.VHIDX, RD.SEQUENCE_NUMBER");){
                        if (sqlStyle.next()) {
                            Element styles = new Element("styles");
                            styles.setAttribute("trand", sqlStyle.getTimestamp("TRAND").toString());
                            styles.setAttribute("vhidx", sqlStyle.getString("VHIDX"));
                            Element style = new Element("style");
                            if (sqlStyle.getString("LINE_CODE") != null) {
                                style.setAttribute("line_code", sqlStyle.getString("LINE_CODE"));
                            }
                            if (sqlStyle.getString("TAXPER") != null) {
                                style.setAttribute("taxper", sqlStyle.getString("TAXPER"));
                            }
                            style.setAttribute("price", sqlStyle.getString("PRICE"));
                            if (sqlStyle.getString("ORIG_PRICE") != null) {
                                style.setAttribute("orig_price", sqlStyle.getString("ORIG_PRICE"));
                            }
                            if (sqlStyle.getString("DESCRIP1") != null) {
                                style.setAttribute("descrip1", sqlStyle.getString("DESCRIP1"));
                            }
                            if (sqlStyle.getString("DESCRIP2") != null) {
                                style.setAttribute("descrip2", sqlStyle.getString("DESCRIP2"));
                            }
                            if (sqlStyle.getString("SREPIDX") != null) {
                                style.setAttribute("srepidx", sqlStyle.getString("SREPIDX"));
                            }
                            if (sqlStyle.getString("ASSOC_RCIDX") != null) {
                                style.setAttribute("assocs", sqlStyle.getString("ASSOC_RCIDX"));
                            }
                            if (sqlStyle.getString("SKUIDX") != null) {
                                style.setAttribute("skuidx", sqlStyle.getString("SKUIDX"));
                            }
                            if (sqlStyle.getString("VSHIDX") != null) {
                                style.setAttribute("vshidx", sqlStyle.getString("VSHIDX"));
                            }
                            style.setAttribute("net", sqlStyle.getString("NET"));
                            if (sqlStyle.getString("GVNUM") != null) {
                                style.setAttribute("gvnum", sqlStyle.getString("GVNUM"));
                            }
                            if (sqlStyle.getString("VOUCHER_GATEWAY_IDX") != null) {
                                style.setAttribute("voucher_gateway_idx", sqlStyle.getString("VOUCHER_GATEWAY_IDX"));
                            }
                            if (sqlStyle.getString("GVGATE_ISDIGITAL") != null) {
                                style.setAttribute("gvgate_isdigital", sqlStyle.getString("GVGATE_ISDIGITAL"));
                            }
                            if (sqlStyle.getString("GVGATE_REC_EMAIL") != null) {
                                style.setAttribute("gvgate_rec_email", sqlStyle.getString("GVGATE_REC_EMAIL"));
                            }
                            if (sqlStyle.getString("DELIVER_WIDX") != null) {
                                style.setAttribute("delto", sqlStyle.getString("DELIVER_WIDX"));
                            }
                            if (sqlStyle.getString("PURCHASE_COST") != null) {
                                style.setAttribute("cost", sqlStyle.getString("PURCHASE_COST"));
                            }
                            if (sqlStyle.getString("RET_REASIDX") != null) {
                                style.setAttribute("ret_reasidx", sqlStyle.getString("RET_REASIDX"));
                            }
                            if (sqlStyle.getString("OVERRIDE_SREPIDX") != null) {
                                style.setAttribute("override_srepidx", sqlStyle.getString("OVERRIDE_SREPIDX"));
                            }
                            if (sqlStyle.getString("ORIG_EXPIRY_DATE") != null) {
                                style.setAttribute("orig_expiry_date", sqlStyle.getTimestamp("ORIG_EXPIRY_DATE").toString());
                            }
                            if (sqlStyle.getString("EXPIRY_DATE") != null) {
                                style.setAttribute("expiry_date", sqlStyle.getTimestamp("EXPIRY_DATE").toString());
                            }
                            if (sqlStyle.getString("POS_MKDMSGIDX") != null) {
                                style.setAttribute("pos_mkdmsgidx", sqlStyle.getString("POS_MKDMSGIDX"));
                            }
                            if (sqlStyle.getString("EXT_TAXRATE") != null) {
                                style.setAttribute("ext_taxrate", sqlStyle.getString("EXT_TAXRATE"));
                            }
                            if (sqlStyle.getString("TAKEN") != null) {
                                style.setAttribute("taken", sqlStyle.getString("TAKEN"));
                            }
                            if (sqlStyle.getString("PACKED") != null) {
                                style.setAttribute("packed", sqlStyle.getString("PACKED"));
                            }
                            if (sqlStyle.getString("ORIG_VSHIDX") != null) {
                                style.setAttribute("orig_vshidx", sqlStyle.getString("ORIG_VSHIDX"));
                            }
                            if (sqlStyle.getString("PROMOIDX") != null) {
                                style.setAttribute("promoidx", sqlStyle.getString("PROMOIDX"));
                            }
                            if (sqlStyle.getString("OLD_HELD_VALUE") != null) {
                                style.setAttribute("old_held_value", sqlStyle.getString("OLD_HELD_VALUE"));
                            }
                            if (sqlStyle.getString("GIFT_IDX") != null) {
                                style.setAttribute("gift_idx", sqlStyle.getString("GIFT_IDX"));
                            }
                            if (sqlStyle.getString("TAX_DONOTREFRESH_FLAG") != null) {
                                style.setAttribute("tax_donotrefresh_flag", sqlStyle.getString("TAX_DONOTREFRESH_FLAG"));
                            }
                            style.setText(sqlStyle.getString("QTY"));
                            notesXml = Note.getNotes(sqlStyle.getLong("VSHIDX"), "RET_TRAND", this.sParams.conn);
                            for (int i = 0; i < notesXml.size(); ++i) {
                                style.addContent((Content)((Element)notesXml.get(i)));
                            }
                            styles.addContent((Content)style);
                            while (sqlStyle.next()) {
                                if (!styles.getAttribute("vhidx").getValue().equals(sqlStyle.getString("VHIDX"))) {
                                    trans.addContent((Content)styles);
                                    styles = new Element("styles");
                                    styles.setAttribute("trand", sqlStyle.getTimestamp("TRAND").toString());
                                    styles.setAttribute("vhidx", sqlStyle.getString("VHIDX"));
                                }
                                if (sqlStyle.getInt("LINE_TYPE") == 6 || sqlStyle.getInt("LINE_TYPE") == 7) {
                                    Element discount = new Element("discount");
                                    discount.setAttribute("loyalty", new Boolean(sqlStyle.getInt("LINE_TYPE") == 7).toString());
                                    if (sqlStyle.getString("LINE_CODE") != null) {
                                        discount.setAttribute("line_code", sqlStyle.getString("LINE_CODE"));
                                    }
                                    discount.setAttribute("reasonidx", sqlStyle.getString("DISCOUNT_REASIDX"));
                                    if (sqlStyle.getString("PROMOIDX") != null) {
                                        discount.setAttribute("promoidx", sqlStyle.getString("PROMOIDX"));
                                    }
                                    discount.setAttribute("net", sqlStyle.getString("NET"));
                                    discount.setText(sqlStyle.getString("DISCOUNT_PER"));
                                    if (sqlStyle.getString("VSHIDX") != null) {
                                        discount.setAttribute("vshidx", sqlStyle.getString("VSHIDX"));
                                    }
                                    if (sqlStyle.getString("ORIG_VSHIDX") != null) {
                                        discount.setAttribute("orig_vshidx", sqlStyle.getString("ORIG_VSHIDX"));
                                    }
                                    if (sqlStyle.getString("OLD_HELD_VALUE") != null) {
                                        discount.setAttribute("old_held_value", sqlStyle.getString("OLD_HELD_VALUE"));
                                    }
                                    if (sqlStyle.getString("OVERRIDE_SREPIDX") != null) {
                                        discount.setAttribute("override_srepidx", sqlStyle.getString("OVERRIDE_SREPIDX"));
                                    }
                                    if (sqlStyle.getString("DESCRIP1") != null) {
                                        discount.setAttribute("descrip1", sqlStyle.getString("DESCRIP1"));
                                    }
                                    if (sqlStyle.getString("DESCRIP2") != null) {
                                        discount.setAttribute("descrip2", sqlStyle.getString("DESCRIP2"));
                                    }
                                    if (sqlStyle.getString("SREPIDX") != null) {
                                        style.setAttribute("srepidx", sqlStyle.getString("SREPIDX"));
                                    }
                                    if (sqlStyle.getString("ASSOC_RCIDX") != null) {
                                        style.setAttribute("assocs", sqlStyle.getString("ASSOC_RCIDX"));
                                    }
                                    if (sqlStyle.getString("COUPON_IDX") != null) {
                                        discount.setAttribute("coupon_idx", sqlStyle.getString("COUPON_IDX"));
                                    }
                                    if (sqlStyle.getString("PROMO_V") != null) {
                                        discount.setAttribute("promo_v", sqlStyle.getString("PROMO_V"));
                                    }
                                    styles.addContent((Content)discount);
                                    continue;
                                }
                                style = new Element("style");
                                if (sqlStyle.getString("LINE_CODE") != null) {
                                    style.setAttribute("line_code", sqlStyle.getString("LINE_CODE"));
                                }
                                if (sqlStyle.getString("TAXPER") != null) {
                                    style.setAttribute("taxper", sqlStyle.getString("TAXPER"));
                                }
                                style.setAttribute("price", sqlStyle.getString("PRICE"));
                                if (sqlStyle.getString("ORIG_PRICE") != null) {
                                    style.setAttribute("orig_price", sqlStyle.getString("ORIG_PRICE"));
                                }
                                if (sqlStyle.getString("DESCRIP1") != null) {
                                    style.setAttribute("descrip1", sqlStyle.getString("DESCRIP1"));
                                }
                                if (sqlStyle.getString("DESCRIP2") != null) {
                                    style.setAttribute("descrip2", sqlStyle.getString("DESCRIP2"));
                                }
                                if (sqlStyle.getString("SREPIDX") != null) {
                                    style.setAttribute("srepidx", sqlStyle.getString("SREPIDX"));
                                }
                                if (sqlStyle.getString("ASSOC_RCIDX") != null) {
                                    style.setAttribute("assocs", sqlStyle.getString("ASSOC_RCIDX"));
                                }
                                if (sqlStyle.getString("SKUIDX") != null) {
                                    style.setAttribute("skuidx", sqlStyle.getString("SKUIDX"));
                                }
                                if (sqlStyle.getString("VSHIDX") != null) {
                                    style.setAttribute("vshidx", sqlStyle.getString("VSHIDX"));
                                }
                                style.setAttribute("net", sqlStyle.getString("NET"));
                                if (sqlStyle.getString("GVNUM") != null) {
                                    style.setAttribute("gvnum", sqlStyle.getString("GVNUM"));
                                }
                                if (sqlStyle.getString("DELIVER_WIDX") != null) {
                                    style.setAttribute("delto", sqlStyle.getString("DELIVER_WIDX"));
                                }
                                if (sqlStyle.getString("PURCHASE_COST") != null) {
                                    style.setAttribute("cost", sqlStyle.getString("PURCHASE_COST"));
                                }
                                if (sqlStyle.getString("RET_REASIDX") != null) {
                                    style.setAttribute("ret_reasidx", sqlStyle.getString("RET_REASIDX"));
                                }
                                if (sqlStyle.getString("OVERRIDE_SREPIDX") != null) {
                                    style.setAttribute("override_srepidx", sqlStyle.getString("OVERRIDE_SREPIDX"));
                                }
                                if (sqlStyle.getString("ORIG_EXPIRY_DATE") != null) {
                                    style.setAttribute("orig_expiry_date", sqlStyle.getTimestamp("ORIG_EXPIRY_DATE").toString());
                                }
                                if (sqlStyle.getString("EXPIRY_DATE") != null) {
                                    style.setAttribute("expiry_date", sqlStyle.getTimestamp("EXPIRY_DATE").toString());
                                }
                                if (sqlStyle.getString("POS_MKDMSGIDX") != null) {
                                    style.setAttribute("pos_mkdmsgidx", sqlStyle.getString("POS_MKDMSGIDX"));
                                }
                                if (sqlStyle.getString("EXT_TAXRATE") != null) {
                                    style.setAttribute("ext_taxrate", sqlStyle.getString("EXT_TAXRATE"));
                                }
                                if (sqlStyle.getString("TAKEN") != null) {
                                    style.setAttribute("taken", sqlStyle.getString("TAKEN"));
                                }
                                if (sqlStyle.getString("PACKED") != null) {
                                    style.setAttribute("packed", sqlStyle.getString("PACKED"));
                                }
                                if (sqlStyle.getString("ORIG_VSHIDX") != null) {
                                    style.setAttribute("orig_vshidx", sqlStyle.getString("ORIG_VSHIDX"));
                                }
                                if (sqlStyle.getString("PROMOIDX") != null) {
                                    style.setAttribute("promoidx", sqlStyle.getString("PROMOIDX"));
                                }
                                if (sqlStyle.getString("OLD_HELD_VALUE") != null) {
                                    style.setAttribute("old_held_value", sqlStyle.getString("OLD_HELD_VALUE"));
                                }
                                if (sqlStyle.getString("GIFT_IDX") != null) {
                                    style.setAttribute("gift_idx", sqlStyle.getString("GIFT_IDX"));
                                }
                                if (sqlStyle.getString("TAX_DONOTREFRESH_FLAG") != null) {
                                    style.setAttribute("tax_donotrefresh_flag", sqlStyle.getString("TAX_DONOTREFRESH_FLAG"));
                                }
                                style.setText(sqlStyle.getString("QTY"));
                                notesXml = Note.getNotes(sqlStyle.getLong("VSHIDX"), "RET_TRAND", this.sParams.conn);
                                for (int i = 0; i < notesXml.size(); ++i) {
                                    style.addContent((Content)((Element)notesXml.get(i)));
                                }
                                styles.addContent((Content)style);
                            }
                            trans.addContent((Content)styles);
                        }
                    }
                    catch (Throwable throwable) {
                        var13_32 = throwable;
                        throw throwable;
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
            trans.setName("error");
            trans.setAttribute("desc", e.getMessage());
            return false;
        }
    }

    public boolean populate(String docket) {
        return this.populate(docket, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean populate(String docket, boolean showNotFoundErrors) {
        if (this.sParams.useDisplayDevice) {
            this.sParams.displayDevice.displayWelcomeMessage();
            this.sParams.displayDevice.setIsDisabled(true);
        }
        try {
            if (docket.length() < 4) {
                if (showNotFoundErrors) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("wrong_length_doc"), StoreParams.res.getString("Error_loading"), 0);
                }
                boolean bl = false;
                return bl;
            }
            Element trans = new Element("transaction");
            if (!this.db_getTransActionXML(docket, trans)) {
                if (trans.getName().equals("error")) {
                    Object[] objs = new Object[]{trans.getAttribute("desc").getValue()};
                    if (showNotFoundErrors) {
                        DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("error_msg_is"), objs), StoreParams.res.getString("Error_loading"), -1, 0);
                    }
                    boolean bl = false;
                    return bl;
                }
                this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("trans", docket).getXML();
                if (this.sParams.root == null) {
                    boolean objs = false;
                    return objs;
                }
                if (this.sParams.root.getAttribute("vhidx") == null) {
                    if (showNotFoundErrors) {
                        DlgMessage.showMessage(this, StoreParams.res.getString("docket_not_found"), StoreParams.res.getString("Error_loading"), 0);
                    }
                    boolean objs = false;
                    return objs;
                }
                List contents = this.sParams.root.getChildren();
                while (contents.size() > 0) {
                    trans.addContent((Content)((Element)((Element)contents.get(0)).detach()));
                }
                List attributes = this.sParams.root.getAttributes();
                while (attributes.size() > 0) {
                    trans.setAttribute(((Attribute)attributes.get(0)).detach());
                }
            }
            if (!this.populate(trans)) {
                this.voidTrans(false);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (this.sParams.useDisplayDevice) {
                this.sParams.displayDevice.setIsDisabled(false);
            }
        }
        return true;
    }

    public void setFITVisible(boolean visible) {
        if (this.sParams.bMyFit) {
            this.menuFITSessions.setVisible(visible);
        } else {
            this.menuFITSessions.setVisible(false);
        }
    }

    public boolean populate(Element trans) {
        if (trans != null && trans.getAttribute("vhidx") != null) {
            try {
                if (this instanceof FrSales) {
                    ((FrSales)this).voidTrans(false, true, false);
                } else {
                    this.voidTrans(false);
                }
                this.setFITVisible(false);
                this.vhidx = trans.getAttribute("vhidx").getLongValue();
                if (trans.getAttribute("sordidx") != null) {
                    this.sordidx = trans.getAttribute("sordidx").getLongValue();
                }
                if (trans.getAttribute("docket_number") != null) {
                    this.docknum = trans.getAttribute("docket_number").getValue();
                }
                if (trans.getAttribute("trans_number") != null) {
                    this.transnum = trans.getAttribute("trans_number").getValue();
                }
                if (trans.getAttribute("owner_trading_currency_code") != null) {
                    this.ownerCurrency = trans.getAttribute("owner_trading_currency_code").getValue();
                }
                if (trans.getAttribute("partial_click_and_collect_allowed") != null) {
                    this.transactionAvailable = true;
                    this.partialCCAllowed = trans.getAttribute("partial_click_and_collect_allowed").getIntValue() == 1;
                }
                this.setTransType(trans.getAttribute("tr_type").getIntValue());
                boolean local = trans.getAttribute("vhidx_local") != null && trans.getAttribute("vhidx_local").getValue().equals("true");
                for (int i = 0; i < this.noteTypes.size(); ++i) {
                    this.noteTypes.elementAt(i).setKeyIdx(this.vhidx, local);
                }
                this.addNotes(this.noteTypes, trans.getChildren("note"));
                return true;
            }
            catch (DataConversionException e) {
                PosUtils.logError(e);
            }
        }
        return false;
    }

    protected void addNotes(Vector<NoteType> pnoteTypes, List<?> notesXml) {
        for (int i = 0; i < notesXml.size(); ++i) {
            Element noteXml = (Element)notesXml.get(i);
            Note note = Note.createNote(noteXml, pnoteTypes);
            if (note == null) continue;
            this.notes.add(note);
        }
        this.notesSet();
    }

    protected void setEditable(boolean peditable) {
        this.editable = peditable;
    }

    protected void search(boolean allStores) {
        StringBuffer sbFilter = new StringBuffer();
        if (allStores && !this.hasSecurity(11151L, 0)) {
            DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
        } else if (allStores && !this.sParams.checkIConn()) {
            DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
        } else {
            HistoryOptions options = new HistoryOptionsBuilder().transactionNumber().referenceNumber().phone().firstname().surname().deliveryAddress().productCode().transactionDates().cartonNumber().build();
            StringBuffer result = new StringBuffer();
            DlgHistoryFilter histFilter = new DlgHistoryFilter(this, StoreParams.res.getString("History_Search_Filter"), this.sParams.checkIConn(), options, sbFilter, result);
            histFilter.setVisible(true);
            if (result.toString().equals("OK")) {
                BJTextField searchField;
                this.setCursor(StoreParams.waitCursor);
                BJTextField bJTextField = searchField = allStores ? this.sParams.tfHistAll : this.sParams.tfHistStore;
                if (this.sParams.checkIConn()) {
                    String sExtraWhere = "H.VHIDX = H.VHIDX AND H.\"ACTIVE\" > 0 AND decode(H.TR_TYPE, 614, H.NOTES1, NULL) IS NULL AND ( (H.TR_TYPE = 249 AND NVL(H.TRANSFER_COMPLETE_FLAG, 0) = 0) OR H.TR_TYPE <> 249) AND  H.TR_TYPE != 691 " + (allStores ? " AND (H.WIDX = " + this.sParams.getStoreIdx() + " OR H.TR_TYPE != 564) " : " AND H.WIDX = " + this.sParams.getStoreIdx());
                    if (searchField.getToServ() == null) {
                        searchField.setCache(this.sParams.cacher, this.sParams.iconn, 265L, "382,367,368,369,370,371,372,375,861,961", "", sExtraWhere + sbFilter.toString() + this.sParams.sWhseRefSecWhereRETAIL);
                    } else {
                        searchField.setWhere(sExtraWhere + sbFilter.toString() + this.sParams.sWhseRefSecWhereRETAIL);
                    }
                } else {
                    String sExtraWhere = "H.COMPLETE > 0 AND H.\"ACTIVE\" > 0 AND (H.TR_TYPE != 614 OR H.NOTES1 IS NULL) AND H.TR_TYPE != 691";
                    if (searchField.getCacher() == null || searchField.getToServ() != null) {
                        searchField.setCache(this.sParams.cacher, 661L, "922,923,924", "RET_TRANH H LEFT JOIN RET_TRAND D ON D.VHIDX = H.VHIDX AND D.SEQUENCE_NUMBER = 0 LEFT JOIN SKU ON SKU.SKUIDX = D.SKUIDX LEFT JOIN CLR ON CLR.CLRIDX = SKU.CLRIDX LEFT JOIN STYLE S ON S.STYLEIDX = CLR.STYLEIDX LEFT JOIN PERSON P ON P.PERIDX = H.CLIENTIDX", sExtraWhere + sbFilter.toString() + this.sParams.sWhseRefSecWhereRETAIL);
                    } else {
                        searchField.setWhere(sExtraWhere + sbFilter.toString() + this.sParams.sWhseRefSecWhereRETAIL);
                    }
                }
                this.setCursor(StoreParams.normalCursor);
                searchField.clear();
                boolean wasOnline = this.sParams.checkIConn();
                searchField.doSearch(this);
                if (wasOnline && !this.sParams.checkIConn()) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("online_search_error"), StoreParams.res.getString("Error"), -1, 0);
                }
                if (!searchField.getText().equals("")) {
                    this.setCursor(StoreParams.waitCursor);
                    boolean tempBool = this.menu.populate(this, (int)searchField.getidx(), searchField.getText().substring(1));
                    this.setCursor(StoreParams.normalCursor);
                    this.bCanceled = !tempBool;
                } else {
                    this.bCanceled = true;
                }
            }
        }
    }

    protected static boolean isTimeoutDisabled(Window window) {
        Window[] ownedWindows;
        for (Window ownedWindow : ownedWindows = window.getOwnedWindows()) {
            if (!ownedWindow.isShowing()) continue;
            if (ownedWindow instanceof RemPosReport || ownedWindow instanceof searchFrame || ownedWindow instanceof Receipt || ownedWindow instanceof EODReport || ownedWindow instanceof DlgMessage || ownedWindow instanceof DlgImportAPNs || ownedWindow instanceof PosDateSearch || ownedWindow instanceof DlgOmneoPerson || ownedWindow instanceof DlgManualLoyaltyDiscount || ownedWindow instanceof DlgPacking || ownedWindow instanceof DlgBookingSummary || ownedWindow instanceof BasicDialog) {
                return true;
            }
            if (!PosFrame.isTimeoutDisabled(ownedWindow)) continue;
            return true;
        }
        return false;
    }

    protected boolean isModalChildVisible() {
        Window[] ownedWindows;
        for (Window ownedWindow : ownedWindows = this.getOwnedWindows()) {
            if (!ownedWindow.isShowing() || !(ownedWindow instanceof JDialog) || !((JDialog)ownedWindow).isModal()) continue;
            return true;
        }
        return false;
    }

    public void setNotes(Vector<NoteType> pnoteTypes) {
        if (pnoteTypes.size() > 0 || this.notes.size() > 0) {
            DlgNotes dlgNotes = new DlgNotes(this, StoreParams.res.getString("Notes"), true, this.getUser(), this.notes, pnoteTypes, false);
            dlgNotes.setVisible(true);
            try {
                for (int i = 0; i < this.notes.size(); ++i) {
                    Note note = this.notes.elementAt(i);
                    if (note.nLogidx != 0L || note.noteType.getKeyIdx() == 0L) continue;
                    note.db_save();
                }
            }
            catch (SQLException ex) {
                PosUtils.logError(ex);
            }
            this.notesSet();
        }
    }

    @Override
    public void dispose() {
        this.dispose(true);
    }

    public void dispose(boolean shutdownIfLastFrame) {
        PersonCrypt.getInstance().SetAcquiredAction(this.menuPersonOfflineKey, null);
        this.clearScreenLocks();
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        this.sParams.getStatusListener().unregisterListener(this);
        this.paHead.close();
        if (this.sParams.bUsingFingerprintLogin) {
            this.sParams.FingerprintProvider.unregisterFingerprintListener(this);
        }
        this.menu.frames.removeElement(this);
        if (this.equals(this.menu.getOpenFrame())) {
            this.menu.setOpenFrame(null);
        }
        super.dispose();
        if (shutdownIfLastFrame && this.menu.frames.size() == 0) {
            this.menu.shutdown();
        }
    }

    public void setLastAction() {
        this.lastActionTime = new Date().getTime();
    }

    protected long getLastAction() {
        return this.lastActionTime;
    }

    private void openTill() {
        if (!this.hasSecurity(11130L, 0)) {
            DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
        } else {
            StringBuffer reasonIdx = new StringBuffer("-1");
            StringBuffer reasonNotes = new StringBuffer();
            DlgReason dlgReason = new DlgReason(this, StoreParams.res.getString("Open_Till"), true, 399L, reasonIdx, reasonNotes, true, "", false);
            dlgReason.setVisible(true);
            long transIdx = 0L;
            if (!reasonIdx.toString().equals("-1") && !this.getUser().isTraningUser()) {
                try (Statement stmt = this.sParams.getStmt();){
                    transIdx = this.sParams.nextVal("XRET_TRANH");
                    String docknum = PosUtils.StringToSqlString(PosUtils.padZeroes(this.sParams.getNextDocketNum("PosFrame.openTill, Screen: " + PosMenuController.getScreenName(this.frameType)), 8));
                    stmt.executeUpdate("INSERT INTO RET_TRANH(VHIDX, TR_TYPE, \"ACTIVE\", WIDX, TRAND, TILL_NUMBER,  FREASIDX, NOTES1, SREPIDX, MEMBER_GENERATEDIDX, TRANSSREPIDX, TRANSMEMIDX, DOCKET_NUMBER, COMPLETE, SALE_DATE ) VALUES( " + transIdx + ", " + 620 + ", 1, " + this.sParams.getStoreIdx() + ", CURRENT_TIMESTAMP, " + " " + PosUtils.StringToSqlString(this.sParams.tillnum) + ", " + reasonIdx.toString() + ", " + PosUtils.StringToSqlString(reasonNotes.toString()) + ", " + this.getUser().getPeridx() + ", " + this.getUser().getMemidx() + ", " + this.getUser().getPeridx() + ", " + this.getUser().getMemidx() + ", " + docknum + ", 1, TRUNC_DATE(current_timestamp) ) ");
                    Utils.CopyLikeReferences(this.sParams.conn, 18L, "WHSE", "WIDX", this.sParams.getStoreIdx(), 23L, "RET_TRANH", "VHIDX", transIdx);
                    this.sParams.yTabInsert("RET_TRANH", "VHIDX", "" + transIdx);
                }
                catch (Exception ex) {
                    PosUtils.logError(ex);
                }
                OpenCashDrawer o = new OpenCashDrawer(this.sParams.printerPort, "");
                o.start();
                if (transIdx != 0L && SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.PRINT_DOCKET_ON_OPEN_TILL)) {
                    Receipt receipt = new Receipt(this, StoreParams.res.getString("Printing_Receipt"), false, this.sParams.getDocketConnection(), transIdx, false);
                    receipt.PrintOpenTillDocket();
                }
            }
        }
    }

    protected void checkTillAmts() {
        PayTypes.checkTotals(this);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.isActive()) {
            this.processKeyEvent(e);
        }
        return false;
    }

    public void ToggleImage() {
        if (this.dlgImage == null) {
            this.dlgImage = new DlgImage(this, StoreParams.res.getString("Image"), this.sParams.productImagePath + this.sParams.tillnum + "Image.ini", false);
            this.dlgImage.setVisible(true);
            this.refreshImage();
        } else if (this.dlgImage.isVisible()) {
            this.dlgImage.setVisible(false);
        } else {
            this.dlgImage.setVisible(true);
            this.refreshImage();
        }
    }

    public void ToggleBudget() {
        if (this.dlgBudget == null) {
            this.dlgBudget = new DlgBudget(this, StoreParams.res.getString("Store_Budget"), true);
            if (!this.dlgBudget.populateBudget()) {
                this.dlgBudget.dispose();
                this.dlgBudget = null;
            } else {
                this.dlgBudget.setVisible(true);
            }
        } else if (this.dlgBudget.isVisible()) {
            this.dlgBudget.setVisible(false);
        } else if (!this.dlgBudget.populateBudget()) {
            this.dlgBudget.dispose();
            this.dlgBudget = null;
        } else {
            this.dlgBudget.setVisible(true);
        }
    }

    public void ToggleSlideshow() {
        if (this.slideShow == null) {
            this.slideShow = new SlideShow(this, this.sParams);
            this.slideShow.start();
        } else if (this.slideShow.isRunning()) {
            this.slideShow.endSlidShow();
        } else {
            this.slideShow = new SlideShow(this, this.sParams);
            this.slideShow.start();
        }
    }

    public void ChangeImage(String sStyleCode, String sStyleName) {
        if (this.dlgImage != null && this.dlgImage.isVisible()) {
            String sFileName = null;
            String sTitle = null;
            if (sStyleCode != null && sStyleCode.length() > 0) {
                sFileName = this.sParams.productImagePath + sStyleCode + ".jpg";
                sTitle = StoreParams.res.getString("Style") + " " + sStyleCode + " - " + sStyleName;
            } else {
                sFileName = "";
                sTitle = StoreParams.res.getString("Image");
            }
            this.dlgImage.setImage(sFileName, sTitle);
            this.dlgImage.repaint();
        }
    }

    public Vector<Note> getNotes() {
        return this.notes;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    @Override
    public void statusChanged(boolean status) {
        this.setStatus(status);
    }

    public boolean getPromotionsEnabled() {
        return this.promotionsEnabled;
    }

    public void setPromotionsEnabled(boolean value) {
        this.promotionsEnabled = value;
    }

    @Override
    public void onFingerPrintScanned(String key) {
        if (this.isActive()) {
            if (this.isLoggedIn(false)) {
                this.paHead.logoff();
            }
            this.paHead.setLabelsForScanning(StoreParams.res.getString("Scanning"));
            this.setLastAction();
            this.paHead.loginWithFingerprint(key);
        }
    }

    public TaxMenu getTaxMenu() {
        return this.taxMenu;
    }

    public boolean isTaxLookupDisabled() {
        return this.taxLookupDisabledForTransaction || this.taxLookupDisabledForSession;
    }

    public void setTaxLookupDisabledForTransaction(boolean taxLookupDisabledForTransaction) {
        this.taxLookupDisabledForTransaction = taxLookupDisabledForTransaction;
        if (this.getTaxMenu() != null) {
            this.getTaxMenu().refreshMenu();
        }
    }

    public void setTaxLookupDisabledForSession(boolean taxLookupDisabledForSession) {
        this.taxLookupDisabledForSession = taxLookupDisabledForSession;
        this.taxLookupDisabledForTransaction = taxLookupDisabledForSession;
        if (this.getTaxMenu() != null) {
            this.getTaxMenu().refreshMenu();
        }
    }

    protected boolean getTaxLookupDisabledForSession() {
        return this.taxLookupDisabledForSession;
    }

    public boolean isUsingAlternativePersonMaint() {
        return this.usingOmneoPersonMaint || this.usingCapillaryMicrosite;
    }

    public boolean isAlternativePersonMaintEnabled() {
        return this.isOmneoPersonMaintEnabled() || this.isCapillaryPersonMaintEnabled();
    }

    public boolean isOmneoPersonMaintEnabled() {
        return this.usingOmneoPersonMaint && this.omneoPersonMaintIsEnabled;
    }

    public boolean isCapillaryPersonMaintEnabled() {
        return this.usingCapillaryMicrosite && this.capillaryMicrositeIsEnabled;
    }

    public void setCapillaryCustomer(CapillaryCustomer customer) {
        this.capillaryCustomer = customer;
    }

    public CapillaryCustomer getCapillaryCustomer() {
        return this.capillaryCustomer;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.lastLoggedInUser = user;
    }

    public User getLastLoggedInUser() {
        return this.lastLoggedInUser;
    }

    public void clearLastLoggedInUser() {
        this.lastLoggedInUser = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean lockTransaction(String transNumber, String displayTransNumber, int transType) {
        transNumber = StringUtils.nullToEmpty(transNumber).toUpperCase();
        displayTransNumber = StringUtils.nullToEmpty(displayTransNumber).toUpperCase();
        try {
            stmt = this.sParams.conn.prepareStatement("SELECT TILL_NUMBER, SCREEN_NAME, SCREEN_TYPE FROM TRANS_LOCK WHERE TRANS_NUMBER = ? AND TRANS_TYPE = ?");
            var5_6 = null;
            try {
                stmt.setString(1, transNumber);
                stmt.setInt(2, transType);
                while (true) {
                    r = stmt.executeQuery();
                    var7_9 = null;
                    if (!r.next()) ** GOTO lbl-1000
                    if (!r.getString("TILL_NUMBER").equals(this.sParams.tillnum.toUpperCase()) || r.getInt("SCREEN_TYPE") != this.frameType) ** GOTO lbl-1000
                    var8_11 = true;
                    if (r == null) return var8_11;
                    if (var7_9 != null) {
                    }
                    ** GOTO lbl41
                    {
                        block53: {
                            block56: {
                                block54: {
                                    catch (Throwable var8_14) {
                                        try {
                                            var7_9 = var8_14;
                                            throw var8_14;
                                        }
                                        catch (Throwable var14_28) {
                                            if (r == null) throw var14_28;
                                            if (var7_9 == null) {
                                                r.close();
                                                throw var14_28;
                                            }
                                            try {
                                                r.close();
                                                throw var14_28;
                                            }
                                            catch (Throwable var15_29) {
                                                var7_9.addSuppressed(var15_29);
                                                throw var14_28;
                                            }
                                        }
                                    }
                                    try {
                                        r.close();
                                        return var8_11;
                                    }
                                    catch (Throwable var9_16) {
                                        var7_9.addSuppressed(var9_16);
                                        return var8_11;
                                    }
lbl41:
                                    // 1 sources

                                    r.close();
                                    return var8_11;
lbl-1000:
                                    // 1 sources

                                    {
                                        dlgMessage = new DlgMessage(this, SP.getRS("Transaction_Lock_Title"), MessageFormat.format(SP.getRS("Transaction_Lock_Message"), new Object[]{displayTransNumber, r.getString("TILL_NUMBER"), "\n", r.getString("SCREEN_NAME")}), 2, 0);
                                        dlgMessage.getOkButton().setText(SP.getRS("Retry"));
                                        dlgMessage.setCloseAction(2);
                                        response = dlgMessage.showMessage();
                                        if (response == 0) break block53;
                                        var10_21 = false;
                                        if (r == null) return var10_21;
                                        if (var7_9 == null) break block54;
                                    }
                                    try {
                                        r.close();
                                        return var10_21;
                                    }
                                    catch (Throwable var11_24) {
                                        var7_9.addSuppressed(var11_24);
                                        return var10_21;
                                    }
                                }
                                r.close();
                                return var10_21;
lbl-1000:
                                // 1 sources

                                {
                                    insert = this.sParams.conn.prepareStatement("INSERT INTO TRANS_LOCK(TRANS_NUMBER, TRANS_TYPE, SCREEN_TYPE, SCREEN_NAME, TILL_NUMBER, LOCK_DATE) VALUES(?, ?, ?, ?, ?, CURRENT_TIMESTAMP)");
                                    var9_18 = null;
                                    try {
                                        insert.setString(1, transNumber);
                                        insert.setInt(2, transType);
                                        insert.setInt(3, this.frameType);
                                        insert.setString(4, this.title);
                                        insert.setString(5, this.sParams.tillnum.toUpperCase());
                                        insert.executeUpdate();
                                    }
                                    catch (Throwable var10_23) {
                                        var9_18 = var10_23;
                                        throw var10_23;
                                    }
                                    finally {
                                        if (insert != null) {
                                            if (var9_18 != null) {
                                                try {
                                                    insert.close();
                                                }
                                                catch (Throwable var10_22) {
                                                    var9_18.addSuppressed(var10_22);
                                                }
                                            } else {
                                                insert.close();
                                            }
                                        }
                                    }
                                    var8_12 = true;
                                    if (r == null) return var8_12;
                                    if (var7_9 == null) break block56;
                                }
                                try {
                                    r.close();
                                    return var8_12;
                                }
                                catch (Throwable var9_19) {
                                    var7_9.addSuppressed(var9_19);
                                    return var8_12;
                                }
                            }
                            r.close();
                            return var8_12;
                        }
                        ** try [egrp 18[TRYBLOCK] [23 : 656->754)] { 
lbl100:
                        // 1 sources

                        if (r == null) continue;
                        if (var7_9 != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable var8_13) {
                                var7_9.addSuppressed(var8_13);
                            }
                            continue;
                        }
                        r.close();
                        continue;
                    }
                    break;
                }
            }
lbl110:
            // 2 sources

            catch (Throwable var6_8) {
                var5_6 = var6_8;
                throw var6_8;
            }
            finally {
                if (stmt != null) {
                    if (var5_6 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable var9_17) {
                            var5_6.addSuppressed(var9_17);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            return true;
        }
    }

    public void clearScreenLocks() {
        try (PreparedStatement stmt = this.sParams.conn.prepareStatement("DELETE FROM TRANS_LOCK WHERE SCREEN_TYPE = ? AND TILL_NUMBER = ?");){
            stmt.setInt(1, this.frameType);
            stmt.setString(2, this.sParams.tillnum.toUpperCase());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    public void clearLock(String transnum, int transType) {
        try (PreparedStatement stmt = this.sParams.conn.prepareStatement("DELETE FROM TRANS_LOCK WHERE TRANS_NUMBER = ? AND TRANS_TYPE = ?AND SCREEN_TYPE = ? AND TILL_NUMBER = ?");){
            stmt.setString(1, transnum);
            stmt.setInt(2, transType);
            stmt.setInt(3, this.frameType);
            stmt.setString(4, this.sParams.tillnum.toUpperCase());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    private static /* synthetic */ JFrame lambda$menuFunc_actionPerformed$0() {
        return new BrowserFrame("Ap21_Insight");
    }
}

