/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.Connection;
import java.util.List;
import java.util.Vector;
import jpos.PosUtils;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.StringUtils;

public class SignInSettings {
    private static SignInSettings instance;
    private boolean usernameOnly;
    private boolean fingerprintEnabled;
    private boolean clearUsernameOnAutoSignOutEnabled;
    private boolean autoSignOutAfterTransactionEnabled;
    private boolean autoSignOutAfterStockTransactionEnabled;
    private int autoSignOutInactivitySeconds;
    private List<String> clockOnWorkgroups = new Vector<String>();
    private boolean timeoutEnabled = true;

    public boolean isUsernameOnly() {
        return this.usernameOnly;
    }

    public boolean isFingerprintEnabled() {
        return this.fingerprintEnabled;
    }

    public boolean isClearUsernameOnAutoSignOutEnabled() {
        return this.clearUsernameOnAutoSignOutEnabled;
    }

    public boolean isAutoSignOutAfterTransactionEnabled() {
        return this.autoSignOutAfterTransactionEnabled;
    }

    public boolean isAutoSignOutAfterStockTransactionEnabled() {
        return this.autoSignOutAfterStockTransactionEnabled;
    }

    public long getAutoSignOutInactivitySeconds() {
        return this.autoSignOutInactivitySeconds;
    }

    public List<String> getClockOnWorkgroups() {
        return this.clockOnWorkgroups;
    }

    public boolean isTimeoutEnabled() {
        return this.autoSignOutInactivitySeconds > 0 && this.timeoutEnabled;
    }

    public void setTimeoutEnabled(boolean timeoutEnabled) {
        this.timeoutEnabled = timeoutEnabled;
    }

    private SignInSettings() {
        this.reload();
    }

    public void reload() {
        this.usernameOnly = false;
        this.fingerprintEnabled = false;
        this.clearUsernameOnAutoSignOutEnabled = false;
        this.autoSignOutAfterTransactionEnabled = false;
        this.autoSignOutInactivitySeconds = 0;
        this.clockOnWorkgroups.clear();
        try (Connection conn = StoreParams.createNewConnection();
             SqlQuery qry = new SqlQuery(conn, "SELECT USERNAME_ONLY, AUTO_SIGN_OUT_AFTER_TRANS, AUTO_SIGN_OUT_AFTER_STOCK, AUTO_SIGN_OUT_AFTER_SECONDS, AUTO_SIGN_OUT_CLEAR_USERNAME, FINGERPRINT, CLOCK_ON_WORKGROUPS FROM POS_SIGN_IN_OPTIONS");){
            if (qry.next()) {
                this.usernameOnly = qry.getBoolean("USERNAME_ONLY");
                this.fingerprintEnabled = qry.getBoolean("FINGERPRINT");
                this.clearUsernameOnAutoSignOutEnabled = qry.getBoolean("AUTO_SIGN_OUT_CLEAR_USERNAME");
                this.autoSignOutAfterTransactionEnabled = qry.getBoolean("AUTO_SIGN_OUT_AFTER_TRANS");
                this.autoSignOutAfterStockTransactionEnabled = qry.getBoolean("AUTO_SIGN_OUT_AFTER_STOCK");
                this.autoSignOutInactivitySeconds = qry.getInt("AUTO_SIGN_OUT_AFTER_SECONDS");
                String workgroupsDelimited = qry.getString("CLOCK_ON_WORKGROUPS");
                if (!StringUtils.isNullOrEmpty(workgroupsDelimited)) {
                    String[] workgroups;
                    for (String group : workgroups = workgroupsDelimited.split(",")) {
                        if (group.trim() == "") continue;
                        this.clockOnWorkgroups.add(group);
                    }
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public static SignInSettings getInstance() {
        if (instance == null) {
            instance = new SignInSettings();
        }
        return instance;
    }
}

