/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import jpos.Clr;
import jpos.SkuPrice;

public class Sku {
    static final int QTY_ORIG = 1;
    static final int QTY_CURR = 2;
    static final int QTY_DIFF = 3;
    static final int QTY_LAST = 4;
    static final int QTY_AVAIL = 5;
    static final int QTY_REQ = 6;
    Clr clr;
    private double availableQty = -1.0;
    boolean availQtyChanged = false;
    private double qty = 0.0;
    private double origQty = 0.0;
    private double lastQty = 0.0;
    long idx = -1L;
    double sizeSeq;
    String apn = "";
    private double reqQty = 0.0;
    private SkuPrice skuPrice = new SkuPrice();
    long vshidx = -1L;
    long pozdidx = -1L;

    public Sku(Clr clr, long skuIdx, String apn, double qty, double sizeSeq) {
        this.clr = clr;
        this.idx = skuIdx;
        this.apn = apn;
        this.qty = qty;
        this.sizeSeq = sizeSeq;
        this.skuPrice = new SkuPrice(this.idx);
    }

    public double getQty() {
        return this.qty;
    }

    public void setReqqty(double preqQty) {
        this.reqQty = preqQty;
    }

    public void setQty(double pqty) {
        this.lastQty = this.qty;
        this.qty = pqty;
    }

    public void setQty(int qtyType, double pqty) {
        switch (qtyType) {
            case 2: {
                this.lastQty = this.qty;
                this.qty = pqty;
                break;
            }
            case 1: {
                this.origQty = pqty;
                break;
            }
            case 4: {
                this.lastQty = pqty;
                break;
            }
            case 5: {
                if (this.availableQty == pqty) break;
                this.availQtyChanged = true;
                this.availableQty = pqty;
                break;
            }
            case 6: {
                this.reqQty = pqty;
                break;
            }
            default: {
                this.setQty(2, pqty);
            }
        }
    }

    public void setOrigQty() {
        this.origQty = this.qty;
    }

    public void setOrigQty(double pqty) {
        this.origQty = pqty;
    }

    public void setPrice(double pprice) {
        this.skuPrice.setPrice(pprice);
    }

    public void setOrigPrice(double pprice) {
        this.skuPrice.setOrigPrice(pprice);
    }

    public void setPozdidx(long pPozdidx) {
        this.pozdidx = pPozdidx;
    }

    public String getEAN() {
        return this.apn;
    }

    public double getNet() {
        return this.clr.style.sParams.rnd(this.qty * this.getPrice());
    }

    public double getGross(int qtyType) {
        return this.clr.style.sParams.rnd(this.getQty(qtyType) * this.getPrice());
    }

    public double getGrossLessTax() {
        return this.clr.style.sParams.rnd(this.qty * this.getPriceLessTax());
    }

    public double getPrice() {
        return this.skuPrice.getPrice();
    }

    public double getOrigPrice() {
        return this.skuPrice.getPrice();
    }

    public double getPriceLessTax() {
        return this.clr.style.sParams.rnd(this.getPrice() / (1.0 + this.clr.style.taxPer / 100.0));
    }

    public double getQty(int qtyType) {
        switch (qtyType) {
            case 2: {
                return this.qty;
            }
            case 3: {
                return this.qty - this.origQty;
            }
            case 1: {
                return this.origQty;
            }
            case 4: {
                return this.lastQty;
            }
            case 5: {
                return this.availableQty;
            }
            case 6: {
                return this.reqQty;
            }
        }
        return this.qty;
    }
}

