/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.MessageFormat;
import jpos.PosUtils;
import jpos.SP;
import jpos.StringUtils;

public class StockAdjustmentSku {
    private long skuidx;
    private String stylecode;
    private String clrcode;
    private String sizeval;
    private String stylename;
    private boolean stocked;

    private StockAdjustmentSku(long skuidx) {
        this.skuidx = skuidx;
    }

    public String toString() {
        String sizeval;
        String clrcode;
        String stylecode = StringUtils.nullToEmpty(this.stylecode);
        if (stylecode.length() > 0) {
            stylecode = stylecode + " ";
        }
        if ((clrcode = StringUtils.nullToEmpty(this.clrcode)).length() > 0) {
            clrcode = clrcode + " ";
        }
        if ((sizeval = StringUtils.nullToEmpty(this.sizeval)).length() > 0) {
            sizeval = sizeval + " ";
        }
        String stylename = StringUtils.nullToEmpty(this.stylename);
        return MessageFormat.format(SP.getRS("style_clr_size_description"), stylecode, clrcode, sizeval, stylename);
    }

    public long getSkuidx() {
        return this.skuidx;
    }

    public boolean getStocked() {
        return this.stocked;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StockAdjustmentSku loadStockAdjustmentSku(long skuidx) {
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT STYLE.STYLECODE, CLR.CLRCODE, SKU.SIZEVAL, STYLE.NAME, COALESCE(STYLE.STKFLAG, 0) FROM STYLE, CLR, SKU WHERE STYLE.STYLEIDX = CLR.STYLEIDX AND CLR.CLRIDX = SKU.CLRIDX AND SKU.SKUIDX = ?");){
            stmt.setLong(1, skuidx);
            try (ResultSet result = stmt.executeQuery();){
                if (!result.next()) return null;
                StockAdjustmentSku sku = new StockAdjustmentSku(skuidx);
                sku.stylecode = result.getString(1);
                sku.clrcode = result.getString(2);
                sku.sizeval = result.getString(3);
                sku.stylename = result.getString(4);
                sku.stocked = result.getInt(5) == 1;
                StockAdjustmentSku stockAdjustmentSku = sku;
                return stockAdjustmentSku;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return null;
    }
}

