/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.SQLException;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import jpos.DiscLine;
import jpos.DlgMessage;
import jpos.DlgReason;
import jpos.FrSales;
import jpos.FrTransferIn;
import jpos.FrTransferInAbstact;
import jpos.Note;
import jpos.PaSales;
import jpos.PaTransferIn;
import jpos.PaTransferInAbstract;
import jpos.PosDouble;
import jpos.PosFrame;
import jpos.PosTable;
import jpos.PosUtils;
import jpos.SP;
import jpos.SalesRep;
import jpos.StoreParams;
import jpos.StyleLine;
import jpos.associations.Association;
import jpos.cardfee.CardFeeUtils;
import jpos.stockreceipt.FrStockReceipt;
import jpos.stockreceipt.PaStockReceipt;
import jpos.voucher.VoucherUtils;

public class StyleTableModel
extends AbstractTableModel {
    String[] columnNames;
    private Vector<Object> data = new Vector();
    private Vector<Object> deleted = new Vector();
    StoreParams sParams;
    Vector<Object> vDetailNotesSaved = null;
    boolean editable = true;
    boolean canChangeprice = false;
    boolean allowInvalid = false;
    boolean bShowCostCol = false;
    boolean bShowDelToCol = false;
    boolean bPopulatingRecall = false;
    boolean bEditSpecialOrder = true;
    boolean bIsTransferRequest = false;
    private boolean canEditTax = true;
    private boolean showReceivedCols = true;
    private boolean allowEditingReceivedCol = true;
    private boolean allowEditingTransferOutCol = true;
    private PosFrame frParent;
    private boolean bTaxRemoved = false;
    private boolean loadStockOnHand = false;
    public static final int SALES_LINK = 0;
    public static final int SALES_CODE_COLUMN = 1;
    public static final int SALES_DESC_COLUMN = 2;
    public static final int SALES_COLOUR_COLUMN = 3;
    public static final int SALES_SIZE_COLUMN = 4;
    public static final int SALES_SALESREP = 5;
    public static final int SALES_QTY_COLUMN = 6;
    public static final int SALES_REFUND_ORIG_QTY_COLUMN = 7;
    public static final int SALES_REFUND_RETURNED_QTY_COLUMN = 8;
    public static final int SALES_PRICE_COLUMN = 9;
    public static final int SALES_EXT_TAX_RATE_COLUMN = 10;
    public static final int SALES_EXT_TAX_AMT_COLUMN = 11;
    public static final int SALES_DISC_COLUMN = 12;
    public static final int SALES_NET_COLUMN = 13;
    public static final int SALES_DELTO_COLUMN = 14;
    public static final int SALES_COST_COLUMN = 15;
    public static final int DEBTOR_SALES_LINK = 0;
    public static final int DEBTOR_SALES_CODE_COLUMN = 1;
    public static final int DEBTOR_SALES_DESC_COLUMN = 2;
    public static final int DEBTOR_SALES_COLOUR_COLUMN = 3;
    public static final int DEBTOR_SALES_SIZE_COLUMN = 4;
    public static final int DEBTOR_SALES_SALESREP = 5;
    public static final int DEBTOR_SALES_QTY_COLUMN = 6;
    public static final int DEBTOR_SALES_PRICE_COLUMN = 7;
    public static final int DEBTOR_SALES_DISC_COLUMN = 8;
    public static final int DEBTOR_SALES_NET_COLUMN = 9;
    public static final int CUST_ORDERS_LINK = 0;
    public static final int CUST_ORDERS_CODE_COLUMN = 1;
    public static final int CUST_ORDERS_DESC_COLUMN = 2;
    public static final int CUST_ORDERS_COLOUR_COLUMN = 3;
    public static final int CUST_ORDERS_SIZE_COLUMN = 4;
    public static final int CUST_ORDERS_SALESREP = 5;
    public static final int CUST_ORDERS_QTY_OUTSTANDING_COLUMN = 6;
    public static final int CUST_ORDERS_REFUND_RETURNED_QTY_COLUMN = 7;
    public static final int CUST_ORDERS_QTY_PACKED_COLUMN = 8;
    public static final int CUST_ORDERS_QTY_TAKEN_COLUMN = 9;
    public static final int CUST_ORDERS_QTY_PICKUP_COLUMN = 10;
    public static final int CUST_ORDERS_PRICE_COLUMN = 11;
    public static final int CUST_ORDERS_EXT_TAX_RATE_COLUMN = 12;
    public static final int CUST_ORDERS_EXT_TAX_AMT_COLUMN = 13;
    public static final int CUST_ORDERS_DISC_COLUMN = 14;
    public static final int CUST_ORDERS_NET_COLUMN = 15;
    public static final int TRANSFERIN_CODE_COLUMN = 0;
    public static final int TRANSFERIN_DESC_COLUMN = 1;
    public static final int TRANSFERIN_COLOUR_COLUMN = 2;
    public static final int TRANSFERIN_SIZE_COLUMN = 3;
    public static final int TRANSFERIN_REQ_COLUMN = 4;
    public static final int TRANSFERIN_PREV_RECEIVED_COLUMN = 5;
    public static final int TRANSFERIN_RECEIVED_COLUMN = 6;
    public static final int TRANSFERIN_COST_COLUMN = 7;
    public static final int TRANSFEROUT_CODE_COLUMN = 0;
    public static final int TRANSFEROUT_DESC_COLUMN = 1;
    public static final int TRANSFEROUT_COLOUR_COLUMN = 2;
    public static final int TRANSFEROUT_SIZE_COLUMN = 3;
    public static final int TRANSFEROUT_REQ_COLUMN = 4;
    public static final int TRANSFEROUT_QTY_COLUMN = 5;
    public static final int TRANSFER_REQ_CODE_COLUMN = 0;
    public static final int TRANSFER_REQ_DESC_COLUMN = 1;
    public static final int TRANSFER_REQ_COLOUR_COLUMN = 2;
    public static final int TRANSFER_REQ_SIZE_COLUMN = 3;
    public static final int TRANSFER_REQ_QTY_COLUMN = 4;
    public static final int STKTAKE_BARCODE_COLUMN = 0;
    public static final int STKTAKE_CODE_COLUMN = 1;
    public static final int STKTAKE_DESC_COLUMN = 2;
    public static final int STKTAKE_COLOUR_COLUMN = 3;
    public static final int STKTAKE_SIZE_COLUMN = 4;
    public static final int STKTAKE_QTY_COLUMN = 5;
    public static final int NOTE_CODE_COLUMN = 0;
    public static final int NOTE_DESC_COLUMN = 1;

    protected StyleTableModel(PosFrame frParent, StoreParams psParams) {
        this.sParams = psParams;
        this.frParent = frParent;
        if (frParent.frameType == 3) {
            this.loadStockOnHand = SP.sParams.bUsingSOHInStockReceipts;
            String outstandingHeading = this.loadStockOnHand ? SP.getRS("RequiredSoh") : SP.getRS("Required");
            this.columnNames = new String[]{SP.getRS("Code"), SP.getRS("Description"), SP.getRS("Colour"), SP.getRS("Size"), outstandingHeading, SP.getRS("Prev_Rec"), SP.getRS("Received"), SP.getRS("StkRecCostCol")};
        } else if (frParent.frameType == 5) {
            this.columnNames = new String[]{SP.getRS("Barcode"), SP.getRS("Code"), SP.getRS("Description"), SP.getRS("Colour"), SP.getRS("Size"), SP.getRS("Qty")};
        } else if (frParent.frameType == 2) {
            this.columnNames = new String[]{SP.getRS("Code"), SP.getRS("Description"), SP.getRS("Colour"), SP.getRS("Size"), SP.getRS("Required"), SP.getRS("Qty")};
        } else if (frParent.frameType == 9) {
            this.columnNames = new String[]{SP.getRS("Code"), SP.getRS("Description"), SP.getRS("Colour"), SP.getRS("Size"), SP.getRS("Qty")};
        } else if (frParent.frameType == 1) {
            this.columnNames = new String[]{"", SP.getRS("Code"), SP.getRS("Description"), SP.getRS("Colour"), SP.getRS("Size"), SP.getRS("SalesRep"), SP.getRS("Qty"), SP.getRS("OrigQty"), SP.getRS("ReturnedQty"), SP.getRS("Price"), SP.getRS("Tax_"), SP.getRS("Tax"), SP.getRS("Disc"), SP.getRS("Net"), SP.getRS("DelTo"), SP.getRS("Cost")};
        } else if (frParent.frameType == 12) {
            this.loadStockOnHand = SP.sParams.bUsingSOHInCustOrders;
            String outstandingHeading = this.loadStockOnHand ? SP.getRS("OutstandingSoh") : SP.getRS("Outstanding");
            this.columnNames = new String[]{"", SP.getRS("Code"), SP.getRS("Description"), SP.getRS("Colour"), SP.getRS("Size"), SP.getRS("SalesRep"), outstandingHeading, SP.getRS("ReturnedQty"), SP.getRS("Packed"), SP.getRS("Taken"), SP.getRS("Pick_Up"), SP.getRS("Price"), SP.getRS("Tax_"), SP.getRS("Tax"), SP.getRS("Disc"), SP.getRS("Net")};
        } else if (frParent.frameType == 10) {
            this.columnNames = new String[]{"", SP.getRS("Code"), SP.getRS("Description"), SP.getRS("Colour"), SP.getRS("Size"), SP.getRS("SalesRep"), SP.getRS("Qty"), SP.getRS("Price"), SP.getRS("Disc"), SP.getRS("Net")};
        }
    }

    protected void clear() {
        this.data.clear();
        this.deleted.clear();
        this.fireTableDataChanged();
        this.bTaxRemoved = false;
    }

    protected void clearDeleted() {
        this.deleted.clear();
    }

    public void setPopulatingRecall(boolean pbPopulatingRecall) {
        this.bPopulatingRecall = pbPopulatingRecall;
    }

    public boolean IsRecall() {
        return this.bPopulatingRecall;
    }

    public void setEditSpecialOrder(boolean pbEditSpecialOrder) {
        this.bEditSpecialOrder = pbEditSpecialOrder;
    }

    public boolean canEditSpecialOrder() {
        return this.bEditSpecialOrder;
    }

    protected boolean refund(int row, PosFrame owner, SalesRep returnOverrideSalesRep) {
        Object line = this.data.elementAt(row);
        while (!(line instanceof StyleLine)) {
            line = this.data.elementAt(--row);
        }
        StyleLine style = (StyleLine)line;
        if (style.reasonIdx.toString().equals("-1")) {
            DlgReason reas = new DlgReason(owner, StoreParams.refundreasmsg + " : " + style.stylecode, true, 272L, style.reasonIdx, style.reasonNotes, true, "R.RCIDX NOT IN(568, 569, 644, 645)", true);
            reas.setVisible(true);
            if (style.reasonIdx.toString().equals("-1")) {
                return false;
            }
            if (style.getQty() > 0.0) {
                double retQty = style.getQty() * -1.0;
                if (style.getReturnedQuantity() > 0.0 && (retQty = (style.getOriginalQuantity() - style.getReturnedQuantity()) * -1.0) >= 0.0) {
                    retQty = -1.0;
                }
                style.setQty(retQty);
                style.setOrigQty(0.0);
                style.setAttachedPromoIdx(0L);
                style.setReturnOverrideSalesRep(returnOverrideSalesRep);
                if (this.sParams.useDisplayDevice && owner.frameType == 1) {
                    this.sParams.displayDevice.productChange(style.getSkuidx(), style.getPrice(), false, style.getDisc());
                }
            }
            this.fireTableRowsUpdated(row, row + style.getNumDiscs());
        }
        return true;
    }

    protected int addEAN(PosTable context, String EAN, double pqty, boolean consolidate, boolean showPrice) {
        EAN = EAN.trim();
        if (this.editable) {
            for (int i = 0; i < this.data.size() && consolidate; ++i) {
                StyleLine row;
                if (!(this.data.elementAt(i) instanceof StyleLine) || !EAN.equals((row = (StyleLine)this.getRow(i)).getBarcode()) || row.hasNonLoyaltyDisc() || !(row.getQty() >= 0.0) || (VoucherUtils.isVoucher(row.getSkuidx()) || CardFeeUtils.isCardFee(row.getSkuidx())) && this.frParent.frameType != 5 || (this.frParent.transType == 242 || this.frParent.transType == 241 || this.frParent.transType == 245 || this.frParent.transType == 244 || this.frParent.transType == 715) && !row.isNew()) continue;
                if (!this.canSetValueAt(context, row.getQty(3) + pqty, i, 6)) {
                    return i;
                }
                row.setQty(row.getQty() + pqty);
                switch (this.frParent.frameType) {
                    case 3: {
                        this.fireTableCellUpdated(i, 6);
                        break;
                    }
                    case 2: {
                        this.fireTableCellUpdated(i, 5);
                        break;
                    }
                    case 9: {
                        this.fireTableCellUpdated(i, 4);
                        break;
                    }
                    case 5: {
                        this.fireTableCellUpdated(i, 5);
                        break;
                    }
                    case 1: {
                        this.fireTableCellUpdated(i, 6);
                        break;
                    }
                    case 12: {
                        this.fireTableCellUpdated(i, 6);
                        break;
                    }
                    case 10: {
                        this.fireTableCellUpdated(i, 6);
                        break;
                    }
                }
                return i;
            }
            StyleLine newline = new StyleLine(EAN, this.frParent.frameType != 5, this.sParams, this.loadStockOnHand);
            if (!showPrice) {
                newline.setPrice(0.0);
            }
            if (this.bTaxRemoved) {
                newline.removeTax();
            }
            newline.setQty(pqty);
            if (newline.isValid() || this.allowInvalid) {
                if (this.frParent.frameType == 3) {
                    PaTransferInAbstract panel;
                    FrTransferInAbstact frame;
                    if (this.frParent instanceof FrStockReceipt) {
                        frame = (FrStockReceipt)this.frParent;
                        panel = (PaStockReceipt)frame.paBody;
                    } else {
                        frame = (FrTransferIn)this.frParent;
                        panel = (PaTransferIn)frame.paBody;
                    }
                    if (!(frame.transType != 250 && frame.transType != 251 || this.frParent.transnum == null && frame.pordidx == -1L || frame.canOverReceipt())) {
                        panel.notifyOverReceipt();
                        return -2;
                    }
                    if (frame.transType == 250 && frame.transnum != null && !frame.canReceiptItemsNotOnTransfer()) {
                        panel.notifyItemNotOnTransfer();
                        return -2;
                    }
                    if (frame.transType == 251 && frame.pordidx != -1L && !frame.canReceiptItemsNotOnPurchOrder()) {
                        panel.notifyItemNotOnPurchOrder();
                        return -2;
                    }
                }
                this.data.add(newline);
                int row = this.getRowCount() - 1;
                this.fireTableRowsInserted(row, row);
                row = this.data.indexOf(newline);
                if (row > -1) {
                    return row;
                }
                return this.getRowCount() - 1;
            }
            return -1;
        }
        return -2;
    }

    private boolean canSetValueAt(PosTable context, double value, int row, int col) {
        try {
            context.fireTableValueChangingEvent(value, row, col);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isNonZeroQty(int row) {
        return this.data.elementAt(row) instanceof StyleLine && ((StyleLine)this.data.elementAt(row)).getQty() != 0.0;
    }

    protected boolean isNegQty(int row) {
        return this.data.elementAt(row) instanceof StyleLine && ((StyleLine)this.data.elementAt(row)).getQty() < 0.0;
    }

    protected StyleLine getStyle(long skuidx) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (!(this.data.elementAt(i) instanceof StyleLine) || ((StyleLine)this.data.elementAt(i)).getSkuidx() != skuidx) continue;
            return (StyleLine)this.data.elementAt(i);
        }
        return null;
    }

    protected int addSku(long sku, double qty, boolean oldLine, boolean bMergeQty) {
        if (this.editable) {
            if (bMergeQty) {
                for (int i = 0; i < this.data.size(); ++i) {
                    if (!(this.data.elementAt(i) instanceof StyleLine) || sku != ((StyleLine)this.data.elementAt(i)).getSkuidx()) continue;
                    ((StyleLine)this.data.elementAt(i)).setQty(((StyleLine)this.data.elementAt(i)).getQty() + qty);
                    return i;
                }
            }
            StyleLine newline = new StyleLine(sku, qty, this.sParams, this.loadStockOnHand);
            newline.setNew(!oldLine);
            if (this.frParent.frameType == 3) {
                newline.setVal(4, "0", this.frParent.frameType);
                newline.setReqQty(qty);
            }
            if (this.frParent.frameType == 2 && this.isTransferRequest()) {
                newline.setVal(4, "0", this.frParent.frameType);
                newline.setReqQty(qty);
                newline.setQty(0.0);
                newline.setTransferRequest(true);
            }
            if (newline.isValid()) {
                this.data.add(newline);
                int row = this.getRowCount() - 1;
                if (this.bTaxRemoved) {
                    newline.removeTax();
                }
                this.fireTableRowsInserted(row, row);
                return row;
            }
            return -1;
        }
        return -2;
    }

    protected int addStyleLine(StyleLine row) {
        this.data.add(row);
        if (this.bTaxRemoved) {
            row.removeTax();
        }
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
        return this.getRowCount() - 1;
    }

    protected int addNote(StyleLine style, Note note, int row) {
        if (!style.getNotes().contains(note)) {
            style.getNotes().add(note);
        }
        note.styleParent = style;
        this.data.insertElementAt(note, (row += style.getDiscLines().size()) + 1);
        this.fireTableRowsInserted(row + 1, row + 1);
        return row + 1;
    }

    public boolean addDiscLine(DiscLine disc) {
        if (this.editable) {
            int row = this.data.indexOf(disc.getStyleParent()) + disc.getStyleParent().getDiscLines().indexOf(disc) + 1;
            this.data.add(row, disc);
            this.fireTableRowsInserted(row, row);
            return true;
        }
        return false;
    }

    protected Vector<Object> delLine(int row, PosFrame frParent, boolean checkFeeSku, boolean storeDeleted) {
        Vector<Object> lines = new Vector<Object>(5, 1);
        if (this.editable && row < this.data.size()) {
            Object line = this.data.elementAt(row);
            lines.add(line);
            if (line instanceof StyleLine) {
                if (checkFeeSku && this.sParams.isLaybyFeeSku(((StyleLine)line).getSkuidx()) && !frParent.hasSecurity(11129L, 0)) {
                    DlgMessage.showMessage(frParent, StoreParams.res.getString("no_security"), StoreParams.res.getString("Remove_Layby_Fee"), 2);
                    lines.clear();
                    return lines;
                }
                while (row + 1 < this.data.size() && !(this.data.elementAt(row + 1) instanceof StyleLine)) {
                    lines.add(this.data.remove(row + 1));
                    if (!(lines.elementAt(lines.size() - 1) instanceof DiscLine)) continue;
                    ((DiscLine)lines.elementAt(lines.size() - 1)).getDiscParent().getDiscLines().remove(lines.elementAt(lines.size() - 1));
                }
                for (int i = 0; i < this.data.size(); ++i) {
                    if (!(this.data.elementAt(i) instanceof StyleLine) || this.data.elementAt(i) == line || ((StyleLine)this.data.elementAt(i)).getSplitFromStyleLine() == null || ((StyleLine)this.data.elementAt(i)).getSplitFromStyleLine() != line) continue;
                    ((StyleLine)this.data.elementAt(i)).setSplitFromStyleLine(null);
                }
            } else if (line instanceof DiscLine) {
                ((DiscLine)line).getStyleParent().removeDisc((DiscLine)line);
                ((DiscLine)line).getDiscParent().getDiscLines().remove(line);
            } else if (line instanceof Note) {
                ((Note)line).styleParent.getNotes().remove(line);
            }
            this.data.remove(row);
            if (storeDeleted) {
                this.deleted.addAll(lines);
            }
            this.fireTableRowsDeleted(row, row + lines.size() - 1);
        }
        return lines;
    }

    protected double getQty(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getQty();
        }
        return 0.0;
    }

    protected void setCosting(int row, String Cost, boolean onlineOverWrite) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.data.elementAt(row)).setCosting(Cost, onlineOverWrite);
        }
    }

    protected void fetchCostings(int row, long supidx) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.data.elementAt(row)).fetchCostings(supidx);
            this.fireTableCellUpdated(row, 7);
        }
    }

    protected String getCosting(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getCosting();
        }
        return "00.0000";
    }

    protected void setDefault(int row, boolean bDefault) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.data.elementAt(row)).setDefault(bDefault);
        }
    }

    protected void getDefault(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.data.elementAt(row)).getDefault();
        }
    }

    protected void setSalesRep(int row, long sRepIdx, String sRepName) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.data.elementAt(row)).setSalesRep(sRepIdx, sRepName);
        }
    }

    protected void setAssociations(int row, Vector<Association> associations, boolean linked) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.data.elementAt(row)).setAssociations(associations);
            ((StyleLine)this.data.elementAt(row)).setLinked(linked);
        }
    }

    protected String getSalesRep(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getSalesRepName();
        }
        return "";
    }

    protected long getSalesRepIdx(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getSalesRepIdx();
        }
        return 0L;
    }

    protected Vector<Association> getAssociations(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getAssociations();
        }
        return null;
    }

    protected void setReturnedQty(int row, double qty) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.data.elementAt(row)).setReturnedQuantity(qty);
        }
    }

    protected double getReturnedQty(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getReturnedQuantity();
        }
        return 0.0;
    }

    protected void setOriginalQty(int row, double qty) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.data.elementAt(row)).setOriginalQuantity(qty);
        }
    }

    protected double getOriginalQty(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getOriginalQuantity();
        }
        return 0.0;
    }

    protected double getQtyIgnoreFees(int row) {
        StyleLine styleLine;
        if (this.data.elementAt(row) instanceof StyleLine && (styleLine = (StyleLine)this.data.elementAt(row)).getSkuidx() != this.sParams.lbAdminFeeSku && styleLine.getSkuidx() != this.sParams.lbCancFeeSku && styleLine.getSkuidx() != this.sParams.specOrdAdminFeeSku && styleLine.getSkuidx() != this.sParams.specOrdCancFeeSku) {
            return styleLine.getQty();
        }
        return 0.0;
    }

    protected double getPickUpQty(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getPickUpQty();
        }
        return 0.0;
    }

    protected double getPackedQty(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getPackedQty();
        }
        return 0.0;
    }

    protected double getOutstandingQty(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getOutstandingQty();
        }
        return 0.0;
    }

    protected double getOutstandingPackedQty(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getOutstandingPackedQty();
        }
        return 0.0;
    }

    protected double getTakenQty(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getTakenQty();
        }
        return 0.0;
    }

    protected double getAvailQty(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getQty(5);
        }
        return 0.0;
    }

    protected Object getItemAt(int row) {
        return this.data.elementAt(row);
    }

    protected double getOrigQty(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getQty(1);
        }
        return 0.0;
    }

    protected double getReqQty(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getQty(6);
        }
        return 0.0;
    }

    protected int getDelRowCnt() {
        return this.deleted.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public void setColumnName(int col, String name) {
        this.columnNames[col] = name;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object line = this.data.elementAt(row);
        if (this.frParent.frameType == 5 && col == 0) {
            return ((StyleLine)line).getBarcode();
        }
        if (line instanceof DiscLine) {
            return ((DiscLine)line).getVal(col, this.frParent.frameType);
        }
        if (line instanceof StyleLine) {
            Object tempObj = ((StyleLine)line).getVal(col, this.frParent.frameType);
            if (col == 5 && (tempObj.toString() == null || tempObj.toString() == "")) {
                tempObj = ((FrSales)this.frParent).salesRep.getName();
            }
            return tempObj;
        }
        if (line instanceof Note) {
            switch (col) {
                case 0: {
                    return ((Note)line).ref;
                }
                case 1: {
                    return line;
                }
            }
            return "";
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean bCanEdit;
        if (!this.editable) {
            bCanEdit = false;
        } else if (this.frParent.frameType == 1 && !this.bEditSpecialOrder) {
            bCanEdit = false;
        } else if (row >= this.data.size()) {
            bCanEdit = false;
        } else if (this.data.elementAt(row) instanceof StyleLine) {
            StyleLine ele = (StyleLine)this.data.elementAt(row);
            block0 : switch (this.frParent.frameType) {
                case 1: {
                    switch (col) {
                        case 2: {
                            if (ele.getStkFlag() == 0) {
                                if (ele.getGvNum() != null || !ele.isNew() || !ele.isValid() || CardFeeUtils.isCardFee(ele.getSkuidx())) {
                                    bCanEdit = false;
                                    break block0;
                                }
                                bCanEdit = true;
                                break block0;
                            }
                            bCanEdit = false;
                            break block0;
                        }
                        case 5: {
                            bCanEdit = false;
                            break block0;
                        }
                        case 0: {
                            bCanEdit = false;
                            break block0;
                        }
                        case 6: {
                            if (ele.getGvNum() != null || this.sParams.isLaybyFeeSku(ele.getSkuidx()) || CardFeeUtils.isCardFee(ele.getSkuidx()) || ele.getGift() != null) {
                                bCanEdit = false;
                                break block0;
                            }
                            bCanEdit = true;
                            break block0;
                        }
                        case 7: {
                            if (!ele.isNew()) {
                                bCanEdit = false;
                                break block0;
                            }
                            bCanEdit = true;
                            break block0;
                        }
                        case 8: {
                            bCanEdit = false;
                            break block0;
                        }
                        case 9: {
                            if (!ele.isNew() || !this.canChangeprice && ele.getPriceBeforeUserChange() != 0.0) {
                                bCanEdit = false;
                                break block0;
                            }
                            bCanEdit = true;
                            break block0;
                        }
                        case 10: {
                            if (ele.isNew() && this.sParams.bUsingExtendedTax && this.canEditTax && !this.sParams.bUsingTaxLookup) {
                                bCanEdit = true;
                                break block0;
                            }
                            bCanEdit = false;
                            break block0;
                        }
                        case 11: {
                            if (ele.isNew() && this.sParams.bUsingExtendedTax && this.canEditTax && this.sParams.bUsingTaxLookup) {
                                bCanEdit = true;
                                break block0;
                            }
                            bCanEdit = false;
                            break block0;
                        }
                        case 14: {
                            if (!ele.getGenPurchaseOrder() || !this.bShowDelToCol) {
                                bCanEdit = false;
                                break block0;
                            }
                            bCanEdit = true;
                            break block0;
                        }
                        case 15: {
                            if (!ele.getChangeCost() || !this.bShowDelToCol) {
                                bCanEdit = false;
                                break block0;
                            }
                            bCanEdit = true;
                            break block0;
                        }
                    }
                    bCanEdit = false;
                    break;
                }
                case 10: {
                    switch (col) {
                        case 5: {
                            bCanEdit = false;
                            break block0;
                        }
                        case 0: {
                            bCanEdit = false;
                            break block0;
                        }
                        case 2: {
                            if (ele.getStkFlag() == 0) {
                                if (ele.getGvNum() != null || !ele.isNew() || !ele.isValid() || CardFeeUtils.isCardFee(ele.getSkuidx())) {
                                    bCanEdit = false;
                                    break block0;
                                }
                                bCanEdit = true;
                                break block0;
                            }
                            bCanEdit = false;
                            break block0;
                        }
                        case 6: {
                            if (ele.getGvNum() != null || this.sParams.isLaybyFeeSku(ele.getSkuidx()) || CardFeeUtils.isCardFee(ele.getSkuidx()) || ele.getGift() != null) {
                                bCanEdit = false;
                                break block0;
                            }
                            bCanEdit = true;
                            break block0;
                        }
                    }
                    bCanEdit = false;
                    break;
                }
                case 12: {
                    switch (col) {
                        case 2: {
                            if (ele.getStkFlag() == 0) {
                                if (ele.getGvNum() != null || !ele.isNew() || !ele.isValid() || CardFeeUtils.isCardFee(ele.getSkuidx())) {
                                    bCanEdit = false;
                                    break block0;
                                }
                                bCanEdit = true;
                                break block0;
                            }
                            bCanEdit = false;
                            break block0;
                        }
                        case 5: {
                            bCanEdit = false;
                            break block0;
                        }
                        case 0: {
                            bCanEdit = false;
                            break block0;
                        }
                        case 6: {
                            if (ele.getGvNum() != null || CardFeeUtils.isCardFee(ele.getSkuidx()) || ele.getGift() != null) {
                                bCanEdit = false;
                                break block0;
                            }
                            bCanEdit = true;
                            break block0;
                        }
                        case 11: {
                            if (!ele.isNew() || !this.canChangeprice && ele.getPriceBeforeUserChange() != 0.0) {
                                bCanEdit = false;
                                break block0;
                            }
                            bCanEdit = true;
                            break block0;
                        }
                        case 12: {
                            if (ele.isNew() && ele.getQty() >= 0.0 && this.sParams.bUsingExtendedTax && this.canEditTax && !this.sParams.bUsingTaxLookup) {
                                bCanEdit = true;
                                break block0;
                            }
                            bCanEdit = false;
                            break block0;
                        }
                        case 13: {
                            if (ele.isNew() && ele.getQty() >= 0.0 && this.sParams.bUsingExtendedTax && this.canEditTax && this.sParams.bUsingTaxLookup) {
                                bCanEdit = true;
                                break block0;
                            }
                            bCanEdit = false;
                            break block0;
                        }
                    }
                    bCanEdit = false;
                    break;
                }
                case 5: {
                    switch (col) {
                        case 5: {
                            bCanEdit = true;
                            break block0;
                        }
                    }
                    bCanEdit = false;
                    break;
                }
                case 2: {
                    switch (col) {
                        case 5: {
                            bCanEdit = this.allowEditingTransferOutCol;
                            break block0;
                        }
                    }
                    bCanEdit = false;
                    break;
                }
                case 9: {
                    switch (col) {
                        case 4: {
                            bCanEdit = true;
                            break block0;
                        }
                    }
                    bCanEdit = false;
                    break;
                }
                case 3: {
                    switch (col) {
                        case 6: {
                            boolean adhoc = false;
                            if (this.frParent instanceof FrTransferIn) {
                                adhoc = ((FrTransferIn)this.frParent).getAdhoc();
                            } else if (this.frParent instanceof FrStockReceipt) {
                                adhoc = ((FrStockReceipt)this.frParent).getAdhoc();
                            }
                            if (adhoc && this.sParams.bRecptCost && this.frParent.hasSecurity(12667L, 0)) {
                                bCanEdit = true;
                                break block0;
                            }
                            bCanEdit = this.showReceivedCols && this.allowEditingReceivedCol;
                            break block0;
                        }
                        case 7: {
                            bCanEdit = this.sParams.bRecptCost;
                            break block0;
                        }
                    }
                    bCanEdit = false;
                    break;
                }
                default: {
                    bCanEdit = false;
                }
            }
        } else {
            bCanEdit = false;
        }
        return bCanEdit;
    }

    protected void setNonReturnableFlag(int row, boolean nonReturnable) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.data.elementAt(row)).setNonReturnable(nonReturnable);
        }
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        try {
            Object orgValue = value;
            if (row < this.getRowCount()) {
                if (this.data.elementAt(row) instanceof DiscLine) {
                    this.fireTableRowsUpdated(row - 1, row);
                } else if (this.data.elementAt(row) instanceof StyleLine) {
                    double val;
                    if (this.frParent.frameType == 3 && col != 0) {
                        val = PosUtils.doubleValFormatted(value.toString()) + ((StyleLine)this.data.elementAt(row)).getQty(1);
                        if (col == 6) {
                            val = PosUtils.scale(val, 0);
                        }
                        if (col != 7) {
                            value = PosDouble.valueOf(val);
                        }
                    }
                    if (this.frParent.frameType == 2 && col == 5) {
                        value = PosDouble.valueOf(PosUtils.scale(PosUtils.doubleValFormatted(value.toString()), 0));
                    }
                    if (this.frParent.frameType == 3 && col == 0) {
                        value = orgValue;
                    } else if (this.frParent.frameType == 3 && PosUtils.doubleValFormatted(value.toString()) < ((StyleLine)this.data.elementAt(row)).getQty(1)) {
                        value = PosDouble.valueOf(((StyleLine)this.data.elementAt(row)).getQty(1));
                    } else if (PosUtils.doubleValFormatted(value.toString()) < 0.0) {
                        switch (this.frParent.frameType) {
                            case 1: {
                                StyleLine line;
                                val = PosUtils.doubleValFormatted(value.toString());
                                if (col != 6 || !((line = (StyleLine)this.data.elementAt(row)).getQty() > 0.0)) break;
                                value = "0";
                                break;
                            }
                            case 10: {
                                if (col != 6 || !(((StyleLine)this.data.elementAt(row)).getQty() >= 0.0)) break;
                                value = "0";
                                break;
                            }
                            case 12: {
                                if (col != 6 && col != 8 && col != 10 || !(((StyleLine)this.data.elementAt(row)).getQty() >= 0.0)) break;
                                value = "0";
                                break;
                            }
                            case 3: {
                                if (col != 6) break;
                                value = "0";
                                break;
                            }
                            case 2: {
                                if (col != 5) break;
                                value = "0";
                                break;
                            }
                            case 9: {
                                if (col != 4) break;
                                value = "0";
                                break;
                            }
                            case 5: {
                                if (col != 5) break;
                                value = "0";
                                break;
                            }
                        }
                    }
                    double qtyBefore = ((StyleLine)this.data.elementAt(row)).getQty();
                    long skuIdx = ((StyleLine)this.data.elementAt(row)).getSkuidx();
                    double price = ((StyleLine)this.data.elementAt(row)).getPrice();
                    if (((StyleLine)this.data.elementAt(row)).setVal(col, value, this.frParent.frameType)) {
                        this.fireTableCellUpdated(row, col);
                        if (this.sParams.useDisplayDevice && this.frParent.frameType == 1) {
                            double qtyAfter;
                            if (col == 9) {
                                price = PosUtils.doubleValFormatted(value.toString());
                                this.sParams.displayDevice.productChange(skuIdx, price, true, ((PaSales)((FrSales)this.frParent).paBody).tblStyles.getDisc());
                            } else if (col == 6 && qtyBefore != (qtyAfter = PosUtils.doubleValFormatted(value.toString()))) {
                                this.sParams.displayDevice.productChange(skuIdx, price, qtyBefore < qtyAfter, ((PaSales)((FrSales)this.frParent).paBody).tblStyles.getDisc());
                            }
                        }
                    } else if (!((StyleLine)this.data.elementAt(row)).getSetValErrorMessage().equals("")) {
                        DlgMessage.showMessage(this.frParent, ((StyleLine)this.data.elementAt(row)).getSetValErrorMessage(), StoreParams.res.getString("Stop"), 0);
                    }
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    protected double getDue(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getNet();
        }
        return 0.0;
    }

    protected double getDueAvailableForManualLoyalty(int row) {
        StyleLine s;
        if (this.data.elementAt(row) instanceof StyleLine && !(s = (StyleLine)this.data.elementAt(row)).getSkuPrice().stopDiscountsClr() && s.isNew() && !VoucherUtils.isVoucher(s.getSkuidx())) {
            return Math.max(((StyleLine)this.data.elementAt(row)).getNet(), 0.0);
        }
        return 0.0;
    }

    protected double getDueApplicableForRewardsAccrual(int row, boolean accrueOnFullPriceOnly) {
        StyleLine s;
        long freightSku = PosUtils.getFreightSku();
        if (this.data.elementAt(row) instanceof StyleLine && (s = (StyleLine)this.data.elementAt(row)).isNew() && s.getSkuidx() != freightSku && !SP.sParams.defaultSkus.contains(String.valueOf(s.getSkuidx()))) {
            boolean fullPriceStyleLine;
            boolean bl = fullPriceStyleLine = !s.hasMarkdown() && !s.hasNonLoyaltyDisc();
            if (!accrueOnFullPriceOnly || fullPriceStyleLine) {
                return ((StyleLine)this.data.elementAt(row)).getNet();
            }
        }
        return 0.0;
    }

    protected double getPickupDue(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getPickupNet();
        }
        return 0.0;
    }

    protected double getTakenDue(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getTakenNet();
        }
        return 0.0;
    }

    protected double getDelDue(int row) {
        if (this.deleted.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.deleted.elementAt(row)).getNet();
        }
        return 0.0;
    }

    protected double getGross(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getGross(2);
        }
        return 0.0;
    }

    protected String getBarcode(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getBarcode();
        }
        return "";
    }

    protected double getDisc(int row) {
        if (this.data.elementAt(row) instanceof DiscLine) {
            return ((DiscLine)this.data.elementAt(row)).getNet();
        }
        return 0.0;
    }

    protected double getTax(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            return ((StyleLine)this.data.elementAt(row)).getTax();
        }
        return 0.0;
    }

    protected boolean isEditable() {
        return this.editable;
    }

    protected void db_insertLine(int row) throws SQLException {
        if (this.data.elementAt(row) instanceof StyleLine) {
            if (this.frParent instanceof FrSales && ((StyleLine)this.data.elementAt(row)).getSalesRepIdx() == 0L) {
                ((StyleLine)this.data.elementAt(row)).setSalesRep(((FrSales)this.frParent).salesRep.getPeridx(), ((FrSales)this.frParent).salesRep.getName());
            }
            ((StyleLine)this.data.elementAt(row)).db_insertline();
        } else if (this.data.elementAt(row) instanceof DiscLine) {
            ((DiscLine)this.data.elementAt(row)).db_insertline();
        } else if (this.data.elementAt(row) instanceof Note && ((Note)this.data.elementAt((int)row)).nLogidx == 0L) {
            ((Note)this.data.elementAt((int)row)).noteType.setKeyIdx(((Note)this.data.elementAt((int)row)).styleParent.getVshidx(), true);
            if (this.vDetailNotesSaved != null) {
                this.vDetailNotesSaved.add(this.data.elementAt(row));
            }
            ((Note)this.data.elementAt(row)).db_save();
        }
    }

    protected void backupQtyBeforeSave(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.data.elementAt(row)).backupQtyBeforeSave();
        }
    }

    protected void db_insertLineAdj(int row) throws SQLException {
        if (this.data.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.data.elementAt(row)).setAdjustment();
            ((StyleLine)this.data.elementAt(row)).db_insertline();
        } else if (this.data.elementAt(row) instanceof DiscLine) {
            ((DiscLine)this.data.elementAt(row)).db_insertline();
        }
    }

    protected void db_insertDelLineAdj(int row) throws SQLException {
        if (this.deleted.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.deleted.elementAt(row)).setQty(0.0 - ((StyleLine)this.deleted.elementAt(row)).getQty(1));
            ((StyleLine)this.deleted.elementAt(row)).setPackedQty(0.0 - ((StyleLine)this.deleted.elementAt(row)).getQty(7));
            ((StyleLine)this.deleted.elementAt(row)).setPickUpQty(0.0);
            ((StyleLine)this.deleted.elementAt(row)).db_insertline();
        } else if (this.deleted.elementAt(row) instanceof DiscLine && !((DiscLine)this.deleted.elementAt(row)).isNew()) {
            ((DiscLine)this.deleted.elementAt(row)).db_insertline();
        }
    }

    protected void db_saveStkTake(int row, long vhidx, long st_vshidx) throws SQLException {
        if (this.data.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.data.elementAt(row)).db_saveStkTake(vhidx, st_vshidx);
        }
    }

    protected void db_delLine(int row) throws SQLException {
        if (this.deleted.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.deleted.elementAt(row)).db_delLine();
        }
    }

    protected void setReason(int row, String reasidx) {
        if (this.data.elementAt(row) instanceof StyleLine && ((StyleLine)this.data.elementAt(row)).getQty(1) != ((StyleLine)this.data.elementAt(row)).getQty()) {
            ((StyleLine)this.data.elementAt((int)row)).reasonIdx.replace(0, ((StyleLine)this.data.elementAt((int)row)).reasonIdx.length(), reasidx);
        }
    }

    protected void setDelReason(int row, String reasidx) {
        if (this.deleted.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.deleted.elementAt((int)row)).reasonIdx.replace(0, ((StyleLine)this.deleted.elementAt((int)row)).reasonIdx.length(), reasidx);
        }
    }

    protected boolean isBalanced(int row) {
        if (this.frParent.frameType != 3) {
            return true;
        }
        return ((StyleLine)this.data.elementAt(row)).getVal(4, this.frParent.frameType).equals(((StyleLine)this.data.elementAt(row)).getVal(5, this.frParent.frameType));
    }

    protected Object getRow(int row) {
        if (this.data.size() > row) {
            return this.data.elementAt(row);
        }
        return null;
    }

    protected void initOrigQtys(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.data.elementAt(row)).initOrigQtys();
        }
    }

    protected void setOrigQty(int row, double qty) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.data.elementAt(row)).setOrigQty(qty);
        }
    }

    protected void setQty(int row, double qty) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.data.elementAt(row)).setQty(qty);
        }
    }

    protected void setCost(int row, double cost) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.data.elementAt(row)).setCost(cost);
        }
    }

    protected void setQty(int row) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.data.elementAt(row)).setQty(((StyleLine)this.data.elementAt(row)).getQty(4));
        }
    }

    protected void setEditable(boolean ed) {
        this.editable = ed;
    }

    protected void setNewRow(int row, boolean pnew) {
        if (this.data.elementAt(row) instanceof StyleLine) {
            ((StyleLine)this.data.elementAt(row)).setNew(pnew);
        }
    }

    public void setAllowInvalid(boolean pallowInvalid) {
        this.allowInvalid = pallowInvalid;
    }

    protected int rowNumOf(Object row) {
        return this.data.indexOf(row);
    }

    public void setTransferRequest(boolean b) {
        this.bIsTransferRequest = b;
    }

    public boolean isTransferRequest() {
        return this.bIsTransferRequest;
    }

    public Vector<Object> getData() {
        return this.data;
    }

    public void setCanEditTax(boolean canEditTax) {
        this.canEditTax = canEditTax;
    }

    public void setShowReceivedCols(boolean showReceivedCols) {
        this.showReceivedCols = showReceivedCols;
    }

    public void setAllowEditingReceivedCol(boolean allowEditing) {
        this.allowEditingReceivedCol = allowEditing;
    }

    public void setAllowEditingTransferOutCol(boolean allowEditing) {
        this.allowEditingTransferOutCol = allowEditing;
    }

    public void removeTax() {
        if (!this.bTaxRemoved) {
            if (this.data.size() > 0) {
                for (int i = 0; i < this.data.size(); ++i) {
                    if (!(this.data.elementAt(i) instanceof StyleLine)) continue;
                    ((StyleLine)this.getRow(i)).removeTax();
                }
                this.fireTableRowsUpdated(0, this.data.size() - 1);
            }
            this.bTaxRemoved = true;
        }
    }
}

