/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jpos.SP;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchButton;
import jpos.ui.UIConstants;

public class SubstituteProductsPanel
extends JPanel {
    public static final int BUTTON_WIDTH = 200;
    private JPanel subPanel;
    private Consumer<SubstituteProduct> handleSelectedSubstitute;

    public SubstituteProductsPanel() {
        this(null, null);
    }

    public SubstituteProductsPanel(List<SubstituteProduct> substituteProducts, Consumer<SubstituteProduct> handleSelectedSubstitute) {
        super(new GridBagLayout());
        this.handleSelectedSubstitute = handleSelectedSubstitute;
        LabelSubHeading heading = new LabelSubHeading(SP.getRS("Substitute_Products"));
        heading.setHorizontalAlignment(0);
        final JScrollPane scrollPane = new JScrollPane(){

            @Override
            public Dimension getMinimumSize() {
                Dimension d = super.getMinimumSize();
                Dimension scrollBarSize = super.getVerticalScrollBar().getPreferredSize();
                d.width = 200 + scrollBarSize.width;
                return d;
            }

            @Override
            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }
        };
        this.subPanel = new JPanel(new GridBagLayout()){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                if (scrollPane.getVerticalScrollBar().isVisible()) {
                    Dimension scrollBarSize = scrollPane.getVerticalScrollBar().getPreferredSize();
                    d.width -= scrollBarSize.width;
                }
                return d;
            }
        };
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getVerticalScrollBar().setUnitIncrement(UIConstants.BUTTON_HEIGHT);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.getViewport().add(this.subPanel);
        this.add((Component)heading, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.setProducts(substituteProducts);
    }

    public void setSelectedSubstituteHandler(Consumer<SubstituteProduct> handleSelectedSubstitute) {
        this.handleSelectedSubstitute = handleSelectedSubstitute;
    }

    public void setProducts(List<SubstituteProduct> substituteProducts) {
        this.subPanel.removeAll();
        boolean shouldBeVisible = false;
        if (substituteProducts != null && substituteProducts.size() > 0) {
            shouldBeVisible = true;
            for (int i = 0; i < substituteProducts.size(); ++i) {
                TouchButton productButton = new TouchButton(""){

                    @Override
                    public int getButtonWidth() {
                        return 200;
                    }

                    @Override
                    public int getButtonHeight() {
                        return UIConstants.BUTTON_HEIGHT;
                    }
                };
                productButton.setText(substituteProducts.get(i).getStyleCode());
                if (this.handleSelectedSubstitute != null) {
                    final SubstituteProduct substitute = substituteProducts.get(i);
                    productButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SubstituteProductsPanel.this.handleSelectedSubstitute.accept(substitute);
                        }
                    });
                }
                this.subPanel.add((Component)productButton, new GridBagConstraints(0, i + 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 10, 10, 10), 0, 0));
            }
            this.subPanel.add((Component)new JLabel(), new GridBagConstraints(0, substituteProducts.size() + 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.setVisible(shouldBeVisible);
    }

    public static class SubstituteProduct {
        private long clrIdx;
        private String styleCode;

        public long getClrIdx() {
            return this.clrIdx;
        }

        public String getStyleCode() {
            return this.styleCode;
        }

        public SubstituteProduct(long clrIdx, String styleCode) {
            this.clrIdx = clrIdx;
            this.styleCode = styleCode;
        }
    }
}

