/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.io.Reader;
import java.io.StringReader;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import jpos.PosUtils;
import jpos.StringUtils;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public class XMLUtils {
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-M-d H:m:s");

    public static boolean getBooleanValue(Element element, String attributeName) {
        if (element != null && element.getAttribute(attributeName) != null) {
            try {
                return element.getAttribute(attributeName).getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasValue(Element element, String attributeName) {
        return !XMLUtils.getValue(element, attributeName).equals("");
    }

    public static String getValue(Element element, String attributeName) {
        if (element != null && element.getAttribute(attributeName) != null) {
            return StringUtils.nullToEmpty(element.getAttribute(attributeName).getValue());
        }
        return "";
    }

    public static long getLongValue(Element element, String attributeName) {
        if (element != null && element.getAttribute(attributeName) != null) {
            try {
                return element.getAttribute(attributeName).getLongValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public static double getDoubleValue(Element element, String attributeName) {
        if (element != null && element.getAttribute(attributeName) != null) {
            try {
                return element.getAttribute(attributeName).getDoubleValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        return 0.0;
    }

    public static String toString(Element e) {
        if (e == null) {
            return "";
        }
        XMLOutputter output = new XMLOutputter();
        return output.outputString(e);
    }

    public static LocalDate getDate(Element element, String attributeName) {
        String value;
        if (element != null && element.getAttribute(attributeName) != null && (value = element.getAttribute(attributeName).getValue()) != null && !value.isEmpty()) {
            try {
                return LocalDate.parse(value, dateFormat);
            }
            catch (DateTimeParseException e) {
                try {
                    return LocalDate.parse(value, DateTimeFormatter.ISO_LOCAL_DATE);
                }
                catch (DateTimeParseException ex) {
                    try {
                        LocalDateTime dateTime = LocalDateTime.parse(value, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                        return dateTime.toLocalDate();
                    }
                    catch (DateTimeParseException ext) {
                        return null;
                    }
                }
            }
        }
        return null;
    }

    public static Element getFirstMatchingChild(Element parent, String attributeName, String attributeValue) {
        if (parent == null || StringUtils.isNullOrEmpty(attributeName) || StringUtils.isNullOrEmpty(attributeValue)) {
            return null;
        }
        try {
            Object result = XPath.selectSingleNode((Object)parent, (String)String.format("*[@%s='%s']", attributeName, attributeValue));
            if (result instanceof Element) {
                return (Element)result;
            }
            return null;
        }
        catch (JDOMException e) {
            PosUtils.logError(e);
            return null;
        }
    }

    public static Element getElementFromXMLString(String xml) {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((Reader)new StringReader(xml));
            return doc.getRootElement();
        }
        catch (Exception e) {
            return null;
        }
    }
}

