/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class XPTableHeaderRenderer
extends DefaultTableCellRenderer
implements MouseListener,
MouseMotionListener {
    private JTableHeader header;
    private int rolloverColumn = -1;
    private int alignment = 2;

    public XPTableHeaderRenderer(JTableHeader header, int alignment) {
        this.header = header;
        this.alignment = alignment;
        header.addMouseListener(this);
        header.addMouseMotionListener(this);
        this.setHorizontalAlignment(alignment);
    }

    private void updateRolloverColumn(MouseEvent e) {
        int col = this.header.columnAtPoint(e.getPoint());
        if (col != this.rolloverColumn) {
            this.rolloverColumn = col;
            this.header.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateRolloverColumn(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.updateRolloverColumn(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.rolloverColumn = -1;
        this.header.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.rolloverColumn = -1;
        this.header.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.updateRolloverColumn(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component rendererComponent = table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus || column == this.rolloverColumn, row, column);
        if (rendererComponent instanceof JLabel) {
            JLabel columnHeader = (JLabel)rendererComponent;
            columnHeader.setHorizontalAlignment(this.alignment);
        }
        return rendererComponent;
    }
}

