/*
 * Decompiled with CFR 0.152.
 */
package jpos.associations;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jpos.FrSales;
import jpos.PosComboBox;
import jpos.PosDialog;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.XMLUtils;
import jpos.associations.Association;
import jpos.associations.AssociationSearchScreen;
import jpos.associations.grandParentAssoc;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import org.jdom.Element;

public class AssociationSelectionScreen
extends PosDialog
implements AutoCloseable {
    PosFrame parentFrame;
    private static final int WIDTH = 800;
    private Vector<grandParentAssoc> grandAssoc = new Vector();
    private Vector<PosComboBox<Association>> cmbList = new Vector();
    private Vector<LabelNormal> Labels = new Vector();
    private Vector<Integer> addedItems = new Vector();
    private DialogButton okButton = new DialogButton("");
    private DialogButton cancelButton = new DialogButton("");
    private ImageIcon imgSearch;

    public AssociationSelectionScreen(PosFrame frame, Vector<Association> currentAssocs) {
        super(frame, SP.getRS("Assoc_Button"), true);
        this.imgSearch = new ImageIcon(SP.sParams.imagepath + "search.png");
        this.parentFrame = frame;
        this.populateGrandParents();
        this.populateAssociations();
        if (currentAssocs != null) {
            this.populateExistingValues(currentAssocs);
        }
        this.init();
        this.pack();
        this.resizeDialog(this.parentFrame, 0.35f, 0.28f);
    }

    private void populateExistingValues(Vector<Association> currentAssocs) {
        boolean hasSelection = false;
        for (int associationType = 0; associationType < currentAssocs.size(); ++associationType) {
            for (int i = 0; i < this.cmbList.get(associationType).getItemCount(); ++i) {
                if (this.cmbList.get(associationType).getItemAt(i) == null || currentAssocs.get(associationType) == null || ((Association)this.cmbList.get(associationType).getItemAt(i)).getAscID() != currentAssocs.get(associationType).getAscID()) continue;
                this.cmbList.get(associationType).setSelectedIndex(i);
                hasSelection = true;
                break;
            }
            if (currentAssocs.get(associationType) != null && !hasSelection) {
                if (this.addedItems.get(associationType) == -1) {
                    this.cmbList.get(associationType).addItem(currentAssocs.get(associationType));
                }
                this.cmbList.get(associationType).setSelectedItem(currentAssocs.get(associationType));
                this.addedItems.set(associationType, this.cmbList.get(associationType).getSelectedIndex());
            }
            hasSelection = false;
        }
    }

    @Override
    public void close() {
        this.dispose();
    }

    private void init() {
        this.okButton.setText(StoreParams.res.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssociationSelectionScreen.this.okDialog();
            }
        });
        this.cancelButton.setText(StoreParams.res.getString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssociationSelectionScreen.this.cancelDialog();
            }
        });
        JPanel controlPanel = new JPanel(new GridBagLayout());
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonConstraints.insets = new Insets(5, 5, 5, 5);
        buttonConstraints.anchor = 10;
        controlPanel.add((Component)this.okButton, buttonConstraints);
        buttonConstraints.gridx = 1;
        controlPanel.add((Component)this.cancelButton, buttonConstraints);
        JPanel allAssocs = new JPanel(new GridBagLayout()){

            @Override
            public void doLayout() {
                super.doLayout();
                for (Component comp : this.getComponents()) {
                    JButton btn;
                    Component prev;
                    if (!(comp instanceof JButton) || !((prev = this.getComponentAt((btn = (JButton)comp).getX() - 1, btn.getY())) instanceof PosComboBox)) continue;
                    btn.setSize(btn.getWidth(), prev.getHeight());
                    btn.setPreferredSize(new Dimension(btn.getWidth(), prev.getHeight()));
                }
            }
        };
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        for (int i = 0; i < this.grandAssoc.size(); ++i) {
            gbc.gridy = i;
            gbc.gridx = 0;
            gbc.weightx = 0.2;
            gbc.anchor = 17;
            allAssocs.add((Component)this.Labels.get(i), gbc);
            gbc.gridx = 1;
            gbc.weightx = 0.6;
            PosComboBox<Association> comboBox = this.cmbList.get(i);
            comboBox.setPreferredSize(new Dimension(200, 30));
            allAssocs.add(comboBox, gbc);
            gbc.gridx = 2;
            gbc.weightx = 0.0;
            gbc.anchor = 17;
            gbc.insets = new Insets(0, 0, 0, 5);
            JButton search = this.createSearchButton(i, this.grandAssoc.get(i).getRcidx(), this.grandAssoc.get(i).getName());
            search.setPreferredSize(new Dimension(comboBox.getPreferredSize().height, comboBox.getPreferredSize().height));
            allAssocs.add((Component)search, gbc);
            gbc.insets = new Insets(5, 5, 5, 5);
        }
        JScrollPane scrollPane = new JScrollPane(allAssocs);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.add((Component)scrollPane, "Center");
        mainPanel.add((Component)controlPanel, "South");
        this.setContentPane(mainPanel);
        this.setFocusCycleRoot(true);
        this.pack();
        this.setSize(new Dimension(600, 400));
    }

    private JButton createSearchButton(final int index, final long rpcidx, final String screenName) {
        JButton search = new JButton();
        search.setIcon(this.imgSearch);
        search.setPreferredSize(new Dimension(50, 50));
        search.setMinimumSize(new Dimension(40, 40));
        search.setMaximumSize(new Dimension(50, 50));
        search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssociationSelectionScreen.this.bSearch_actionPerformed(e, index, rpcidx, screenName);
            }
        });
        return search;
    }

    private void populateGrandParents() {
        Element result = SP.sParams.OnlineQueryProvider.getOnlineQuery("getGrandParents", "").getXML();
        if (result != null) {
            List gpentElements = result.getChildren();
            for (Object gpent : gpentElements) {
                Element tempEle = (Element)gpent;
                if (tempEle == null || XMLUtils.getLongValue(tempEle, "rcidx") == 0L && XMLUtils.getValue(tempEle, "name") == null && XMLUtils.getValue(tempEle, "name") == "") continue;
                this.grandAssoc.add(new grandParentAssoc(XMLUtils.getLongValue(tempEle, "rcidx"), XMLUtils.getValue(tempEle, "name")));
                PosComboBox cmbAssociation = new PosComboBox();
                cmbAssociation.addItem(new Association(null));
                cmbAssociation.setPreferredSize(new Dimension(200, 100));
                cmbAssociation.setFieldWidth(200);
                this.cmbList.add(cmbAssociation);
                LabelNormal tempLabel = new LabelNormal();
                tempLabel.setText(XMLUtils.getValue(tempEle, "name"));
                this.Labels.add(tempLabel);
                this.addedItems.add(-1);
            }
            if (this.grandAssoc.size() == 0) {
                PosUtils.logError("No Grand Parent Associations setup - please contact HO.");
                this.dispose();
            } else {
                ((FrSales)this.parentFrame).addToAscVector(this.grandAssoc.size());
            }
        } else {
            PosUtils.logError("No Grand Parent Associations setup - please contact HO.");
            this.dispose();
        }
    }

    private void populateAssociations() {
        if (((FrSales)this.parentFrame).getPerson().getAttribute("peridx") != null) {
            String peridx = XMLUtils.getValue(((FrSales)this.parentFrame).getPerson(), "peridx");
            Element result = SP.sParams.OnlineQueryProvider.getOnlineQuery("getAssocsPer", peridx).getXML();
            if (result != null) {
                List assocElements = result.getChildren();
                for (Object assoc : assocElements) {
                    Element tempEle = (Element)assoc;
                    for (int i = 0; i < this.grandAssoc.size(); ++i) {
                        if (!this.grandAssoc.get(i).getName().equals(XMLUtils.getValue(tempEle, "label")) || XMLUtils.getLongValue(tempEle, "rpcidx") != this.grandAssoc.get(i).getRcidx()) continue;
                        Association tempAsc = new Association(tempEle);
                        this.grandAssoc.get(i).addAssociation(tempAsc);
                        this.cmbList.get(i).addItem(tempAsc);
                    }
                }
            } else {
                PosUtils.logError("No Associations setup - please contact HO.");
                this.dispose();
            }
        }
    }

    @Override
    public void cancelDialog() {
        this.grandAssoc = null;
        this.cmbList = null;
        this.dispose();
    }

    @Override
    public void okDialog() {
        for (int i = 0; i < this.grandAssoc.size(); ++i) {
            ((FrSales)this.parentFrame).setAscAtPosition(i, (Association)this.cmbList.get(i).getSelectedItem());
        }
        this.dispose();
    }

    void bSearch_actionPerformed(ActionEvent e, int associationType, long rpcidx, String screenName) {
        AssociationSearchScreen assocScreen = screenName == null || screenName.equals("") ? new AssociationSearchScreen(this.parentFrame, associationType, rpcidx) : new AssociationSearchScreen(this.parentFrame, associationType, rpcidx, screenName);
        assocScreen.setVisible(true);
        if (assocScreen.getSelection() == -1) {
            assocScreen.dispose();
        } else {
            boolean hasSelection = false;
            for (int i = 0; i < this.cmbList.get(associationType).getItemCount(); ++i) {
                if (((Association)this.cmbList.get(associationType).getItemAt(i)).getAscID() != assocScreen.getSelectedAssociation().getAscID()) continue;
                this.cmbList.get(associationType).setSelectedIndex(i);
                hasSelection = true;
                break;
            }
            if (!hasSelection) {
                if (this.addedItems.get(associationType) == -1) {
                    this.cmbList.get(associationType).addItem(assocScreen.getSelectedAssociation());
                } else if (((Association)this.cmbList.get(associationType).getItemAt(this.addedItems.get(associationType))).getAscID() != assocScreen.getSelectedAssociation().getAscID()) {
                    this.cmbList.get(associationType).removeItemAt(this.addedItems.get(associationType));
                    this.cmbList.get(associationType).addItem(assocScreen.getSelectedAssociation());
                }
                this.cmbList.get(associationType).setSelectedItem(assocScreen.getSelectedAssociation());
                this.addedItems.set(associationType, this.cmbList.get(associationType).getSelectedIndex());
            }
        }
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    private void resizeDialog(Window frParent, float scaleWidth, float scaleHeight) {
        Rectangle parentRect = frParent.getBounds();
        int width = (int)((float)parentRect.width * scaleWidth);
        int height = (int)((float)parentRect.height * scaleHeight);
        int x = parentRect.x + (parentRect.width - width) / 2;
        int y = parentRect.y + (parentRect.height - height) / 2;
        this.setBounds(x, y, width, height);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }
}

