/*
 * Decompiled with CFR 0.152.
 */
package jpos.associations;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import jpos.PosTable;
import jpos.SP;
import jpos.associations.Association;
import jpos.associations.AssociationColumn;
import jpos.associations.AssociationTableModel;
import org.jdom.Element;

public class AssociationTable
extends PosTable {
    public static final int MAX_ASSOCIATIONS_DISPLAYED = 20;
    private static final String pickToolip = SP.getRS("Check_All");
    private static final AssociationColumn[] defaultColumns = new AssociationColumn[]{AssociationColumn.name, AssociationColumn.contactPerson, AssociationColumn.address1, AssociationColumn.address2, AssociationColumn.city, AssociationColumn.postcode};
    private AssociationTableModel model = (AssociationTableModel)this.getModel();

    public AssociationTable(Window parentWindow) {
        super(parentWindow, new AssociationTableModel());
        this.getSelectionModel().setSelectionMode(0);
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                this.configureColumn(e);
            }

            private void configureColumn(TableColumnModelEvent e) {
                int index = e.getToIndex();
                AssociationColumn col = AssociationTable.this.model.getColumnType(index);
                if (col != null) {
                    TableColumn tableCol = AssociationTable.this.getColumnModel().getColumn(index);
                    if (col.getWidth() > 0) {
                        tableCol.setPreferredWidth(col.getWidth());
                        if (!col.isResizable()) {
                            tableCol.setMinWidth(col.getWidth());
                            tableCol.setMaxWidth(col.getWidth());
                            tableCol.setResizable(false);
                        }
                    }
                }
            }
        });
        this.createColumns();
    }

    private void createColumns() {
        for (AssociationColumn col : defaultColumns) {
            this.model.addColumn(col);
        }
    }

    public void addColumn(AssociationColumn column) {
        this.model.addColumn(column);
    }

    public void addAssociations(List<Association> sessions, boolean overwrite) {
        this.model.addAssociations(sessions, overwrite);
    }

    public void addAssociation(Association session) {
        this.model.addAssociation(session);
    }

    public Association getAssociation(int row) {
        return this.model.getAssociation(row);
    }

    public void addSelectionListener(ListSelectionListener listener) {
        this.getSelectionModel().addListSelectionListener(listener);
    }

    public boolean populateAssociations(boolean limited, long rpcidx) {
        long maxAssociations;
        int index = 0;
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        long l = maxAssociations = limited ? 20L : -1L;
        if (SP.sParams.checkIConn()) {
            Element result = SP.sParams.OnlineQueryProvider.getOnlineQuery("getAssocs", Long.toString(rpcidx) + "," + Long.toString(SP.sParams.getStoreIdx())).getXML();
            if (result != null) {
                ArrayList<Association> associations = new ArrayList<Association>();
                List associationElements = result.getChildren();
                for (Object association : associationElements) {
                    associations.add(new Association((Element)association));
                    ++index;
                }
                this.model.addAssociations(associations, true);
            }
            return true;
        }
        return false;
    }

    public Association getSelectedAssociation() {
        return this.model.getAssociation(this.getSelectedRow());
    }

    public void filter(String searchString) {
        this.model.filter(searchString);
        this.selectFirstRow();
    }

    public void removeAssociations(Association associations) {
        int row = this.model.getAssociationRow(associations);
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        this.model.removeAssociation(associations);
    }
}

