/*
 * Decompiled with CFR 0.152.
 */
package jpos.basscom.cache;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.Connection;
import java.util.Hashtable;
import jpos.basscom.cache.CacheProvider;
import jpos.basscom.cache.HashCache;
import jpos.basscom.cache.OnlineCacheSearch;
import jpos.basscom.cache.QueryHandler;
import jpos.basscom.components.ToServ;
import jpos.basscom.utils.Utils;
import jpos.basscom.utils.Xmls;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class Cacher
implements Serializable {
    private Hashtable<String, QueryHandler> qhMap = new Hashtable();
    private CacheProvider cp = null;
    private StringBuffer sReturn = new StringBuffer("");
    private int nextQH = 0;
    Connection cn = null;
    private OnlineCacheSearch onlineSearchCache = null;

    public Cacher(long memidx, Connection con) {
        this.cp = new CacheProvider(memidx, con);
        this.cn = con;
    }

    public boolean startSearch(String qhKey, ToServ toserv, long cacheidx, int rowsPerBlock, String where, Hashtable<String, Hashtable<String, String>> rsetHash, String orderBy) {
        rsetHash.clear();
        if (toserv != null) {
            if (this.onlineSearchCache != null) {
                this.onlineSearchCache.UserWhere = where;
                this.onlineSearchCache.UserOrder = orderBy;
                this.onlineSearchCache.CurrentPage = 0;
                String cacheSearchCriteria = this.elementToString(OnlineCacheSearch.serializeToXML(this.onlineSearchCache));
                String sXML = this.doServ(toserv, "12", cacheSearchCriteria);
                if (sXML != null) {
                    return HashCache.parseXML(sXML, rsetHash, 1);
                }
            }
            return false;
        }
        QueryHandler qh = this.qhMap.get(qhKey);
        return qh.startSearch(toserv, rowsPerBlock, where, rsetHash, orderBy);
    }

    public boolean getNextBlock(String qhKey, ToServ toserv, long cacheidx, Hashtable<String, Hashtable<String, String>> rsetHash, int startRec) {
        if (toserv != null) {
            if (this.onlineSearchCache != null) {
                ++this.onlineSearchCache.CurrentPage;
                String cacheSearchCriteria = this.elementToString(OnlineCacheSearch.serializeToXML(this.onlineSearchCache));
                String sXML = this.doServ(toserv, "13", cacheSearchCriteria);
                if (sXML != null) {
                    return HashCache.parseXML(sXML, rsetHash, startRec);
                }
            }
            return false;
        }
        if (qhKey == null) {
            return false;
        }
        QueryHandler qh = this.qhMap.get(qhKey);
        return qh.getNextBlock(rsetHash, startRec);
    }

    public boolean startSearchXml(String qhKey, String eWhere, int rowsPerBlock, Xmls xml, String orderBy) {
        QueryHandler qh = this.qhMap.get(qhKey);
        return qh.startSearchXml(eWhere, rowsPerBlock, xml, orderBy);
    }

    public boolean getNextBlockXml(String qhKey, Xmls xml) {
        QueryHandler qh = this.qhMap.get(qhKey);
        return qh.getNextBlockXml(xml);
    }

    public boolean validate(String qhKey, ToServ toserv, long cacheidx, String column, String value, String[] sqlReturn, boolean bMulti) {
        if (toserv != null) {
            if (this.onlineSearchCache != null) {
                this.onlineSearchCache.ValidationColumn = column;
                this.onlineSearchCache.ValidationValue = value;
                this.onlineSearchCache.AllowMulti = bMulti ? "Y" : "N";
                String cacheSearchCriteria = this.elementToString(OnlineCacheSearch.serializeToXML(this.onlineSearchCache));
                String sGot = this.doServ(toserv, "10", cacheSearchCriteria);
                if (sGot == null) {
                    return false;
                }
                sqlReturn[0] = this.getPar(sGot, 3, 1);
                sqlReturn[1] = this.getPar(sGot, 3, 2);
                sqlReturn[2] = this.getPar(sGot, 3, 3);
                return true;
            }
            return false;
        }
        QueryHandler qh = this.qhMap.get(qhKey);
        return qh.validate(toserv, column, value, sqlReturn, bMulti);
    }

    public boolean validate(String qhKey, ToServ toserv, long cacheidx, String column, String value, String[] sqlReturn) {
        return this.validate(qhKey, toserv, cacheidx, column, value, sqlReturn, false);
    }

    public void clearQH(String qhKey, ToServ toserv) {
        if (toserv == null) {
            QueryHandler qh = this.qhMap.get(qhKey);
            qh.close();
            this.qhMap.remove(qhKey);
            this.onlineSearchCache = null;
        }
    }

    public String getQueryHandler(ToServ toserv, long cacheidx, String mandTable, String fromTable, String where) {
        if (toserv != null) {
            return "0";
        }
        QueryHandler qh = new QueryHandler(this.cn, this, cacheidx, mandTable, fromTable, where);
        String sRet = String.valueOf(this.nextQH);
        this.qhMap.put(sRet, qh);
        ++this.nextQH;
        return sRet;
    }

    public String getCacheSql(ToServ toserv, long cacheidx, String mandTable, String fromTable, String where) {
        try {
            return this.cp.getCacheSql(cacheidx, mandTable, fromTable, where);
        }
        catch (Exception q) {
            Utils.logError(q);
            return null;
        }
    }

    public void loadCacheSql(ToServ toserv, long cacheidx, String mandTable, String fromTable, String where) {
        if (toserv != null) {
            toserv.setSearchurl(false);
            this.onlineSearchCache = new OnlineCacheSearch();
            this.onlineSearchCache.Cacheidx = cacheidx;
            this.onlineSearchCache.MandatoryTableidx = mandTable;
            this.onlineSearchCache.ExtraFrom = fromTable;
            this.onlineSearchCache.ExtraWhere = where;
            try {
                String cacheSearchCriteria = this.elementToString(OnlineCacheSearch.serializeToXML(this.onlineSearchCache));
                String cacheInfo = this.doServ(toserv, "7", cacheSearchCriteria);
                StringReader stringReader = new StringReader(cacheInfo);
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build((Reader)stringReader);
                Element cacheInfoXml = doc.getRootElement();
                OnlineCacheSearch cacheResult = OnlineCacheSearch.DeSerialize(cacheInfoXml);
                this.onlineSearchCache.CacheName = cacheResult.CacheName;
                this.onlineSearchCache.KeyColumnName = cacheResult.KeyColumnName;
                this.onlineSearchCache.CodeColumnName = cacheResult.CodeColumnName;
                this.onlineSearchCache.ColumnAttributes = cacheResult.ColumnAttributes;
                this.onlineSearchCache.Columns = cacheResult.Columns;
            }
            catch (Exception e) {
                this.onlineSearchCache = null;
            }
        } else {
            try {
                this.cp.loadCacheSql(cacheidx, mandTable, fromTable, where);
            }
            catch (Exception q) {
                Utils.logError(q);
            }
        }
    }

    private String elementToString(Element node) {
        XMLOutputter outp = new XMLOutputter();
        return outp.outputString(node);
    }

    public int getColCount(ToServ toserv, long cacheidx) {
        if (toserv != null) {
            if (this.onlineSearchCache != null) {
                return this.onlineSearchCache.Columns.length;
            }
            return -1;
        }
        return this.cp.getColCount(cacheidx);
    }

    public String getCacheName(ToServ toserv, long cacheidx) {
        if (toserv != null) {
            if (this.onlineSearchCache != null) {
                return this.onlineSearchCache.CacheName;
            }
            return "";
        }
        return this.cp.getCacheName(cacheidx);
    }

    public String getColName(ToServ toserv, long colNum, long cacheidx) {
        if (toserv != null) {
            if (this.onlineSearchCache != null) {
                return this.onlineSearchCache.Columns[(int)colNum].Name;
            }
            return "";
        }
        return this.cp.getColName(colNum, cacheidx);
    }

    public String getUniqueidxName(ToServ toserv, long cacheidx) {
        if (toserv != null) {
            if (this.onlineSearchCache != null) {
                return this.onlineSearchCache.KeyColumnName;
            }
            return "";
        }
        return this.cp.getUniqueidxName(cacheidx);
    }

    public boolean getColAttribs(ToServ toserv, long cacheidx, Hashtable<String, Hashtable<String, String>> colHash) {
        if (toserv != null) {
            String sXML = null;
            if (this.onlineSearchCache != null) {
                sXML = this.onlineSearchCache.ColumnAttributes;
            }
            if (sXML != null) {
                return HashCache.parseXML(sXML, colHash, 1);
            }
            return false;
        }
        return this.cp.getColAttribs(cacheidx, colHash);
    }

    private String doServ(ToServ toserv, String action, String sdata) {
        int status = toserv.postToServlet(action, sdata, "jpos.basscom.servlets.SeCache", this.cn, this.sReturn, false, false);
        if (status == 0) {
            return null;
        }
        if (this.sReturn.length() < 3 || !this.sReturn.substring(0, 2).equals("99")) {
            return null;
        }
        return this.sReturn.substring(2, this.sReturn.length());
    }

    public String getPar(String sdata, int pars, int parNum) {
        int start = pars * 9;
        int offset = 0;
        for (int i = 1; i < parNum; ++i) {
            start += Integer.parseInt(sdata.substring(offset, offset + 9).trim());
            offset += 9;
        }
        return sdata.substring(start, start + Integer.parseInt(sdata.substring(offset, offset + 9).trim()));
    }

    public CacheProvider getCProvider() {
        return this.cp;
    }
}

