/*
 * Decompiled with CFR 0.152.
 */
package jpos.basscom.cache;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.StringTokenizer;
import jpos.basscom.cache.Cacher;
import jpos.basscom.components.ToServ;
import jpos.basscom.utils.MultiResultSetBuilderXmls;
import jpos.basscom.utils.Utils;
import jpos.basscom.utils.Xmls;

public class QueryHandler
implements Serializable {
    private Cacher cp = null;
    private long cacheidx;
    private String mandTable;
    private String fromTable;
    private String where;
    private Connection con;
    private Statement lazyLoadStmt = null;
    private ResultSet lazyLoadResultSet = null;
    private int rowsPerBlock;
    private int colCount;
    MultiResultSetBuilderXmls cacheBuilder = null;
    private boolean endReached;

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public QueryHandler(Connection con, Cacher cp, long cacheidx, String mandTable, String fromTable, String where) {
        this.con = con;
        this.cp = cp;
        this.cacheidx = cacheidx;
        this.mandTable = mandTable;
        this.fromTable = fromTable;
        this.where = where;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(ToServ toserv, String column, String value, String[] sqlReturn, boolean bMulti) {
        sqlReturn[0] = "";
        sqlReturn[1] = "";
        sqlReturn[2] = "";
        boolean valid = false;
        String lWhere = bMulti ? (this.where == null || this.where.equals("") ? column + " IN(" + this.quoteSplit(value) + ")" : this.where + " AND " + column + " IN(" + this.quoteSplit(value) + ")") : (this.where == null || this.where.equals("") ? column + " = " + Utils.StrToDBX(value) : this.where + " AND " + column + " = " + Utils.StrToDBX(value) + "");
        Statement stmt = null;
        try {
            String sql = this.cp.getCacheSql(toserv, this.cacheidx, this.mandTable, this.fromTable, lWhere);
            stmt = this.con.createStatement();
            ResultSet result = null;
            try {
                result = stmt.executeQuery(sql);
                if (bMulti) {
                    while (result.next()) {
                        if (sqlReturn[0].equals("")) {
                            sqlReturn[0] = this.nvl(result.getString(1));
                            sqlReturn[1] = this.nvl(result.getString(2));
                            sqlReturn[2] = this.nvl(result.getString(3));
                        } else {
                            sqlReturn[0] = sqlReturn[0] + "," + this.nvl(result.getString(1));
                            sqlReturn[1] = sqlReturn[1] + "," + this.nvl(result.getString(2));
                            sqlReturn[2] = sqlReturn[2] + "," + this.nvl(result.getString(3));
                        }
                        valid = true;
                    }
                } else if (result.next()) {
                    sqlReturn[0] = this.nvl(result.getString(1));
                    sqlReturn[1] = this.nvl(result.getString(2));
                    sqlReturn[2] = this.nvl(result.getString(3));
                    valid = true;
                }
            }
            finally {
                Utils.closeResultSet(result);
            }
            Utils.closeStatement(stmt);
        }
        catch (SQLException e) {
            Utils.logError(e);
        }
        finally {
            Utils.closeStatement(stmt);
        }
        return valid;
    }

    public boolean startSearch(ToServ toserv, int rowsPerBlock, String eWhere, Hashtable<String, Hashtable<String, String>> rsetHash, String orderBy) {
        this.endReached = false;
        this.rowsPerBlock = rowsPerBlock;
        this.colCount = this.cp.getColCount(toserv, this.cacheidx) + 1;
        eWhere = eWhere == null || eWhere.equals("") ? this.where : this.where + " AND " + eWhere + "";
        String sql = this.cp.getCacheSql(toserv, this.cacheidx, this.mandTable, this.fromTable, eWhere);
        if (orderBy != null && !orderBy.equals("")) {
            sql = sql + " ORDER BY " + orderBy;
        }
        this.closeLazyLoad();
        try {
            this.lazyLoadStmt = this.con.createStatement();
            this.lazyLoadResultSet = this.lazyLoadStmt.executeQuery(sql);
            return this.getNextBlock(rsetHash, 1);
        }
        catch (SQLException e) {
            Utils.logError(e);
            this.endReached = true;
            return false;
        }
    }

    public boolean getNextBlock(Hashtable<String, Hashtable<String, String>> rsetHash, int startRec) {
        if (this.endReached || this.lazyLoadResultSet == null) {
            return false;
        }
        try {
            for (int c = 0; c < this.rowsPerBlock; ++c) {
                if (!this.lazyLoadResultSet.next()) {
                    this.endReached = true;
                    break;
                }
                Hashtable<String, String> colsHash = new Hashtable<String, String>(this.colCount);
                for (int d = 0; d < this.colCount; ++d) {
                    if (this.lazyLoadResultSet.getObject(d + 1) != null) {
                        colsHash.put("col" + d, this.lazyLoadResultSet.getString(d + 1));
                        continue;
                    }
                    colsHash.put("col" + d, "");
                }
                rsetHash.put(startRec + "", colsHash);
                ++startRec;
            }
            return true;
        }
        catch (SQLException e) {
            Utils.logError(e);
            return false;
        }
    }

    public boolean startSearchXml(String eWhere, int rowsPerBlock, Xmls xml, String orderBy) {
        this.endReached = false;
        this.rowsPerBlock = rowsPerBlock;
        this.colCount = this.cp.getColCount(null, this.cacheidx) + 1;
        eWhere = eWhere == null || eWhere.equals("") ? this.where : this.where + " AND " + eWhere + "";
        String sql = this.cp.getCacheSql(null, this.cacheidx, this.mandTable, this.fromTable, eWhere);
        if (orderBy != null && !orderBy.equals("")) {
            sql = sql + " ORDER BY " + orderBy;
        }
        this.closeLazyLoad();
        try {
            this.lazyLoadStmt = this.con.createStatement();
            this.lazyLoadResultSet = this.lazyLoadStmt.executeQuery(sql);
        }
        catch (SQLException e) {
            Utils.logError(e);
            this.endReached = true;
            return false;
        }
        this.cacheBuilder = new MultiResultSetBuilderXmls(this.lazyLoadResultSet, 1);
        this.cacheBuilder.setAsAttributeAll();
        this.cacheBuilder.setRowName("row");
        for (int i = 0; i < this.colCount + 1; ++i) {
            this.cacheBuilder.setAsAttribute(i + 1, "col" + i);
        }
        return this.getNextBlockXml(xml);
    }

    public boolean getNextBlockXml(Xmls xml) {
        if (this.endReached || this.lazyLoadResultSet == null) {
            return false;
        }
        xml.clear();
        xml.append("<?xml version=\"1.0\"?>");
        xml.stEle("rset");
        try {
            int upto = this.cacheBuilder.getRowCount() + this.rowsPerBlock;
            this.cacheBuilder.setdoSav(false);
            this.cacheBuilder.setMaxRows(upto);
            if (this.cacheBuilder.build(xml)) {
                xml.endEle("rset");
                return true;
            }
            return false;
        }
        catch (Exception e) {
            Utils.logError(e);
            return false;
        }
    }

    public void close() {
        this.closeLazyLoad();
    }

    private void closeLazyLoad() {
        if (this.lazyLoadResultSet != null) {
            Utils.closeResultSet(this.lazyLoadResultSet);
            this.lazyLoadResultSet = null;
        }
        if (this.lazyLoadStmt != null) {
            Utils.closeStatement(this.lazyLoadStmt);
            this.lazyLoadStmt = null;
        }
    }

    public String quoteSplit(String str) {
        StringTokenizer st = new StringTokenizer(str, ",");
        StringBuffer s = new StringBuffer("");
        while (st.hasMoreTokens()) {
            if (s.length() > 0) {
                s.append("," + Utils.StrToDBX(st.nextToken()));
                continue;
            }
            s.append(Utils.StrToDBX(st.nextToken()));
        }
        return s.toString();
    }

    public String nvl(String sNull) {
        if (sNull == null) {
            return new String("");
        }
        return new String(sNull);
    }
}

